Ext.define('SoftwareAvailability.view.Main',{
	extend: "utilities.OuterPanel",
	alias: "widget.main",

	requires: [
		'SoftwareAvailability.view.FormItems',
		'SoftwareAvailability.view.ErrorContainer',
		'configutilities.Tools'
	],

	id: "main",
	title : config.title.mainPageTitle,

	layout: {
		align: "stretch",
		type: "vbox"
	},

	margin : '8 8 0 8',

	tools : [
		{
			xtype : 'button',
			text : config.title.backTitle,
			cls : 'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype : 'tools'
		}
	],

	items : [
		{
			xtype : 'formitems',
			margin : '8 8 0 8'
		},
		{
			xtype : 'panel',
			id : 'hiddenPanel',
			cls:'containerShadow config_containerShadow',
			hidden : true,
			flex: 1,
			scroll: true,
			autoScroll: true,
			margin : 8,
			items : [
				{
					xtype : 'softwareavailabilitychart',
					id : 'chartPlaceHolder',
					margin : '10 10 0 10'
				},
				{
					xtype : 'grid',
					cls :'gridSkin_expander',
					id : 'mainGrid',
					margin : '0 10 10 10',
					store : new Ext.data.Store({
						fields : ['software','system'],
						data : [],
						groupField : 'software',
						sortOnLoad : false
					}),
					features: [{
						ftype: 'grouping',
						id : 'softwareTypeGrouping',
						groupHeaderTpl: [
							'{name:this.formatHeader}',
							{
								formatHeader: function(name) {
									var cType = name.split(":");
									return cType[0];
								}
							}
						],
						hideGroupedHeader: false,
						startCollapsed: false,
					}],

					tools: [
						{
							xtype:'button',
							id :'tc',
							name :'tc',
							iconCls: 'iconCollapseAll',
							pressedCls:'iconExpandAll',
							enableToggle : true,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:{
								'toggle':function(obj, pressed, eOpts){
									var thisGrid = Ext.getCmp('mainGrid'),
									groupingFeature = thisGrid.view.getFeature('softwareTypeGrouping');
									if(pressed)
									{
										groupingFeature.collapseAll();
										obj.setIconCls('iconExpandAll');
									}
									else
									{
										groupingFeature.expandAll();
										obj.setIconCls('iconCollapseAll');
									}
									thisGrid.doLayout();
								}
							}
						}
					], 
					queryMode : 'local',
					hideHeaders : true,
					viewConfig : {
						deferEmptyText : true,
						cls:'gridSkin_expander_view'
					},
					emptyText : "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>Software not available in systems of the selected OS</div></td></tr></table>",

					columns : {
						defaults : {
							sortable : true,
							hideable : false,
							menuDisabled : true,
							draggable : false,
							resizable : false,
							flex : 1
						},
						items : [
							{
								text : 'System',
								dataIndex : 'system',
								width : 280,
								renderer : function(value)
								{
									var column = "";
									if (value != "" && value.length > 0)
									{
										var mainArr = value.split("|");

										if(mainArr.length > 1) // contains unavailable system list.
										{
											/*For available sys list*/
											var rowText1 = '<table valign="top" class="OStable" style="margin: 2px 0px 10px 0px" width="100%">';
											var tmpArr1 = mainArr[0].split("#$#");
											var allSystems1 = tmpArr1.slice(1,tmpArr1.length);
											var count1 = 1;

											rowText1 +='<thead><tr width="100%"><th class="OStable_td" colspan="3" style="padding:7px 7px 7px 9px;font-size:8pt;">'+ tmpArr1[0] + '</th></tr></thead>';

											var colText1 = '';

											var sysSize1 = allSystems1.length;
											for(var d = 0; d < sysSize1; d++)
											{
												if (count1 == 4) 
												{
													count1 = 1;
												}
												if (count1 == 1)
												{
													colText1 = colText1 + '<tr width="100%">';
												}

												colText1 = colText1 + '<td width="33%" style="padding:7px;font-size:8pt;"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href="javascript:loadURL(\'' + allSystems1[d] + '\')">' + allSystems1[d]+ '</a></td>';

												if (count1 == 3)
												{
													colText1 = colText1 + '</tr>';
												}
												count1++;
												while (count1 < 4 && d == sysSize1-1)
												{
													colText1 = colText1 + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
													count1++;
												}
											}

											rowText1 = rowText1 + colText1;
											rowText1 += '</table>';

											/**End**/

											/** For unavailable sys list**/
											var rowText = '<table valign="top" class="OStable" style="margin: 2px 0px 2px 0px" width="100%">';
											var tmpArr = mainArr[1].split("#$#");
											var allSystems2 = tmpArr.slice(1,tmpArr.length);
											var count2 = 1;

											rowText += '<thead><tr width="100%"><th class="OStable_td" colspan="3" style="padding:7px 7px 7px 9px;font-size:8pt;">'+ tmpArr[0] + '</th></tr></thead>';

											var colText = '';

											var sysSize2 = allSystems2.length;
											for(var d = 0; d < sysSize2; d++)
											{
												if (count2 == 4) 
												{
													count2 = 1;
												}
												if (count2 == 1)
												{
													colText = colText + '<tr width="100%">';
												}

												colText = colText + '<td width="33%" style="padding:7px;font-size:8pt;"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href="javascript:loadURL(\'' + allSystems2[d] + '\')">' + allSystems2[d]+ '</a></td>';

												if (count2 == 3)
												{
													colText = colText + '</tr>';
												}
												count2++;

												while (count2 < 4 && d == sysSize2-1)
												{
													colText = colText + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
													count2++;
												}
											}

											rowText = rowText + colText;
											rowText += '</table>';

											column = rowText1 + rowText;
											return column;
											/*End*/
										}
										else // contains only available system list.
										{
											var rowText = '';
											var tmpArr = value.split("#$#");
											var allSystem = tmpArr.slice(1,tmpArr.length);
											var count = 1;

											rowText ='<thead><tr width="100%"><th class="OStable_td" colspan="3" style="padding:7px 7px 7px 9px;font-size:8pt;">'+ tmpArr[0] + '</th></tr></thead>';

											var colText = "";
											var sysSize = allSystem.length;
											for(var d = 0; d < sysSize; d++)
											{
												if (count == 4) 
												{
													count = 1;
												}
												if (count == 1)
												{
													colText = colText + '<tr width="100%">';
												}

												colText = colText + '<td width="33%" style="padding:7px;font-size:8pt;"><img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href="javascript:loadURL(\'' + allSystem[d] + '\')">' + allSystem[d]+ '</a></td>';

												if (count == 3)
												{
													colText = colText + '</tr>';
												}
												count++;

												while (count < 4 && d == sysSize-1)
												{
													colText = colText + '<td width="33%" class="OStable_emptytd">&nbsp;</td>';
													count++;
												}
											}
											rowText = rowText + colText;
											return '<table valign="top" class="OStable" style="margin: 2px 0px 2px 0px" width="100%">' + rowText+ '</table>';
										}
									}
									else
									{
										return value;
									}
								}
							}
						]
					}
				}
			]
		},
		{
			xtype: "errorcontainer",
			hidden: true,
			margin : '10 10 10 10',
		}
	]
});



