Ext.define('SystemManufacturers.view.Main',{
	extend: "utilities.OuterPanel",
	alias: "widget.main",
	requires: [
		'SystemManufacturers.view.FormItems',
		'SystemManufacturers.view.ErrorContainer',
		'configutilities.Tools',
		'utilities.CommonPanel'
	],
	id: "main",
	title : config.title.mainPageTitle,
	layout: {
		align: "stretch",
		type: "vbox"
	},
	margin : '8 8 0 8',
	tools : [
		{
			xtype : 'button',
			text : config.title.backTitle,
			cls : 'backbutton',
			id : 'backBtnMain',
			iconCls:'iconBack',
			hidden : true
		},
		{
			xtype: 'tbseparator',
			id: 'bkSeperator',
			hidden : true
		},
		{
			xtype : 'tools'
		}
	],
	items : [
		{
			xtype : 'formitems',
			margin: '8 8 0 8'
		},
		{
			xtype : 'commonPanel',
			id : 'hiddenPanel',
			margin: 8,
			hidden : true,
			items : [
				{
					xtype : 'systemmanufacturerschart',
					id : 'chartPlaceHolder',
					margin : '10 10 0 10',
				},
				{
					xtype : 'grid',
					cls :'gridSkin_expander',
					id : 'mainGrid',
					margin : '10 10 10 10',
					store : new Ext.data.Store({
						fields : ['Manufacturer','column_1','column_2','column_3','column_4'],
						data : [],
						groupField : 'Manufacturer',
						sortOnLoad : false
					}),
					features: [{
						ftype: 'grouping',
						id : 'groupingId',
						groupHeaderTpl: [
							'{name:this.formatHeader}',
							{
								formatHeader: function(name) {
									var cType = name.split(":");
									if(cType.length == 1)
									{
										return cType[0];
									}
									else if(cType.length == 2)
									{
										return cType[0] + ":" + cType[1];
									}
									else if(cType.length == 3)
									{
										return cType[0] + ":" + cType[1] + ":" +cType[2];
									}
								}
							}
						],
						hideGroupedHeader: false,
						startCollapsed: false,
					}],
					tools: [
						{
							xtype:'button',
							id :'tc',
							name :'tc',
							iconCls: 'iconCollapseAll',
							enableToggle : true,
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:{
								'toggle':function(obj, pressed, eOpts){
									var thisGrid = Ext.getCmp('mainGrid'),
									groupingFeature = thisGrid.view.getFeature('groupingId');
									if(pressed){
										groupingFeature.collapseAll();
										obj.setIconCls('iconExpandAll');
									}else{
										groupingFeature.expandAll();
										obj.setIconCls('iconCollapseAll');
									}
									thisGrid.doLayout();
								}
							}
						}
					],
					hideGroupedHeader: false,
					startCollapsed: false,
					queryMode : 'local',
					hideHeaders : true,
					viewConfig : 
					{
						deferEmptyText : true,
						cls:'gridSkin_expander_view'
					},
					emptyText : "<table border='0' height='350px' width='100%'><tr><td align=center vlaign=top><img src='/final/admin/eg_images/exclamation-icon.gif'><div>No result found for the current selection</div></td></tr></table>",
					columns : {
						defaults : {
							sortable : true,
							hideable : false,
							menuDisabled : true,
							draggable : false,
							resizable : false,
							flex : 1
						},
						items : [
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_1',
								flex : 1,
								renderer : function(val,meta,record)
								{
									if (val != "" && val.length > 0)
									{
										var tmpTag = '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href=\'javascript:getSystemDetails("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
										return tmpTag;
									}
									else
									{
										meta.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_2',
								flex : 1,
								renderer : function(val,meta,record)
								{
									if (val != "" && val.length > 0)
									{
										var tmpTag = '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href=\'javascript:getSystemDetails("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
										return tmpTag;
									}
									else
									{
										meta.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_3',
								flex : 1,
								renderer : function(val,meta,record)
								{
									if (val != "" && val.length > 0)
									{
										var tmpTag = '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href=\'javascript:getSystemDetails("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
										return tmpTag;
									}
									else
									{
										meta.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							},
							{
								header: '',
								sortable: false,
								menuDisabled : true,
								dataIndex: 'column_4',
								flex : 1,
								renderer : function(val,meta,record)
								{
									if (val != "" && val.length > 0)
									{
										var tmpTag = '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a id="mouse" style="vertical-align:text-bottom" href=\'javascript:getSystemDetails("'+val+'")\' target="main" class="eg_monlink">'+val+'</a>';
										return tmpTag;
									}
									else
									{
										meta.tdCls += "OStable_emptytd";
										return "&nbsp";
									}
								}
							}
						]
					}
				}
			]
		},
		{
			xtype: "errorcontainer",
			hidden: true
		}
	]
});



