Ext.define('ViewSchedule.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main','Schedules'],
	refs:[
		{selector : 'main', ref : 'main'},
		{selector: 'schedules', ref:'schedules'}
	],

	init: function()
	{
		this.buildFieldData()
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'schedules button[id="deleteId"]':
			{
				'click' : this.deleteSchedules
			},

		});
	},

	buildFieldData: function() {
		Ext.Ajax.request({
			url : config.urls.initialURL,
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	afterMainRender: function()
	{
		if (publicJSON.hasSchedules)
		{
			var resultContainer = Ext.getCmp('gridDisplay');
				resultContainer.removeAll();
				resultContainer.add({
					xtype : 'schedules',
					arrayStore : publicJSON.schedulesArray,
					pageLimit : publicJSON.recordsPerPage,
				});
			resultContainer.show();
		}
		else
		{
			var resultContainer = Ext.getCmp('gridDisplay');
			resultContainer.update('<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText" style="margin:1% auto 0 auto;">'+config.msgs.noDataMsg+'.</div></td></tr></table>');
			resultContainer.show();
		}
	},

	deleteSchedules: function()
	{
		var cmd = 'delete';
		var viewStoreObj = Ext.getCmp('schedules');
		var store = viewStoreObj.getStore();
		var noOfrecords = store.getCount();
		var selectionModelObj = viewStoreObj.getSelectionModel();
		if ( noOfrecords > 0 )
		{
			var schSelected=false;
			if(selectionModelObj.getSelection().length>0)
				schSelected=true;
			if(schSelected)
			{
				//var schName = record.get('scheduleName');
				Ext.Msg.confirm(config.title.mainPageTitle,config.msgs.scheduleDeleteMsg,function(btn){
					if (btn == "yes")
					{
						var sch_id="";
						var sch_name="";
						var mid = "";
						var selected = selectionModelObj.getSelection();
						if(selected.length>0)
						{
							for(var i=0;i<selected.length;i++)
							{
								var recOrg = selected[i];
								sch_id += recOrg.get('scheduleId')+',';
								mid +='&mid='+encodeURIComponent(recOrg.get('scheduleId'));
								//sch_name += "'"+recOrg.get('scheduleName')+"_cf',";
								sch_name += recOrg.get('scheduleName')+"_cf,";
								viewStoreObj.store.remove(recOrg);
							}
						}
						sch_id = sch_id.substring(0,sch_id.length - 1);
						sch_name = sch_name.substring(0,sch_name.length - 1);

						Ext.Ajax.request(
						{
							url : config.urls.scheduleURL,
							params : 'cmd=Delete&id='+sch_id+'&sch_name='+sch_name,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								var jsonData_schedulesArray = jsonData.schedulesArray;
								Ext.Msg.show({
									title : config.title.mainPageTitle,
									msg : config.msgs.scheduleMsg,
									icon :'iconInformation',
									buttons : Ext.Msg.OK
								});
								if (jsonData_schedulesArray.length == 0)
								{
									var resultContainer = Ext.getCmp('gridDisplay');
									resultContainer.removeAll();
									//resultContainer.add({
										//xtype : 'container',
										//html : '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+config.msgs.noDataMsg+'.</div></td></tr></table>',
									//});
									resultContainer.update('<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+config.msgs.noDataMsg+'.</div></td></tr></table>');
									resultContainer.show();
								}
								else
								{
									var resultContainer = Ext.getCmp('gridDisplay');
										resultContainer.removeAll();
										resultContainer.add({
											xtype : 'schedules',
											arrayStore : jsonData_schedulesArray,
											pageLimit : jsonData.recordsPerPage,
										});
									resultContainer.show();
								}
							}
						});
					}
				});
			}
			else
			{
				Ext.Msg.alert(config.title.mainPageTitle,config.msgs.scheduleAlertMsg);
				return false;
			}
		}
	},

});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



