Ext.define('XmlComparison.controller.Main', {
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'FormItems'
	],
	refs:[
		{
			selector : 'main', 
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		}
		
	],
	init :function() {
		me = this;
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'formitems button[id="submit"]' :{
				'click' : this.showDetails
			},
			'main button[id="justDiff"]' :{
				'click' : this.showOnlyDiffData
			},
			'main button[id="showAll"]' :{
				'click' : this.showAllData
			},
			'main button[id="prevDiff"]' :{
				'click' : this.previousDiff
			},
			'main button[id="nextDiff"]' :{
				'click' : this.nextDiff
			}
		});
	},
	afterMainRender : function()
	{
		me.getFormitems().show();
	},
	validateData : function(fileOne,fileTwo)
	{
		if ('<%=isDouble%>'=="false")
		{
			if(!validateSingleByte(thisForm[i].value))
			{
				Ext.Msg.alert(config.title.mainPageTitle,config.msgs.doubleByteAlert);
				return false;
			}
		}
		return true;
	},
	showDetails : function(from)
	{
		//alert('LoadDetails')
		var fileOne = Ext.getCmp("FILE_0").getValue();
		var fileTwo = Ext.getCmp("FILE_1").getValue();

		if ( (fileOne != null && (fileOne.indexOf(":\\") != -1)) )
		{
			firstFileName = fileOne.substring(fileOne.lastIndexOf("\\")+1,fileOne.length);
		}
		else
		{
			firstFileName = fileOne;
		}

		if ( (fileTwo != null && (fileTwo.indexOf(":\\") != -1)) )
		{
			secondFileName = fileTwo.substring(fileTwo.lastIndexOf("\\")+1,fileTwo.length);
		}
		else
		{
			secondFileName = fileTwo;
		}
		me.getMain().getComponent('differencePanel').hide();

		var url = "../servlet/com.eg.EgFileUpload";
		var jsonURL ="../config/XmlComparison/data/EcXmlComparisonJSON.jsp?";
		var thisForm = this.getFormitems().getForm();
		var isValidateflag = me.validateData(fileOne,fileTwo);

		if (isValidateflag && thisForm.isValid())
		{
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();
			this.getFormitems().submit({
				url : url,
				params: "fileOne="+encodeURIComponent(fileOne)+"&fileTwo="+encodeURIComponent(fileTwo),
				method : 'POST',
				success : function(form, action)
				{
					publicJSON = Ext.decode(action.response.responseText);
					Ext.Ajax.request({
						url : jsonURL,
						params: "fileDestURL="+encodeURIComponent(fileDestURL)+"&SecfileDestURL="+encodeURIComponent(SecfileDestURL),
						method : 'POST',
						async : false,
						success : function( response ){
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
							{
								Ext.getCmp('formitems').collapse();
								var jsonText = response.responseText;
								publicJSON = Ext.decode( jsonText );
								Ext.getCmp('differencePanel').setVisible(true);
								Ext.getCmp('measDiffFrame').setVisible(true);

								var prevData = publicJSON['previousXmlData'];
								var presData = publicJSON['currentXmlData'];

								Ext.getCmp("baseText").setValue(prevData);
								Ext.getCmp("newText").setValue(presData);
								var measDiffFrameObj = Ext.getCmp('measDiffFrame');
								Ext.getCmp('justDiff').setIconCls("iconConfigCompareDiff");
								diffUsingJS(0);
								myMask.hide();
							}
						},
						failure: function( response )
						{
							myMask.hide();
							Ext.MessageBox.alert("Ajax Failed","Error in updating details!!!");
						}
					});
				},
				failure: function(form, action)
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details!");
				}
			});
		}
		else
		{
			Ext.Msg.alert(config.title.mainPageTitle,config.msgs.alert1+" 'xml/txt'" );
		}
	},
	showOnlyDiffData: function()
	{
		document.getElementById("prevDiffIndex").value='';
		diffUsingJS(0);
		var divId = document.getElementById("diffoutput");
		var rows = divId.getElementsByTagName('tr'); // getting all data and hide it by changing its style.
		if(rows != null)
		{
			for (var j = 1; j <rows.length; j+=1)
			{
				rows[j].style.display = 'none';
			}
		}

		var x = divId.getElementsByClassName("change"); // here we get only diff data and change its style.
		if(x != null)
		{
			for(var i=0;i<x.length;i++)
			{
				if(x[i].style.display = 'none')
				{
					x[i].style.display = '';
				}
			}
		}

		Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
		Ext.getCmp('showAll').enable();
		Ext.getCmp('showAll').setIconCls("iconConfigCompareSame");
		Ext.getCmp("justDiff").disable();
		Ext.getCmp("justDiff").setIconCls("iconConfigCompareDiffDisabled");
	},
	showAllData:function()
	{
		document.getElementById("prevDiffIndex").value='';
		diffUsingJS(0);
		Ext.getCmp('showAll').disable();
		Ext.getCmp('showAll').setIconCls("iconConfigCompareSameDisabled");
		Ext.getCmp("justDiff").enable();
		Ext.getCmp("justDiff").setIconCls("iconConfigCompareSame");
		
	},
	nextDiff : function()
	{
		findingNext();
	},
	previousDiff : function()
	{
		findingPrev();
	}
		
});

	function diffUsingJS(viewType)
	{
		document.getElementById("prevDiffIndex").value = ''; 
		var baseText = Ext.getCmp("baseText").getValue();
		var newTextValue = Ext.getCmp("newText").getValue();
		base = difflib.stringAsLines(baseText),
		newtxt = difflib.stringAsLines(newTextValue),
		sm = new difflib.SequenceMatcher(base, newtxt);
		opcodes = sm.get_opcodes();
		contextSize = Ext.getCmp("contextSize").getValue();
		contextSize = contextSize || null;

		var diffoutputdiv = document.getElementById('diffoutput');
			
		diffoutputdiv.innerHTML = "";
		var headerContent = '<div><div class="config_diff_base_header"><span class="xml_file_name">BASE FILE</span> ('+firstFileName+')</div><div class="config_diff_new_header" ><span class="xml_file_name">NEW FILE</span> ('+secondFileName+')</div></div>';
		//'<div><div style="float:left;text-align:left;width:50%;padding:5px 0 0 0;border-right:1px" >'+firstFileName+'</div><div style="float:right;text-align:left;width:50%;padding:5px 5px 5px 5px">'+secondFileName+'</div></div>'
		Ext.getCmp("diffHeader").update(headerContent);
	
	
		//validate xml data begin
		var flag = false;
		var baseTextRes = "";
		var newTextRes = "";
		var fileExt = ".xml";

		if (((firstFileName.toLowerCase().indexOf(fileExt)) != -1) || (secondFileName.toLowerCase().indexOf(fileExt)) != -1)
		{
			baseTextRes = validateXmlData(baseText);
			newTextRes = validateXmlData(newTextValue);
		}
		var validationResults = "<table class='diff'><tbody><tr>";
		if(baseTextRes.length >0)
		{
			flag = true;
			if(baseTextRes.indexOf("page") > -1)
			{
				baseTextRes = baseTextRes.replace("page","file");
			}
			validationResults += "<td><strong><span style='color:red'>" + baseTextRes+".</span></strong></td>";
			//validationResults+="<td><strong><span style='color:#F6262D;'>" + baseTextRes+".</span></strong></td>";
		}
		else
		{
			validationResults += "<td style='width:50%;color:green'>This file contains well-formed xml data</td>"
			//validationResults+="<td style='color:green'>This file contains well-formed xml data</td>";
		}

		if(newTextRes.length > 0)
		{
			flag = true;
			if(newTextRes.indexOf("page") > -1)
			{
				newTextRes = newTextRes.replace("page","file");
			}

			validationResults += "<td><strong><span style='color:red;width:50%'> " + newTextRes+".</span></strong></td>";
			//validationResults +="<td><strong><span style='color:#F6262D;'> " + newTextRes+".</span></strong></td>";
		}
		else
		{
			validationResults += "<td style='width:50%;color:green'>This file contains well-formed xml data.</td>"
			//validationResults +="<td style='color:#26F683'>This file contains well-formed xml data.</td>";
		}
		validationResults += "</tr></tbody></table>";

		if(flag)
		{
			diffoutputdiv.innerHTML = validationResults;
			Ext.getCmp('justDiff').hide();
			Ext.getCmp('showAll').hide();
			Ext.getCmp('prevDiff').hide();
			Ext.getCmp('nextDiff').hide();
			Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
			return false;
		}
		//end

		diffoutputdiv.appendChild(diffview.buildView({
			baseTextLines: base,
			newTextLines: newtxt,
			opcodes: opcodes,
			baseTextName: '',
			newTextName: '',
			contextSize: contextSize,
			viewType: viewType,
			requestFrom: 'XMLComparisonPage'
		}));
		
		//Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
		Ext.getCmp('measDiffFrame').update(document.getElementById('diffoutput').innerHTML);
		Ext.getCmp('justDiff').show();
		Ext.getCmp('showAll').show();
		Ext.getCmp('prevDiff').show();
		Ext.getCmp('nextDiff').show();
		Ext.getCmp("showAll").disable();
		Ext.getCmp("justDiff").enable();
		enableAndDisableButton();

		Ext.getCmp('clorCode').update('<table class="colorCodediff" width="100%" height="20px"><tr><td class="xmlComparisonReplace" nowrap width="25%" align="center">Difference ('+replaceCount+','+replaceCount+')</td><td class="xmlComparisonEmpty" nowrap width="25%" align="center">Empty ('+insertCount+','+deleteCount+')</td><td class="xmlComparisonInsertHd" nowrap width="25%" align="center">Insert (0,'+insertCount+')</td><td class="xmlComparisonDeleteHd" nowrap width="25%" align="center">Delete ('+deleteCount+',0)</td></tr></table>');
	}

	
	function showDiff(prevData,presData)
	{
		var urlStr = "../config/XmlComparison/data/ecShowDiff.jsp";
		Ext.Ajax.request({
			url : urlStr,
			standardSubmit : true,
			method: 'POST',
			params : {
				'previousValue' : prevData,
				'presentValue' : presData,
			},
			success : function(response)
			{
				var publicJSON = Ext.decode(response.responseText);
				var tableHtmlData = publicJSON['tableHtmlData'];

				var moreDetailsWin = Ext.create('Ext.window.Window',{
					alias:'widget.showLineDiff',
					title : "SHOW DIFFERENCE",
					id:'diffWindow',
					modal : true,
					resizable : false,
					constrain : true,
					ghost:false,
					closeAction: 'destory',
					doClose: function() {
						this.destroy();
					},
					listeners:{
						show: function(win) {
							if (this.modal) {
								var doms = Ext.dom.Query.select('.x-mask');
								for (var key in doms)
								{
									this.dom=doms[key];
									if (!Ext.isEmpty(this.dom.offsetParent))
									{
										if (this.dom.offsetParent.tagName=='BODY')
										{
											Ext.fly(this.dom).addCls('windowModal');
										}
									}
								}
							}
						},
						hide:  function(win) {
							if (this.modal) {
								Ext.fly(this.dom).removeCls('windowModal');
							}
						},
						afterrender:function(){
							Ext.EventManager.onWindowResize(function(){
							var me = this;
							me.center();
							},this);
						}
					},
					width: 600,
					height: 450,
					padding:'5 10 10 10',
					scroll : true,
					autoScroll : true,
					items : [{
						xtype : "container",
						html : tableHtmlData
					}]
				});
				moreDetailsWin.show();
			}
		});
	}

	function findingNext()
	{
		var divId = document.getElementById("diffoutput").innerHTML=''; 
		var y = document.getElementsByClassName("change");
		var value = document.getElementById("prevDiffIndex").value;
		var rowIndex = 0;
		if(value!=null && value.length>0 )
		{
			var prevIndex = parseInt(value)
			$(y[prevIndex]).find("td").removeClass('xmlComparisonHighlight');
			rowIndex = parseInt(value)+1;
		}
		
		y[rowIndex].scrollIntoView(false);
		var firstTdClass = $(y[rowIndex]).find("td:first").attr('class');
		var secondTdClass = $(y[rowIndex]).find("td:last").attr('class');
		$(y[rowIndex]).find("td").addClass('xmlComparisonHighlight');
		if(y.length !== rowIndex )
		{
			document.getElementById("prevDiffIndex").value = rowIndex;
		}
		
		enableAndDisableButton();
	}

	function findingPrev()
	{
		var divDatainner = document.getElementById("diffoutput").innerHTML;
		var divId = document.getElementById("diffoutput").innerHTML=''; 
		var y = document.getElementsByClassName("change");
		var value = document.getElementById("prevDiffIndex").value;
		var rowIndex = 0;
		if(value!=null && value.length>0 )
		{
			var prevIndex = parseInt(value)
			$(y[prevIndex]).find("td").removeClass('xmlComparisonHighlight');
			rowIndex = parseInt(value)-1;
		}
		y[rowIndex].scrollIntoView(false);
		var firstTdClass = $(y[rowIndex]).find("td:first").attr('class');
		var secondTdClass = $(y[rowIndex]).find("td:last").attr('class');
		$(y[rowIndex]).find("td").addClass('xmlComparisonHighlight');
		
		if(rowIndex>=0 )
		{
			document.getElementById("prevDiffIndex").value = rowIndex;
		}
		enableAndDisableButton();
	}

	function enableAndDisableButton()
	{
		var curIndex = document.getElementById("prevDiffIndex").value;
		Ext.getCmp('prevDiff').disable();
		Ext.getCmp('prevDiff').setIconCls("iconConfigComparePrevDisabled");
		Ext.getCmp("nextDiff").enable();
		Ext.getCmp("nextDiff").setIconCls("iconConfigCompareNext");
		
		var x = document.getElementsByClassName("change");
		if(x == null || x.length == 0)
		{
			Ext.getCmp('justDiff').disable();
			Ext.getCmp('justDiff').setIconCls("iconConfigCompareNextDisabled");
			Ext.getCmp('nextDiff').disable();
			Ext.getCmp('nextDiff').setIconCls("iconConfigCompareNextDisabled");
		}
		if(curIndex!=null && curIndex.length>0)
		{
			curIndex = parseInt(curIndex);
			if(curIndex>0)
			{
				Ext.getCmp('prevDiff').enable();
				Ext.getCmp('prevDiff').setIconCls("iconConfigComparePrev");
				
			}
			
			if(curIndex == (x.length)-1)
			{
				Ext.getCmp("nextDiff").disable();
				Ext.getCmp("nextDiff").setIconCls("iconConfigCompareNextDisabled");
			}
		}
		
	}

	
	function checkErrorXML(x) {
		xt = ""
		h3OK = 1
		checkXML(x)
	}

	function checkXML(n) {
		var l, i, nam
		nam = n.nodeName
		if (nam == "h3") {
			if (h3OK == 0) {
				return;
			}
			h3OK = 0
		}
		if (nam == "#text") {
			xt = xt + n.nodeValue + "\n"
		}
		l = n.childNodes.length
		for (i = 0; i < l; i++) {
			checkXML(n.childNodes[i])
		}
	}

	function validateXmlData(xmlString)
	{
		//code for IE
		 if (window.ActiveXObject) { 
			 var oXML = new ActiveXObject("Microsoft.XMLDOM"); oXML.loadXML(xmlString);
			 return oXML;
		 }
		 // code for Chrome, Safari, Firefox, Opera, etc. 
		 else 
		 {
			 var parser = new DOMParser();
			 var xmlDoc = parser.parseFromString(xmlString, "text/xml");
			if (xmlDoc.getElementsByTagName("parsererror").length > 0)
			{
				checkErrorXML(xmlDoc.getElementsByTagName("parsererror")[0]);
				return xt;
			}
			else
			{
				return '';
			}
		 }
	}

	function validateSingleByte(input)
	{
		for(var i=0;i<input.length;i++)
		{
			var charValue=input.charCodeAt(i);
			if(charValue>255)
				return false;
		}
		return true;
	}