Ext.apply(Ext.form.VTypes, {
	fileTypeCheck: function(val, field) 
	{
		var fileType1 = /^.*\.(xml)$/i;
		var fileType2 = /^.*\.(txt)$/i;
		return fileType1.test(val) || fileType2.test(val);
	},
	fileUploadText: 'File must be in xml/txt format'
});

Ext.define('XmlComparison.view.FormItems', {
	extend: 'Ext.form.Panel',
	alias: 'widget.formitems',
	headers: {'Content-type':'multipart/form-data'},
	id: 'formitems',
	cls:'formOuter accordionArrow',
	collapsible: true,
	items : [
		{
			xtype : 'container',
			margin : 10,
			layout : {
				type : 'hbox',
				pack : 'center'
			},
			items: [
				{
					xtype: 'filefield',
					cls: 'fileupload',
					vtype:'fileTypeCheck',
					id : 'FILE_0',
					name : 'FILE_0',
					fieldLabel: oldFileName,
					labelCls:'label_bold',
					labelAlign:'top',
					labelSeparator: '',
					labelWidth: 80,
					emptyText :'No file chosen',
					buttonText : 'Browse'
				},
				{
					xtype: 'filefield',
					cls: 'fileupload',
					vtype:'fileTypeCheck',
					id : 'FILE_1',
					name : 'FILE_1',
					labelCls:'label_bold',
					fieldLabel: newFileName,
					labelSeparator: '',
					labelAlign:'top',
					labelWidth: 80,
					emptyText :'No file chosen',
					margin: '0 0 0 20',
					buttonText : 'Browse'
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'submit',
					cls: 'button20',
					margin: '16 0 0 20',
					width: 80
				},
				{
					xtype: 'textfield',
					name: 'contextSize',
					id: 'contextSize',
					hidden:true
				},
				{
					xtype: 'hiddenfield',
					id: 'baseText',
					name: 'baseText',
					value: ''
				},
				{
					xtype: 'hiddenfield',
					id: 'newText',
					name: 'newText',
					value: ''
				},
				{
					xtype: 'hiddenfield',
					id: 'FILE_0_dstFile',
					name: 'FILE_0_dstFile',
					value: fileDestURL // the directory to which the file(s) to be uploaded.
				},
				{
					xtype: 'hiddenfield',
					name: 'FILE_1_dstFile',
					id: 'FILE_1_dstFile',
					value: SecfileDestURL // the directory to which the file(s) to be uploaded.
				}
			]
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},
		collapse: function()
		{
			var file0 = Ext.getCmp("FILE_0").getValue();
			console.log("file0: ",file0);
			var file1 = Ext.getCmp("FILE_1").getValue();
			console.log("file1: ",file1);
		},

		expand: function()
		{

		}
	}
});



