Ext.define('AlwaysVisibleTip', {
    extend: 'Ext.slider.Tip',
	id:'mytip',
	cls: 'yellowTip',
    init: function(slider) {
        var me = this;

        me.callParent(arguments);
        slider.removeListener('dragend', me.hide);
        slider.on({
            scope: me,
            change: me.onSlide,
            afterrender: {
                fn: function() {
                    me.onSlide(slider, null, slider.thumbs[0]);
					tip_hide_task.delay(2000);


                },
                delay: 100
            }
        });
    }
});
var tip_hide_task = new Ext.util.DelayedTask(function(){
      Ext.getCmp('mytip').hide();
});
Ext.define('XmlComparison.view.Main',{
	extend: "utilities.OuterPanel",
	alias: "widget.main",
	requires: [
		'XmlComparison.view.FormItems'
	],
	id: "main",
	autoScroll: false,
	scroll: false,
	title : config.title.mainPageTitle,
	layout: {
		align: "stretch",
		type: "vbox"
	},
	margin : '8 8 0 8',
	items : [
		{
			xtype : 'formitems',
			margin : '8 8 0 8'
		},
		{
			xtype:'panel',
			cls:'datapanel',
			border:true,
			flex: 1,
			hidden:true,
			layout: {
				type:'vbox',
				align:'stretch'
			},
			id: 'differencePanel',
			//frame: false,
			margin: 8,
			items: [
				{
					xtype:'container',
					layout:{
						type:'vbox',
						align:'stretch',
					},
					flex:1,
					border:true,
					id:'temp_panel',
					cls:'XMLComparisonMainDiv',
					style:{'margin-top':'7px'},
					items: [
						{
							xtype: "component",
							id:'diffHeader',
							html:'',
						},
						{
							xtype: "component",
							layout:'fit',
							id:'measDiffFrame',
							name:'measDiffFrame',
							flex:1,
							style:{'overflow-y':'auto'},
							//overflowY: 'auto',
							//overflowX: 'hidden',
							html :''
						}
					]
				}
			],
			dockedItems: [{
				xtype: 'toolbar',
				//layout:{pack:'start'},
				defaults:{
					width:20,
					height:20,
					ui:'xmlConfig_btn'
				},
				items: [
					{
						xtype : 'button',
					
						iconCls: 'iconConfigCompareDiff',
						id : 'justDiff',
						width:20,
						height:20,
						listeners: {
						afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Just Difference'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px',
							overflow:'hidden'
							
						}
					},
					{
						xtype : 'button',
						iconCls: 'iconConfigCompareSameDisabled',
						id : 'showAll',
						disabled: true,
						listeners: {
						afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Show All'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px',
							overflow:'hidden'
						}
					},
					{
						xtype : 'button',
						iconCls: 'iconConfigComparePrevDisabled',
						id : 'prevDiff',
						disabled: true,
						listeners: {
						afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Previous Difference'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px',
							overflow:'hidden'
						}
					},
					{
						xtype : 'button',
						iconCls: 'iconConfigCompareNext',
						id : 'nextDiff',
						height:20,
						width:20,
						margin:'0 10 0 0',
						listeners: {
						afterrender: function () {
								Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: 'Next Difference'
								});
							}
						},
						style: {
							background: 'none',
							border: '0px',
							height:'20px',
							width:'20px',
							overflow:'hidden'
						}
					},
					{
						xtype: "component",
						id:'clorCode',
						height:20,
						flex:1,
						name:'clorCode',
						html :'<table class="colorCodediff" width="100%" height="20px"><tr><td class="xmlComparisonReplace" width="25%" align="center">Difference (1,1)</td><td class="xmlComparisonEmpty" nowrap width="25%" align="center">Empty (1,1)</td><td class="xmlComparisonInsertHd" nowrap width="25%" align="center">Insert (0,1)</td><td class="xmlComparisonDeleteHd" nowrap width="25%" align="center">Delete (1,0)</td></tr></table>'
					}
				]
			}]
			
		}
	]
});



