$.getScript("/final/scripts/utilities/EgChartTheme.js");
function getHighChartsInstance(container_Id,chartHeight,chartWidth){
	 var drawChart = true;
	 var EcHighStockChart = {
		highchart: null,
		defaults: {
			chart: {
				plotBorderWidth: 0,
				plotBorderColor : '#e5e5e5',
				backgroundColor:'#ffffff',
				plotBackgroundColor: 'white',
				plotShadow: false,
				placeValuesInside:0,
				shadow: false,
				zoomType:'xy',
				align:'center',
				ignoreHiddenSeries:false,
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '5');
						$('.highcharts-legend-item rect').attr('width', '9').attr('x', '8');
					}
				}   
			},
			rangeSelector: {
				enabled: false
			},
			global: {
				useUTC: true
				//timezoneOffset: timezoneOffsetValue
			},
			navigator: {
				enabled: false
			},
			yAxis: {
				min: 0,
				border :0,
				tickPixelInterval:75,
				//tickInterval : 1, // added newly
				reversedStacks: false,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				labels: {
					style: {
						color : '#636363',
						fontWeight: 'Normal',
						fontFamily: 'Arial',
						fontSize: '11px'
					},
					formatter: function() {
						var val = Highcharts.numberFormat (this.value,4, '.','');
						//var val_ar = val.split('.');
						val = (parseFloat(val));
						/*if(val_ar.length>1)
						{
							if(val_ar[1]=='0000')
								val = val_ar[0];
							else if (val_ar[1].lastIndexOf("000")>-1)
							{
								val = val_ar[0]+"."+val_ar[1].substring(0,1);
							}else if (val_ar[1].lastIndexOf("00")>-1)
							{
								val = val_ar[0]+"."+val_ar[1].substring(0,2);
							}
						}*/
						return val;
					}
				},
				showLastLabel: true,
				tickPositioner: function(min,max){
					var act = min,
					ticks = [];
					this.tickAmount=1;
					var flag=false;
					var interval=this.tickInterval;
					var second=0;
					if(min==max)
					{
						if(max>1)
							max=max+1;
						else if(max==0){
							max=max+1;
							second=0
							flag=true;
						}
						else
						{
							max=max+0.1;
						}
					}
					var cc=1
					while(act <= max){
						if(cc==2 && flag)
							ticks.push(second);
						else
							ticks.push(act);
						act+= interval;
						cc++;
					}
					if(!flag)
						ticks.push(act);
				  return ticks;  
				}
			},
			scrollbar: {
				enabled: false
			},
			legend: {
				verticalAlign: 'top',
				align:'center',
				layout: 'horizontal',
				//itemDistance : 10,
				borderWidth: 0,
				//y:5,
				//x:5,
				width: 300,
				adjustChartSize: false,
				navigation: {
					arrowSize: 5
				},
				itemStyle: {
					color : '#2a292a',
					fontWeight: 'normal',
					fontFamily: 'Arial',
					fontSize: '10px'
				},
				symbolWidth: 15
			},
			labels :{
				itemStyle: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontFamily: 'Arial',
					fontSize: '10px'
				}
			},
			tooltip: {
				borderColor: 'black',
				valueDecimals: 4,
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontFamily: 'Arial',
					fontSize: '10px'
				}
			},
			exporting: {
				enabled: false
			},
			credits: {
				enabled: false
			},
			xAxis: {
				type:'datetime',
				tickPixelInterval:50,
				min: 0,
				border :1,
				lineWidth: 1,
				minPadding:3,
				//maxPadding:0.02,
				ordinal: false,
				endOnTick: true,
				showFirstLabel: true,
				startOnTick: true,
				labels: {
					style: {
						color : '#636363',
						fontWeight: 'Normal',
						fontFamily: 'Arial',
						fontSize: '11px',
					},
					overflow: 'justify',
					showLastLabel: true,
					endOnTick: true,
					showFirstLabel: true,
					startOnTick: true,
					useHTML: false
				},
				title: {
					style: {
						color : '#636363',
						fontWeight: '500',
						fontFamily: 'Arial',
						fontSize: '11px'
					}
				}
			},
			title: {
				text: '',
				style: {
					color : '#2a292a',
					fontWeight: 'Normal',
					fontFamily: 'Arial',
					fontSize: '8px'
				}
			},
			series: {
			}
		},
		setData: function(jsonData,currentDateFormat,drilldownurl) {
			var toolTipFmt = '';
			var chartType = 'bar';
			var setStacking='normal'
			var setMinPointLength=0;
			var setendOnTick=true;
			var insidePos= jsonData['inside'];
			fontFamily = jsonData['fontName'];
			fontSize = jsonData['fontsize'];
			yaxisTitle = jsonData['yAxisLabel'];
			LegendPosition = jsonData['LegendPosition'];
			showLegend = jsonData['showlegendFont'];
			xLabel = jsonData['xAxisLabel'];
			var xLabelText = jsonData['xAxisLabelText'];
			LegendFont = jsonData['LegendFont'];
			chartType = jsonData['chartType'];
			yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
			YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
			fontFamily='Arial';
			LegendFont='Arial';
			yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
			xLabel =(xLabel == null || xLabel == '')?'':xLabel;
			xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
			titleEnable =(xLabelText == null || xLabelText == '')?false:true;
			fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
			fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
			LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
			LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
			legendWidth = (LegendPosition == 'right')?190:400;
			needLegendFormat = (LegendPosition == 'right')?'true':'false';
			maxLegendHeight = (LegendPosition == 'right')?null:50;
			//valign = (LegendPosition == 'right')?'middle':'top';
			valign=LegendPosition;
			var showLegends =jsonData['legend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			else if(showLegends == 'true')
				showLegends=true;
			if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
				insidePos=false;
			else if(insidePos == 'true')
				insidePos=true;
			var chartTitle =jsonData['title'];
			chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
			var chartContObj=document.getElementById(container_Id);
		   //var setGroupPadding=-0.1;
			var setGroupPadding=-0.065;
			var setPointPadding=0.1;// default value
			var data=jsonData['DataSet'];
			var rotateDegree=0;
			var dataLabelColor='#FFFFFF';
			var chartSubType=jsonData['chartSubType'];
			var drilDown=jsonData['drildown'];
			var setPointWidth=null;
			var setCursor=null;
			var isUptimeChart=jsonData['uptime'];
			//var space =[-5, 10, 20, 10]; // added newly (changed 1st value from 0 to -5)
			var space =[10,0,10,0];
			var titleMargin = 20;
			var yaixlinewidth=0;
			var xtickwidth=0;
			var ticklength=10;
			var xval=-10;
			var ymax=null;
			var isHypervisorResoucesChart=jsonData['isHypervisorChart'];

			/*For Dashboard chart spacing & title margin*/
			var reqFrom = jsonData['reqFrom']; 
			if (reqFrom != null && reqFrom != "" && reqFrom != undefined )
			{
				if(reqFrom == "DashboardPie")
				{
					space = [5,0,0,0];
					titleMargin = 0;
				}
				else if(reqFrom == "DashboardDaywiseChanges")
				{
					space = [5,10,5,10];
					titleMargin = 15;
				}
			}

			//End

			ymax = jsonData['ymax'];
			if (ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
				ymax=null;
			if (!showLegends)
			{
				if(chartSubType!=null && chartSubType=='stacked'){
					if(chartType!=null &&chartType=='column')
						if(chartTitle == null || chartTitle == '')
							space=[40, 10, 10, 10];
				}
			}
			if (drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
			{
				setCursor='pointer';
			}
			var calBarwidth=0;
			var calx = jsonData['legendXVal'];
			var caly = jsonData['legendYVal'];
			if (calx == "" || calx == undefined || calx == null)
			{
				calx=50;
			}
			if (caly == "" || caly == undefined || caly == null)
			{
				caly = 100;
			}
			if (data!=null && data.length>=1)
			{
				//calx = (chartWidth/data.length)+40;
				var xx=data[0].data;
				calBarwidth=21+((chartHeight-((xx.length*21)+50))/xx.length)/10
				//if(xx.length==1)
				if(xx.length==1)
				{
					setGroupPadding=0.2;
					setPointPadding=0.4;
				}
				else if(xx.length>1 && xx.length<=4)
				{
					setGroupPadding=0.2;
					setPointPadding=0.1;
				}
				if(chartType!=null &&chartType=='column')
				{
					setPointWidth=20;
					if(xx.length>45)
					{
						setPointWidth=5;
					}
					else if(xx.length>40)
					{
						setPointWidth=8;
					}
					else if(xx.length>32)
					{
						setPointWidth=10;
					}
					else if(xx.length>21)
					{
						if(reqFrom == "DashboardDaywiseChanges")
						{
							setPointWidth=12;
						}
						else
						{
							setPointWidth=17;
						}
					}
					else if(xx.length>15)
					{
						setPointWidth=17;
					}
					else if(xx.length<=8)
					{
						setGroupPadding=0.25;
						setPointPadding=0.1;
					}
					
					if(isHypervisorResoucesChart==true)
					{
						setPointWidth=12;
						if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
						var isMonthlyChart=jsonData['isMonthlyChart'];
						if(isMonthlyChart==true)
							setPointWidth=null;
					}
				}
			}
			if(isHypervisorResoucesChart==true)
				xval=2;

			var isDataLabelEnable=jsonData['isDataLabelEnabled'];
			var isCombinationLineChart=jsonData['isCombinationLineChart'];
			var setMarkerEnable=true;
			var isEndOnTick=jsonData['endOnTick'];
			if(isDataLabelEnable==false)
			{
				 isDataLabelEnable=false;
			}
			else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
			{
				 isDataLabelEnable=true;
			}
				
			if(chartType!=null && chartType=='pie')
			{
				strpointFormat='';
				dataLabelColor='#2a292a';
				if(strSkin=='Dark' || strSkin=='dark')
						dataLabelColor='#c0c0c0';
			}
			else
			{
				strpointFormat='<b>:{point.y}</b>';
			}
			if(chartType!=null && (chartType=='column' ||chartType=='line'))
			{
				rotateDegree=-90;
				
				if(chartSubType!=null && chartSubType=='stacked')
				{
					xtickwidth=1;
					ticklength=5;
					xval=2;
					strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
				}
				else
				{
					strpointFormat='<b>:{point.y}</b>';
				}
			}
			if(chartType!=null && chartType=='bar')
			{
				yaixlinewidth=1;
				if(chartSubType!=null && chartSubType=='stacked')
				{
					dataLabelColor='#FFFFFF';
					setendOnTick=false;
					if(isUptimeChart!=null && isUptimeChart=='uptimechart')
					{
						setPointWidth=21;
					}
					else
					{
						setPointWidth=20;
					}
				}
				else
				{
					dataLabelColor='#2a292a';
					if(strSkin=='Dark' || strSkin=='dark')
						dataLabelColor='#c0c0c0';
					
					  setMinPointLength=10;
					  setPointWidth=21;
				}
			}
			if(chartType!=null && chartType=='line')
			{
				setStacking=null;
				strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			var fontweight="Normal";
			var fontsize="11px";
			var fontfamily='Arial';
			if(chartType!=null && chartType=='pie'){
				fontsize="11px";
				fontweight="500";
				fontfamily='Arial';
			}
			if(isCombinationLineChart==true)
			{
			setStacking=null;
			setMarkerEnable=false;
			}
			if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
			{
				if(ymax==null)
					setendOnTick=true;
			}
			if(isEndOnTick==false)
			{
				 setendOnTick=false;
			}
			var lablecolor='#2a292a';
			var connColor='#C0C0C0';
			if(strSkin=='Dark' || strSkin=='dark')
			{
				lablecolor='#636363';
				connColor='#9b9fa1';
			}
			var marginbottom=null;
			var marginright=null;
			var mychartwidth=chartWidth;
			var mychartheight=chartHeight;
			var marginTop=20;
			if(xLabel.length>=6)
				marginbottom=chartHeight-20-(xLabel.length)*(setPointWidth+1);
			if(chartType!=null && chartType=='column')
			{
				marginbottom=null;
				marginTop=null;
				//if(chartContObj!=null)
				//	chartContObj.style.height = '100%';
				if(xLabel.length>=6)
					marginright=chartWidth-20-(xLabel.length)*(setPointWidth+5);
				if(marginright>150)
					marginright =30;

				if(marginright<0)
					marginright=chartWidth-20-(xLabel.length)*(setPointWidth+3);
				if(setPointWidth==null)
					marginright=30;
			}
			if(chartType!=null && chartType=='bar')
			{
				mychartwidth=chartWidth; // added newly modified (changed value from null to chartWidth(userdefined width))
				if(chartContObj!=null)
					chartContObj.style.width = '97%';
			}
			if(chartType!=null && (chartType=='line'))
			{
				setendOnTick=false;
				marginTop=null;
				marginbottom=null;
				mychartwidth=null;
				mychartheight=null;
				if(chartContObj!=null)
				{
					chartContObj.style.height = '100%';
					if(chartType=='pie')
						chartContObj.style.width = '100%';
					else
						chartContObj.style.width = '97%';
				}
			}
			var setBorderWidth=0;
			if(chartType!=null && (chartType=='pie')){
				setBorderWidth=1;
			}
			var chartingOptions = {
				chart:{
					height:mychartheight,
					width:mychartwidth,
					type : chartType,
					//spacing : [10,0,10,0]
					spacing:space
					//marginTop:marginTop,
					//marginRight:marginright,
					//marginBottom: marginbottom
				},
				title: {
					text: chartTitle,
					margin : titleMargin
				},
				tooltip: {
					//pointFormat: strpointFormat,
					valueDecimals: 4,
					formatter: function() {
						var val = Highcharts.numberFormat (this.y,4, '.','');
						val = (parseFloat(val));
						if(val ==0)
							return false;
						var s ='';
						
						if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
						{
							if(strSkin=='Dark' || strSkin=='dark')
								s += '<b><span style="color:white">'+val+'</span></b>';
							else
								s += '<b><span style="color:#2a292a">'+val+'</span></b>';
						}else{
							if(strSkin=='Dark' || strSkin=='dark')
								s += '<b><span style="color:white">'+ this.x +'  :  '+val+'</span></b>';
							else
								s += '<b><span style="color:#2a292a">'+ this.x +'  :  '+val+'</span></b>';
						}
						return s;
					}
				},
				yAxis: {
					min: 0,
					max:ymax,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineColor: '#dedede',
					lineColor: '#dedede',
					endOnTick:setendOnTick,
					allowDecimals: false,
					labels: {
						style: {
							color : '#606060',
							fontWeight: 'Normal',
							fontFamily: 'Arial',
							fontSize: '10px'
						}
					},
					title: {
						text: yaxisTitle,
						enabled: YtitleEnable,
						style: {
							color : '#606060',
							fontWeight: '500',
							fontFamily:'Arial',
							fontSize: '11px'
						}
					}
				},
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#dedede',
					lineColor: '#dedede',
					lineWidth:1,
					allowDecimals: false,
					labels: {
						rotation:rotateDegree,
						x:xval,
						style: {
							color : '#606060',
							fontWeight: 'Normal',
							fontFamily: 'Arial',
							fontSize: '10px',
						},
						formatter: function() {
							var val=this.value;
							var val2=val.toString();
							if(val!=null && val.length>32)
							{
								var val2=val.substring(32);
								if(val2.length>3)
									val=val.substring(0,32)+'...';
							}
							return val;
						}
					},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						style: {
							color : '#606060',
							fontWeight: '500',
							fontFamily:'Arial',
							fontSize: '11px'
						}
					}
				},
				plotOptions: {
					pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: '85%',
						allowPointSelect: true,
						cursor: setCursor,
						innerSize: '30%', // for a donut look. check api
						dataLabels: {
							connectorColor: connColor,
							softConnector: false,
							distance:5
						},
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='pie')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
										   document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					},
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						point: {
							//pointRange : 1,
							//pointInterval : 1,
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='bar')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											postForm(QString);
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					},
					column :{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='column')
									{
										if(drilDown!=null && drilDown=='sametab')
										{
											document.location.href=QString;
										}
										else if(drilDown!=null && drilDown=='newtab')
										{
											openInNewWin(QString);
										}
										/*if(QString.indexOf("/")>-1)
										{
											document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}*/
									}
								}
							}
						}
					},
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							enabled:setMarkerEnable,
							fillColor: '#FFFFFF',
							lineWidth: 0.5,
							lineColor: null ,
							symbol:'circle'
						},
						point: {
							events: {
								click: function() {
									var QString=this.options.url;
									if(QString == "" || QString == 'null' || QString == 'undefined' || QString == undefined)
									{
									}
									else if(chartType!=null && chartType=='line')
									{
										if(QString.indexOf("/")>-1)
										{
										  document.location.href=QString;
										}
										else
										{
											openInNewWin(QString);
										}
									}
								}
							}
						}
					},
					series: {
						shadow: false,
						stacking: setStacking, 
						borderWidth: setBorderWidth,
						depth: 0,
						groupPadding:setGroupPadding,
						pointPadding:setPointPadding,
						dataLabels: {
							enabled: isDataLabelEnable,
							inside:insidePos,
							rotation:rotateDegree,
							overflow:'none',
							//x:3,
							color:dataLabelColor,
							style: {
								color : dataLabelColor,
								fontFamily: fontfamily,
								fontSize: fontsize,
								textShadow: false,
								textOutline: false
							},
							//formatter : function() { // added newly
								//var retrunvar = "";
								//if (chartType == "pie")
								//{
									//retrunvar = this.point.name;
								//}
								//else 
								//{
									//retrunvar = this.point.y;
								//}
								//if(retrunvar != undefined && retrunvar.length>20)
								//{
									//c=0;
									//strval=''
									//while(c<retrunvar.length)
									//{
										//strval+=retrunvar.substring(c,c+20)+'<br>';
										//c=c+20;
									//}
									//retrunvar= strval;
								//}
								//return retrunvar;
							//}
						},
						states: {
							hover: {
								enabled: false
							}
						},
						minPointLength:setMinPointLength
					}
				},
				legend: {
					verticalAlign: 'top',
					x: calx,
					y: caly,
					itemDistance:5,
					enabled: showLegends,
					//width:legendWidth,
					align:LegendPosition,
					layout : 'vertical',
					//maxHeight :maxLegendHeight,
					itemStyle: {
						fontFamily:'Arial'
					},
					symbolPadding : 10,
					//itemMarginTop : 0,
					itemMarginBottom : 7
					//labelFormatter: function() {
						//var retrunvar = this.name;
						//if(retrunvar.length>28 && needLegendFormat == 'true')
						//{
							//c=0;
							//strval=''
							//while(c<retrunvar.length)
							//{
								//strval+=retrunvar.substring(c,c+28)+'<br>';
								//c=c+28;
							//}
							//retrunvar= strval;
						//}
						//return retrunvar;
					//}
				}
			};
			var myhtml = '<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>';
			var chartContObj=document.getElementById(container_Id);
			this.highchart= jQuery.extend(true, this.defaults, chartingOptions);
			var chartData=[];
			if(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined)
			{
				drawChart = false;
				if(chartContObj!=null)
				{
					chartContObj.innerHTML=myhtml;
					
				}
			}else{
				this.highchart.series=jsonData['DataSet'];
				this.highchart.chart.renderTo = container_Id;
			}
		},

		drawChart: function() {
			if(drawChart)
			{
				Highcharts.setOptions({
					lang: {
							thousandsSep: ''
						}
				});
				Highcharts.setOptions({
					global: {
						useUTC: true,
						//timezoneOffset: timezoneOffsetValue
					}
				});
				this.highchart= jQuery.extend(true, this.highchart, getUserThemeFor(strSkin));
				Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
				new Highcharts.Chart(this.highchart);
			}
		}

	};
	return EcHighStockChart;
}

function postForm(QString)
{
	var url = '';
	var params = '';
	var len = QString.indexOf('?');
	if (len > -1)
	{
		url = QString.substring(0,len);
		params = QString.substring(len+1);
	}

	var strArr = params.split('&');

    var form = document.createElement('form');
    form.setAttribute('method', 'post');
    form.setAttribute('action', url);

    for (var i=0; i<strArr.length; i++) 
	{
		var name = '';
		var value = '';
		var paramValue = strArr[i];
		var paramLen = paramValue.indexOf('=');
		if (paramLen > -1)
		{
			name = paramValue.substring(0,paramLen);
			value =  decodeURIComponent(paramValue.substring(paramLen+1)).replace(/[+]/g,' ');
		}
        if (strArr.hasOwnProperty(i)) 
		{
            var hiddenField = document.createElement('input');
            hiddenField.setAttribute('type', 'hidden');
            hiddenField.setAttribute('name', name);
            hiddenField.setAttribute('value', value);

            form.appendChild(hiddenField);
        }
    }
    document.body.appendChild(form);
    form.submit();
}



