
diffview = {
	/**
	 * Builds and returns a visual diff view.  The single parameter, `params', should contain
	 * the following values:
	 *
	 * - baseTextLines: the array of strings that was used as the base text input to SequenceMatcher
	 * - newTextLines: the array of strings that was used as the new text input to SequenceMatcher
	 * - opcodes: the array of arrays returned by SequenceMatcher.get_opcodes()
	 * - baseTextName: the title to be displayed above the base text listing in the diff view; defaults
	 *	   to "Base Text"
	 * - newTextName: the title to be displayed above the new text listing in the diff view; defaults
	 *	   to "New Text"
	 * - contextSize: the number of lines of context to show around differences; by default, all lines
	 *	   are shown
	 * - viewType: if 0, a side-by-side diff view is generated (default); if 1, an inline diff view is
	 *	   generated
	 */
	buildView : function (params) {
		var delCnt = 0;
		var insertCnt = 0;
		var replaceCnt = 0;
		var baseTextLines = params.baseTextLines;
		var newTextLines = params.newTextLines;
		var opcodes = params.opcodes;
		var baseTextName = params.baseTextName ? params.baseTextName : "";
		var newTextName = params.newTextName ? params.newTextName : "";
		var contextSize = params.contextSize;
		var requestFrom = params.requestFrom;
		//var flag = params.flag;

		var inline = (params.viewType == 0 || params.viewType == 1) ? params.viewType : 0;

		if (baseTextLines == null)
			throw "Cannot build diff view; baseTextLines is not defined.";
		if (newTextLines == null)
			throw "Cannot build diff view; newTextLines is not defined.";
		if (!opcodes)
			throw "Cannot build diff view; opcodes is not defined.";
		
		function celt (name, clazz) {
			var e = document.createElement(name);
			e.className = clazz;
			if(name =='table')
			{
				e.id = "xmlComp";
			}
			return e;
		}

		function createPreTag(text)
		{
			var e = document.createElement('pre');
			e.className = "preSpace";
			e.appendChild(document.createTextNode(text));
			return e;
		}
		
		function telt (name, text) {
			var e = document.createElement(name);
			e.appendChild(document.createTextNode(text));
			return e;
		}
		
		function ctelt (name, clazz, text) {
			var e = document.createElement(name);
			e.className = clazz;
			e.appendChild(createPreTag(text));
			//if(text.length>70)
			//{
				//var stringRes = breakString(text,70);
				//var brokenStr = convertingToStr(stringRes);
				//e.appendChild(document.createTextNode(brokenStr));
			//}
			//else
			//{
				//e.appendChild(document.createTextNode(text));
			//}
			return e;
		}

		function convertingToStr(brokenStr)
		{
			var resultStr = "";
			if(brokenStr!=null)
			{
				for(var i=0;i<brokenStr.length;i++)
				{
					resultStr += brokenStr[i]+"\n";
				}
			}
			return resultStr;
		}
		function breakString(givenString,screenLen)
		{
			var aListResultant = new Array();
			var strLen = givenString.length;
			var resLen = strLen/screenLen;
			var idx = 0;
			var k = 0;
			if (givenString.indexOf(" ")>-1)
			{
				for (var i=0;i<resLen;i++)
				{
					var res = givenString.substring(idx,idx+screenLen);
					var s = res.length;
					if (res.charAt(s-1)==' ')
					{
						res = res.trim();
						aListResultant.push(res);
						idx = idx+screenLen;
					}
					else
					{
						k = res.lastIndexOf(" ");
						if (k==0 || k == -1)
						{
							aListResultant.push(res.substring(0));
							idx = idx+screenLen;
						}
						else
						{
							aListResultant.push(res.substring(0,k));
							var temp = res.substring(k);
							var m = temp.length;
							idx = idx+screenLen;
							idx = idx-m;
						}
					}
					if (i == resLen-1)
					{
						var lastLen = strLen-idx;
						if (lastLen > screenLen)
						{
							resLen = resLen+1;
						}
					}
				}
				var ss = givenString.substring(idx).trim();
				aListResultant.push(ss);
			}
			else
			{
				for (var i=0;i<resLen ;i++)
				{
					var res = givenString.substring(idx,idx+screenLen);
					aListResultant.push(res);
					idx = idx+screenLen;
				}
				aListResultant.push(givenString.substring(idx));
			}
			
			return aListResultant;
		}

		var tdata = document.createElement("thead");
		var node = document.createElement("tr");
		tdata.appendChild(node);
		if (inline) {
			node.appendChild(document.createElement("th"));
			node.appendChild(document.createElement("th"));
			node.appendChild(ctelt("th", "texttitle", baseTextName + " vs. " + newTextName));
		} else {
			node.appendChild(document.createElement("th"));
			node.appendChild(document.createElement("th"));
			node.appendChild(ctelt("th", "texttitle", baseTextName));
			node.appendChild(document.createElement("th"));
			node.appendChild(ctelt("th", "texttitle", newTextName));
		}
		tdata = [tdata];
		
		var rows = [];
		var node2;
		
		/**
		 * Adds two cells to the given row; if the given row corresponds to a real
		 * line number (based on the line index tidx and the endpoint of the 
		 * range in question tend), then the cells will contain the line number
		 * and the line of text from textLines at position tidx (with the class of
		 * the second cell set to the name of the change represented), and tidx + 1 will
		 * be returned.	 Otherwise, tidx is returned, and two empty cells are added
		 * to the given row.
		 */
		function addCells (row, tidx, tend, textLines, change) {
			if (tidx < tend) {
				row.appendChild(telt("th", (tidx + 1).toString()));
				row.appendChild(ctelt("td", change, textLines[tidx].replace(/\t/g, "\u00a0\u00a0\u00a0\u00a0")));
				return tidx + 1;
			} else {
				row.appendChild(document.createElement("th"));
				row.appendChild(celt("td", "xmlComparisonEmpty"));
				return tidx;
			}
		}
		
		function addCellsInline (row, tidx, tidx2, textLines, change) {
			row.appendChild(telt("th", tidx == null ? "" : (tidx + 1).toString()));
			row.appendChild(telt("th", tidx2 == null ? "" : (tidx2 + 1).toString()));
			row.appendChild(ctelt("td", change, textLines[tidx != null ? tidx : tidx2].replace(/\t/g, "\u00a0\u00a0\u00a0\u00a0")));
		}

		for (var idx = 0; idx < opcodes.length; idx++) {
			code = opcodes[idx];
			change = code[0];
			var b = code[1];
			var be = code[2];
			var n = code[3];
			var ne = code[4];
			var b1 = b;
			var rowcnt = Math.max(be - b, ne - n);
			var toprows = [];
			var botrows = [];

			if (change == 'xmlComparisonDelete')
			{
				delCnt += rowcnt;
			}
			else if (change == 'xmlComparisonInsert')
			{
				insertCnt += rowcnt;
			}
			else if (change == 'xmlComparisonReplace')
			{
				replaceCnt += rowcnt;
			}

			for (var i = 0; i < rowcnt; i++) {
				// jump ahead if we've already provided leading context or if this is the first range
				if (contextSize && opcodes.length > 1 && ((idx > 0 && i == contextSize) || (idx == 0 && i == 0)) && change=="equal") {
					var jump = rowcnt - ((idx == 0 ? 1 : 2) * contextSize);
					
					if (jump > 1) {
						
						toprows.push(node = document.createElement("tr"));
						
						b += jump;
						n += jump;
						i += jump - 1;
						if (!inline)
						{
							node.appendChild(document.createElement("th"))
						}
						node.appendChild(telt("th", "..."));
						if (!inline)
						{
							//node.appendChild(telt("th", ""));
							node.appendChild(ctelt("td", "xmlComparisonSkip", ""));
						}
						node.appendChild(telt("th", "..."));
						node.appendChild(ctelt("td", "xmlComparisonSkip", ""));
						
						// skip last lines if they're all equal
						if (idx + 1 == opcodes.length) {
							break;
						} else {
							continue;
						}
					}
				}
				
				//toprows.push(node = document.createElement("tr"));
				if(change =='xmlComparisonInsert' || change =='xmlComparisonDelete' || change =='xmlComparisonReplace')
				{
					toprows.push(node = celt("tr", "change"));
				}
				else
				{
					toprows.push(node = document.createElement("tr"));
				}
				if (inline) {
					if (change == "xmlComparisonInsert") {
						addCellsInline(node, null, n++, newTextLines, change);
					} else if (change == "xmlComparisonReplace") {
						botrows.push(node2 = document.createElement("tr"));
						if (b < be) addCellsInline(node, b++, null, baseTextLines, "xmlComparisonDelete");
						if (n < ne) addCellsInline(node2, null, n++, newTextLines, "xmlComparisonInsert");
					} else if (change == "xmlComparisonDelete") {
						addCellsInline(node, b++, null, baseTextLines, change);
					} else {
						// equal
						addCellsInline(node, b++, n++, baseTextLines, change);
					}
				} else {
						if(change =='xmlComparisonReplace')
						{
							var leftStr = '';
							var rightStr = '';
							if(b<be)
							{
								leftStr = baseTextLines[b];
							}

							if(n<ne)
							{
								rightStr = newTextLines[n];
							}

							var td = document.createElement("th");
							td.setAttribute("width","10px");
							td.className = "diffTh";
							if (leftStr.trim().length == 0 && rightStr.trim().length == 0) {}
							else
							{
								var link = document.createElement("a");
								//link.setAttribute('href',"javascript:showDiff(\'"+leftStr+"\',\'"+rightStr+"\')");
								link.setAttribute('href','javascript:showDiff(\"'+leftStr+'\",\"'+rightStr+'\")');
								var divId = document.createElement("span");
								divId.className ="iconConfigCompareNotEqualRed";
								divId.title="Show the difference";
								link.appendChild(divId);

								td.appendChild(link);
							}

							node.appendChild(td);
						}
						else
						{
							var td1 = document.createElement("th");
							td1.className = "diffTh";
							node.appendChild(td1);
						}
					b = addCells(node, b, be, baseTextLines, change);
					n = addCells(node, n, ne, newTextLines, change);
				}
			}

			for (var i = 0; i < toprows.length; i++)
			{
				rows.push(toprows[i]);
			}
			for (var i = 0; i < botrows.length; i++)
			{
				rows.push(botrows[i]);
			}
		}

		tdata.push(node = document.createElement("tbody"));

		var rowLen = '';
		if (requestFrom == 'XMLComparisonPage')
		{
			rowLen = (rows.length)-1;
		}
		else
		{
			rowLen = rows.length;
		}
		for (var idx=0;idx<rowLen;idx++)
		//for (var idx=1;idx<rows.length;idx++)
		{
			rows.hasOwnProperty(idx) && node.appendChild(rows[idx]);
		}

		node = celt("table", "diff" + (inline ? " inlinediff" : ""));

		for (var idx in tdata) { 
			tdata.hasOwnProperty(idx) && node.appendChild(tdata[idx]);
		}

		window.deleteCount = delCnt;
		window.insertCount = insertCnt;
		window.replaceCount = replaceCnt;

		return node;
	}
};

