function downloadAsPDF(s_qryString)
{
	var progressBar = Ext.MessageBox.progress({
		title: 'Downloading',
		value: 5,
		width: 350,
		increment: 15,
		closable: false,
		progressText: 'Connecting..',
		wait: true,
		waitConfig: {
			interval: 200
		},
		msg: '<b>Downloading Please wait...</b>',
		scope: this,
		handler: function () {
			this.updateText('Done!');
		}
	});
	var iFrameExists = Ext.query("#pdfIframe");
	if(Ext.isEmpty(iFrameExists))
	{
		Ext.DomHelper.append(document.body,{
			tag: 'iframe',
			frameBorder: 0,
			width: 0,
			height: 0,
			css: 'display:none;visibility:hidden;height:1px;',
			src: s_qryString,
			id: 'pdfIframe'
		});
	}
	else
	{
		Ext.select('#pdfIframe').set({src : s_qryString});
	}

	Ext.Ajax.request(
	{
		url : '/final/config/EcSaveStatusJson.jsp',
		scope:this,
		success: function(response){
			
			var jsonText = response.responseText;
			var jsonData=Ext.decode(jsonText);
			if(!Ext.isEmpty(jsonData))
			{
				var downloadStatus = jsonData.isDownloaded;
				if(downloadStatus)
				{
					progressBar.hide();
				}
			}
			else
			{
				progressBar.hide();
			}
		}
	});
}

function createXTemplate(consolidatedGridCollection,showGridColumnHeader,containsLink,joinColumns,reqFrom)
{
	var gridCollection = "";
	for(key in consolidatedGridCollection)
	{
		var tplView = new Array();
		if ( consolidatedGridCollection[key].dataViewHeading != "" && consolidatedGridCollection[key].dataViewHeading != undefined)
		{
			tplView.push('<table class="configurationTable2" cellspacing="0" style="width:100%" cellpadding="0" border="0" align="center" >');
		}
		else
		{
			tplView.push('<table class="configurationTable1" cellspacing="0" style="width:100%" cellpadding="0" border="0" align="center" >');
		}

		if ( consolidatedGridCollection[key].dataViewHeading != "" && consolidatedGridCollection[key].dataViewHeading != undefined ) // table heading
		{
			tplView.push(
				'<thead>',
					'<tr>',
						'<th class="configurationTableHead">{dataViewHeading}</th>',
					'</tr>',
				'</thead>');
		}

		tplView.push(
			'<tbody>',
			'<tr>',
			'<td width="100%">');

		if ( consolidatedGridCollection[key].dataViewHeading != "" && consolidatedGridCollection[key].dataViewHeading != undefined && reqFrom != null && reqFrom != "" && reqFrom != undefined && reqFrom.toLowerCase() == "consolidatedview")
		{
			tplView.push('<div class="configurationInnerTable">');
		}
		tplView.push('<div class="consolidatedView_div">');
		tplView.push('<table border="0" cellspacing="0" cellpadding="0" class="consolidatedView_table">');

		if (showGridColumnHeader == true) // column header
		{
			tplView.push(
				'<thead><tr>',
					'<tpl for="gridColumn">',
						'<th style="text-align:left;">{.}</th>',
					'</tpl>',
				'</tr></thead>',
				'<tpl for="gridStore">',
					'<tr>'
			);
		}
		else
		{
			tplView.push(
				'<tpl for="gridStore">',
					'<tr>'
			);
		}

		for (c1 in consolidatedGridCollection[key].gridColumn)
		{
			var str = consolidatedGridCollection[key].gridColumn[c1];

			if(joinColumns == true)
			{
				str = str.split(' ').join('');
				str = str.split('(').join('');
				str = str.split(')').join('');
			}

			if(containsLink == true)
			{
				tplView.push('<td><a id="mouse" href=\'javascript:getSystemDetails("{'+str+'}")\' target="main" class="eg_monlink">{'+str+'}</a></td>');
			}
			else
			{
				tplView.push('<td>{'+str+'}</td>');
			}
		}

		tplView.push('</tr>',
				'</tpl>',
			'</table></div>');

		if ( consolidatedGridCollection[key].dataViewHeading != "" && consolidatedGridCollection[key].dataViewHeading != undefined && reqFrom != null && reqFrom != "" && reqFrom != undefined && reqFrom.toLowerCase() == "consolidatedview")
		{
			tplView.push('</div>');
		}

		tplView.push('</td>',
			'</tr>',
			'</tbody>',
			'</table>'
		);
		var template = Ext.create('Ext.XTemplate', tplView);
		var data = template.apply(consolidatedGridCollection[key]);
		gridCollection = gridCollection + data;
	}
	return gridCollection;
}



