var bookletNameAry=[];
var queryStrForSch='';

Ext.define("configutilities.ReportBooklet", {
	extend: 'Ext.button.Button',
	alias: 'widget.reportBooklet',
	id: 'reportBooklet',
	name: 'Test',
	listeners: {
		click:function(button,pressed)
		{
			queryStrForSch = queryString;
			this.getBookletInfo();
		},

		afterrender: function ()
		{
			Ext.create('Ext.tip.ToolTip', {
				target: this.id,
				anchor: 'top',
				cls: 'yellowTip',
				trackMouse: true,
				html: 'Combine Reports'
			});
		}
	},

	getBookletInfo:function()
	{
		var thisBooklet = this;
		var url = '/final/config/EcCombineReports.jsp';
		Ext.Ajax.request({
			url: url,
			params: '',
			scope: this,
			success: function(response)
			{
				var jsonData = response.responseText;
				var groupPDFRes = Ext.decode(response.responseText);
				thisBooklet.openBookletWindow(groupPDFRes);
			},
			failure: function(err)
			{
				Ext.MessageBox.alert('Error occured in ErGroupPDFBean.jsp page');
			}
		});
	},

	openBookletWindow:function(groupPDFRes)
	{
		var thisBooklet = this;
		var isNew = groupPDFRes.isNew;
		var screenLabels = groupPDFRes.screenLabels;
		var dropDwVal = '';
		var hiddenDrop = false;
		if (isNew == 'true')
		{
			hiddenDrop = true;
		}
		dropDwVal = groupPDFRes.bookletArr;

		Ext.create('Ext.window.Window', {
			title: 'COMBINE REPORT',
			id:'bookletWindow',
			width: 385,
			modal: true,
			closable:true,
			draggable:false,
			resizable:false,
			header:{
				style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
			},
			ui:'newPopupWindow withBorderShadow newplainHeader_border',
			padding:0,
			layout: 'fit',
			listeners:
			{
				show: function (win) 
				{
					if (this.modal)
					{
						var el ;
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							 el = Ext.fly(dom[y]);

						}
					 el.addCls('windowModal');
					}
				},
				afterrender:function()
				{
					Ext.getCmp('bookletID').setFieldLabel(screenLabels['config.common.Add to Booklet']);
					Ext.getCmp('bookletDesId').setFieldLabel(screenLabels['config.common.Description']);
					Ext.getCmp('rNameID').setFieldLabel(screenLabels['config.common.Report Name']);
					Ext.getCmp('viewID').setText(screenLabels['config.common.Preview']);
					Ext.getCmp('addReportID').setText(screenLabels['config.common.Add & Close']);
				}
			},
			items: [
				{
					margin: 10,
					xtype: 'container',
					layout: 'column',
					defaults:{
						labelSeparator:'',
						labelAlign:'top',
						columnWidth: 1.0
					},
					items: [
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							columnWidth:0.4,
							fieldLabel: 'Add to Booklet',
							id: 'bookletID',
							name: 'bookletID',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							listeners: {
								'afterrender':function()
								{
									var bookletID = Ext.getCmp('bookletID');
									bookletID.getStore().loadRawData(dropDwVal);
									bookletID.setValue(dropDwVal[0]['valueField']);
									for(var i=0;i<dropDwVal.length;i++)
									{
										bookletNameAry.push(dropDwVal[i]['displayField']);
									}
								},
								'change': function()
								{
									if (Ext.getCmp('bookletID').getValue() == 'NewBooklet')
									{
										Ext.getCmp('newBookletID').show();
										Ext.getCmp('bookletDesId').show();
									}
									else
									{
										Ext.getCmp('newBookletID').hide();
										Ext.getCmp('newBookletID').setValue('');
										Ext.getCmp('bookletDesId').hide();
										Ext.getCmp('bookletDesId').setValue('');
									}
									Ext.getCmp('bookletWindow').doComponentLayout();
									Ext.getCmp('bookletWindow').doLayout();
								},
							}
						},
						{
							xtype: 'textfield',
							name: 'newBookletName',
							id: 'newBookletID',
							emptyText:'Booklet Name',
							fieldLabel: 'Booklet Name',
							cls: 'textbox',
							margin:'0 0 0 10',
							hidden: !hiddenDrop,
							columnWidth: 0.6,
							maxLength: 32,
							enforceMaxLength: true
						},
						{
							xtype: 'textfield',
							fieldLabel: 'Description',
							name: 'bookletDesId',
							id: 'bookletDesId',
							emptyText: 'Description',
							cls: 'textbox',
							margin:'20 0 0 0',
							hidden: !hiddenDrop
						},
						{
							xtype: 'container',
							layout: 'column',
							margin: '20 0 0 0',
							defaults:{
								labelSeparator:'',
								labelAlign: 'top'
							},
							items:[
								{
									xtype: 'textfield',
									name: 'rName',
									id: 'rNameID',
									columnWidth: 0.45,
									margin: 0,
									cls: 'textbox',
									fieldLabel: 'Report Name',
									emptyText: 'Report Name',
									maxLength:32,
									enforceMaxLength: true
								},
								{
									xtype: 'button',
									text: 'Preview',
									ui:'newButtonSmall',
									id  :'viewID',
									columnWidth: 0.25,
									margin: '20 0 0 10',
									listeners: {
										'click': function() {
											me.printData();
										}
									}
								},
								{
									xtype: 'button',
									text: 'Add & Close',
									id: 'addReportID',
									ui:'newButtonSmall',
									columnWidth: 0.30,
									margin: '20 0 0 10',
									name: 'addReportName',
									listeners: {
										'click': function()
										{
											thisBooklet.addOrUpdateBooklet();
										}
									}
								}
							]
						}
					]
				}
			]
		}).show();
	},

	addOrUpdateBooklet:function()
	{
		var thisBooklet = this;
		var bookletID = Ext.getCmp('bookletID').getValue();
		var newBookletID = Ext.getCmp('newBookletID').getValue();
		var bookletDesId = Ext.getCmp('bookletDesId').getValue();
		var rNameID = Ext.getCmp('rNameID').getValue();
		if(thisBooklet.validateBooklet(newBookletID))
		{
			if(bookletID=='NewBooklet')
			{
				queryStrForSch +=  '&newBookletID=' + newBookletID + '&rNameID=' + rNameID+'&bookletDesId='+bookletDesId;
			}
			else
			{
				queryStrForSch += '&bookletID='+ bookletID + '&rNameID=' + rNameID;
			}
			Ext.Ajax.request({
				url: '../servlet/com.eg.EcBookletC',
				params: queryStrForSch,
				scope: this,
				success: function(response){
					var responseStr = Ext.decode(response.responseText);
					var maxReportID = responseStr.maxReportID;
					var maxBookletID = responseStr.maxBookletID;
					var errorMsg = responseStr.errorMsg;
					if(errorMsg!=undefined && errorMsg!='undefined')
					{
						thisBooklet.getMessageBox('COMBINE REPORT',errorMsg);
					}
					else
					{
						thisBooklet.savePdfToLocal(maxReportID,maxBookletID);
					}
				},
				failure: function(err)
				{
					Ext.MessageBox.alert('Error occured in ErBookletC servlet');
				}
			});
		}
	},

	validateBooklet:function(newBookletID)
	{
		var thisBooklet = this;
		var bookletID = Ext.getCmp('bookletID').getValue();
		var rNameID = Ext.getCmp('rNameID').getValue();
		var bookletDesId = Ext.getCmp('bookletDesId').getValue();
		if(bookletID=='NewBooklet')
		{
			if(newBookletID=="" || newBookletID.length==0)
			{
				thisBooklet.getMessageBox('COMBINE REPORT','Please enter booklet name!');
				return false;
			}
			if(bookletNameAry.length>0 && bookletNameAry.indexOf(newBookletID)>-1)
			{
				thisBooklet.getMessageBox('COMBINE REPORT','Booklet name is already exists!');
				return false;
			}
			if(!checkspecial(newBookletID,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				this.getMessageBox('COMBINE REPORT','Special characters are not allowed');
				return false;
			}
			if(!checkspecial(bookletDesId,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				this.getMessageBox('COMBINE REPORT','Special characters are not allowed');
				return false;
			}
		}
		if(rNameID=="" || rNameID.length==0)
		{
			thisBooklet.getMessageBox('COMBINE REPORT','Please enter Report name!');
			return false;
		}
		if(!checkspecial(rNameID,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			thisBooklet.getMessageBox('COMBINE REPORT','Special characters are not allowed');
			return false;
		}
		return true;
	},

	savePdfToLocal:function(maxReportID,maxBookletID)
	{
		var thisBooklet = this;
		var param='maxReportID='+maxReportID+'&maxBookletID='+maxBookletID+'&isNeedPDFFooter=false';
		Ext.Ajax.request(
		{
			url: '../servlet/com.eg.EcPdfDownloadC',
			params: param,
			scope:this,
			success: function(response)
			{
				thisBooklet.getInfoMessageBox('COMBINE REPORT','Report has been added to the booklet successfully');
				Ext.getCmp('bookletWindow').doClose();
			},
			failure:function()
			{
				alert('Error in EcPdfDownloadC');
			}
		});
	},

	getMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	},

	getInfoMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.INFO
		});
		return false;
	}
});



