Ext.define('configutilities.SendMail', {
	extend : 'Ext.window.Window',
	alias : 'widget.sendmail',
	title : 'SEND MAIL',
	modal : true,
	ghost : false,
	resizable : false,
	constrain : true,
	closeAction : 'destroy',
	id : 'sendmail',
	padding : '5 10 10 10',
	items : [
		{
			xtype: 'form',
			id : 'mailForm',
			layout: 'vbox',
			padding: 10,
			bodyStyle: {
				'background': 'none'
			},
			defaults: {
				cls: 'textbox',
				labelAlign: 'left',
				xtype: 'textfield',
				width: 550
			},
			items: [
				{
					fieldLabel: '<b>To</b>',
					labelSeparator:'',
					name : 'to',
					id : 'to'
				},
				{
					fieldLabel: '<b>Cc</b>',
					name : 'cc',
					id : 'cc',
					labelSeparator:''
				},
				{
					fieldLabel: '<b>Bcc</b>',
					name : 'bcc',
					id: 'bcc',
					labelSeparator:''
				},
				{
					fieldLabel: '<b>Subject</b>',
					name : 'subject',
					id : 'subject',
					labelSeparator:''
				}
			],
			buttons: [
				{
					text: 'Submit',
					cls: 'button20',
					margin: 0,
					handler: function () {
						var form = this.up('form').getForm();
						var sendmail = this.up('#sendmail');
						var toField = Ext.getCmp("to");
						var ccField = Ext.getCmp("cc");
						var bccField = Ext.getCmp("bcc");
						var subjectField = Ext.getCmp("subject").getValue();
						if(!sendmail.validateMailID(toField))
						{
							return;
						}
						if(ccField!=null && ccField.getValue().length >0 && !sendmail.validateMailID(ccField))
						{
							return;
						}
						if(bccField!=null && bccField.getValue().length >0 && !sendmail.validateMailID(bccField))
						{
							return;
						}
						if(!checkblank(subjectField))
						{
							Ext.Msg.alert('Send Mail','Subject should not be empty',function(btn){
								if (btn == 'ok')
								{
									Ext.getCmp("subject").focus(true);
								}
							});
							return;
						}
						Ext.getBody().mask('Sending Mail...');
						form.submit({
							url : '../servlet/egurkha.config.EcSendMail?cmd=ConfigMail&mail=current',
							method: 'POST',
							success: function(form, action){
								Ext.getBody().unmask();
								var jsonObj = Ext.decode(action.response.responseText);
								if (jsonObj.pageFrom == "EcSendMail")
								{
									Ext.Msg.show({
										title:jsonObj.title,
										msg: jsonObj.message,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								else
								{
									if (jsonObj.reason != undefined && jsonObj.reason.length > 0)
									{
										Ext.Msg.show({
											title:jsonObj.title,
											msg: jsonObj.reason,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
									else
									{
										Ext.Msg.show({
											title:jsonObj.title,
											msg: jsonObj.message +"<br>" + jsonObj.footer ,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation'
										});
									}
								}
								sendmail.close();
								delete jsonObj;
							},
							failure: function(form, action) // if result page doest not contain success:true, this method fires
							{
								Ext.getBody().unmask();
								sendmail.close();
								switch (action.failureType) {
									case Ext.form.action.Action.CLIENT_INVALID:
										Ext.Msg.alert('Failure', 'Form fields may not be submitted with invalid values');
										break;
									case Ext.form.action.Action.CONNECT_FAILURE:
										Ext.Msg.alert('Failure', 'Ajax communication failed');
										break;
									case Ext.form.action.Action.SERVER_INVALID:
										Ext.Msg.alert('Failure', action.result.msg);
								}
							}
						});
					}
				}
			]
		}
	],
	initComponent : function()
	{
		Ext.Ajax.request(
		{
			url : '/final/servlet/com.eg.EcConfigurationServletNew?cmd=ConfigMail&mail=current',
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.loadFldLabels(jsonData);
			}
		});
		this.callParent();
	},
	loadFldLabels : function(jsonData)
	{
		var toField=Ext.getCmp("to");
		var ccField=Ext.getCmp("cc");
		var bccField=Ext.getCmp("bcc");
		var subjectField=Ext.getCmp("subject");
		var btnSubmit = Ext.getCmp("submit");
		toField.setFieldLabel(jsonData.labels['config.common.TO']);
		ccField.setFieldLabel(jsonData.labels['config.common.CC']);
		bccField.setFieldLabel(jsonData.labels['config.common.BCC']);
		subjectField.setFieldLabel(jsonData.labels['config.common.Subject']);
		//btnSubmit.setText(jsonData.labels['config.common.Submit']);
		this.setTitle(jsonData.labels['title']);
	},
	validateMailID : function(field)
	{
		var me = this;
		var val = field.getValue();
		var flag = true;
		var arr = val.split(',');
		for(var i=0; i<arr.length; i++)
		{
			if(!me.checkmailID(arr[i],field))
			{
				flag = false;
				return(flag);
			}
		}
		return(flag);
	},
	checkmailID : function(value,field)
	{
		var val = value;
		var flag = true;
		num = 0;
		if( val.charAt(0).indexOf("0") > -1
			|| val.charAt(0).indexOf("1") > -1
			|| val.charAt(0).indexOf("2") > -1
			|| val.charAt(0).indexOf("3") > -1
			|| val.charAt(0).indexOf("4") > -1
			|| val.charAt(0).indexOf("5") > -1
			|| val.charAt(0).indexOf("6") > -1
			|| val.charAt(0).indexOf("7") > -1
			|| val.charAt(0).indexOf("8") > -1
			|| val.charAt(0).indexOf("9") > -1)
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}
		if(val=="")
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}
		if(val!="" && val!=null)
		{
			var s_spl="`~!#$%^*()+={}[]\\|?;\"\'\/<>";
			for(var i=0; i<s_spl.length; i++)
			{
				check_char = val.indexOf(s_spl.charAt(i));
				if(check_char >-1)
				{
					flag = false;
				}
			}
			if(flag==false)
			{
				Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
					if (btn == 'ok')
					{
						field.focus(true);
					}
				});
				flag = false;
				return(flag);
			}
		}
		if(val.charAt((val.length)-1)=='@')
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}

		for(c=0; c < val.length; c++)
		{
			if(val.charAt(c) == '@')
			{
				num++;
			}
		}
		if(num > 1)
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}

		if(val.charAt((val.length)-1)=='.')
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}

		if(val.indexOf('@.')>-1)
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}
		if(val.indexOf('@')==-1)
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}
		if(val.indexOf('.')==-1)
		{
			Ext.Msg.alert('Send Mail',_mailIDMessage,function(btn){
				if (btn == 'ok')
				{
					field.focus(true);
				}
			});
			flag = false;
			return(flag);
		}
		return(flag);
	},
	listeners: {
		show: function (win) {
			if (this.modal) {
				var dom = Ext.dom.Query.select('.x-mask');
				var el;
				for (var y = 0; y < dom.length; y++) {
					el = Ext.fly(dom[y]);
				}
				el.addCls('windowModal');
			}
		},
		hide: function (win) {
			
			if (this.modal) {
				var dom = Ext.dom.Query.select('.x-mask');
				var el;
				for (var y = 0; y < dom.length; y++) {
					el = Ext.fly(dom[y]);
				}
				el.removeCls('windowModal');
			}
		}
	}
});



