<%
/*****************************************************************************************************
*	Name		:	EgAgentLogView.jsp
*	Purpose		:	To view the Log Files from the selected Agent.
******************************************************************************************************/
%>
<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>
<%@ page import ="java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import="com.eg.EgLicenseInfo" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgServerList" %>
<%@ page import="com.eg.EgConMonHelper" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="egurkha.UserBean" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=AgentLogs");
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=AgentLogs");
			}
			else
			{
				session.setAttribute("reqFrom","AgentLogs");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}
	session.setAttribute("reqFrom","AgentLogs");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("AgentLogs"))
	{
		session.setAttribute("treeViewSrc","AgentLogs");
	}

	Hashtable nick_ip_map = new com.eg.EgDiscInfo("manager").getNickIpMap();
	if(nick_ip_map == null){
		nick_ip_map = new Hashtable();
	}

	ArrayList resultData = new ArrayList();
	LinkedHashMap logsDirMap = new LinkedHashMap();
	ArrayList logFileList = new ArrayList();
	logFileList.add("Select a log file");
	EgLicenseInfo licInfo = new EgLicenseInfo();
	UserBean userBean = new UserBean();

	String agentIP = request.getParameter("agentIP");
	String logFileDir = request.getParameter("logFileDir");
	String logFileName = request.getParameter("logFileName");
	String downloadFlag = request.getParameter("downloadFlag");
	logsDirMap.put("Select a log directory","-1");
	if(agentIP != null && !agentIP.equals("-1"))
	{
		logsDirMap.put("Agent Logs","logs");
		logsDirMap.put(".NET BTM  Logs","logs/.NetProfLogs");
	}
	if(logFileDir != null && !logFileDir.equals("-1"))
	{
		long createTime = 0;
		long currentTime = 0;
		Object logsObj = session.getAttribute("logs_time");
		Object dotNetObj = session.getAttribute(".net_time");

		if(logsObj != null && logFileDir.equals("logs"))
		{
			createTime = ((Long)session.getAttribute("logs_time")).longValue();
			currentTime = System.currentTimeMillis();
			if((currentTime - createTime) <= 600000)
			{
				logFileList = (ArrayList)session.getAttribute("logsFileList");
			}
			else
			{
				session.removeAttribute("logsFileList");
				session.removeAttribute("logs_time");
			}

		}
		else if(dotNetObj != null && logFileDir.equals("logs/.NetProfLogs"))
		{
			createTime = ((Long)session.getAttribute(".net_time")).longValue();
			currentTime = System.currentTimeMillis();
			if((currentTime - createTime) <= 600000)
			{
				logFileList = (ArrayList)session.getAttribute(".netFileList");
			}
			else
			{
				session.removeAttribute(".netFileList");
				session.removeAttribute(".net_time");
			}
		}
		if(logFileList.size() == 1)
		{
			if(agentIP != null && agentIP.length()>0 && agentIP.indexOf(":")>0)
			{
				agentIP = agentIP.substring(0,agentIP.indexOf(":"));
			}
			RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
			if(helper.setAgentIntoControlMode(agentIP))
			{
				helper.executeTask("ListLogFiles", session.getId(), logFileDir + "@#@Y");
				if(helper.isOutputAvailable())
				{
					logFileList.addAll(helper.getOutput());
					if(logFileList != null && logFileList.size()>1)
					{
						if(logFileDir.equals("logs"))
						{
							session.setAttribute("logsFileList",logFileList);
							session.setAttribute("logs_time",new Long(System.currentTimeMillis()));
						}
						else if(logFileDir.equals("logs/.NetProfLogs"))
						{
							session.setAttribute(".netFileList",logFileList);
							session.setAttribute(".net_time",new Long(System.currentTimeMillis()));
						}
					}
				}
			}
		}
		if(logFileList.size() == 1)
		{
			logFileList.clear();
			logFileList.add("No log files found");
		}
	}
	String lastModified = "";
	if(logFileName != null && !logFileName.equals("-1"))
	{
		RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
		if(helper.setAgentIntoControlMode(agentIP))
		{
			helper.executeTask("ReadFile", session.getId(), logFileName + "@#@Y");
			if(helper.isOutputAvailable())
			{
				resultData = helper.getOutput();
				session.setAttribute("logFileContent",resultData);
				long time = Long.parseLong(String.valueOf(resultData.get(0)));
				SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
				lastModified = (String)sdf.format(new Date(time));
			}
		}
	}
	if(downloadFlag != null && downloadFlag.equals("true"))
	{
		PrintWriter pw = null;
		try
		{
			pw = response.getWriter();
			response.setContentType("application/text");
			response.setHeader("Content-Disposition","attachment; filename="+logFileName);
			response.setContentLength(2048);
			if(!resultData.isEmpty())
			{
				for(int i=1;i<resultData.size();i++)
				{
					pw.write(resultData.get(i)+toString()+"\n");
				}
			}
		}
		catch(Exception ioe)
		{
			throw new ServletException(ioe.getMessage());
		}
		finally
		{
			if(pw != null)
				pw.close();
		}
	}
	Set agentSet = new TreeSet();
	ArrayList premiumAgents = userBean.getPremiumAgents();
	ArrayList basicAgents = licInfo.getBasicAgents();
	ArrayList externalAgents = licInfo.getExternalAgents();
	ArrayList remoteAgents = licInfo.getRemoteAgents();

	agentSet.addAll(premiumAgents);
	agentSet.addAll(basicAgents);
	agentSet.addAll(externalAgents);
	agentSet.addAll(remoteAgents);

	ArrayList allAgents = new ArrayList(agentSet);
	EgServerList serverList = new EgServerList();
	ArrayList totalAgents = serverList.getAgentList(allAgents);
	allAgents = new ArrayList();
	if(totalAgents!=null && totalAgents.size() > 0)
	{
		for(int k=0;k<totalAgents.size();k=k+4)
		{
			String thisip = (String) totalAgents.get(k);
			String thisstauts = (String) totalAgents.get(k+1);
			if(thisstauts.equals("Installed-Running"))
			{
				allAgents.add(thisip);
			}
		}
	}
	Collections.sort(allAgents,String.CASE_INSENSITIVE_ORDER);
	if(allAgents.size() > 0)
	{
		allAgents.add(0,"Select an agent IP/Nickname");
	}
	else
	{
		allAgents.add("No Agent IP/Nickname found");
	}
%>
<html>
<head>
<title>eG Agent Logs </title>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<style>
	.iconDownload
	{
		background : url('/final/images/Light/eG_Icons.png') no-repeat top left;
		background-position: -80px -260px; width: 16px; height: 16px;
	}
	.iconRefresh
	{
		background : url('/final/images/Light/eG_Icons.png') no-repeat top left;
		background-position: -40px -280px; width: 16px; height: 16px;
	}

</style>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script>
document.onscroll = function()
{
	clearTimeout(time);
	time = setTimeout(logout,timeoutTime);
}
</script>
<script language="javascript">
var loading = false;
var selectedIp = "";
var selectedDir = "";
var selectedFile = "";

function selectBoxDisable(value)
{
	var selectObjOne = document.getElementById("agentTypes");
	var selectObjTwo = document.getElementById("logdir");
	var selectObjThree = document.getElementById("logname");
	if(selectObjOne!=null && selectObjTwo!=null && selectObjThree != null)
	{
		if(value == 'true')
		{
			selectObjOne.disabled = true;
			selectObjTwo.disabled = true;
			selectObjThree.disabled = true;
			loading = true;
		}
		else
		{
			selectObjOne.disabled = false;
			selectObjTwo.disabled = false;
			selectObjThree.disabled = false;
			loading = false;
		}
	}
}

function showLoadImage()
{
	selectBoxDisable("true");
	var loading_image = document.getElementById("loading_image");
	if (loading_image != null)
	{
		loading_image.style.display = "block";
		loading_image.style.position = 'absolute';
		bringToFront(loading_image);
	}
}
function getObj()
{
	var selIp = document.getElementById("agentTypes");
	var selDir = document.getElementById("logdir");
	var selFile = document.getElementById("logname");
	selectedIp = selIp[selIp.selectedIndex].value;
	selectedDir = selDir[selDir.selectedIndex].value;
	selectedFile = selFile[selFile.selectedIndex].value;
}

function changeIp(value)
{
	window.location.href="/final/misc/EgAgentLogView.jsp?sessionInUse=true&agentIP="+value;
}

function changeLogDir()
{
	getObj();
	var queryString ="sessionInUse=true&";
	if(selectedDir != '-1')
	{
		queryString += "agentIP="+selectedIp+"&logFileDir="+selectedDir;
		showLoadImage();
	}
	window.location.href="/final/misc/EgAgentLogView.jsp?"+queryString;
}

function changeLogFile()
{
	getObj();
	var queryString = "sessionInUse=true&agentIP="+selectedIp+"&logFileDir="+selectedDir+"&logFileName="+selectedFile;
	window.location.href="/final/misc/EgAgentLogView.jsp?"+queryString;
	showLoadImage();
}

function loadFile(action)
{
	getObj();
	var queryString = "";
	if(action == 'refresh')
	{
		showLoadImage();
	}
	else if (action == 'download')
	{
		queryString = "downloadFlag=true&";
	}
	queryString += "sessionInUse=true&agentIP="+selectedIp+"&logFileDir="+selectedDir+"&logFileName="+selectedFile;
	window.location.href="/final/misc/EgAgentLogView.jsp?"+queryString;
}

function bringToFront(obj)
{
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();
	var max_index = 0;
	var cur_index;
	for (var i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}

function getAbsoluteDivs()
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (var i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
		}
	return arr;
}

var $j = jQuery.noConflict();

jQuery.fn.egResize = function() {
	var winWidth = window.innerWidth;
	var winHeight = window.innerHeight;

	$j(".logFrame").width(winWidth-20);
	$j(".tableWidth").width(winWidth-20);
<%
	if(logFileName != null && !logFileName.equals("-1") && resultData.size() > 1)
	{
%>
	$j(".logFrame").height(winHeight-129);
	$j(".tableWidth").height(winHeight-129);
<%
	}
	else
	{
%>
	$j(".tableWidth").height(winHeight-103);
	$j(".tableWidth").height(winHeight-103);
<%
	}
%>
};

$j(document).ready(function(){
	$j(document).egResize();
});

$j(window).resize(function(){
	$j(document).egResize();
});
</script>
</head>
<body class="eg_cellbglits">
<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
		<td class="eg_cellbglits">
			<table cellspacing="0" cellpadding="4" style="border:0px solid red" align="center">
				<tr>
					<td nowrap="" height="23" valign="right"></td>
					<td nowrap="" height="23" align="center"><b>eG Agent Logs</b></td>
				</tr>
				<tr>
					<td nowrap="" height="20" align="center">
						<img src="/final/admin/eg_images/info2.gif">
					</td>
					<td nowrap="" height="15" align="center">This page enables the administrator to view the log files of the agent.</td>
				</tr>
				<tr>
					<td nowrap="" height="11"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" valign="top" align="center" class="eg_cellbglits">
			<table cellspacing="0" width="98.7%" cellpadding="3" style="border:0px solid cyan">
				<tr class="eg_cellbglits">
					<td style="width:32%;text-align:left;"><egui:intnl text='admin.agents.Agent IP/Nickname'/></td>
					<td style="width:32%;text-align:left;"><egui:intnl text='admin.agents.Log file directory'/></td>
					<td style="width:32%;text-align:left;"><egui:intnl text='admin.agents.Log file name'/></td>
				</tr>
				<tr class="eg_cellbglits">
					<td style="width:32%;">
						<select id="agentTypes" name="agentTypes" style="width:100%" onchange='JavaScript:changeIp(this.value)'>
<%
	for (int i=0; i<allAgents.size(); i++)
	{
		String dispField = (String)allAgents.get(i);
		String valueField = dispField;
		String selected = "";
		if(dispField.equalsIgnoreCase("Select an agent IP/Nickname"))
			valueField = "-1";
		if(valueField.equals(agentIP))
			selected="selected";
%>
								<option value="<%=valueField%>"<%=selected%>><b><%=dispField%></b></option>
<%
	}
%>
							</select>
					</td>
					<td style="width:32%" align="center">
						<select id="logdir" name="logdir" style="width:100%" onchange='JavaScript:changeLogDir();'>
<%
	Iterator dirListIter = logsDirMap.keySet().iterator();
	while(dirListIter.hasNext())
	{
		String dispField = (String)dirListIter.next();
		String valueField = (String)logsDirMap.get(dispField);
		String selected = "";
		if(valueField.equals(logFileDir))
			selected="selected";
%>

							<option value="<%=valueField%>"<%=selected%>><b><%=dispField%></b></option>
<%
	}
%>
						</select>
					</td>
					<td style="width:32%" align="right">
						<select id="logname" name="logname" onchange="javascript:changeLogFile();" style="width:100%">
<%
	for(int i=0;i<logFileList.size();i++)
	{
		String dispField = (String)logFileList.get(i);
		String valueField = dispField;
		String selected = "";
		if(dispField.equalsIgnoreCase("Select a log file"))
			valueField = "-1";
		if(valueField.equals(logFileName))
			selected="selected";
%>
									<option value="<%=valueField%>"<%=selected%> ><b><%=dispField%></b> </option>
<%
	}
%>
						</select>
					</td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="98%" style="border:0px solid green">
<%
	if(logFileName != null && !logFileName.equals("-1") && resultData.size()>1)
	{
%>
				<tr nowrap height="26">
					<td style="width:50%;text-align:left;font-weight:bold;font-size: 10px">
						<egui:intnl text='admin.manager.Last modified time'/> &nbsp;:&nbsp;<%=lastModified%>
					</td>
					<td style="width:50%" align="right">
							<a href="javascript:void(0);" onclick="javascript:loadFile('refresh');" title="Refresh">
							<img src="" class="iconRefresh"/></a>&nbsp;&nbsp;&nbsp;
							<a href="javascript:void(0);" onclick="javascript:loadFile('download');" title="Download">
							<img src="" class="iconDownload"/></a>
					</td>
				<tr>
<%
	}
%>
			</table>
			<table cellspacing="0" cellpadding="0" width="98.4%">
				<div id="loading_image" name="loading_image" class="eg_cellbgmedium linesquare" style="display:none;position:absolute;left:35%; top:50%;width:325px;height:80px">
					<img src='/final/admin/eg_images/loading-bar.gif' width='143' height='30' border='0'/><br><br>
					<egui:intnl text='Please wait the log file is being loaded....'/><br>
				</div>
				<div class="tableWidth linesquare">
					<iframe id="logFrame" name="logFrame" src="/final/misc/EgAgentDebugMode.jsp?logFileName=<%=logFileName%>" class="logFrame"  border="0" scrolling="hidden" scroll="no" marginwidth="0px" marginheight="0px" frameborder="0" color="blue" style="background-color:white;width:100%;height:100%;border-width:0px; border-style:solid;overflow:auto; border-color:grey"></iframe>
				<div>
			</table>
		</td>
	</tr>
</table>
</body>
</html>



