<%
/**
 *	File name		: EgBTMQueryDetails.jsp
 *	Purpose			: This page shows the DB query details of BTM/DTM
 *	Version			: eG 6.1
 *	Creation Date	: 2-Aug-2016
 */
%>

<%@ page import ="com.eg.*" %>
<%@ page import ="java.io.*" %>
<%@ page import="java.sql.*"%>
<%@ page import="java.util.*"%>
<%@ page import="egurkha.EgDBConnectUI"%>
<%@ page import ="com.egurkha.util.StringUtils"%>
<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public void getExitPointCutTableInfo(HashMap exitPointCutTableMapper, String key, String[] values)
	{
		if(exitPointCutTableMapper != null && key.length() > 0)
		{
			try
			{
				if (values != null && values.length > 0)
				{
					ArrayList tempList = new ArrayList();
					for(int x=0 ; x<values.length ; x++)
					{
						String tableHeaderStr = values[x];
						tempList.add(tableHeaderStr);
					}
					exitPointCutTableMapper.put(key, tempList);
				}
			}
			catch(Exception ee)
			{
				ee.printStackTrace();
			}
		}
	}
	
	public static void createDbEntry(HashMap mainKVP, HashMap columnNames, EgDBConnectUI dbconnect) throws Exception{
		//System.out.println("Inside createDbEntry method\n");
		
		ArrayList dateList = new ArrayList(Arrays.asList("MSMT_TIME","REQUEST_TIME","REQUEST_DATE"));
		ArrayList doubleList = new ArrayList(Arrays.asList("PRE_PROCESSOR_TIME", "RESPONSE_TIME", "SLOW_URL_THRESHOLD", "STALLED_URL_THRESHOLD", "CPU_TIME", "WAIT_TIME", "BLOCK_TIME","SQL_CALLS","SQL_TIME"));
		ArrayList intList = new ArrayList(Arrays.asList("SEQ_NO"));
		ArrayList blobList = new ArrayList(Arrays.asList("TRACE_DETAILS","DETAILS"));
		
		Connection conn = dbconnect.getConnection();
		Iterator tableNames = mainKVP.keySet().iterator(); 
		while(tableNames.hasNext()){
			Object tableName = tableNames.next();
			ArrayList rowsDataMapList = (ArrayList)mainKVP.get(tableName);
			for(int rowMapIndx = 0; rowMapIndx<rowsDataMapList.size();rowMapIndx++){
				String query = "INSERT INTO " + tableName + " (" + columnNames.get(tableName).toString().replace("[","").replace("]","")+") Values (";
				for(int count=0;count<((List)columnNames.get(tableName)).size();count++) query+="?,";
				query=(query.substring(0,query.length()-1))+")";
				HashMap row = (HashMap)rowsDataMapList.get(rowMapIndx);			
				PreparedStatement psmt = conn.prepareStatement(query);
				ArrayList columnNamesList = (ArrayList)(columnNames.get(tableName));
				for(int columnNameIndx =0; columnNameIndx<columnNamesList.size();columnNameIndx++){					
					String columnName = (String) columnNamesList.get(columnNameIndx);
					int colCount = (((ArrayList)columnNames.get(tableName)).indexOf(columnName))+1;
					if(intList.contains(columnName))
						psmt.setInt(colCount++,Integer.parseInt((String)row.get(columnName)));
					else if(doubleList.contains(columnName))
						psmt.setDouble(colCount++,Double.parseDouble((String)row.get(columnName)));
					else if (dateList.contains(columnName))
						psmt.setTimestamp(colCount++,((java.sql.Timestamp)row.get(columnName)));
					else if (blobList.contains(columnName))
						psmt.setBytes(colCount++,(byte[])row.get(columnName));
					else
						psmt.setString(colCount++,(String)row.get(columnName));						
				}
				System.out.println("Inserting into  "+tableName+"\n"+psmt.executeUpdate()+"Rows Affected.");
			}
		}
	}

	public static boolean deleteDbEntry(String guid,ArrayList tableNames, EgDBConnectUI dbconnect) throws Exception{
		boolean deleted = false;
		Connection conn = dbconnect.getConnection();
		for(int tableNameIndx =0;tableNameIndx<tableNames.size();tableNameIndx++){
			Object tableName = tableNames.get(tableNameIndx);
			PreparedStatement psmt = conn.prepareStatement("DELETE FROM "+(String)tableName+" WHERE EG_GUID=?");
			psmt.setString(1, guid);
			int rowsAffected = psmt.executeUpdate();
			System.out.println("No of Rows Deleted From The Table "+(String)tableName+"  => "+rowsAffected);
			if(rowsAffected>0) deleted = true;				
		}
		return deleted;
	}

	public static boolean guidPresentInDb (String guid, ArrayList tableNames, EgDBConnectUI dbconnect) throws Exception{
		boolean alreadyPresent = false;
		Connection conn = dbconnect.getConnection();
		for(int tableNameIndx =0;tableNameIndx<tableNames.size();tableNameIndx++){
			Object tableName = tableNames.get(tableNameIndx);
			Statement statement = conn.createStatement();
			ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM "+(String)tableName+" WHERE EG_GUID='"+guid+"'");
			while(rs.next())	if (rs.getInt(1)>0) alreadyPresent = true;
		}
		return alreadyPresent;
	}

	public static HashMap getJsonMap(HashMap columnNames, HashMap columnData){
		HashMap mainKVP = new HashMap();
		Iterator tableNames = columnNames.keySet().iterator(); 
		while(tableNames.hasNext()){
			Object tableName = tableNames.next();
			int colNamesCount = ((List)columnNames.get(tableName)).size();
			ArrayList tblDta = new ArrayList();
			List colDtaRows = (List)columnData.get(tableName);
			if(colDtaRows!=null){
				//System.out.println(colDtaRows.size());
				for(int AllRowsColDataIndx =0; AllRowsColDataIndx<colDtaRows.size();AllRowsColDataIndx++){
					Object row = colDtaRows.get(AllRowsColDataIndx);
					HashMap thisRowData = new HashMap();
					for(int elemIndx =0; elemIndx<colNamesCount;elemIndx++){
						String colName = (String)((ArrayList)columnNames.get(tableName)).get(elemIndx);
						Object cellData = ((ArrayList)row).get(elemIndx);
						thisRowData.put(colName, cellData);
					}
					tblDta.add(thisRowData);
				}
			}
			mainKVP.put(tableName, tblDta);
		}
		return mainKVP;
	}
%>

<%
	String guid = request.getParameter("guid");
	String testType = request.getParameter("testType");
	String whoami = request.getParameter("whoami");
	String pwd = request.getParameter("pwd");
	String enableSaveGuidBtn = "";
	if(whoami == null || pwd == null || whoami.equals("null") || pwd.equals("null") || !whoami.equals("egurkha")  || !pwd.equals("admin"))
	{
		%><jsp:forward page="../admin/EgErrorUrl.jsp"/><%
	}
	String[] testTypeArray = null;
	String iniFileName = "eg_apm.ini";
	com.eg.IniFile apmIni = new com.eg.IniFile(EgInstallInfo.getInstallDir()+"/manager/config/"+iniFileName);
	HashMap exitPointCutTableMapper = new HashMap();
	
	if(testType == null){
		testType = "All";
	}

	Vector testTypeFromIni = apmIni.getAllValues("APM_TEST_TYPE");
	Set testTypeSet = new HashSet(testTypeFromIni);
	if (testTypeSet != null)
	{
		testTypeArray = new String[testTypeSet.size()+1];
		testTypeArray[0] = "All";
		Iterator testTypeItr = testTypeSet.iterator();
		int temp = 1;
		while(testTypeItr.hasNext())
		{
			String testTypeNameStr = (String)testTypeItr.next();
			testTypeArray[temp] = testTypeNameStr;
			temp++;
		}
	}
	String[] pointCutNames = apmIni.getVariables("POINTCUT_HEADER_DETAILS");
	if (pointCutNames != null && pointCutNames.length > 0)
	{
		for (int k=0 ; k<pointCutNames.length ; k++)
		{
			String tblHeaderDetails = apmIni.getValue("POINTCUT_HEADER_DETAILS", pointCutNames[k]);
			if (tblHeaderDetails != null && tblHeaderDetails.length() > 0)
			{
				String[] headerInfos = (String[])tblHeaderDetails.split(",");
				getExitPointCutTableInfo(exitPointCutTableMapper, pointCutNames[k], headerInfos);
			}
		}
	}
	
	boolean uploadSuccess = false;
	String fileName = null;
	String fileUpload = request.getParameter("fileUpload");
	String contentType = request.getContentType();

	if(fileUpload!=null && fileUpload.equals("true")){
		if(contentType!=null && contentType.indexOf("multipart/form-data;") > -1){
			InputStream inputStream = null;
			OutputStream outputStream = null;
			String destinationDir = EgInstallInfo.getInstallDir()+"/manager/tomcat/temp/";
			try{
				Part filePart = request.getPart("btmdatafile");
				if(filePart!=null){
					String header = filePart.getHeader("content-disposition");
					if(header!=null && header.length() > 0){
						String fileNameKey = "filename=\"";
						fileName = header.substring(header.indexOf(fileNameKey) + fileNameKey.length(), header.lastIndexOf("\""));
					}
				}
				if(fileName!=null){
					inputStream = filePart.getInputStream();
					outputStream = new FileOutputStream(new File(destinationDir + File.separator + fileName));
					int read = 0;
					byte[] bytes = new byte[1024];

					try{
						while ((read = inputStream.read(bytes)) != -1) {
							outputStream.write(bytes, 0, read);
						}
						uploadSuccess = true;
						System.out.println("Successfully uploaded the file "+fileName+" on the folder "+destinationDir);
					}
					catch(Exception e){
						System.out.println("Exception occured while uploading the file "+fileName);
						e.printStackTrace();
					}
					finally{
						try{
							if (outputStream != null) {
								outputStream.close();
							}
						}
						catch(Exception e){}

						try{
							if (inputStream != null) {
								inputStream.close();
							}
						}
						catch(Exception e){}
					}
				}
			}
			catch(Exception e){
				System.out.println("Exception occured while uploading BTM data file. "+e.getMessage());
				e.printStackTrace();
			}
		}
	}
	//out.println("uploadSuccess :"+uploadSuccess);
	boolean deSerializationDone = false;
	HashMap sourceMap = null;
	HashMap columnNames = null;
	String uploadSuccessFromReq = request.getParameter("uploadSuccess");
	String fileNameFromReq = request.getParameter("fileName");
	if(uploadSuccessFromReq != null && fileNameFromReq != null){
		uploadSuccess = (uploadSuccessFromReq.equalsIgnoreCase("true")) ? true : false;	
		fileName = request.getParameter("fileName");
	}
	
	if(uploadSuccess){
		String filePath = EgInstallInfo.getInstallDir()+"/manager/tomcat/temp/"+fileName;
		FileInputStream fis  = null;
		ObjectInputStream ois = null;
		try {
			fis = new FileInputStream(filePath);
			ois = new ObjectInputStream(fis);
			// read object from file
			Object sourceObject = ois.readObject();
			if(sourceObject!=null && sourceObject instanceof HashMap){
				sourceMap = (HashMap)sourceObject;
			}
			Object columnNameObject = ois.readObject();
			if(columnNameObject!=null && columnNameObject instanceof HashMap){
				columnNames = (HashMap)columnNameObject;
			}

			deSerializationDone = true;
			int len = fileName.length();
			int lastIndex = fileName.lastIndexOf("_");
			if(len > 60 && lastIndex > 0){
				guid = fileName.substring(fileName.lastIndexOf("_")+1 , lastIndex+51);
			}
			else{
				guid = fileName;
			}
			testType = "All";
			System.out.println("BTM Data is de-serialized from the file "+fileName);
		} catch (IOException e) {
			e.printStackTrace();
		}
		finally{
			// closing resources
			try{
				ois.close();
			}catch(Exception e){}
			try{
				fis.close();
			}catch(Exception e){}
		}
	}
	
	String fileDownload = request.getParameter("fileDownload");
	boolean export = false;
	if(fileDownload != null && fileDownload.length() > 0 && fileDownload.equalsIgnoreCase("true")){
		//Download the details of this GUID as a serializable object.
		export = true;
	}
	

	String External_Service_Details = "External_Service_Details";
	String BTM_User_Experience = "BTM_User_Experience";

	if(!deSerializationDone){
		sourceMap = new HashMap();
		columnNames = new HashMap();

		EgDbaseInfo egDbaseInfo = new EgDbaseInfo("manager");

		ArrayList queryTables = null;
		String[] queries = null;
		String errorMsg = "";
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ResultSetMetaData rsmd = null;
		int colCount = 0;

		String[] apmTestTables = apmIni.getVariables("APM_TEST_TYPE");
		if (apmTestTables != null)
		{
			queryTables = new ArrayList();
			EgDBConnectUI dbconnect = new EgDBConnectUI();
			conn = dbconnect.getConnection();
			for (int x=0 ; x<apmTestTables.length ; x++)
			{
				String apmTestType = apmIni.getValue("APM_TEST_TYPE", apmTestTables[x]);
				String testTable = apmTestTables[x]+"_DDD";
				if (apmTestType.equalsIgnoreCase(testType) || testType.equalsIgnoreCase("All"))
				{
					boolean isTableExistsInDB = egDbaseInfo.isTableExistInDB(testTable);
					//System.out.println("isTableExistsInDB = "+isTableExistsInDB);
					if(isTableExistsInDB)
						queryTables.add(testTable);
					else{
						try{
							//System.out.println(testTable);
							if(conn!=null){
								stmt = conn.createStatement();
								rs = stmt.executeQuery("select * from "+testTable);
								//System.out.println("rs = "+rs.next());
								rsmd = rs.getMetaData();
								int count = 1;
								while(rs.next() && count < rsmd.getColumnCount())
									rs.getString(rsmd.getColumnName(count++));
								queryTables.add(testTable);
							}
						}catch(SQLException e){
							//System.out.println("Table -> "+testTable+" Is Not Present In DataBase! ");
						}
					}
				}
			}
			dbconnect.releaseConnection();
			queryTables.add(External_Service_Details);
			queryTables.add(BTM_User_Experience);
		}

		if (queryTables != null && guid != null && guid.length() > 0)
		{
			guid = guid.trim();
			if (queryTables.size() > 0){
				queries = new String[queryTables.size()];
				String orderByStr = "";
				for (int q=0 ; q<queryTables.size() ; q++) {
					String testTableName = (String)queryTables.get(q);
					testTableName = testTableName.trim();
					if (testTableName.endsWith("_DDD") || testTableName.endsWith("_Details"))
						orderByStr = " order by node_order";
					else 
						orderByStr = "";
					queries[q] = "select * from "+testTableName+" where eg_guid='"+guid+"'"+orderByStr;
				}
			}
		}

		ArrayList dddColumnTypes = new ArrayList();
		ArrayList externalColumnTypes = new ArrayList();
		ArrayList userExpColumnTypes = new ArrayList();

		if(queries != null && queries.length > 0)
		{
			EgDBConnectUI dbconnect = new EgDBConnectUI();
			try
			{
				//String displayName = "";
				conn = dbconnect.getConnection();
				stmt = conn.createStatement();
				for (int a=0 ; a<queries.length ; a++)
				{
					String query = queries[a];
					String testTableName = (String)queryTables.get(a);
					boolean dddTable = false;
					//displayName = "Data Details for "+testTableName;
					if(testTableName != null && testTableName.contains("_DDD")) {
						//displayName = "DDD Data Details for "+testTableName;
						dddTable = true;
					}
					try
					{
						rs = stmt.executeQuery(query); // executing all BTM related tables one by one
						if (rs != null){
							rsmd = rs.getMetaData();
						}
					}
					catch(Exception ex){
						rs = null;
						rsmd = null;
						ex.printStackTrace();
					}

					/* VARCHAR - 12 , NUMERIC - 2 , TIMESTAMP - 93 , BLOB - 2004 */
					int totalColumns = rsmd.getColumnCount();

					boolean dddBlobColumn = false;

					if(dddTable){
						ArrayList dddColumnNames = new ArrayList();
						if(dddColumnTypes.size() == 0){
							for(int d = 1; d <=totalColumns; d++){
								int columnType = rsmd.getColumnType(d);
								dddColumnTypes.add(columnType);
								String columnName = rsmd.getColumnName(d);
								dddColumnNames.add(columnName);
							}
							columnNames.put(testTableName , dddColumnNames);
						}
					}
					else if (testTableName.equals(External_Service_Details)){
						ArrayList externalColumnNames = new ArrayList();
						if(externalColumnTypes.size() == 0){
							for(int d = 1; d <=totalColumns; d++){
								int columnType = rsmd.getColumnType(d);
								externalColumnTypes.add(columnType);
								String columnName = rsmd.getColumnName(d);
								externalColumnNames.add(columnName);
							}
							columnNames.put(testTableName , externalColumnNames);
						}
					}
					else if(testTableName.equals(BTM_User_Experience)){
						ArrayList userExpColumnNames = new ArrayList();
						if(userExpColumnTypes.size() == 0){
							for(int d = 1; d <=totalColumns; d++){
								int columnType = rsmd.getColumnType(d);
								userExpColumnTypes.add(columnType);
								String columnName = rsmd.getColumnName(d);
								userExpColumnNames.add(columnName);
							}
							columnNames.put(testTableName , userExpColumnNames);
						}
					}

					ArrayList resultList = new ArrayList();
					while(rs != null && rs.next()) {
						ArrayList rowList = new ArrayList();
						for(int d=1;d<=totalColumns;d++){
							int columnType = rsmd.getColumnType(d);
							if(columnType == 12) {
								String data = rs.getString(d);
								rowList.add(data);
							}
							else if(columnType == 93) {
								Timestamp timeStamp = rs.getTimestamp(d);
								rowList.add(timeStamp);
							}
							else if(columnType == 2) {
								double data = rs.getDouble(d);
								rowList.add(data);
							}
							else if(columnType == 2004) {
								byte[] data = (byte[])rs.getBytes(d);
								rowList.add(data);
							}
							else{
								String data = rs.getString(d);
								rowList.add(data);
							}
						}
						resultList.add(rowList);
					}
					if(resultList.size() > 0){
						sourceMap.put(testTableName , resultList);
					}
				}
			}
			catch(Exception e){
				e.printStackTrace();
				dbconnect.changeConn();
				errorMsg = "Problem while executing query... "+e.toString();
			}
			finally{
				try
				{
					if(rs != null)
						rs.close();
					if(stmt != null)
						stmt.close();
					dbconnect.releaseConnection();
				}
				catch(Exception e1){
					e1.printStackTrace();
				}
				rs=null;
				stmt=null;
				rsmd=null;
			}
		}
	}
	if(guid!=null){
		boolean present = guidPresentInDb(guid,  new ArrayList(Arrays.asList("BusinessTransTest_DDD", "External_Service_Details", "BTM_User_Experience")), new EgDBConnectUI());
		//System.out.println("present = "+ present);
		enableSaveGuidBtn = (present) ? "disabled" : "";
	}
	String operation = request.getParameter("operation");	
	if(export){
		//C:\egurkha\manager\tomcat\temp
		String fileName4ser = "eg_btm_log_"+guid+".ser";
		String filePath = EgInstallInfo.getInstallDir()+"/manager/tomcat/temp/"+fileName4ser;
		FileOutputStream fos  = null;
		ObjectOutputStream oos = null;
		boolean serializationDone = false;
		try {
			fos = new FileOutputStream(filePath);
			oos = new ObjectOutputStream(fos);
			// write object to file
			oos.writeObject(sourceMap);
			oos.writeObject(columnNames);
			serializationDone = true;
			System.out.println("BTM Data is serialized for the guid "+guid);
		} catch (IOException e) {
			e.printStackTrace();
		}
		finally{
			// closing resources
			try{
				oos.close();
			}catch(Exception e){}
			try{
				fos.close();
			}catch(Exception e){}
		}

		// .ser File Download (Begin)
		if(serializationDone)
		{
			BufferedInputStream buf=null;
			ServletOutputStream myOut=null;
			try
			{
				myOut = response.getOutputStream();
				File myfile = new File(filePath);
				//set response headers
				response.setContentType("application/octet-stream");
				response.setHeader("Content-Disposition","attachment; filename="+fileName4ser);
				response.setContentLength((int) myfile.length());
				FileInputStream input = new FileInputStream(myfile);
				buf = new BufferedInputStream(input);
				int readBytes = 0;

				//read from the file; write to the ServletOutputStream
				while((readBytes = buf.read( )) != -1){
					myOut.write(readBytes);
				}
				System.out.println("BTM Data is downloaded for the guid "+guid +"& file name is "+fileName4ser);
			}
			catch (Exception ex){
				ex.printStackTrace();
			}
			finally
			{
				//close the input/output streams
				if (myOut != null)
					myOut.close();
				if (buf != null)
					buf.close();
			}
		}
		//.ser File Download (End)
		return;
	}
	else if(operation!=null && operation.equalsIgnoreCase("create")){
		//System.out.println("  columnNames   "+columnNames);
		EgDBConnectUI dbconnect = new EgDBConnectUI();
		try{
			createDbEntry(getJsonMap(columnNames, sourceMap),columnNames, dbconnect);
		}catch(Exception e){
			dbconnect.changeConn();
//			out.print("Object Exception Occured!");
			response.setStatus(409);
			e.printStackTrace();
		}finally{
			try {
				dbconnect.releaseConnection(); 
			}
			catch(Exception e1){
				e1.printStackTrace();
			}
		}
	}
	else if(operation!=null && operation.equalsIgnoreCase("delete")){
		boolean deleted = false;
		EgDBConnectUI dbconnect = new EgDBConnectUI();
		try{
			System.out.println("List of tables in which data will be deleted = "+new ArrayList(columnNames.keySet()));
			deleted = deleteDbEntry(guid, new ArrayList(columnNames.keySet()), dbconnect);
		}catch(Exception e){
			response.setStatus(409);
			e.printStackTrace();
			dbconnect.changeConn();
		}finally{
			try {
				dbconnect.releaseConnection();
			}
			catch(Exception e1){
				e1.printStackTrace(); 
			}
		}
		if (!deleted) response.setStatus(409);
	}
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>eG Java/.Net Query Helper Page</title>
<link rel="stylesheet" href="//code.jquery.com/ui/1.8.24/themes/base/jquery-ui.css">

<link rel="stylesheet" type="text/css" href="/final/resources/css/ext-eg.css">

<!--
<link rel = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_gray.css"/>
-->

<style>

.newTable {
    border: 0px solid #b5b5b5;
    overflow: auto;
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
}
.newTable table {
    border: 1px solid #cdcdcd;
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
}
.newTable table tbody tr:nth-child(even) {
    background-color: #f9f9f9
}
.newTable table tbody tr:nth-child(odd) {
    background-color: #ffffff
}
.newTable table thead tr th {
    border: 1px solid #cdcdcd;
    padding: 4px 10px 1px 10px;
    font-size: 12px;
    background-color: #e6e6e6;
    text-transform: uppercase;
    line-height: 1.8em;
}
.newTable table thead tr th.subHeader {
    background-color: #f4f5f5;
    text-align: center
}
.newTable table tbody tr td {
    border-bottom: 1px solid #cdcdcd;
    padding: 4px 10px 1px 10px;
    font-size: 12px;
    line-height: 1.8em;
}
.newTable table tbody tr td.iconColumn{
	padding: 2px 10px 1px 10px;
    line-height: 1.6em;
}
.newTable table tbody tr td.rowspanRightBorder {
    border-right: 1px solid #cdcdcd;
}
.newTable table tbody tr td .ellipsisText {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
/*   New components  --> class:newTable  -  styles end here   */

.popupDiv{
	background:#ffffff;
	padding:10px;
	border:1px solid #cccccc;
	border-radius:5px;
	-webkit-box-shadow: 0px 0px 10px 5px rgba(100, 100, 100, 0.35); 
    -moz-box-shadow: 0px 0px 10px 5px rgba(100, 100, 100, 0.35);
    box-shadow: 0px 0px 10px 5px rgba(100, 100, 100, 0.35);
}

.ui-icon-closethick {
    background-image: url(/final/images/Light/newPopupWindowClose.png) !important;
    background-position: left !important;
    margin: 0 5px 0 0 !important;
}

.ui-dialog .ui-dialog-titlebar-close, .ui-icon-closethick {
    width: 16px !important;
    height: 16px !important;
}

.ui-dialog .ui-dialog-titlebar-close {
    background: none !important;
	border: 0px solid red !important;
}

.ui-dialog .ui-dialog-titlebar-close, .ui-dialog .ui-dialog-titlebar-close:hover {
    padding: 0 !important;
}

.ui-button-icon-only .ui-icon {
    left: 0px;
	margin-left:0px;
	top:0px;
}

</style>

<script src="/final/jquery/jquery.js"></script>
<script src="/final/jquery/jquery-ui.js"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/eg_aggregate.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>

<script>
	$(document).ready( function(){
//		Uncomment This to enable DeleteFromDatabase Button after every 5 clicks on the guid cell
		var clickCount=0;
		$("#guid").click(function() {
			clickCount=clickCount+1;
			if(clickCount % 5 == 0)	$("#deleteGuid").attr("disabled", false);
			else $("#deleteGuid").attr("disabled", true);
		})
		$(".tableTotalValue").each(function() {
			var value = $(this).attr("value");
			var $spanId = $(this).attr("data-id");
			$("#"+$spanId).html(value);
		});
	});

	function showTopologyPage($this, url){
		var height = 680; 
		var width = 1300;
		var left = (screen.width/2)-(width/2);
		var top = (screen.height/2)-(height/2);
		var myWindow = window.open(url, "myWindow", "width="+width+", height="+height+", top="+top+", left="+left);
	}
	function getTraceDetails($this,title)
	{
		$($this).closest("td").append('<div class="dialog" title="Trace Details" style="display:none;"> </div>');
		var $table=$($this).closest("td").find('div.tableContainer');
		var $dialog=$($this).closest("td").find('div.dialog');
		$dialog.html($table.html());
		//$dialog.show();
		$dialog.dialog();
		$dialog.dialog("option","width",800);
		$dialog.dialog("option","height",500);
		$dialog.dialog("option","position",'center');
		$dialog.dialog("option","title",title+" Trace Details");
		$dialog.dialog("option", "closeText" ,"");

		$(".tabs").tabs();
		$(".tabs").each(function() {
			$(this).css("display", "inline-block");
		});
	}

	function validateForm() {
		var x = document.forms["BTMQueryForm"]["guid"].value;
		if (x == null || x == "") {
			alert("BTM Request GUID must be filled out");
			return false;
		}
	}

	function save()
	{
		window.location.href = "/final/misc/EgBTMQueryDetails.jsp?sessionInUse=true&fileDownload=true";
	}

	function openUploadWin() {
		showDivs('linkDiv');
	}

	function hideDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display="none";
		}
	}

	function showDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display = 'block';
			show_div.style.position = 'absolute';
			bringToFront(show_div);
		}
	}

	function bringToFront(obj)
	{
		if (!document.getElementsByTagName)
			return;
		var divs = getAbsoluteDivs();  
		var max_index = 0;  
		var cur_index;  
		for (i = 0; i < divs.length; i++)
		{
			var item = divs[i];
			if (item == obj || item.style.zIndex == '')
				continue;
			cur_index = parseInt(item.style.zIndex);
			if (max_index < cur_index)
			{
				max_index = cur_index;
			}
		}
			obj.style.zIndex = max_index + 1;
	}

	function getAbsoluteDivs()  
	{
		var arr = new Array();
		var all_divs = document.body.getElementsByTagName("DIV");
		var j = 0;
		for (i = 0; i < all_divs.length; i++)
			if (all_divs.item(i).style.position=='absolute')
			{
				arr[j] = all_divs.item(i);
				j++;
		}
		return arr;
	}
	function saveToDb(url,guid){	
		$.ajax({
			type: "GET",
			url: url,
			success: function(data){ alert("DataSaved To DataBase!"); },
			error : function(er){ if(er.status == 409) alert("Insert Failed Data Might Be Already Present!");  }
		});
	}
	function deleteFromDb(url){
		$.ajax({
			type: "GET",
			url: url,
			success: function(data){ alert("Data Deleted From DataBase"); },
			error : function(er){ if(er.status == 409) alert("Delete Failed Data Might Not Be Present!");  }
		});
	}
</script>
</head>
<body>
	<div id="linkDiv" class="popupDiv" name="linkDiv" style="display:none;left:500px;top:100px;width:400px;height:70px; position:absolute;">
		<table  border="0" cellspacing="0" cellpadding="0" width="100%">
			<tr>
				<td class="eg_whitebg">
					<table cellspacing="0" cellpadding="3" border="0" width="100%">
						<tr>
							<td >
								<div style="display:block;text-align:right"><a id="closeLink" class="mouse" onclick="hideDivs('linkDiv');"><img src="/final/images/Light/newPopupWindowClose.png" border="0" class="mouse" title="close"></a>
								</div>
							</td>
						</tr>
					</table>
				</td>
			<tr>
				<td>
					<div  id='linkInnerDiv' name='linkInnerDiv' style="height:50px;"> 
						<form name="uploadForm" id="uploadForm"  method = "post" enctype = "multipart/form-data" action="/final/misc/EgBTMQueryDetails.jsp?whoami=egurkha&pwd=admin&fileUpload=true">
						<table>
							<tr>
								<td style="width:80%;padding:10px;"> <input type="file" id="btmdatafile" name="btmdatafile" style="border:1px solid #cccccc;padding:4px;width:100%"/></td>
								<td style="width:100px;text-align:center;padding:10px"> <input type="submit" value="Upload" style="padding:4px 10px"/> </td>
							</tr>
						</table>
						</form>
					</div>
				</td>
			</tr>
		</table>
	</div>

<%
		if (guid == null || testType == null )
		{
			guid = "";
			testType = "All";
%>
			<form name="BTMQueryForm" action="EgBTMQueryDetails.jsp" onsubmit="return validateForm();">
				<INPUT TYPE="hidden" NAME="whoami" value="<%=whoami%>">
				<INPUT TYPE="hidden" NAME="pwd" value="<%=pwd%>">
				<br/>
				<table align="center" width="75%" border="0">
					<th align="left" style="font-size:24px;"><b>eG BTM Debug Helper</b></th>
					<th align="right" style="font-size:16px;text-align:right"><b><%=new java.util.Date()%></b></th>
				</table>
				<br/>
				<div class="newTable">
				<table border="0" width="75%" align="center">
					<tr>
						<td width="50%" ><b>BTM Request GUID </td>
						<td width="50%"><INPUT TYPE="text" NAME="guid" value="<%=guid%>" size="60"></b></td>
					</tr>
					<tr>
						<td width="50%"><b>APM Type</b></td>
						<td width="65%">
							<select name="testType">
	<%		for (int i=0;i<testTypeArray.length;i++)
			{
				String selected = "";
				if (testType.equalsIgnoreCase(testTypeArray[i])) {
					selected = "selected";
				}
	%>							<option value="<%=testTypeArray[i]%>" <%=selected%>><%=testTypeArray[i]%></option><%
			}
	%>						</select>
						</td>
					</tr>
					<tr>
						<td align="center"  colspan="2" style="padding:4px" ><input type="button" value="Export" title="Export the transaction details" disabled style="padding:2px 10px"> <input type="button" value="Import" title="Import the transaction details" onClick="javascript:openUploadWin()" style="padding:2px 10px;margin-left:30px" ></td>
					</tr>
					</table>
					</div>
						<p style="text-align:center;margin:10px">
							<INPUT TYPE="submit" style="padding:2px 10px">
						</p>
					<br>

			</form>
	<%
		}
		else
		{
			int size = sourceMap.size();
			String exportDisabled = "";
			if(size == 0) {
				exportDisabled = "disabled";
			}
%>
			<br/>
				<table align="center" width="75%" border="0">
					<th align="left" style="font-size:24px;"><b>eG BTM Debug Helper</b></th>
					<th align="right" style="font-size:16px;text-align:right"><b><%=new java.util.Date()%></b></th>
				</table>
			<div class="newTable">
			<table border="1" width="75%" align="center">
				<br>
				<tr>
					<td width="45%"><b>DDD Data Details for GUID</td>
					<td id ="guid" width="45%"><%=guid%></b></td>
				</tr>
				<tr>
					<td width="45%"><b>APM TestType</td>
					<td width="45%"><%=testType%></b></td>
				</tr>
				<tr>
					<td align="center" colspan="2" style="padding:4px"><a href="EgBTMQueryDetails.jsp?whoami=<%=whoami%>&pwd=<%=pwd%>&guid=<%=guid%>&testType=<%=testType%>&fileDownload=true"><input style="padding:2px 10px;margin-left:30px" type="button" value="Export" title="Export the transaction details" <%=exportDisabled%>></a> <%if(uploadSuccess){%><input style="padding:2px 10px;margin-left:30px" type="button" value="Save To DataBase" title="Save table Values to DataBase" onClick="javascript:saveToDb('EgBTMQueryDetails.jsp?whoami=<%=whoami%>&pwd=<%=pwd%>&guid=<%=guid%>&testType=<%=testType%>&uploadSuccess=true&fileName=<%=fileName%>&operation=create','<%=guid%>')" <%=enableSaveGuidBtn%>><input style="padding:2px 10px;margin-left:30px" type="button" value="Delete From DataBase" title="Delete table Values From DataBase" id="deleteGuid" onClick="javascript:deleteFromDb('EgBTMQueryDetails.jsp?whoami=<%=whoami%>&pwd=<%=pwd%>&guid=<%=guid%>&testType=<%=testType%>&&operation=delete')" disabled><%}%><input style="padding:2px 10px;margin-left:30px" type="button" value="Import" title="Import the transaction details" onClick="javascript:openUploadWin()"><input style="padding:2px 10px;margin-left:30px" type="button" value="Show Topology From DataBase" title="Shows The Topology Diagram For This GUID" onClick="javascript:showTopologyPage(this,'/final/monitor/eGBTMd3Topology.jsp?&testName=BusinessTransTest&EG_GUID=<%=guid%>')"> </td>
				</tr>
			</table>
			</div>
				<p style="text-align:center;margin:10px">
					<a href="EgBTMQueryDetails.jsp?whoami=<%=whoami%>&pwd=<%=pwd%>"><input style="padding:2px 10px" type="button" value="Back To HomePage"></a>
				</p>
			<br>
<%
			if(deSerializationDone){
%>
				<h4 align="center">Below BTM data's are retrieved from the file : &nbsp;<%=fileName%></h4>
<%
			}
			HashMap userExperienceStateMap = new HashMap();
			userExperienceStateMap.put(5, "Error");
			userExperienceStateMap.put(10, "Stalled");
			userExperienceStateMap.put(15, "Slow");
			userExperienceStateMap.put(20, "Healthy");
			try{
				if(sourceMap.size() > 0) {
					Set keys = sourceMap.keySet();
					Iterator itr = keys.iterator();
					while(itr.hasNext()){
						String tableName = (String) itr.next();
						ArrayList ddDataList = (ArrayList) sourceMap.get(tableName);

						ArrayList columnHeaderNames = (ArrayList) columnNames.get(tableName);
						if(columnHeaderNames==null || columnHeaderNames.size() == 0) {
							continue;
						}

						int rows = ddDataList.size();
						String displayName = "DDD Data Details for "+tableName;
						boolean dddBlobColumn = false;
						boolean extBlobColumn = false;
						int blobIndex = -1;
						boolean isUserExpTable = false;
						if(tableName.equals(BTM_User_Experience)){
							isUserExpTable = true;
						}
%>
					<div id='resultDiv' style='margin:10px;border:1px solid #cccccc'>
					<div id='headerDiv'></div>
					<h4  style="margin:10px;"><%=displayName%> ( Number of rows found : <span id="<%=rows%>Span"> <%=rows%> </span> )</h4>
					<div class="newTable" style="margin:0px 10px 10px 10px;overflow:auto">
					<table border="1" id="wholetable">
						<tr>
<%
						for(int i=0; i<columnHeaderNames.size();i++){
							String headerName = (String) columnHeaderNames.get(i);
							if(headerName.equalsIgnoreCase("trace_details")){
								dddBlobColumn = true;
								blobIndex = i;
							}
							else if(headerName.equalsIgnoreCase("details")){
								extBlobColumn = true;
								blobIndex = i;
							}
%>
							<td nowrap> <b><%=headerName%> </b> </td>
<%
						}
%>
						</tr>
<%
						for(int i=0;i<rows;i++){
							ArrayList rowList = (ArrayList) ddDataList.get(i);
%>
						<tr>
<%
							for(int j=0;j<rowList.size();j++){
								Object data = rowList.get(j);
								if(isUserExpTable && j == 2){
									// User EXP.
									String codeString = data.toString();
									try{
										Integer expCode = Integer.parseInt(codeString);
										Object value = userExperienceStateMap.get(expCode);
										if(value!=null){
											data = value;
										}
									}
									catch(Exception e){
										Double expCode = Double.parseDouble(codeString);
										int code = expCode.intValue();
										Object value = userExperienceStateMap.get(code);
										if(value!=null){
											data = value;
										}
									}
								}
								if(dddBlobColumn && j == blobIndex){
									// DDD BLOB Column
									byte[] allBytesInBlob = (byte[])data;
									ByteArrayInputStream bos = new ByteArrayInputStream(allBytesInBlob);
									ObjectInputStream objectInputStream = new ObjectInputStream(bos);
									String dataString = (String)objectInputStream.readObject();
									ArrayList valueTokens = StringUtils.egTokenizer(dataString,"%*%");
									if(valueTokens != null)
									{
										int valueTokensSize = valueTokens.size();
%>
									<td>
										<div class="tableContainer" style="display:none;">
											<div class="tabs">
												<ul>
													<li><a href="#tabs-1">View TabularData</a></li>
													<li><a href="#tabs-2">View RawData</a></li>
												</ul>
												<div id="tabs-1" class="newTable">
													<table border="1" style="font-size:12px">
													<thead>
														<tr>
															<th>Call Type</th>
															<th>Node Order</th>
															<th>Total Execution Time(ms)</th>
															<th>Self Execution Time(ms)</th>
															<th>Trace Details</th>
														</tr>
													</thead>
													<tbody>
<%
											StringBuilder traceDetailsBuf = new StringBuilder();
											for(int k=0 ; k<valueTokensSize ; k++)
											{
												String valueString = (String) valueTokens.get(k);
												traceDetailsBuf.append(valueString);
												if(valueString != null)
												{
													ArrayList exitPcStackTraceSpliter = StringUtils.egTokenizer(valueString, "#=#");
													if (exitPcStackTraceSpliter != null && exitPcStackTraceSpliter.size() > 0)
													{
														try
														{
															String nodeOrder = (String)exitPcStackTraceSpliter.get(0);
															String execTime = (String)exitPcStackTraceSpliter.get(1);
															String selfExecTime = (String)exitPcStackTraceSpliter.get(2);
															String method = (String)exitPcStackTraceSpliter.get(3);
															String callType = (String)exitPcStackTraceSpliter.get(4);
%>
														<tr>
															<td><%=callType%></td>
															<td><%=nodeOrder%></td>
															<td><%=execTime%></td>
															<td><%=selfExecTime%></td>
															<td><%=method%></td>
														</tr>
<%
														}
														catch(Exception ex) {
															System.err.println("[EgBTMQueryDetails] - StackTraceLine :"+valueString+" StackTrace Spliter :"+exitPcStackTraceSpliter);
															//ex.printStackTrace();
														}
													}
												}
												traceDetailsBuf.append("<br/>");
											}
%>
													</tbody>
													</table>
												</div>
												<div id="tabs-2">
													<p style="font-size:12px"><%=traceDetailsBuf.toString()%></p>
												</div>
											</div>
										</div>
										<input class="traceDetailsClass" type="submit" name="TRACE DETAILS" value="TRACE DETAILS" onclick="getTraceDetails(this,'<%=tableName%>')">
									</td>
<%
									}
								}
								else if(extBlobColumn && j == blobIndex){
									// Ext. BLOB Column
									Hashtable ht = new Hashtable();
									byte[] allBytesInBlob = (byte[])data;
									ByteArrayInputStream bos = new ByteArrayInputStream(allBytesInBlob);
									ObjectInputStream objectInputStream = new ObjectInputStream(bos);
									Hashtable wholeDataFromDb = (Hashtable)objectInputStream.readObject();
									if (wholeDataFromDb != null)
									{
										Iterator dbItr = wholeDataFromDb.keySet().iterator();
										while(dbItr.hasNext())
										{
											String keyData = (String) dbItr.next();
											String type = keyData;
											if(keyData.indexOf("[") > -1){
												type = keyData.substring(0,keyData.indexOf("["));
											}
											Hashtable modifiedDataTable = new Hashtable();
											ArrayList values = (ArrayList)wholeDataFromDb.get(keyData);
											if(values != null){
												modifiedDataTable.put(keyData,values);
											}
											ArrayList temp;
											if(ht != null && ht.containsKey(type))
											{
												temp = (ArrayList) ht.get(type);
												temp.add(modifiedDataTable);
											}
											else
											{
												temp = new ArrayList();
												temp.add(modifiedDataTable);
												ht.put(type, temp);
											}
										}
									}
%>
									<td>
<%
									if (ht != null){
										StringBuilder extDetailsBuf = new StringBuilder();
										Iterator htItr = ht.keySet().iterator();
%>
										<div class="tableContainer" style="display:none;">
											<div class="tabs">
												<ul>
													<li><a href="#tabs-1">View TabularData</a></li>
													<li><a href="#tabs-2">View RawData</a></li>
												</ul>
												<div id="tabs-1" class="newTable">
<%
										while(htItr.hasNext()) {
											String key = (String) htItr.next();
											if(key != null){
%>
													<p><%=key%></p>
													<table border="1" style="font-size:12px">
													<thead>
<%
												if (exitPointCutTableMapper != null && exitPointCutTableMapper.size() > 0){
													Iterator pcItr = exitPointCutTableMapper.keySet().iterator();
													while(pcItr.hasNext()){
														String callTypeStr = (String)pcItr.next();
														if (callTypeStr.equalsIgnoreCase(key)){
															ArrayList tableColList = (ArrayList)exitPointCutTableMapper.get(callTypeStr);
															if(tableColList != null && tableColList.size() > 0) {
																for (int v=0 ; v<tableColList.size() ; v++) {
																	String tableHeaders = (String)tableColList.get(v);
%>
														<th><%=tableHeaders%></th>
<%
																}
															}
														}
													}
												}
												%>
												</thead>
												<tbody>
												<%
												ArrayList outList = (ArrayList)ht.get(key);
												if(outList != null)
												{
													for (int b=0 ; b<outList.size() ; b++)
													{
														Hashtable combinedDataTable = (Hashtable)outList.get(b);
														if (combinedDataTable != null && combinedDataTable.size() > 0)
														{
															Iterator combinedDataTableItr = combinedDataTable.keySet().iterator();
															while(combinedDataTableItr.hasNext())
															{
																String headerStr = (String)combinedDataTableItr.next();
																if(headerStr!= null && headerStr.length() > 0) {
																	ArrayList valueList = (ArrayList)combinedDataTable.get(headerStr);
																	if (valueList != null) {
																		for (int jj=0 ; jj<valueList.size() ; jj++) {
																		String details = (String)valueList.get(jj);
																		String rawData = headerStr+"="+details;
%>
														<tr>
<%
																		if(key.equalsIgnoreCase("SQL") || key.equalsIgnoreCase("HTTP") || key.equalsIgnoreCase("WebService")) {
																			try{
																				if (headerStr.indexOf("[H]") > -1)
																				{
																					String tblCallType = headerStr.substring(0,headerStr.indexOf("[H]"));
																					String tblDbIpAddr = headerStr.substring(headerStr.indexOf("[H]")+3, headerStr.indexOf("[P]"));
																					String tblDbPort = headerStr.substring(headerStr.indexOf("[P]")+3, headerStr.indexOf("[T]"));
																					String tblDbHostName = headerStr.substring(headerStr.indexOf("[T]")+3, headerStr.indexOf("[I]"));
																					String tblDbSid = headerStr.substring(headerStr.indexOf("[I]")+3);
%>
															<td><%=tblCallType%></td>
															<td><%=tblDbIpAddr%></td>
															<td><%=tblDbPort%></td>
															<td><%=tblDbHostName%></td>
															<td><%=tblDbSid%></td>
<%
																				}
																			}
																			catch(Exception ex1) {
																				System.err.println("[EgBTMQueryDetails] - Key :"+key+" Header String  :"+headerStr);
																				ex1.printStackTrace();
																			}
																		}
																		else if(key.equalsIgnoreCase("RMI") || key.equalsIgnoreCase("EMAIL") ||
																				key.equalsIgnoreCase("EJB") || key.equalsIgnoreCase("EXCEPTION") ||
																				key.indexOf("Custom")>-1) {
																					String tblCallType = key;
																							
%>
																<td><%=tblCallType%></td>
<%
																		}
																		else if(key.equalsIgnoreCase("JMS")) {
																			try
																			{
																				if (headerStr.indexOf("[T]") > -1) {
																					String tblCallType = headerStr.substring(0,headerStr.indexOf("[T]"));
																					String tblJmsProvider = headerStr.substring(headerStr.indexOf("[T]")+3, headerStr.indexOf("[I]"));
																					String tblQueueOrTopic = headerStr.substring(headerStr.indexOf("[I]")+3);
%>
																<td><%=tblCallType%></td>
																<td><%=tblJmsProvider%></td>
																<td><%=tblQueueOrTopic%></td>
<%
																				}
																			}
																			catch(Exception ex1) {
																				System.err.println("[EgBTMQueryDetails] - Key :"+key+" Header String  :"+headerStr);
																				ex1.printStackTrace();
																			}
																		}

																		if(details != null){
																			ArrayList extServiceTraceSpliter = StringUtils.egTokenizer(details, "[V]");
																			for (int z=0 ; z<extServiceTraceSpliter.size() ; z++)
																			{
																				String element = (String)extServiceTraceSpliter.get(z);
%>
																<td><%=element%></td>
<%
																			}
																		}
																		extDetailsBuf.append(rawData+"<br/>");
%>
															</tr>
<%
																		}
																	}
																}
															}
														}
													}
												}
												extDetailsBuf.append("<br/>");
											}
%>
														</tbody></table><br/>
<%
										}
%>
													</div>
												<div id="tabs-2">
													<p style="font-size:12px"><%=extDetailsBuf.toString()%></p>
												</div>
											</div>
										</div>
										<input class="traceDetailsClass" type="submit" name="DETAILS" value="DETAILS" onclick="getTraceDetails(this,'<%=tableName%>')">
<%
									}
%>
									</td>
<%
								}
								else{
%>
									<td nowrap> <%=data.toString()%> </td>
<%
								}
							}
%>
						</tr>
<%
						}
%>
					</table>
					</div>
					</div>
<%
					}
				}
				else{
					// No Data Found !!!
					//out.println("No Data Found !!!");
%>
					<table height="100%" width="100%" border="0" class="white_bg" style="table-layout:auto;">
					<tr>
						<td align="center" valign="middle" id="eg_errorsmall" style="font-size:10.5pt"> 
							<img src="/final/images/Light/info_mgs_icon.png" align="center" border="0"/><br>
							No detailed data found for this Guid <%=guid%>
						</td>
					</tr>
				</table>
<%
				}
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
%>
		</div>
</body>
</html>