<%@ page import ="com.eg.EgInstallInfo"%>
<%@ page import ="com.eg.*"%>
<%@ page import ="com.egurkha.util.StringUtils"%>
<%@ page import ="java.text.SimpleDateFormat"%>
<%@ page import ="java.util.*"%>
<%@ page import ="java.io.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setDateHeader("Expires", -1);

	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ManagerLogs");
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=ManagerLogs");
			}
			else
			{
				session.setAttribute("reqFrom","ManagerLogs");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}
	session.setAttribute("reqFrom","ManagerLogs");
	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("ManagerLogs"))
	{
		session.setAttribute("treeViewSrc","ManagerLogs");
	}

	boolean isStandalone = true;
	boolean isPrimary = false;
	boolean isSecondaryRunning = false;

	LinkedHashMap logsDirMap = new LinkedHashMap();
	ArrayList mgrIpList = new ArrayList();
	ArrayList logFileList = new ArrayList();
	TreeSet dateList = new TreeSet();
	LinkedHashMap dateMap = new LinkedHashMap();

	String logFileDir = request.getParameter("logFileDir");
	String logFileName = request.getParameter("logFileName");
	String filterDate = request.getParameter("filterDate");
	String downloadFlag = request.getParameter("downloadFlag");
	String managerIp = request.getParameter("managerIp");
	logFileName = logFileName == null ? "-1" : logFileName;
	String filePath = "";
	String lastModified = "";
	long logFileSize = 0;

	try
	{
		if(managerIp == null || managerIp.length() == 0)
		{
			managerIp = new EgSpecsInfo("manager").getEGServer();
		}
		IniFile egUIFile = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
		File logsFileDir1 = new File(EgInstallInfo.getInstallDir()+ "/manager/logs");
		File logsFileDir2 = new File(EgInstallInfo.getInstallDir()+ "/manager/tomcat/logs");
		if(EgInstallInfo.isClusterSupported)
		{
			ArrayList dirList1 = PMClusterHelper.getSecondaryManagerLogFiles(managerIp ,logFileName, "list","false","manager/logs");
			ArrayList dirList2 = PMClusterHelper.getSecondaryManagerLogFiles(managerIp ,logFileName, "list","false","tomcat/logs");
			if(dirList1 != null && dirList1.size() > 0)
			{
				logsDirMap.put("Manager Logs","manager/logs");
			}
			if(dirList2 != null && dirList2.size() > 0)
			{
				logsDirMap.put("Tomcat Logs","tomcat/logs");
			}

			EgManagersIniForManager mi = EgManagersIniForManager.getInstance();
			isStandalone = false;
			String pMgrIP = mi.getPrimaryManagerIP();
			if(pMgrIP != null)
				mgrIpList.add(pMgrIP);
			if(mi.getSecondaryManagers().size() > 0)
				mgrIpList.addAll(mi.getSecondaryManagers());
			if(managerIp != null && !managerIp.equalsIgnoreCase(pMgrIP))
			{
				EgManagerInfo managerInfo = mi.getManagerlInfo(managerIp);
				isSecondaryRunning = managerInfo.isManagerRunning();
			}
			else
			{
				isPrimary = true;
			}
			if(isPrimary || isSecondaryRunning)
			{
				if(!logFileName.equals("-1"))
					logFileName = EgURLDecoder.decode(request.getParameter("logFileName"),"UTF-8");
				if(logFileDir != null && !logFileDir.equals("-1"))
					logFileList = PMClusterHelper.getSecondaryManagerLogFiles(managerIp ,logFileName, "list","false",logFileDir);
			}
		}
		else if(managerIp != null)
		{
			mgrIpList.add(managerIp);
			if(logsFileDir1.isDirectory()&& logsFileDir1.listFiles().length > 0)
			{
				logsDirMap.put("Manager Logs","manager/logs");
			}
			if(logsFileDir2.isDirectory() && logsFileDir2.listFiles().length > 0)
			{
				logsDirMap.put("Tomcat Logs","tomcat/logs");
			}
		}
		if(mgrIpList.size() == 0)
		{
			mgrIpList.add("No Manager IP/Nickname found");
			logsDirMap.clear();
		}
		if(logFileDir != null && !logFileDir.equals("-1"))
		{
			Boolean dateFlag=true;
			StringTokenizer dateDuplicate = null;
			Date modifiedDate = new Date();
			if(isStandalone)
			{
				File[] logFiles = null;
				if(logFileDir.equals("manager/logs"))
				{
					logFiles = logsFileDir1.listFiles();
					if(!logFileName.equals("-1"))
						filePath = EgInstallInfo.getInstallDir()+ "/manager/logs/"+logFileName;
				}
				else if(logFileDir.equals("tomcat/logs"))
				{
					logFiles = logsFileDir2.listFiles();
					if(!logFileName.equals("-1"))
						filePath = EgInstallInfo.getInstallDir()+ "/manager/tomcat/logs/"+logFileName;
				}
				if(logFiles != null && logFiles.length > 0)
				{
					for(int i=0;i<logFiles.length;i++)
					{
						File file = logFiles[i];
						if(file.isFile())
						{
							logFileList.add(file.getName());
						}
					}
				}
				//Remove the extention type files from manager log files list(logFileList)
				String fileExt = egUIFile.getValue("LOG_FILE_LENGTH","FileExtention");
				String[] exts = StringUtils.getTokens(fileExt,",");
				for(int i=0;i<exts.length;i++)
				{
					for(int j=0;j<logFileList.size();j++)
					{
						String file_name = (String)logFileList.get(j);
						if(file_name.indexOf(exts[i])>0)
						{
							logFileList.remove(j);
							j--;
						}
					}

				}
				if(!logFileName.equals("-1"))
				{
					filePath = StringUtils.replace(filePath,"\\","/");
					String lines="";
					File thisFile = new File(filePath);
					boolean isLineSkip = false;
					String limitStr = egUIFile.getValue("LOG_FILE_LENGTH", "LengthLimit");
					int limit = Integer.parseInt(limitStr);
					long skipBytes = 0;
					logFileSize = thisFile.length();
					long fileLimit = limit * 1024 * 1024;
					BufferedReader buf = new BufferedReader(new InputStreamReader(new FileInputStream(filePath),"UTF-8"));
					if(logFileSize > fileLimit)
					{
						isLineSkip = true;
						skipBytes = logFileSize - fileLimit;
						buf.skip(skipBytes);
					}
					if(logFileName.endsWith(".ini"))
					{
						dateFlag = false;
					}
					while((lines = buf.readLine()) != null)
					{
						if(isLineSkip)
						{
							isLineSkip = false;
						}
						else
						{
							if(lines != null && !lines.equals("") && lines.indexOf(" ") >0)
							{
								dateDuplicate = new StringTokenizer(lines," ");
								String selectDate = dateDuplicate.nextToken();
								if(selectDate.length() == 10)
								{
									dateFlag = selectDate.indexOf("/") == 2 && selectDate.lastIndexOf("/") == 5;
									if(dateFlag)
									{
										dateList.add(selectDate);
									}
								}
							}
						}
					}
					if(buf != null)
					{
						buf.close();
					}
					modifiedDate = new Date(thisFile.lastModified());
					if(filterDate == null)
						filterDate = "-1";
					if(downloadFlag != null && downloadFlag.equals("true"))
					{
						PrintWriter pw = null;
						try
						{
							pw = response.getWriter();
							response.setContentType("application/text");
							response.setHeader("Content-Disposition","attachment; filename="+logFileName);
							buf = new BufferedReader(new InputStreamReader(new FileInputStream(filePath),"UTF-8"));
							response.setContentLength((int)thisFile.length());
							skipBytes = 0;
							isLineSkip = false;
							if(logFileSize > fileLimit)
							{
								isLineSkip = true;
								skipBytes = logFileSize - fileLimit;
								buf.skip(skipBytes);
							}
							while((lines = buf.readLine()) != null)
							{
								if(isLineSkip)
								{
									isLineSkip = false;
								}
								else if(filterDate != null)
								{
									if(!lines.startsWith(filterDate) && !filterDate.equals("-1"))
										continue;
									pw.write(lines+"\n");
								}
							}
						}
						catch(Exception ioe)
						{
							throw new ServletException(ioe.getMessage());
						}
						finally
						{
							if(buf != null)
								buf.close();
							if(pw != null)
								pw.close();
						}
					}
				}
			}
			else if(isPrimary || isSecondaryRunning && !logFileName.equals("-1"))
			{
				if(logFileName.endsWith(".ini"))
				{
					dateFlag = false;
				}
				ArrayList resultData = PMClusterHelper.getSecondaryManagerLogFiles(managerIp ,logFileName,"file","false",logFileDir);
				String timeString = (String)resultData.get(0);
				if(timeString != null && timeString.length() > 0)
				{
					long time = Long.parseLong(timeString.substring(timeString.indexOf("@#")+2));
					modifiedDate = new Date(time);
				}
				String line = "";
				if(resultData != null)
				{
					logFileSize = resultData.size();
					for(int i=1;i<logFileSize;i++)
					{
						line = (String)resultData.get(i);
						if(line != null && !line.equals("") && line.indexOf(" ") > 0)
						{
							dateDuplicate = new StringTokenizer(line," ");
							String selectDate = dateDuplicate.nextToken();
							if(selectDate.length() == 10)
							{
								dateFlag = selectDate.indexOf("/") == 2 && selectDate.lastIndexOf("/") == 5;
								if(dateFlag)
								{
									dateList.add(selectDate);
								}
							}
						}
					}
					if(filterDate == null)
						filterDate = "-1";
					if(downloadFlag != null && downloadFlag.equals("true"))
					{
						PrintWriter pw = null;
						long byteSize = 0;
						try
						{
							pw = response.getWriter();
							response.setContentType("application/text");
							response.setHeader("Content-Disposition","attachment; filename="+logFileName);
							for(int i=1;i<logFileSize;i++)
							{
								String data = (String)resultData.get(i);
								if(filterDate != null)
								{
									if(!data.startsWith(filterDate) && !filterDate.equals("-1"))
										continue;
									data = data.substring(0,data.lastIndexOf("<br>"));
									pw.write(data+"\n");
									byteSize += (data+"\n").length() * 2;
								}
							}
							response.setContentLength((int)byteSize);
						}
						catch(Exception ioe)
						{
							throw new ServletException(ioe.getMessage());
						}
						finally
						{
							if(pw != null)
								pw.close();
						}
					}
				}
			}
			SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a");
			lastModified = (String)sdf.format(modifiedDate);
			ArrayList sortedDate = new ArrayList(dateList);
			if(sortedDate.size() > 0)
			{
				dateMap.put("No Filter","-1");
			}
			else if(!logFileName.equals("-1"))
			{
				dateMap.put("Not Applicable","-1");
			}
			if(dateFlag)
			{
				Collections.sort(sortedDate,new Comparator()
				{
					SimpleDateFormat  f = new SimpleDateFormat("dd/MM/yyyy");
					public int compare(Object obj1, Object obj2)
					{
						try
						{
							int i = f.parse((String)obj2).compareTo(f.parse((String)obj1));
							return i;
						}
						catch (Exception e)
						{
							throw new IllegalArgumentException(e);
						}
					}
				});
				String dispDateFormat = egUIFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
				for(int j=0;j<sortedDate.size();j++)
				{
					String actualDate = (String)sortedDate.get(j);
					java.util.Date date = new java.text.SimpleDateFormat("dd/MM/yyyy",Locale.ENGLISH).parse(actualDate);
					SimpleDateFormat sdf1 = new SimpleDateFormat(dispDateFormat);
					String displayDate = (String)sdf1.format(date);
					dateMap.put(displayDate,actualDate);
				}
			}
		}
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}

	String queryString = "";
	if(isStandalone)
	{
		queryString = "filePath="+filePath;
	}
	else if(isPrimary || isSecondaryRunning)
	{
		queryString = "managerIp="+managerIp+"&logFileName="+logFileName+"&logFileDir="+logFileDir;
	}
	queryString +="&filterDate="+filterDate;
%>
<html>
<head>
<title>eG Manager Logs</title>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<style>
	.iconDownload
	{
		background : url('/final/images/Light/eG_Icons.png') no-repeat top left;
		background-position: -80px -260px; width: 16px; height: 16px;
	}
	.iconRefresh
	{
		background : url('/final/images/Light/eG_Icons.png') no-repeat top left;
		background-position: -40px -280px; width: 16px; height: 16px;
	}

</style>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script>
document.onscroll = function()
{
	clearTimeout(time);
	time = setTimeout(logout,timeoutTime);
}
</script>
<script language="javascript">
var boxIp ='';
var logFileDir = '';
var logFileName ='';
var filDate = '';

function getObj()
{
	var selectedIp = document.getElementById("managerIp");
	var selectedDir = document.getElementById("logdirectory");
	var selectedFile = document.getElementById("logfile");
	var selectedDate = document.getElementById("filterdate");
	boxIp = selectedIp[selectedIp.selectedIndex].value;
	logFileDir = selectedDir[selectedDir.selectedIndex].value;
	logFileName = selectedFile[selectedFile.selectedIndex].value;
	filDate = selectedDate[selectedDate.selectedIndex].value;
}

function changeManagerIp(value)
{
	window.location.href="/final/misc/EgManagerLogView.jsp?managerIp="+value+"&sessionInUse=true";
}

function changeFileDirectory()
{
	getObj();
	var queryString = "logFileDir="+logFileDir+"&managerIp="+boxIp+"&sessionInUse=true";
	window.location.href="/final/misc/EgManagerLogView.jsp?"+queryString;
}

function changeLogFile()
{
	getObj();
	var queryString = "logFileName="+logFileName+"&logFileDir="+logFileDir+"&managerIp="+boxIp+"&sessionInUse=true";
	window.location.href="/final/misc/EgManagerLogView.jsp?"+queryString;
	loadImage();
}

function filterByDate()
{
	getObj();
	var queryString = "filterDate="+filDate+"&logFileName="+logFileName+"&logFileDir="+logFileDir+"&managerIp="+boxIp+"&sessionInUse=true";
	window.location.href="/final/misc/EgManagerLogView.jsp?"+queryString;
}

function loadFile(action)
{
	getObj();
	var queryString = "";
	if(action == 'refresh')
	{
		loadImage();
	}
	else if (action == 'download')
	{
		queryString = 'downloadFlag=true&';
	}
	queryString += "filterDate="+filDate+"&logFileName="+logFileName+"&logFileDir="+logFileDir+"&managerIp="+boxIp+"&sessionInUse=true";
	window.location.href="/final/misc/EgManagerLogView.jsp?"+queryString;
}

function loadImage()
{
	var imageObj= document.getElementById("loading_image");
	if (imageObj != null)
	{
		imageObj.style.display = 'block';
		imageObj.style.position = 'absolute';
		bringToFront(imageObj);
	}
}

function bringToFront(obj)
{
	if (!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();
	var max_index = 0;
	var cur_index;
	for (var i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if (item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if (max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}

function getAbsoluteDivs()
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for (var i = 0; i < all_divs.length; i++)
		if (all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
		}
	return arr;
}

var $j = jQuery.noConflict();
jQuery.fn.egResize = function() {
	var winWidth = window.innerWidth;
	var winHeight = window.innerHeight;

	$j(".logFrame").width(winWidth-20);
	$j(".tableWidth").width(winWidth-20);
<%
	if(!logFileName.equals("-1") && logFileSize > 1)
	{
%>
		$j(".logFrame").height(winHeight-129);
		$j(".tableWidth").height(winHeight-129);
<%
	}
	else
	{
%>
		$j(".logFrame").height(winHeight-103);
		$j(".tableWidth").height(winHeight-103);
<%
	}
%>
};

$j(document).ready(function(){
	$j(document).egResize();
});

$j(window).resize(function(){
	$j(document).egResize();
});
</script>
</head>
<body class="eg_cellbglits">

<table cellspacing="0" cellpadding="0" border="0" width="100%">
	<tr>
		<td class="eg_cellbglits">
			<table cellspacing="0" cellpadding="4" style="border:0px solid red" align="center">
				<tr>
					<td nowrap="" height="23" valign="right"></td>
					<td nowrap="" height="23" align="center"><b>eG Manager Logs</b></td>
				</tr>
				<tr>
					<td nowrap="" height="20" align="center">
						<img src="/final/admin/eg_images/info2.gif">
					</td>
					<td nowrap="" height="15" align="center">This page enables the administrator to view the log files of the manager.</td>
				</tr>
				<tr>
					<td nowrap="" height="11"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td width="100%" valign="top" align="center" class="eg_cellbglits">
			<table cellspacing="0"width="98.7%" cellpadding="3" style="border:0px solid cyan">
				<tr class="eg_cellbglits">
					<td style="width:25%;text-align:left"><egui:intnl text='admin.manager.Manager IP/Nickname'/></td>
					<td style="width:25%;text-align:left"><egui:intnl text='admin.manager.Log file directory'/></td>
					<td style="width:25%;text-align:left"><egui:intnl text='admin.manager.Log file name'/></td>
					<td style="width:25%;text-align:left"><egui:intnl text='admin.manager.Filter by date'/></td>
				</tr>
				<tr class="eg_cellbglits">
					<td style="width:25%;">
						<select id="managerIp" name="managerIp" onchange='JavaScript:changeManagerIp(this.value)' style="width:100%">
<%
	for(int i=0;i<mgrIpList.size();i++)
	{
		String dispField = (String) mgrIpList.get(i);
		String selected = "";
		if(dispField.equals(managerIp))
		{
			selected = "selected";
		}
%>
							<option value="<%=dispField%>" <%=selected%>><b><%=dispField%></b></option>
<%
	}
%>
						</select>
					</td>
					<td style="width:25%;">
						<select id="logdirectory" name="logdirectory" onchange="javascript:changeFileDirectory()" style="width:100%">
							<option value="-1"><b>Select a log file directory</b></option>
<%
	Iterator dirItr = logsDirMap.keySet().iterator();
	while(dirItr.hasNext())
	{
		String dispField = (String)dirItr.next();
		String valueField = (String)logsDirMap.get(dispField);
		String selected = "";
		if(valueField.equals(logFileDir))
		{
			selected = "selected";
		}
%>
							<option value="<%=valueField%>" <%=selected%>><b><%=dispField%></b> </option>
<%
	}
%>
						</select>
					</td>
					<td style="width:25%;">
						<select id="logfile" name="logfile" onchange="javascript:changeLogFile()" style="width:100%;">
							<option value="-1"><b>Select a log file</b></option>
<%
	for(int i=0;i<logFileList.size();i++)
	{
		String dispField = (String)logFileList.get(i);
		String selected = "";
		if(dispField.equals(logFileName))
		{
			selected = "selected";
		}
%>
							<option value="<%=dispField%>" <%=selected%>><b><%=dispField%></b> </option>
<%
	}
%>
						</select>
					</td>
					<td style="width:25%;">
						<select id="filterdate" name="filterdate" onchange="javascript:filterByDate()" style="width:100%;">
<%
	if(dateMap.size() == 0)
	{
%>
							<option value="-1">Select a date</option>
<%
	}
	Iterator dateItr = dateMap.keySet().iterator();
	while(dateItr.hasNext())
	{
		String dispField = (String)dateItr.next();
		String valueField = (String)dateMap.get(dispField);
		String selected = "";
		if(valueField.equals(filterDate))
		{
			selected = "selected";
		}
%>
							<option value="<%=valueField%>" <%=selected%>><b><%=dispField%></b></option>
<%
	}
%>
						</select>
					</td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="98%" style="border:0px solid green">
<%
	if(!logFileName.equals("-1") && logFileSize > 1)
	{
%>
				<tr nowrap height="26">
					<td style="width:50%;text-align:left;font-weight:bold;font-size: 10px">
						<egui:intnl text='admin.manager.Last modified time'/> &nbsp;:&nbsp;&nbsp;&nbsp;<%=lastModified%>
					</td>
					<td style="width:50%" align="right">
							<a href="javascript:void(0);" onclick="javascript:loadFile('refresh');" title="Refresh">
							<img src="" class="iconRefresh"/></a>&nbsp;&nbsp;&nbsp;
							<a href="javascript:void(0);" onclick="javascript:loadFile('download');" title="Download">
							<img src="" class="iconDownload"/></a>
					</td>
				<tr>
<%
	}
%>
			</table>
			<table cellspacing="0" cellpadding="0" width="98.7%">
				<div id="loading_image" name="loading_image" class="eg_cellbgmedium linesquare" style="display:none;position:absolute;left:35%; top:50%;width:325px;height:80px">
					<img src='/final/admin/eg_images/loading-bar.gif' width='143' height='30' border='0'/><br><br>
					<egui:intnl text='Please wait the log file is being loaded....'/><br>
				</div>
				<div class="tableWidth linesquare">
					<iframe id="logFrame" name="logFrame" src="/final/misc/EgManagerDebugMode.jsp?<%=queryString%>" class="logFrame"  border="0" scrolling="hidden" scroll="no" marginwidth="0px" marginheight="0px" frameborder="0" color="blue" style="background-color:white;width:100%;height:100%;border-width:0px; border-style:solid;overflow:auto; border-color:grey"></iframe>
				<div>
			</table>
		</td>
	</tr>
</table>
</body>
</html>



