<!DOCTYPE html>
<%
   /**
	*	Displays alarms occurring currently, marked as critical/minor/warning/normal/unknown. Allows alarms to be
	*	viewed based on the type - all/critical/critical & minor. Allows selected alarms to be deleted.
	*	@created	22/05/2013
	*	@version	6.0
	*/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
	String uiFile = "eg_ui.ini";
	String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(iniFileDir + uiFile);
		
	String queryString = request.getQueryString();
	queryString=(queryString==null)?"":queryString;
	queryString=queryString.trim();
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	boolean isOracleDB=EgDbInfo.isOraAdapter;
	boolean isFromDashBoard = "true".equals(request.getParameter("isFromDashBoard"))?true:false;

	long refreshFrequency = 60 * 1000L;
	String refFreq = u_ser.getRefreshFrequency();

	if(refFreq!=null && refFreq.length()>0)
	{
		refreshFrequency =  Long.valueOf(refFreq).longValue() * 1000L;
	}
	long dashboardRefreshFrequency = 60 * 60 * 1000L;
	String dashboardRefreshStr = egUI.getValue("MONITOR_DASHBOARD","DashboardAlarmRefresh");
	if(dashboardRefreshStr!=null && dashboardRefreshStr.length()>0)
	{
		dashboardRefreshFrequency =  Long.valueOf(dashboardRefreshStr).longValue() * 60 * 1000L;
	}
	String isPopupWindow=request.getParameter("isPopupWindow");
	String isFromCitrixDashboard=request.getParameter("isFromCitrixDashboard");
	String isUserExperiencePage=request.getParameter("isUserExperiencePage");
	boolean isUED=false;
	if(isUserExperiencePage!=null && isUserExperiencePage.equalsIgnoreCase("true"))
	{
		isUED=true;
	}

	boolean isCitrix=false;
	boolean loadUnknown=false;
	String ctx_defaultParams="";
	if(isFromCitrixDashboard!=null && isFromCitrixDashboard.equalsIgnoreCase("true"))
	{
		isCitrix=true;
		ArrayList al_cols = com.egurkha.util.StringUtils.egTokenizer(queryString, "&",true,false,true);//3-->includeEmpty,4-->unique,5-->trim
		if(al_cols != null && al_cols.size() > 0 )
		{
			for(int l=0;l<al_cols.size();l++)
			{
				String el = (String)al_cols.get(l);

				if(el == null || el.trim().length() == 0)
					continue;
				else if(el.indexOf("state=") != -1){
					loadUnknown = (el.equalsIgnoreCase("state=UNKNOWN"))?true:false;
					continue;
				}

				ctx_defaultParams +="&"+el;
			}
			if(ctx_defaultParams.startsWith("&"))
				ctx_defaultParams = ctx_defaultParams.substring(1);
		}
	}
	String sessionID = session.getId();
	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);

	EgUserRole userRole = user.getUserRole();
	String roleName     = userRole.getRoleName();
	boolean isAlarmViewer = (roleName.equals("AlarmViewer") || roleName.equals("SuperAlarmViewer"));

	String treeSession=(String)session.getAttribute("monitorLastSession");

	String thisPageSession="";
	if(treeSession != null && treeSession.indexOf("?") != -1)
	{
		thisPageSession = treeSession.substring(0,treeSession.indexOf("?"))+"?currentTab=details&"+treeSession.substring(treeSession.indexOf("?")+1);
	}
	String fromPages=request.getParameter("fromPage");
	String showAlarms=request.getParameter("showAlarms");
	String arrangeAlarms=request.getParameter("arrangeAlarms");
	String selectedSubFilterOption=request.getParameter("selectedSubFilterOption");
	String maxDurationAlarmIds=request.getParameter("maxDurationAlarmIds");
	String newWindowAlarm=request.getParameter("newWindowAlarm");
	boolean isNewWindowAlarm = false;
	if(newWindowAlarm != null && newWindowAlarm.trim().length()>0 && newWindowAlarm.equalsIgnoreCase("true"))
		isNewWindowAlarm = true;
	/*if(selectedSubFilterOption!=null && selectedSubFilterOption.indexOf("|amp|")>-1)
	{
		selectedSubFilterOption = com.egurkha.util.StringUtils.replace(selectedSubFilterOption,"|amp|","&");
	}*/
	String FromDashBoard=request.getParameter("isFromDashBoard");
	boolean isFromPages = (fromPages!= null && fromPages.trim().length()>0 && fromPages.equalsIgnoreCase("currentStatus") )?false:true;

	boolean displayWhiteBg=false;
	if(isPopupWindow!=null && isPopupWindow.equals("true"))
	{
		displayWhiteBg=true;
	}

	String isFromQuickLink=request.getParameter("isFromQuickLink");
	isFromQuickLink = (isFromQuickLink == null || isFromQuickLink.trim().length() ==0 )?"false":isFromQuickLink;
	String strEventDelete = egUI.getValue("ALARMS","allowDeletionOfAlertsForDescriptors");

	boolean isEventDelete=false;
	if(strEventDelete!=null && (strEventDelete.equalsIgnoreCase("true") || strEventDelete.equalsIgnoreCase("yes")))
	{
		isEventDelete=true;
	}

	String strEventGrpDelete = egUI.getValue("ALARMS","allowDeletionOfAlertsForEvent");
	boolean isEventGrpDelete=false;
	if(strEventGrpDelete!=null && (strEventGrpDelete.equalsIgnoreCase("true") || strEventGrpDelete.equalsIgnoreCase("yes")))
	{
		isEventGrpDelete=true;
	}

	boolean isAlarmsDetailsInToolTip = false;
	String strAlarmDetailsInToolTip = egUIIni.getValue("ALARMS", "AlarmDetailsInToolTip");
	if(strAlarmDetailsInToolTip!=null && strAlarmDetailsInToolTip.trim().length()>0 && (strAlarmDetailsInToolTip.equalsIgnoreCase("true") || strAlarmDetailsInToolTip.equalsIgnoreCase("yes")))
	{
		isAlarmsDetailsInToolTip=true;
	}
	 if(isAlarmViewer)
		isAlarmsDetailsInToolTip=true;
%>

<%
	String htmlCls="";
	//if(displayWhiteBg)
		//bodyCls="";
	if(isPopupWindow!=null && isPopupWindow.equals("true"))
	{
		htmlCls="refCls";
	}
	else
	{
		htmlCls="content-frame";
	}
%>

<html class="<%=htmlCls%>">
<head>
<style> 
	.configPopfont .linkText
	{
		color:#FFFFFF !important;
	}
</style>
<meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1"/>
<meta charset="utf-8">
<title> Current Alarms / Unknowns </title>
	
<egui:skin ui="monitor"/>
		<!-- ** EXTJS ** -->
 <!-- script src="../extjs/ext-all.js"></script--> 
  

<script language="javascript">
var mgrDateFormat='<%=dateFormatForDatePicker%>';
var isFromQuickLink = '<%=isFromQuickLink%>';
var defaultParams = '<%=queryString%>';
var ctx_defaultParams = '<%=ctx_defaultParams%>';
var isUED=<%=isUED%>;
var isCitrix=<%=isCitrix%>;
var loadUnknown=<%=loadUnknown%>;
var requestParams=new Object();
requestParams.treeSession="<%=treeSession%>";
requestParams.thisPageSession="<%=thisPageSession%>";
var isPopupWindow='<%=isPopupWindow%>';
var fromPages='<%=fromPages%>';
var showAlarms='<%=showAlarms%>';
var maxDurationAlarmIds='<%=maxDurationAlarmIds%>';
var arrangeAlarms='<%=arrangeAlarms%>';
var selectedSubFilterOption='<%=selectedSubFilterOption%>';
var FromDashBoard='<%=FromDashBoard%>';
var isFromCitrixDashboard='<%=isFromCitrixDashboard%>';
var isFromPages=<%=isFromPages%>;
var publicJson;
var showAlarms = 'HIGH|amp|INTERMEDIATE|amp|LOW';
var userId = '<%=EgURLEncoder.encode(u_ser.getLoginID(),"UTF-8")%>';
var maxAcknowledgeDescForSByte = '<egui:intnl text="monitor.current.only 2048 characters allowed"/>';
var ackdbyteAlert = '<egui:intnl text="monitor.current.Acknowledgement is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>';
var maxAcknowledgeDescForDByte = '<egui:intnl text="monitor.current.only 1024 characters allowed"/>';
var isDoubleByteEnabled = "<%=isDouble%>";
var isOracleDB = "<%=isOracleDB%>";
var alarmSelectionAlert = '<egui:intnl text="monitor.currentAlarms.No alarms have been selected"/>';
var maxAlarmSelectionAlert = '<egui:intnl text="monitor.currentAlarms.You are allowed to acknowledge only one alarm at a time"/>';
var ackDescriptionAlert = '<egui:intnl text="monitor.current.Please enter Acknowledgement description"/>';
var unAckDescriptionAlert = '<egui:intnl text="monitor.current.If you need to unacknowledge, provide a message!"/>';
var ackDescriptionSplCharAlert = '<egui:intnl text="monitor.current.The special characters are not allowed in description"/>';
var unAckAlertMsg = '<egui:intnl text="monitor.current.You are not allowed to unacknowledge because the alarm has not yet been acknowledged"/>';
var unAckDeleteConfirmAlert = '<egui:intnl text="monitor.current.This will unacknowledge the selected alarm permanently! Are you sure"/>?';
var alarmAckHiddenParams;
var newWindowAlarm = <%=isNewWindowAlarm%>;
var refreshFreq = "<%=refreshFrequency%>";
var dashboardRefreshFreq = "<%=dashboardRefreshFrequency%>";
var graphTooltipLbl = "<egui:intnl text='monitor.common.Graph'/>";
var pageLbl = "<egui:intnl text='monitor.common.Page'/>";
var recordLbl = "<egui:intnl text='monitor.common.Records'/>";
var ddTooltipLbl = "<egui:intnl text='monitor.common.Diagnosis'/>";
var configTooltipLbl = "<egui:intnl text='admin.common.Configuration'/>";
var assetMgmtTooltipLbl = "<egui:intnl text='monitor.common.Asset Information'/>";
var hideBackButton = <%=!isFromDashBoard%>;
var AcknowledgementBtn = "<egui:intnl text='monitor.common.Acknowledge'/>";
var DeleteAlarmBtn = "<egui:intnl text='monitor.currentAlarms.Delete Alarm'/>";
var AlarmsMainTitle = '<egui:intnl text="monitor.common.Current Alarms" />/<egui:intnl text="monitor.common.Unknowns" />';
var Search = "<egui:intnl text='monitor.common.Search'/>";
var alarmDetails = "<egui:intnl text='monitor.common.Alarm Details'/>";
var assetMgmtTooltipLbl = "<egui:intnl text='monitor.currentAlarms.Asset'/>";
var backLbl = "<egui:intnl text='monitor.common.Back'/>";
var displayingLbl = "<egui:intnl text='monitor.common.Displaying'/>";
var noRecordsLbl = "<egui:intnl text='monitor.common.No records to display'/>";
var ofLbl = "<egui:intnl text='monitor.common.of'/>";
var alarmDetailsLbl = "<egui:intnl text='monitor.common.ALARM DETAILS'/>";
var unknwDetailsLbl = "<egui:intnl text='monitor.common.UNKNOWN DETAILS'/>";
var sampleflag=false;
var isAlarmViewer = <%=isAlarmViewer%>;
var eventDeleteFlag=<%=isEventDelete%>;
var eventGrpDeleteFlag=<%=isEventGrpDelete%>;
var maxEventDeleteAlert = '<egui:intnl text="monitor.currentAlarms.Events delete option enabled,You are allowed to delete only one alarm at a time"/>';
var emptyPanel=new Array();
var isAlarmsDetailsInToolTip=<%=isAlarmsDetailsInToolTip%>;
</script>
<egui:loadApp baseDir="/final/monitor/eg_scripts" appName="currentAlarmsApp"/>
  <script src="../monitor/eg_scripts/eg_validate.js"></script>   

 <!--
 <link rel="stylesheet" type="text/css" href="../monitor/eg_styles/common.css" /> 
  <link rel="stylesheet" type="text/css" href="../monitor/eg_styles/history.css" /> -->
<!-- <link rel="stylesheet" type="text/css" href="/final/styles/ext-custom-com.css" />
<link rel="stylesheet" type="text/css" href="/final/resources/css/ext-eg.css" />
  <link rel="stylesheet" type="text/css" href="/final/styles/egIcons.css" /> -->
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script src="/final/jquery/jquery.js"></script>
<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
<script>
var alarmLoadMask = null;
var assetWin; 
Ext.onReady(function(){

		 Ext.Ajax.on('requestexception', function (conn, response, options) {
                var errorStr = response.responseText;
                if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
                {
                    if (errorStr.indexOf("user-session-invalid") != -1)
                    {
                        callWindow(1);
                    }
                    else if (errorStr.indexOf("user-deleted") != -1)
                    {
                        callWindow(2);
                    }
                    else if (errorStr.indexOf("user-timedout") != -1)
                    {
                        callWindow(3);
                    }
                }
            });
	});
Ext.onReady(function(){

alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
/* Ext.EventManager.onWindowResize(function(w, h){
    Ext.get('currentalarmsmain').doComponentLayout();
}); */

});
//Asset info or GRAPHS popup window in Current Alarms window.
function loadPopup(qUrl)
{
	if(!Ext.isEmpty(qUrl))
	{
		if((typeof assetWin) == 'object') {
			assetWin.destroy(); 
		}
		if(qUrl.indexOf('egShowAssetInformation') > -1)
		{
			if(isPopupWindow != null && isPopupWindow == "true")
			{
				var asmPopupWindow = window.parent.loadPopup();//loadPopup() function is available inside final\egIndex.jsp
				asmPopupWindow.removeAll();
				asmPopupWindow.add(	{
					xtype: "component",
					width: '100%',
					cls: 'outerpanel',
					autoScroll: true,
					scroll: true,
					border: false,
					id: 'assertPopup',
					autoEl: {
							tag: "iframe",
							src: encodeURI(qUrl)		// Reffers egShowAssetInformation.jsp  
							}
					});
				asmPopupWindow.show();
			} else {
				assetWin = Ext.create('Ext.window.Window', {
					title: 'Asset Management',
					id: 'assetWindow',
					name: 'assetWindow',
					//cls: 'lightbox',
					ui: 'newPopupWindow assetAlarmPopupWinHeader',
					header: {
						height: 48,
						padding: '0 20',
						margin: 0
					},
					layout: 'fit',
					closeAction: 'destroy',
					shadow: 'sides',
					modal: true,
					draggable: true,
					resizable: true,
					constrain: true,
					ghost: false,
					height: 350,
					//width: 840,
					width: 605,
					items: [{
						xtype: "component",
						width: '100%',
						cls: 'outerpanel',
						autoScroll: true,
						scroll: true,
						border: false,
						id: 'assertPopup',
						autoEl: {
							tag: "iframe",
							src: encodeURI(qUrl)		// Reffers egShowAssetInformation.jsp  
							}
					}],
					listeners: {
						show: function(win) {
							if (this.modal) {
								var dom = Ext.dom.Query.select('.x-mask');
								var el = Ext.get(dom[0]);
								el.addCls('windowModal');
								
							}
						},
						hide: function(win) {
							if (this.modal) 
							{
								var dom = Ext.dom.Query.select('.x-mask');
								var el = Ext.get(dom[0]);
								el.removeCls('windowModal');
								
							}
						}
						}
					}).show();
				} 
			} else {
				try{
					parent.openWindow(qUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
				}catch(ee)
				{
					parent.parent.openWindow(qUrl,'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
				}
			}
	}
}

var isIE = false;
var isFireFox = false;
var isChrome = false;
function checkBrowserType()
{
	Ext.onReady(function(){
		isIE =  Ext.isIE ||  Ext.isIE6 ||  Ext.isIE7 || Ext.isIE8;
		isFireFox =  Ext.isGecko ||  Ext.isGecko2 ||  Ext.isGecko3;
		isChrome =  Ext.isChrome;
	});
	
}
var metaRefreshUrl = '';
var httpRequest = false;
var refreshURL ="";
var pageURL = "";
var acknowledgeIconCellIdx = 0;
var currentAlmsApp=null;
function wayToLayerModel(alarmQryStr)
{
	checkBrowserType();
	pageURL = alarmQryStr;
	refreshURL = '/final/monitor/EgAlarmSessionDel.jsp';
	if (window.XMLHttpRequest)
	{
		httpRequest = new XMLHttpRequest();
		if (httpRequest.overrideMimeType)
		{
			httpRequest.overrideMimeType('text');
		}
	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}
	}
	if (!httpRequest)
	{
		return false;
	}

	httpRequest.onreadystatechange =  execute;
	httpRequest.open('POST',refreshURL, true);
	httpRequest.setRequestHeader("Content-Type","text/html;charset=UTF-8");
	httpRequest.send(null);		
}

function execute()
{
	if (httpRequest.readyState == 4 || httpRequest.readyState=="complete")
	{
		var iframeDoc ='';
		try
		{
			try
			{
				iframeDoc = opener.document;
			}
			catch(e2)
			{
				try
				{
					iframeDoc = window.parent.parent.document;
				}
				catch (e3)
				{
					iframeDoc = window.parent.document;
				}
			}
			var iFrameId;
			var isException=false;
			try
			{
				if (isFireFox || isChrome)
				{
					iFrameId = iframeDoc.getElementById('main');
				}
				else if (isIE)
				{
					iFrameId = iframeDoc.all['main'];
				}
			}
			catch (eee)
			{
				isException=true;
				try
				{
					iframeDoc = window.parent.parent.document;
				}
				catch (e3)
				{
					iframeDoc = window.parent.document;
				}
			}

			if(iFrameId==null || iFrameId==undefined)
			{
				try
				{
					iframeDoc = window.parent.document;
				}
				catch (e3)
				{
					iframeDoc = window.parent.parent.document;
				}
				

				if(iframeDoc==null || iframeDoc==undefined)
				{
					try
					{
						iframeDoc = window.parent.parent.document;
					}
					catch (e3)
					{
						iframeDoc = window.parent.document;
					}
				}
				isException=true;
			}
			
			if(isException)
			{
				if (isFireFox || isChrome)
				{
					iFrameId = iframeDoc.getElementById('main');
				}
				else if (isIE)
				{
					iFrameId = iframeDoc.all['main'];
				}
			}
			if(pageURL.indexOf("loadPage=AlertDetails") > -1)
			{
				iFrameId.src="/final/monitor/EgCitrixDashCloud.jsp?activeView=alertsPage&"+encodeURI(pageURL);
			}
			else if(pageURL.indexOf("EgConfigChange")>-1)
			{
				iFrameId.src=pageURL;
			}
			/*else if(pageURL.indexOf("layerTestMeasure")>-1)
			{
				iFrameId.src="/final/monitor/aggDashboard.jsp?"+encodeURI(pageURL);
			}*/
			else if(pageURL.indexOf("getFor")>-1)
			{
				iFrameId.src="/final/monitor/egInsideviewDashboard.jsp?"+encodeURI(pageURL);
			}
			else
			{
				iFrameId.src="/final/monitor/EgSiteInfraView.jsp?"+encodeURI(pageURL)+"&toDashBoardLayer=true&gotoLayerModel=true";
			}
			if(isPopupWindow!=null && isPopupWindow=="true")
			{
				var alarmLightBoxPopup=window.parent.Ext.getCmp('alarmLightBoxPopup');
				if(!Ext.isEmpty(alarmLightBoxPopup))
				{
					alarmLightBoxPopup.close();
				}
			}
		}
		catch (error)
		{
			alert(error);
			window.open("/final/monitor/EgSiteInfraView.jsp?"+encodeURI(pageURL))+"&toDashBoardLayer=true"; 
		}
		pageURL = null;
	}
}
$(window).keydown(function(e) {
		if (e.which == 116 || e.keyCode == 82 && e.ctrlKey) { //116 = F5
			Ext.onReady(function(){
				currentAlmsApp.getController('Main').refreshAlarms(metaRefreshUrl);
			});
			return false;
		}
	}); 
</script>

</head>
<%
	String bodyCls="";
	//if(displayWhiteBg)
		//bodyCls="";
	if(isPopupWindow!=null && isPopupWindow.equals("true"))
	{
		bodyCls="refCls";
	}
	else
	{
		bodyCls="content-frame";
	}
%>

<body style="overflow:hidden;padding:0px" class="<%=bodyCls%>">
<div id="alarmloadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"><div class="x-mask-loading" style="position:relative">Loading...</div></div>

</body>
</html>

