<%
/**
 *	Shows the server types as a bar chart with each bar divided on the basis of the number of server types
 *	for each alarm state.
 *
 *	@author		Arun Jayaprakash
 *	@version	3.0
 *	
 *	@modified
 *		10/09/2003	Arun	Removed <br> tags to properly align the "No servers are allocated to your login"  
 *							message.
 *		18/09/2003	Arun	Messages are displayed according to eg_ui.ini
 *		22/09/2003	Arun	Fixed display bug that appeared in Mozilla that occurred because the sampleColors 
 *							parameter was repeated
 *		28/10/2003	Arun	Uses IniUI for headings
 *		04/10/2003	Arun	Added <meta> tag for refreshing. Uses eg_ui.ini for refresh time
 *		15/12/2003	Arun	Reverted to version before 11/10/2003. Retrieves the Map object 
 *							using Dashboard.java if null
 */
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgErrorSmall.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgDateInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.egurkha.*"	%>
<%@ page import="com.egurkha.ini.*"	%>
<%@ page import="com.egurkha.monitor.Dashboard"	%>
<%@ page import="egurkha.EgCrawler"	%>
<%@ page import="java.io.File" %>
<%@ page import="java.util.*" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniUI ui = (IniUI)IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");
	String sortPerCount = ui.getValue("SERVER_DISP_DETAILS", "SORTPERCOUNT");
	String sortOrder = ui.getValue("SERVER_DISP_DETAILS", "SORTPERCOUNTTYPE");
	boolean sorting = (sortPerCount==null)?false:sortPerCount.equalsIgnoreCase("true");
	boolean descend = (sortOrder==null)?true:sortOrder.equalsIgnoreCase("descend");
	descend = sorting && descend;
	ArrayList typeCount = new ArrayList();
	ArrayList typeValue = new ArrayList();
%>

<html>
<head>
<link rel="stylesheet" href="/final/monitor/eg_styles/eg_monitorstyle.css" />
<!--meta http-equiv="refresh" content="<%=refreshTime%>;url=EgDashboardServerTypes.jsp" -->
<style>
	#table_border{border-width:1 1px 1px 1;border-color:#999999; border-style:solid};
	#table_right_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
	#table_right_grey_border{border-width:0 1px 0px 0;border-color:#999999; border-style:solid}
</style>
</head>

<body topmargin="5" marginheight="5" leftmargin="5" marginwidth="5" bgcolor="#F6F6F6" style="overflow:auto">
<center>
<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	Map map = (HashMap)session.getAttribute("appHealth");

	/*
	 * If Servers Health applet has not finished executing, the Map object will not be bound 
	 * in the session .Using Dashboard, get the required data using getAppHealth()
	 */
	if (map == null)
	{
		Dashboard db = new Dashboard(user);
		map = db.getAppHealthCount();
		if (map == null)
		{
			map = new HashMap();
		}
	}

	if (map.size() == 0)
	{
		EgUserRole myrole = user.getUserRole();
		%>
		<jsp:forward page="EgEmpty.jsp" >
			<jsp:param name="reason" value="<%=((myrole.hasAllComponentAccess())?"No components have been enabled for monitoring":"No components have been associated for this user. <BR>Please contact your administrator.")%>"/>
		</jsp:forward>

		<%
		/*
		out.print("<font id=\"eg_alert\">");
		out.print("<br><br><br><br>");
		out.print(ui.getConfigMessage(user.getLoginID(), IniUI.NO_MANAGED_SERVERS));
		out.println("</font>");
		*/
	}
	else
	{
		boolean lcolor=true;

		Object[] keySet2 = map.keySet().toArray();
		if (keySet2.length > 0)
		{
			Arrays.sort(keySet2);
		}
		//for overall status
		int[] allState = new int[5];
		int allSize = 0;
		for (int a=0; a<keySet2.length; a++)
		{
			allSize = 0;
			String server = (String)keySet2[a];
			int[] states = (int[])map.get(server);		//Individual states
			for (int b=0; b<states.length; b++)
			{
				int thisCount = states[b];
				allSize+=thisCount;
				allState[b]+=thisCount;
			}

			if (sorting)
			{
				//map.put(server, states);
				typeValue.add(server);
				typeCount.add(new Double(allSize));
			}
		}

		if (sorting)
		{
			//keySet2 = map.keySet().toArray();
			Object [] tmpArray = typeCount.toArray();
			double [] valueArray = new double[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Double)tmpArray[i]).doubleValue();
				//out.println("<br>valueArray[i]:"+valueArray[i]);
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = typeCount.indexOf(new Double(valueArray[i]));
				//out.println("<br>"+i+". valueArray[i]:"+valueArray[i]+"-->"+thisIndex+"\t"+typeValue.get(thisIndex));
				tmpArray[i] = (String) typeValue.get(thisIndex);
				keySet2[valueArray.length-1-i] = tmpArray[i];
				typeValue.remove(tmpArray[i]);
				typeCount.remove(new Double(valueArray[i]));
			}
		}
		//out.println("<br>keySet2:"+Arrays.asList(keySet2));
		
		Map textAttribute = new Hashtable();
		textAttribute.put("0id", "GOOD_bg");
		textAttribute.put("1id", "UNKNOWN_bg");
		textAttribute.put("2id", "LOW_bg");
		textAttribute.put("3id", "INTERMEDIATE_bg");
		textAttribute.put("4id", "HIGH_bg");

	%>
		<!--table width="95%" cellpadding="0" cellspacing="0" border="0" align="center" id="table_border1" >
		<tr>
			<td align="left" height="25" width="105" bgcolor="#E7E7E7">&nbsp;All Components</td>
				<td nowrap align="center" height="25" width="50" id="table_border2" >
					<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 12px; font-weight: bold; letter-spacing: 1px;">
					<%=allSize%></font>
				</td>
				<td bgcolor="#E7E7E7">
					<table width="100%" height="15" width="100%" border="0" cellspacing="0" cellpadding="0">
					<tr>
				</td>
			<%
			for (int b=0; b<allState.length; b++)
			{
				boolean exists = allState[b]>0;
				if (!exists) continue;
				//size
				int stateCount = allState[b];
				int tdWidth = stateCount*100/allSize;
			%>
					<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType=all" target="_self">
					<span>
						<td nowrap align="center" width="<%=tdWidth%>%" id="<%=textAttribute.get(b+"id")%>" class="mouse" >
							<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
								<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType=all" target="_self" class="eg_bargraph_text">
								&nbsp;
								<%=exists?allState[b]+"":"-"%>&nbsp;
								</a>
							</font>
						</td>
					</span>
					</a>
			<%

			}
%>
					</tr>
					</table>
		</tr>
		<table><br-->
		<table width="100%" cellpadding="0" cellspacing="0" border="0" align="center" id="table_border1">
	<%

		int maxCount = 0;
		for (int a=0; a<keySet2.length; a++)
		{
			lcolor = !lcolor;
			String server = (String)keySet2[a];
			int[] states = (int[])map.get(server);		//Individual states
			int size=0;
			for (int b=0; b<states.length; b++)
			{
				int thisCount = states[b];
				size+=thisCount;
			}
			maxCount = Math.max(maxCount, size);
		}

		if (sorting)
		{
			for (int a=0; a<keySet2.length; a++)
			{
				String server = (String)keySet2[a];
				//out.println("server:"+server);
			}
		}
//out.println("-----------------------"+keySet2.length);
		//for (int a=keySet2.length-1; a>=0; a--)
		for (int a=0;a<keySet2.length; a++)
		{
			//if (a>=5)
			//break;
			//out.println("<br>"+a);
			lcolor = !lcolor;
			String server = (String)keySet2[a];
			int[] states = (int[])map.get(server);		//Individual states
			int size=0;
			for (int b=0; b<states.length; b++)
			{
				int thisCount = states[b];
				size+=thisCount;
			}
			String overallState = null;
			if (states[4]>0)
				overallState = "HIGH";
			else if (states[3]>0)
				overallState = "INTERMEDIATE";
			else if (states[2]>0)
				overallState = "LOW";
			else if (states[1]>0)
				overallState = "UNKNOWN";
			else if (states[0]>0)
				overallState = "GOOD";
			String tmpSrv="";
			if (server.endsWith("_server"))
				tmpSrv=server.substring(0, server.lastIndexOf("_server"));
			else
				tmpSrv=server;
			%>
				<tr bgcolor=<%//=lcolor?"lightgrey":""%>>
				<!--td nowrap align="center" height="25" width="50"><img src="eg_images/eg_layout/Tests<%=overallState%>.gif"></td-->
				<td align="left" height="25" width="50" bgcolor="#E7E7E7" class="cell_border" nowrap>
				&nbsp;<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType=<%=server%>" target="_self" class="eg_monlink" ><%=tmpSrv%>&nbsp;</a>
				</td>
				<td nowrap align="center" height="25" width="50"  class="cell_border" id="table_border2">
					<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
					<%=size%></font>
					<%
						int tableWidth = size*100/maxCount;
						tableWidth = tableWidth<1?1:tableWidth;
					%>
				</td>
				<td bgcolor="#E7E7E7" class="cell_border">
					<table width="<%=tableWidth%>%" height="15" width="100%" border="0" cellspacing="0" cellpadding="0">
					<tr>
				</td>
			<%
			for (int b=0; b<states.length; b++)
			{
				boolean exists = states[b]>0;
				if (!exists) continue;
				//size
				int stateCount = states[b];
				int tdWidth = stateCount*100/size;
				boolean dispRequired = (stateCount*100/maxCount)>5;
			%>
					<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType=<%=server%>" target="_self">
					<span>
						<td nowrap align="center" width="<%=tdWidth%>%" id="<%=textAttribute.get(b+"id")%>" class="mouse">
							<font face="Arial,Verdana" style="font-family: Arial,Verdana; font-size: 11px; font-weight: normal; letter-spacing: 1px;">
								<a href="../servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType=<%=server%>" target="_self" class="eg_bargraph_text" title="<%=states[b]%>">
								
								<%=(exists&&dispRequired)?states[b]+"":""%>
								</a>
							</font>
						</td>
					</span>
					</a>
			<%
			}
			%>
					</tr>
					</table>
			</tr>
	<%
		}
	%>
		</table>
		<%
	}

	/*
	 * Removing the object from session so that this page will not use an 
	 * older version of the Map object. While reading if this object is null,
	 * Dashboard.java is used to get a fresh version of the Map object.
	 */
	session.removeAttribute("appHealth");
	%>
</center>
</body>
</html>
