<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%
/**
 *	Name	:	EgDispMeasure.jsp
 *	Version	:	eG 3.0
 *	Purpose	:	Gets the site, host and test names as parameters and returns the measurements and states.
 *	Created	:	17/07/2000
 *	Author	:	BalaMurugan.V
 *	Modified:	26/09/2003	Arun		Shows measurement host if there is mroe than one
 *				07/09/2003	Srinivas	Report "Not Applicable" if measure value is -3
 *				18/07/2003	Williams	eG 3.0 Layout
 *				27/02/2003	Arun		Reflect true priorities
 *				15/10/2003	Williams	Removed INFO, REMOTE & HELP FORM BUTTONS and made into HTML/CSS Links.
 *				23/10/2003	Williams	Layout modification to give more height/space to Measurements box
 *				09/04/2004	Arun		Removed target attribute for Remote Control, Info and Help for the
 *										page to work with EgMoreInfos.jsp
 *				07/05/2004	Arun		Fix to close HelpWindow/RemCtrl/Info windows from MoreInfos window
 *				12/05/2004	Arun		Fix to include fakeType in the url string for INFO window
 *				02/07/2004	Arun		Does not show Remote Control if agentless.
 *				02/09/2004	Solomon		DD allowed for Agentless server's  external tests.
 */
%>
<%@ include file = "EgLoginTracker.jsp" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.io.*"	%>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.eg.EgAgentInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgManagerServlet" %>
<%@ page import = "com.eg.upload" %>
<%@ page import = "java.net.*" %>
<%@ page import = "com.eg.EgTesterInfo" %>

<!--         CLUSTER   					----->
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgManagersIniForManager" %>
<%@ page import = "com.eg.EgManagerInfo" %>

<%//@ page import = "EgHelpParser" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page session = "true" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<html>
<head>
<title>Measurements</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="Author" content="John Williams" />
<egui:skin ui="monitor"/>
</head>
<body leftmargin="5" topmargin="5" marginheight="5" marginwidth="5" bgcolor="#FFFFFF">
<%!
	//Common Global variables
	EgDbInfo MeasureDisplay=new EgDbInfo("manager");
	EgTablesInfo TableData = new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	//EgHelpParser egHelp = new EgHelpParser();
	String s_aglink,s_glink;
%>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<!--         CONTROL ACTION   					----->
<jsp:useBean id="controlaction" scope="page"  class="egurkha.UserBean"/>
<%
	AlarmPriorities ap = AlarmPriorities.getInstance();
	IniUI ui = IniUI.getInstance();

	EgDbAdapterUI egDb;

	//Local variables
	String	s_status="";
	String	str_site = "";
	String	str_host = "";
	String	str_comptype = "";
	String	str_tstate = "";
	String	str_port = "";
	String	str_layer = "";
	String	str_time = "";
	String	str_info,
			str_measure,
			s_definfo,
			s_tmp_info,
			s_histlink,s_feedlink,
			str_test_table=null;
	String	str_test = "";
	String	test = "";
	String	info = "";
	String[]	str_field_list = null;
	String	s_qstr = null;
	String	s_id = "";
	String	s_qstr_state = null;
	String	str_test_image="";
	ResultSet rs = null;
	ResultSet rs_state = null;
	boolean b_status = false;
	boolean b_status_state = false;
	String	s_info="";
	String	s_hst_info = "";
	String	s_bad_mes_list = "";
	String	message = "";
	String compName = null;

	//New variable declarations for the EgTestStatusInfo.jsp

	String	str_mespresent = "no";
	String	s_sname = "";
	String	s_teststatusinfourl = "";
	String	s_frequencyOfTest = "";
	String	s_timeSinceLastMeasure = "";
	String	s_ttype = "";
	Vector	v_teststatusinfo = new Vector();
	Vector	v_trans4site = new Vector();

	boolean b_isAgentRunning = false;
	boolean b_isTestRunning = false;
	boolean b_isTestConfigured = false;
	boolean b_isInfoAvailableForMeasure = false;

	// CONTROL ACTION
	String ca_host = "";
	String msmtHost_RC = "";
	boolean remoteControlEnabled = EgMemInfo.remoteEnabled;
	String s_uid = (String) session.getValue("sess_userid");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	boolean flag = user.getLoginRCEnabled();

	String s_msmt_host = request.getParameter("msmt_host");
	if(s_msmt_host != null && !s_msmt_host.equals(""))
	{
		if (s_msmt_host.startsWith("("))
		{
			s_msmt_host = s_msmt_host.substring(1,s_msmt_host.length() - 1);
		}
	}
//System.out.println("s_msmt_host is " + s_msmt_host + " QUERY STRING IS " + request.getQueryString());
	String str_hst_info = "";
	//MeasureDisplay.checkForUpdate();
	//egHelp.setModule("M");

	//Checking to see whether there are any parameters
	String s_qctr = request.getParameter("qctr");
%>

<%
	String sid = session.getId();
	String wname ="";
%>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
	if(s_qctr.equals("2"))
	{
		//To display button for Detailed Diagnosis
		StringTokenizer st = null;
		Vector v_measures = new Vector();
		str_test = request.getParameter("test");


		String meas = "";

//		String test = str_test;
//		test = test.substring(0,test.indexOf("-"));
		int index = str_test.indexOf("-");
		test = str_test.substring(0, index);
		info = ui.getReverseLookupAll(str_test.substring(index+1));

		boolean ddEnabled = EgMemInfo.ddEnabled;
		Hashtable commonDdHt = new Hashtable();
		trans.createFile("eg_format.ini");
		String strVarArr[] = trans.getVariables("FORMAT");
		String dummyTestArr[] = trans.getVariables("COMMON_DD_MAPPING");
		
		for(int i=0; i<strVarArr.length; i++)
		{
			if(strVarArr[i].startsWith(test))
			{
				meas = strVarArr[i].substring(strVarArr[i].indexOf(":")+1,strVarArr[i].length());
				if(!v_measures.contains(meas))
				{
					v_measures.add(meas);
				}
			}
		}
		
		for(int d=0; d<dummyTestArr.length; d++)
		{
			if(dummyTestArr[d].startsWith(test))
			{
				meas = dummyTestArr[d].substring(dummyTestArr[d].indexOf(":")+1,dummyTestArr[d].length());
				if(!v_measures.contains(meas))
				{
					v_measures.add(meas);
				}
			}
		}
		
		//End

		//Constructing the Query
		s_definfo= "+";
		str_host = request.getParameter("host");
		compName = str_host;
		str_layer = request.getParameter("layer");
		str_port = str_host.substring(str_host.indexOf(":")+1,str_host.length());
		str_host = str_host.substring(0,str_host.indexOf(":"));
		str_site = request.getParameter("site");
		str_info = "+" + info.trim();
		str_test_image = AlarmPriorities.GOOD_STATE;
		s_hst_info = new String(str_info);

		if(str_port.indexOf(":") > 0)
		{
			str_info = str_port.substring(str_port.indexOf(":")+1,str_port.length()).trim();
			str_hst_info = "+" + info.trim();
			str_info = str_info + "+" + info.trim();
			str_port = str_port.substring(0,str_port.indexOf(":"));
			s_hst_info = new String(str_hst_info);
		}

		s_info = new String(str_info);
		
		//out.println("info"+str_info);
//		str_test = str_test.substring(0,str_test.indexOf("-"));
		str_test_table = MeasureDisplay.getTableForTest(test);
		str_field_list = MeasureDisplay.getColumnNamesForTest(str_test_table,str_layer);

		//query string for the test table
		//query string for report table
		//Building Graph link
		//s_glink = "../servlet/com.eg.LineGraph?site=" + str_site + "&host=" + str_host
		s_glink = "dispComponentGraphs.jsp?site=" + str_site + "&host=" +str_host+ "&port=" + str_port + "&layer=" + str_layer+ "&test=" + test + "&comptype="+request.getParameter("comptype");

		String s_dlink = "dispCompDiagnosis.jsp?site=" + str_site + "&host=" +str_host +"&port=" + str_port + "&test=" + test;
		session.setAttribute("layerforDD",str_layer);

		//String ss_histlink="EgFixHistory.jsp?site=" + str_site + "&test=" + test + "&component=" + request.getParameter("host") + ":" +request.getParameter("comptype");
		String ss_histlink="dispComponentHistory.jsp?site=" + str_site + "&info=" + info.trim() + "&test=" + test + "&component=" + request.getParameter("host") + ":" +request.getParameter("comptype");

		String ss_feedlink="dispComponentFeedback.jsp?site=" + str_site + "&trgthost=" + str_host +"&port=" + str_port + "&test=" + test + "&comptype=" + request.getParameter("comptype");

		//Retrieving the records
		egDb=EgDbAdapterTypeUI.getObject();
		try
		{
			s_status = egDb.setConnection();
			rs=egDb.SelectDispMeasure_1(str_field_list, str_test_table, str_host, str_port, str_site, ui.getReverseLookedupString(str_info), s_definfo, ui.getReverseLookedupString(str_hst_info), s_msmt_host);

			b_status = egDb.getState();
			ResultSetMetaData rsmd = rs.getMetaData();
			Vector v_store = new Vector();
			/*****************************************************************************/
			// To popup the window that displays help relevant to test
			// constructing the query string needed for the test status info
			str_comptype = request.getParameter("comptype");
			str_tstate = request.getParameter("tstate");
			s_teststatusinfourl = "site=" + str_site +
									"&stype=" + str_comptype +
									"&sname=" + str_host +
									"&sport=" + str_port +
									"&sinfo=" + s_info.substring(0,s_info.indexOf("+")) +
									"&tname=" + test +
									"&tstate=" + str_tstate +
									"&faketype=" + request.getParameter("faketype") +
									"&msmt_host=" + s_msmt_host;
			 /********** CONTROL ACTION ********************* */
			ca_host = str_host;  //bug fixed

			/*****************************************************************************/
			if(rs.next())
			{
				int columnCount = rsmd.getColumnCount();
				str_mespresent = "yes";
				str_time = rs.getString(columnCount-2);
				if(s_msmt_host == null || s_msmt_host.equals(""))
				{
					msmtHost_RC = rs.getString(columnCount);
					//No msmt_host passed from prev page. Use the one from the db
					s_teststatusinfourl = s_teststatusinfourl.substring(0,s_teststatusinfourl.indexOf("&msmt_host=")) + "&msmt_host=" + rs.getString(columnCount);
				}
				String s_time=str_time.replace(' ','*');

				str_info = rs.getString(columnCount);
				for(int j=1;j<=columnCount-3;j=j+2)//get rs into a vector
				{
					v_store.addElement(rsmd.getColumnName(j));
					v_store.addElement(rs.getString(j));
					String s_tmpstate = rs.getString(j+1);
					if(s_tmpstate.equals("NONE"))
					{
						s_tmpstate = AlarmPriorities.GOOD_STATE;
					}
					v_store.addElement(s_tmpstate);
					v_store.addElement(str_info);
				}//end of for

				if (rs != null)
				{
					try {
						rs.close();
					} catch (Exception grr) {}
				}
				rs = null;

				rs_state = egDb.SelectDispMeasure_2(str_site, str_host, str_port, ui.getReverseLookedupString(str_info), s_definfo, ui.getReverseLookedupString(str_hst_info), str_layer, test, s_msmt_host);

				b_status_state = egDb.getState();
				while(rs_state != null && rs_state.next())
				{
					String measure = rs_state.getString(1).trim();
					measure = MeasureDisplay.getColumnForMeasure(test,measure);
					String measure_v = "";
					for(int k=0;k<v_store.size();k=k+4)
					{
						measure_v=(String) v_store.elementAt(k);
						measure_v = measure_v.trim();
						if(measure_v.equals(measure))
						{
							v_store.set(k+2,rs_state.getString(2));//Change of state
							v_store.set(k+3,rs_state.getString(3));//Change of info
							break;
						}
					}
				}//end of while
				if (rs_state != null)
					rs_state.close();
				rs_state = null;

				EgAgentInfo agentInfo = new EgAgentInfo(EgConstants.MANAGER);
				EgTesterInfo tt = new EgTesterInfo(EgConstants.MANAGER);
				boolean isRemoteDetailed = tt.getRemoteDetailed();
				tt = null;
				boolean isAgentlessServer = false;
				if (!isRemoteDetailed)
					isAgentlessServer = agentInfo.isAgentlessServer(str_host, str_comptype);
%>
				<tr>
					<td id="eg_11" align="center" height="21" valign="top">
						<table width="100%" height="18" align="right" cellspacing="0" cellpadding="0" border="0">
							<tr>
							<%--
If I take out target="eg_operations" from the <A href> tag, then the window opens correctly in EgDispMeasures.jsp and EgMoreInfos.jsp
							--%>
								<td id="eg_11" width="100%">Last Measurement Time: <%=str_time%></td>
								<td width="20" valign="top"><img src="eg_images/eg_layout/MeasureMenuLeft.gif" width="20" height="18" /></td>
								<td align="center" width="62" height="18" valign="top" nowrap id="eg_measuremenu" background="eg_images/eg_layout/MeasureMenuBG.gif"><a href="javascript:TestStatusInfo();" class="innersubmenu"> &nbsp; &nbsp; INFO &nbsp; &nbsp; </a></td>
<%
								if (!isAgentlessServer)
								{
									//CLUSTERING
									Vector reportingAgents = null;
									boolean remoteControl = false;
									if(EgInstallInfo.isClusterSupported)
									{
										EgServicesInfo serviceInfo = new EgServicesInfo("manager");
										EgManagersIniForManager mi = EgManagersIniForManager.getInstance();

										reportingAgents= mi.getReportingAgentsFor(mi.getManagerIP());

										if(serviceInfo.autoIpNameCheck())
										{
											String tmpNick = null;
											EgDiscInfo discInfo = new EgDiscInfo("manager");
											//Hashtable ipNickMap = discInfo.getIpNickMap();
											Hashtable nickIpMap = discInfo.getNickIpMap();
											String agentIp =(String) nickIpMap.get(str_host);

											if(reportingAgents != null && (reportingAgents.contains(agentIp)  || reportingAgents.contains(str_host)))
											{
												remoteControl = true;
											}
										}	
										else
										{
											if(reportingAgents != null && reportingAgents.contains(str_host) )
											{
												remoteControl = true;

											}

										}	
										
									}
									
									if(!EgInstallInfo.isClusterSupported || (reportingAgents != null && remoteControl) )
									{
										if((remoteControlEnabled && s_uid.equalsIgnoreCase("supermonitor"))
											|| (remoteControlEnabled && flag))
										{
%>
							<%--
If I take out target="eg_operations" from the <A href> tag, then the window opens correctly in EgDispMeasures.jsp and EgMoreInfos.jsp
							--%>
											<td align="center" width="10" height="18" valign="top" nowrap id="eg_measuremenu" background="eg_images/eg_layout/MeasureMenuBG.gif">|</td>
										   <td align="center" width="124" height="18" valign="top" nowrap id="eg_measuremenu" background="eg_images/eg_layout/MeasureMenuBG.gif"><a href="javascript:ControlActions();" class="innersubmenu"> &nbsp; REMOTE CONTROL &nbsp; </a></td>
										<%
										}
									}
							}
%>
							<%--
If I take out target="eg_operations" from the <A href> tag, then the window opens correctly in EgDispMeasures.jsp and EgMoreInfos.jsp
							--%>
								<td align="center" width="10" height="18" valign="top" nowrap id="eg_measuremenu" background="eg_images/eg_layout/MeasureMenuBG.gif">|</td>
								<td align="center" width="62" height="18" valign="top" nowrap id="eg_measuremenu" background="eg_images/eg_layout/MeasureMenuBG.gif"><a href="javascript:HelpWin();" class="innersubmenu"> &nbsp; &nbsp; HELP &nbsp; &nbsp; </a></td>
								<td width="20" valign="top"><img src="eg_images/eg_layout/MeasureMenuRight.gif" width="20" height="18" /></td>
							</tr>
						</table>
					</td>
				</tr>
<%
				s_teststatusinfourl += "&msmttime=" + str_time.replace(' ','*');

				//str_test_image = request.getParameter("priority");

//				String s_tmptest = request.getParameter("test");

				s_teststatusinfourl += "&desc=" + str_test;
				String s_tmptest = ui.getReverseLookedupString(str_test.replace(' ', '+'));

				String testName = null;
				if (s_tmptest.endsWith("-+"))
				{
					testName = s_tmptest.substring(0, s_tmptest.lastIndexOf("-"));
				}
				else
				{
					testName = StringUtils.replace(s_tmptest, "-+"," - ");
				}


				String tempState = null;
				if (v_store.contains(EgConfigInfo.HIGH_PRIORITY))
				{
					tempState = EgConfigInfo.HIGH_PRIORITY;
				}
				else if (v_store.contains(EgConfigInfo.MEDIUM_PRIORITY))
				{
					tempState = EgConfigInfo.MEDIUM_PRIORITY;
				}
				else if (v_store.contains(EgConfigInfo.LOW_PRIORITY))
				{
					tempState = EgConfigInfo.LOW_PRIORITY;
				}

				//if(v_store.contains(AlarmPriorities.BAD_STATE))
//				if (v_store.contains(EgConfigInfo.HIGH_PRIORITY) ||
//				    v_store.contains(EgConfigInfo.MEDIUM_PRIORITY) ||
//				    v_store.contains(EgConfigInfo.LOW_PRIORITY))
				if (tempState != null)
				{
					//str_test_image = AlarmPriorities.BAD_STATE;
					str_test_image = (String)ap.getTestPriority(compName, str_comptype, str_layer, s_tmptest.replace(' ', '+'));
					if (EgConfigInfo.isGood(str_test_image))
					{
						str_test_image = tempState;
					}

				}
				else if(v_store.contains(AlarmPriorities.UNKNOWN_STATE))
				{
					str_test_image = AlarmPriorities.UNKNOWN_STATE;
				}

				int i_maxdisplength = 150;
				if(s_tmptest.length() > i_maxdisplength)
				{
					s_teststatusinfourl += "&mstate=" + str_test_image;
					s_teststatusinfourl += "&mespresent=yes";
%>
					<tr>
						<td width="100%" id="eg_cellbglight">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" height="22" border="0">
								<tr>
									<td width="22" align="center" nowrap><img src="eg_images/eg_layout/Measure<%=str_test_image%>.gif" align="absmiddle" height="20" width="20" border="0" /></td>
									<td id="eg_darktextbold" width="100%" align="left">&nbsp;<%=s_tmptest.substring(0,s_tmptest.indexOf("-"))%></td>
								</tr>
<%
								s_tmptest=ui.getReverseLookupAll(s_tmptest.substring(s_tmptest.indexOf("-")+1));
								while(s_tmptest.length() > i_maxdisplength)
								{
									if(s_tmptest.length() > 0)
									{
%>
										<tr>
											<td colspan="2" width="100%" height="2" id="eg_blankspace" class="eg_cellbglights">&nbsp;</td>
										</tr>
<%
									}
%>
									<tr>
										<td colspan="2" width="100%" height="20" id="eg_11">&nbsp;<%=  s_tmptest.substring(0,i_maxdisplength)%></td>
									</tr>
<%
									s_tmptest = ui.getReverseLookupAll(s_tmptest.substring(i_maxdisplength));
								}
%>
							</table>
<%
				}
				else
				{
%>
					<tr>
						<td width="100%" id="eg_cellbglight">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" height="20" border="0">
								<tr>
									<td width="30" align="center" nowrap><img src="eg_images/eg_layout/Measure<%=str_test_image%>.gif" align="absmiddle" height="20" width="20" border="0" /></td>
									<td id="eg_darktextbold" width="100%">
<%
					s_teststatusinfourl += "&mstate=" + str_test_image;
					s_teststatusinfourl += "&mespresent=yes";

					out.print(" ");
					out.print(ui.getReverseLookupAll(testName));
					if (!StringUtils.isNull(s_msmt_host))
					{
						out.print(" (");
						out.print(s_msmt_host);
						out.print(")");
					}
%>
									</td>
								</tr>
							</table>
<%
				}
				if(s_hst_info != null)
				{
					s_hst_info = s_hst_info.replace('+','*');
					if(s_hst_info.startsWith("*"))
					{
						s_hst_info = s_hst_info.substring(1,s_hst_info.length());
					}
				}
				else
				{
					s_hst_info = "";
				}

				int ind = s_info.indexOf("+");
				if (ind >= 0)
				{
					s_info = s_info.substring(0,ind)+"*"+s_info.substring(ind+1);
				}

				//s_info = s_info.replace('+','*');
				
				boolean allNegative5 = true;
				for(int j=0; j<v_store.size(); j=j+4)
				{
					String measureValue = (String)v_store.elementAt(j+1);
					if (!measureValue.equals("-5") && !measureValue.equals("-5.0000"))
					{
						allNegative5 = false;
						break;
					}
				}

				for(int j=0; j<v_store.size(); j=j+4)
				{
					String s_mes_val = (String)v_store.elementAt(j+1);
					if (!allNegative5 
						&& (s_mes_val.equals("-5") || s_mes_val.equals("-5.0000")))
					{
						continue;
					}

					String value = null;
					try
					{
						Double d = new Double(s_mes_val);
						value = ui.getMeasureLookup(String.valueOf(d.intValue()));
					}
					catch(NumberFormatException nfe)
					{
						System.out.println("EgDispMeasure.jsp : Could not format "+s_mes_val+" into a number");
					}

					if (StringUtils.isNull(value))
					{
						value = s_mes_val;
					}

					String s_messy = MeasureDisplay.getMeasureForColumn(test,(String)v_store.elementAt(j));
					String str_state = (String)v_store.elementAt(j+2);
					//if(str_state.equals(AlarmPriorities.BAD_STATE))
					if (EgConfigInfo.isBad(str_state))
					{
						//str_state = "HIGH";
						s_bad_mes_list += s_messy + ",";

						String priority = (String)ap.getTestMeasurePriority(compName, str_comptype, str_layer, s_tmptest.replace(' ','+'), s_messy);
						if (AlarmPriorities.GOOD_STATE.equals(priority))
						{
							/*
							 * Happens when last set of measures being displayed are old and new alarms are not present in the database. Setting to a different colour because the real priority of that measure is not known.
							 */
							//str_state = AlarmPriorities.HIGH_PRIORITY;
						}
						else
						{
//							if (AlarmPriorities.LOW_PRIORITY.equals(priority))
//							{
//								str_state = "LOW";
//							}
//							else if (AlarmPriorities.MEDIUM_PRIORITY.equals(priority))
//							{
//								str_state = "INTERMEDIATE";
//							}
//							else if (AlarmPriorities.HIGH_PRIORITY.equals(priority))
//							{
//								str_state = "HIGH";
//							}

							str_state = priority;
						}
					}
%>
					<tr>
						<td width="100%">
							<table align="center" width="100%" height="27" cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td width="27" height="27" nowrap><img src="eg_images/eg_layout/MeasureL<%=str_state%>.gif" width="27" height="27" border="0" /></td>
									<td width="100%" height="27" background="eg_images/eg_layout/MeasureBg.gif" id="eg_11"> &nbsp; <%=s_messy%> (<%=TableData.getUnitForMeasure(test,s_messy)%>) : &nbsp;<%=value%></td>
<%
									s_tmp_info =(String)v_store.elementAt(j+3);
									s_tmp_info = s_tmp_info.replace('+','*');
									s_histlink = ss_histlink + "&measure=" + s_messy ;
									/*if(!str_port.equals("NULL"))
									{
										s_histlink = ss_histlink + "&info=" + s_hst_info + "&measure=" + s_messy + "&msmttime=" + s_time + "&host=" + request.getParameter("host") + "&comptype=" + request.getParameter("comptype");
									}
									else
									{
										s_histlink="EgFixHistory.jsp?test="+test+ "&measure="+s_messy+ "&info="+s_hst_info;
									}*/

									s_feedlink = ss_feedlink +"&info="+URLEncoder.encode(s_info)+ "&measure="+s_messy+ "&msmttime="+s_time +"&msmt_host="+s_msmt_host;

									//s_histlink = StringUtils.replace(s_histlink,"\\","\\\\");
									//s_feedlink = StringUtils.replace(s_feedlink,"\\","\\\\");

									//Commented because of unique info lost problem during unknown state
									s_aglink = s_glink + "&info="+URLEncoder.encode(s_info)+ "&gtype=1&measure="+(String)v_store.elementAt(j)+ "&msmt_host="+	s_msmt_host;

									String s_adlink = s_dlink + "&info="+URLEncoder.encode(s_info)+ "&msmt_host="+s_msmt_host+ "&from=0&measure="+s_messy+ "&firsttime=true&flag=0";
									//out.println("Messy is ..."+s_messy);
									if(ddEnabled)
									{
										if(v_measures.contains(s_messy))
										{
											wname = sid + "DIAGNOSIS";
%>
											<td nowrap height="27" background="eg_images/eg_layout/MeasureBg.gif" width="70" align="center">
<%
											if (!isAgentlessServer || specsInfo.isTestExternal(test))
											{
%>
											<a href="#" onClick="javascript:var dd=window.open('<%=s_adlink%>','<%=wname%>','toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,scrollbars=yes,resizable=yes');dd.focus()"><img src="eg_images/eg_layout/Diagnosis.gif" alt="DIAGNOSIS" border="0" width="30" height="27"></a>
<%
											}
											else
											{
												out.print("&nbsp;");
											}
%>
											</td>
<%
										}
									}
%>

<%
									wname = sid + "GRAPH";
									//s_aglink = StringUtils.replace(s_aglink,"\\","\\\\");
%>										out.println("s_aglink"+s_aglink)
									<td nowrap height="27" background="eg_images/eg_layout/MeasureBg.gif" width="70" align="center"><a href="javascript:void(0);" onClick="javascript:var gr=window.openWindow('<%=s_aglink%>','GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes'); gr.focus()"><img src="eg_images/eg_layout/Graph.gif" alt="GRAPH" border="0" width="30" height="27"></a></td>
<%
									wname = sid + "HISTORY" ;
%>
									<td nowrap height="27" background="eg_images/eg_layout/MeasureBg.gif" width="70" align="center"><a href="#" onClick="javascript:var hist=window.open('<%=s_histlink%>','HISTORY','toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');hist.focus()"><img src="eg_images/eg_layout/History.gif" ALT="HISTORY" border="0" width="30" height="27"></a></td>
<%
									wname = sid + "FEEDBACK" ;
%>
									<td nowrap height="27" background="eg_images/eg_layout/MeasureBg.gif" width="70" align="center"><a href="#" onClick="javascript:var feed=window.open('<%=s_feedlink%>','FEEDBACK','toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');feed.focus()"><img src="eg_images/eg_layout/Feedback.gif" alt="FEEDBACK" border="0" width="30" height="27"></a></td>
									<td nowrap height="27" background="eg_images/eg_layout/MeasureBg.gif" width="10" id="eg_blankspace">&nbsp;</td>
									<td width="30" height="27" nowrap><img src="eg_images/eg_layout/MeasureR<%=str_state%>.gif" width="30" height="27" border="0" /></td>
								</tr>
							</table>
						</td>
					</tr>
<%
				}//end of for
			}//end of if(rs.next())
			else
			{
				s_teststatusinfourl += "&mespresent=no"+"&msmttime="+"&mstate=null";
%>
				<tr>
					<td align="center">
						<jsp:useBean id="teststatus" class="egurkha.TestStatusInfo" scope="page"/>
<%
				s_sname = str_host + ":" + str_port;
				//out.println(s_sname);
				if(str_comptype.equals("Oracle_server"))
				{
					//out.println(s_info);
					if(s_info != null && !s_info.equals(""))
					{
						s_sname = s_sname + ":" + s_info.substring(0,s_info.indexOf("+"));
						//out.println(s_sname);
					}
				}

				//specsInfo.checkForUpdate();
				boolean b_isTestExternal = specsInfo.isTestExternal(test,str_comptype);
				if(b_isTestExternal)
				{
					s_ttype = "External";
				}
				else
				{
					s_ttype = "Internal";
				}

				boolean b_isPortRelevantForTest = specsInfo.isPortRelevantForTest(test);
				if(!b_isPortRelevantForTest)
				{
					//New code
					//to display sun08.chn.egurkha.com
					//instead of sun08.chn.egurkha.com:1521:egurkha
					if(str_comptype.equals("Oracle_server"))
					{
						s_sname = s_sname.substring(0,s_sname.indexOf(":"));
					}
					else
					{
						s_sname = s_sname.substring(0,s_sname.lastIndexOf(":"));
					}
				}

				boolean b_isTestDisabled = teststatus.isTestDisabled(str_comptype, s_sname, test);
				if(!b_isTestDisabled)
				{
					s_frequencyOfTest = teststatus.frequencyOfTest(str_comptype, s_sname, test);
				}
				else
				{
					s_frequencyOfTest = "Not Applicable";
				}
				//out.println("there : "+request.getParameter("tstate"));
				//out.println("str_tstate : "+str_tstate+" str_mes : "+str_mespresent);
				if(str_tstate.equals(AlarmPriorities.UNKNOWN_STATE) && str_mespresent.equals("no"))
				{
					b_isTestConfigured = teststatus.isTestConfigured(str_comptype, s_sname, test);
					if(b_isTestConfigured)
					{
						v_teststatusinfo.addElement("<font id=\"eg_12\" style=\"line-height: 22px;\"><em>The agent has not reported measures yet.</em></font>");
						v_teststatusinfo.addElement("<br><strong><u>Possible reasons</u> :</strong>&nbsp;");
						v_teststatusinfo.addElement("The agent might not be running on the system or it might have just been started.");
						v_teststatusinfo.addElement("If the agent has just been started, the state of the test will soon turn to Good/Bad.");
						v_teststatusinfo.addElement("If the agent has been running for a long time, either the agent is unable to connect to the manager or the agent is not reporting any measures as the component being monitored might not be running.");
					}
					else
					{
						v_teststatusinfo.addElement("The agent is not reporting measures to the manager.");
						v_teststatusinfo.addElement("The test has not been configured.");
					}
				}

				if(str_tstate.equals(AlarmPriorities.GOOD_STATE) && str_mespresent.equals("no"))
				{
					b_isInfoAvailableForMeasure = teststatus.isInfoAvailableForMeasure(test, str_host, str_site, str_port);
					if(b_isTestDisabled)
					{
						v_teststatusinfo.addElement("The test has been disabled for the component.");
					}
					else if(b_isInfoAvailableForMeasure)
					{
						v_teststatusinfo.addElement("The eG manager has received data for this test and is in the process of indexing the data. Please wait for a short while for the process to complete.");
					}
					else
					{
						if(test.equals("WebSiteTransactionTest"))
						{
							if((str_site != null) && !str_site.equals(""))
							{
								v_trans4site = teststatus.trans4Site(str_site);
								if(v_trans4site.size() == 0)
								{
									v_teststatusinfo.addElement("<font id=\"eg_12\" style=\"line-height: 22px;\"><em>The agent has not reported measures yet.</em></font>");
									v_teststatusinfo.addElement("<br><strong><u>Possible reasons</u> :</strong>&nbsp;");
									v_teststatusinfo.addElement("Transactions have not been configured for the site.");
								}
							}
						}
						else
						{
							v_teststatusinfo.addElement("<font id=\"eg_12\" style=\"line-height: 22px;\"><em>The agent has not reported measures yet.</em></font>");
							v_teststatusinfo.addElement("<br><strong><u>Possible reasons</u> :</strong>&nbsp;");
							v_teststatusinfo.addElement("The corresponding agent might not be running or the agent might not have started this test yet.");
							v_teststatusinfo.addElement("If the agent is not running, the state of this test will soon turn to UNKNOWN. Otherwise, the measures will appear in a short while.");
							v_teststatusinfo.addElement("Note that if the agent has been running for a long time but the measures are not showing up, this means that the agent is unable to communicate to the manager. Please refer to the trouble shooting guide.");
						}
					}
				}
%>
				<table width="100%" cellspacing="0" cellpadding="0" align="center" border="0">
					<tr>
						<td id="eg_blankspace" height="12">&nbsp;</td>
					</tr>
					<tr>
						<th align="left" valign="middle" id="eg_cellbglight" height="20">&nbsp; eG Test Measure Status Info</th>
					</tr>
					<tr>
						<td id="eg_blankspace" height="4">&nbsp;</td>
					</tr>
				</table>
				<table width="100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Measurement Host</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<%
							if(s_msmt_host == null || s_msmt_host.equals(""))
							{
								s_msmt_host = teststatus.getMeasurementHost(str_comptype, s_sname, test);
							}
						%>
						<td width="100%" class="eg_12" id="eg_innerbg" colspan="5"><%=s_msmt_host%></td>
					</tr>
					<tr>
						<td colspan="7" id="eg_blankspace" height="4">&nbsp;</td>
					</tr>
					<tr>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Component type</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<td width="50%" class="eg_12" id="eg_innerbg"><%=str_comptype%></td>
						<td width="4" id="eg_blankspace" nowrap>&nbsp;</td>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Component</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<td width="50%" class="eg_12" id="eg_innerbg"><%=s_sname%></td>
					</tr>
					<tr>
						<td colspan="7" id="eg_blankspace" height="4">&nbsp;</td>
					</tr>
					<tr>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Test name</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<td width="50%" class="eg_12" id="eg_innerbg"><%=test%></td>
						<td width="4" id="eg_blankspace" nowrap>&nbsp;</td>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Test type</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<td width="50%" class="eg_12" id="eg_innerbg"><%=s_ttype%></td>
					</tr>
					<tr>
						<td colspan="7" id="eg_blankspace" height="4">&nbsp;</td>
					</tr>
					<tr>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Test frequency(secs)</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
						<td width="50%" class="eg_12" id="eg_innerbg"><%=s_frequencyOfTest%></td>
						<td width="4" id="eg_blankspace" nowrap>&nbsp;</td>
						<td align="left" nowrap id="eg_darktextbold" class="eg_innerbg"> &nbsp; Time since last measure</td>
						<td width="40" align="center" nowrap class="eg_innerbg">:</td>
<%
							if(!s_timeSinceLastMeasure.equals(""))
							{
%>
								<td width="50%" class="eg_12" id="eg_innerbg"><%=s_timeSinceLastMeasure%></td>
<%
							}
							else
							{
%>
								<td width="50%" class="eg_12" id="eg_innerbg">Not Available</td>
<%
							}
%>
					</tr>
					<tr>
						<td colspan="7" id="eg_blankspace" height="4">&nbsp;</td>
					</tr>
					<tr>
						<th align="left" nowrap id="<%=str_tstate%>alarms"> &nbsp; Test state</th>
						<th width="40" align="center" nowrap id="<%=str_tstate%>alarms" height="18">:</th>
						<th align="left" width="100%" id="<%=str_tstate%>alarms" colspan="5"><%=str_tstate%></th>
					</tr>
					<tr>
						<td colspan="7">
							<table width="100%" cellspacing="0" cellpadding="1" align="center" border="0">
								<tr>
									<td id="eg_darktext">
										<p>
			<%
										for(int i=0;i < v_teststatusinfo.size();i++)
										{
											out.println(v_teststatusinfo.elementAt(i));
										}
			%>
										</p>
									</td>
								</tr>
								<tr>
									<td id="eg_blankspace" height="10">&nbsp;</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
<%
				v_teststatusinfo.removeAllElements();
				v_trans4site.removeAllElements();
%>
			</td>
		</tr>
<%
			} //end of else
			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception bug123) {}
			}
			egDb.releaseConnection(false);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch (Exception e)
		{
			if(!s_status.equals("CONNECTED"))
			{
					message = "Could not establish connection";
			}
			else
			{
				if(rs == null)
				{
					if(!b_status)
					{
						message = "No measures found for this test in the database !!";
					}
				}
				else if(rs != null)
				{
					if(!b_status)
					{
						message = "An unknown error occured while fetching records";
					}
				}
				else if(!b_status_state)
				{
						message = "You have exceeded your limit for the number of agents! This component is not being monitored by eG currently!!";
				}
				else
				{
					message = e.toString();
				}
				if (rs != null)
				{
					try {
						rs.close();
					} catch (Exception bug123) {}
				}
				if (rs_state != null)
				{
					try {
						rs_state.close();
					} catch (Exception bug123) {}
				}
				egDb.releaseConnection(true);
			}
			EgDbAdapterTypeUI.releaseObject(egDb);
%>
	<tr>
		<td align="center" valign="middle" id="eg_darktext" height="148"><%=message%></td>
	</tr>
<%
		}
	}
	else
	{
%>
	<tr>
		<td align="center" valign="middle" id="eg_darktext" height="148">Please select a test to see the measurements</td>
	</tr>
<%
	}
%>
</table><!-- Measurements Table ends here -->

<%
	// To get the id for the help page using the testName
	//s_id = egHelp.getIdForTest("EgDispLayers.jsp", test);
	//out.println(s_id);
%>

<script language ="javascript">

function ControlActions()
{

	<% session.setAttribute("form", "layer");%>
	var form="layer";
	// "ca_host" has been changed as "s_msmt_host"
	<%if(s_msmt_host != null && !s_msmt_host.equals("")){%>
		var url = "DispAgentInfo.jsp?agentIP=<%=s_msmt_host%>" + "&agentMode=<%=PreAgentInfo.getAgentMode(s_msmt_host)%>&form1=" + form;
	<%}else{%>
		var url = "DispAgentInfo.jsp?agentIP=<%=msmtHost_RC%>" + "&agentMode=<%=PreAgentInfo.getAgentMode(msmtHost_RC)%>&form1=" + form;
	<%}%>

	//alert(url);
	if(window.rcwin==null)
	{
		window.rcwin = window.open(url,"RemoteControl","toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=1");

	}
	else
	{
		if(window.rcwin != null)
		{
			window.rcwin.close();
			window.rcwin = null;
		}

		window.rcwin = window.open(url,"RemoteControl","toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=1");
	}
}

function TestStatusInfo()
{
	var url = "EgTestStatusInfo.jsp?<%=s_teststatusinfourl%>&layer=<%=str_layer%>";
	//alert("the url is " + url);

	<%
//		wname = sid + "TESTSTATUSINFOWINDOW";
		wname = "TESTSTATUSINFOWINDOW";
	%>

	if(!window.teststatusinfo)
	{
		teststatusinfo = window.open("EgTestStatusInfo.jsp?<%=s_teststatusinfourl%>&layer=<%=str_layer%>&badmeslist=<%=s_bad_mes_list%>","<%=wname%>","toolbar=no,menubar=no,location=no,status=no,width=650,height=400,left=181,top=155,screenx=206,screeny=155,resizable=yes,scrollbars=1");
	}
	else
	{
		if(window.teststatusinfo != null)
		{
			teststatusinfo = null
		}
		teststatusinfo = window.open("EgTestStatusInfo.jsp?<%=s_teststatusinfourl%>&layer=<%=str_layer%>&badmeslist=<%=s_bad_mes_list%>","<%=wname%>","toolbar=no,menubar=no,location=no,status=no,width=650,height=400,left=181,top=155,screenx=206,screeny=155,resizable=yes,scrollbars=1,scrollbars=yes");
	}

	teststatusinfo.focus();
}

function HelpWin()
{
	<%
//		wname = sid + "HelpWindow";
		wname = "HelpWindow";
	%>
	if(!window.helpwin)
	{
		helpwin = window.open("../eghelp/EgMHelp.jsp?test=<%=test%>","<%=wname%>","toolbar=no,menubar=no,location=no,status=no,width=600,height=400,left=206,top=155,scrollbars=1,scrollbars=yes,screenx=0,screeny=0,resizable=yes");
	}
	else
	{
		if(window.helpwin != null)
		{
			helpwin = null;
		}

		helpwin = window.open("../eghelp/EgMHelp.jsp?test=<%=test%>","<%=wname%>","toolbar=no,menubar=no,location=no,status=no,width=600,height=400,left=206,top=155,scrollbars=1,scrollbars=yes,screenx=0,screeny=0,resizable=yes");
	}

	helpwin.focus();
}
</script>
<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td id="eg_blankspace" height="5">&nbsp;</td>
	</tr>
</table>
</body>
</html>






