
<%
/****************************************************************************
*	Name			:	EgSegmentTopologyJSON.jsp
*	Version			:	eG 6.1.0 v
*	Purpose			:	To get the segment topology details in JSON format
*	Creation Date	:	01-06-2015
*	Last Modified	:	
*	--Prantish
******************************************************************************/
%>
<%@ include file = "EgServerDashboardTracker.jsp" %>
<%@ page import = "egurkha.EgCrawler" %>

<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.eGComponentCategory" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.eg.SidCheck" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import = "com.eg.EgDateInfo" %>

<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.egurkha.monitor.VMDesktopBean" %>
<%@ page import = "com.egurkha.supermanager.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>

<%@ page import = "java.util.*" %>
<%@ page import = "net.sf.json.*" %>


<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	eGComponentCategory egCompCategory = eGComponentCategory.getInstance();
	IniFile udTests	=	new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_udtests.ini");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );

	EgMappingInfo trackerMappingInfo = new EgMappingInfo(trackerLanguage);
	JSONObject rootJson = new JSONObject();
	
	String segmentName = request.getParameter("segment");
	String site = request.getParameter("site");
	String zoomLevel = request.getParameter("zoom");
	String phyTopology = request.getParameter("physical_topology");
	String service = request.getParameter("service");
	String topologyRenderingMode = request.getParameter("topologyRenderingMode");
	
	String installDir = EgInstallInfo.getInstallDir();
	if(segmentName != null) {
		segmentName = segmentName.trim();
	}
	if(zoomLevel == null) {
		zoomLevel = "1";
	}
	if(site == null){
		site = "";
	}
	if(service == null) {
		service = "";
	}
	
	String fromMyDashboard = request.getParameter("fromMyDashboard");
	String anonymousUser="no";
	String profileName="";
	boolean isFromMyDashboard=false;
	String setMyDashboardAsHome="no";
	String isMyDashboardPopout="no";
	if(fromMyDashboard!=null && fromMyDashboard.equalsIgnoreCase("true"))
	{
		isFromMyDashboard=true;
		String myDashboardTheme = request.getParameter("myDashboardTheme");
		anonymousUser = request.getParameter("anonymousUser");
		profileName = request.getParameter("profileName");
		setMyDashboardAsHome=request.getParameter("setMonitorHome");
		isMyDashboardPopout=request.getParameter("isDisablePopupOption");
		if(!com.egurkha.util.StringUtils.isNull(myDashboardTheme) && !myDashboardTheme.equalsIgnoreCase(monitor_Skin))
		{
			monitor_Skin=myDashboardTheme;
		}
	}

	String vmhost = request.getParameter("Vmhost");
	String vmware = request.getParameter("vmware");
	String treeFlag = request.getParameter("treeFlag");
	String isFromZone = request.getParameter("isFromZone");
	String iszoneName = request.getParameter("iszoneName")!= null?request.getParameter("iszoneName"):"";
	String parentZone = request.getParameter("parentZone");
	if(vmware==null) {
		vmware = "";
	}
	String finalTopoStr = getTopologyString(segmentName, site, phyTopology, vmhost, request);
	//Get row & column spacing from eg_ui.ini .... (Begin)
	IniUI iniUI = IniUI.getInstance();
	String rs = iniUI.getValue("TOPOLOGY_OPTIONS", "Row_space");
	String cs = iniUI.getValue("TOPOLOGY_OPTIONS", "Column_space");
	iniUI =  null;
	int rowspace = 50;
	int colspace = 50;
	try
	{
		if(rs != null) {
			rowspace = Integer.parseInt(rs);
		}
	}
	catch(Exception e){
	}

	try
	{
		if(cs!=null) {
			colspace = Integer.parseInt(cs);
		}
	}
	catch(Exception e){
	}
	EgNewTopology egNewTopo= new EgNewTopology(finalTopoStr, rowspace, colspace, monitor_Skin, request);
	
	String iniFileName = installDir + "/manager/config/js_topology.ini";
	if(topologyRenderingMode != null && topologyRenderingMode.equals("auto")){
		iniFileName = installDir + "/manager/config/js_auto_topology.ini";
	}
	
	IniFile jsTopoIniObj = EgConfigFilesSync.getInstance(iniFileName);
	String subjectName = segmentName;
	if(segmentName!=null && segmentName.equals("Independent_servers"))
	{
		subjectName = site + ":" + segmentName;
	}
	String[] allLines = jsTopoIniObj.getLinesUnderSubject(subjectName);
	String iniZoom = jsTopoIniObj.getValue(subjectName, "zoom");
	if(iniZoom != null && iniZoom.length() > 0 )
	{
		zoomLevel = iniZoom;
	}
	EgConfigFilesSync.releaseInstance(jsTopoIniObj);

	boolean isPosition = false;
	StringBuffer positionBuffer = new StringBuffer();
	if(allLines != null)
	{
		List positionList = Arrays.asList(allLines);
		positionBuffer.append(positionList.toString().substring(1, positionList.toString().indexOf("]")));
		isPosition = true;
	}

	if(topologyRenderingMode != null && topologyRenderingMode.equals("auto")){
		rootJson.put("rootJson", egNewTopo.getAutoTopologyJson());
	} else {
		rootJson.put("rootJson", egNewTopo.getTopologyJson());
	}
	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(rootJson.toString());

%>
	

<%!
	private String getTopologyString(String segmentName, String site, String phyTopology, String vmHost, HttpServletRequest httpRequest)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		EgCrawler strBean = new EgCrawler(iniFile);

		String str = null;

		if (phyTopology.equals("1"))
		{
			str = strBean.getPhysicalTopology(segmentName);
		}
		//This check is to topology graph view for Vmware guests components
		else if (phyTopology.equals("2"))
		{
			if(vmHost != null || (!vmHost.equals("null")))
			{
				VMDesktopBean vmdbean = new VMDesktopBean(httpRequest);
				str = vmdbean.getVmhostString(vmHost, site);
			}
		}
		else
		{
			if (segmentName!=null && segmentName.equals("Independent_servers"))
			{
				str = strBean.getSiteString(site, site + "_INDEPENDENT");
			}
			else
			{
				str = strBean.getSiteString(site, segmentName);
			}
		}

		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
		{
			newString = EgConstants.BLANK_SPACE;
		}
		else
		{
			newString = ap.getTopologyPriority(str, site);
		}
		newString = sortTopoString(newString);
		return newString;
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr == null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i = 0; i < topoToks.length; i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation != null && relation.length == 2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation != null && relation.length == 1)
				{
					thisLhs = relation[0];
				}
				
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs) == -1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj != null && finalLhs.indexOf(thisLhs) == -1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj == null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < finalLhs.size(); i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs != null && !thisRhs.equals(""))
		{
		String [] toks = StringUtils.getTokens(thisRhs, ",");
		for (int i = 0; i < toks.length; i++ )
		{
			String thisStr = toks[i];
			TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
			result.add(rhsCmp);
			
			if (!rhsCmp.toString().equals("null"))
			{
				h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		
		return result;
	}
%>
<%

	
%>