<%
/**
 *	Shows the distribution of the values in the chart. Used by EgDashBoard.jsp to show the results
 *	@author		Arun Jayaprakash
 *	@created	02/05/2003
 *	@version	eG 3.0
 *
 *	@modified
 *		10/09/2003	Arun	Server names do not show :NULL
 *		08/10/2003	Arun	Stopped Cisco-related "unrelated" tests from appearing in the 
 *							layers page by removing the fromalarm parameter
 *		10/11/2003	Arun	Modified doPost() to enable searching by server types and/or 
 *							server names in EgShowDistribution.jsp 
 *		12/11/2003	Arun	Shows server types only if there are two or more server types. Shows search 
 *							option only if the number of servers in the server type exceed the minimum.
 *		19/12/2003	Arun	Refresh showed older state because it read state from the object stored 
 *							in the session
 *		15/04/2004	Arun	Modified to fix refresh bug in EgShowDistribution.jsp
 */
%>

<%@ include file="EgLoginTracker.jsp" %>
<%@ page import="com.eg.EgDbAdapterTypeUI" %>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="egurkha.EgDbAdapterUI" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>
<html>
<head>
<title> &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<meta name="Author" content="John Williams" />
<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />
<%
	List servers = null;	//List of servers that should be displayed
	String serverType = request.getParameter("serverType");
	String flag = request.getParameter("flag");
	String name = request.getParameter("sname");

	StringBuffer metaRefreshUrl = new StringBuffer(192);
	metaRefreshUrl.append("/final/servlet/com.egurkha.monitor.DashboardDistribution?");

	String title = request.getParameter("title");
	String state = request.getParameter("showState");
	if (title != null && (title.equalsIgnoreCase(IniUI.SERVERS_HEALTH) || title.equalsIgnoreCase("null")))
	{
		metaRefreshUrl.append("showAllStates=false");

		if (state != null && !state.equalsIgnoreCase("null"))
		{
			metaRefreshUrl.append("&showState=");
			metaRefreshUrl.append(state);
		}
	}
	else if (title != null && !title.equalsIgnoreCase("null"))
	{
		metaRefreshUrl.append("showAllStates=true");
	}

	if (flag != null)
	{
		metaRefreshUrl.append("&serverTypeChanged=yes");
		metaRefreshUrl.append("&flag=");
		metaRefreshUrl.append(flag);
	}

	if (serverType != null && !serverType.equalsIgnoreCase("null"))
	{
		metaRefreshUrl.append("&showServerType=");
		metaRefreshUrl.append(serverType);
	}

	if (name != null && !name.equalsIgnoreCase("null"))
	{
		metaRefreshUrl.append("&sname=");
		metaRefreshUrl.append(name);
	}
%>
<script language="JavaScript1.2" src="eg_scripts/eg_validate.js"></script>
<script language="JavaScript1.2">
function valform()
{
	var thisForm = document.showservers;
	var servertype = "null";
	if (thisForm.stype != null)
	{
		servertype = thisForm.stype.options[thisForm.stype.options.selectedIndex].value;
	}

	var servername = "";
	var sub = true;
	if (thisForm.sname != null)
	{
		servername = thisForm.sname.value;
		sub = checkspecial(thisForm.sname,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
	}

	if (servername == "" && (servertype == "null" || servertype == ""))
	{
		sub = false;
	}

	if(sub)
	{
		//when servername is '192.168.10.12 and 192.168.10.13', replace space by '*'
		for(var x=0;x<servername.length;x++)
		{
			if(servername.charAt(x) == ' ')
			{
				servername = servername.replace(' ','*');
			}
		}

		if(servername == "")
		{
//window.location.href = "EgShowDistribution.jsp?serverType=" + servertype + "&flag=type";
			parent.location.href="/final/servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&showServerType="+servertype;
		}
		else
		{
			var sType = thisForm.ServerType.value;
			if (sType == servertype)
			{
				/*
				 * Server type has not changed
				 */
//window.location.href = "EgShowDistribution.jsp?serverType=" +servertype+ "&sname=" +servername+ "&flag=both&showServerType="+servertype;
				var refreshUrl = "<%=metaRefreshUrl.toString()%>";
				refreshUrl = replaceParam(refreshUrl, "&sname=", servername);
				refreshUrl = replaceParam(refreshUrl, "&flag=", "both");
				parent.location.href = refreshUrl;
			}
			else
			{
				/*
				 * Server type has changed. Get list of servers for this type
				 */
//window.location.href = "EgShowDistribution.jsp?serverType=" +servertype+ "&sname=" +servername;
				parent.location.href="/final/servlet/com.egurkha.monitor.DashboardDistribution?showAllStates=true&serverTypeChanged=yes&flag=both&showServerType="+servertype+"&sname="+servername+"&serverType="+servertype;
			}
		}
	}
	else
	{
		alert("Search criteria not specified.");
		thisForm.sname.focus();
	}
}

function refreshPage(url)
{
	/*
	 * If the line is directly added to the refresh tag, the url can be seen 
	 * a little before the page refreshes.
	 */
	parent.location.href=url;
}
</script>
<meta http-equiv="refresh" content="20;url=javascript:refreshPage('<%=metaRefreshUrl.toString()%>');">
</head>
<%
	if (flag != null)
	{
		List totalServers = null;
		String serverTypeChanged = request.getParameter("serverTypeChanged");
		if (serverTypeChanged != null && serverTypeChanged.equalsIgnoreCase("yes"))
		{
			/*
			 * A different server type and server name was given in EgShowDistribution.jsp
			 */
			totalServers = (List)session.getAttribute("distribution");
		}
		else
		{
			totalServers = (List)session.getAttribute("alarmDistribution");
		}

		int size = totalServers.size();
		if (flag.equalsIgnoreCase("both"))
		{
			String searchKey = StringUtils.replace(name.trim(), "*", " ");
			String[] tokens = StringUtils.getTokens(searchKey, EgConstants.BLANK_SPACE);
			servers = new LinkedList();
			for (int a=0; a<tokens.length; a++)
			{
				if (servers.indexOf(tokens[a]) == -1)
				{
					for (int b=0; b<size; b++)
					{
						String[] row = (String[])totalServers.get(b);
						if (row[0].toLowerCase().indexOf(tokens[a].toLowerCase()) > -1)
						{
							servers.add(row);
						}
					}
				}
			}
		}
	}
	else
	{
		/*
		 * Came from com.egurkha.monitor.DashboardDistribution
		 */
		servers = (List)session.getAttribute("distribution");
	}
%>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" id="eg_innerbg">
<form name="showservers" method="post" action="javascript:valform();">

<%
	List serverTypes = null;
	boolean showServerTypes = false;
	if (!StringUtils.isNull(serverType) && !serverType.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		/*
		 * Came from Application At A Glance applet
		 *
		 * Show server types in a drop down if there are 
		 * atleast two server types
		 */
		UserRegistry registry = UserRegistry.getInstance();
		User user = registry.getUser(session.getId());

		serverTypes = new LinkedList();
		serverTypes.addAll(user.getServerTypes());

		int hostSystemIndex = serverTypes.indexOf(Server.HOST_SYSTEM);
		if (hostSystemIndex > -1)
		{
			/*
			 * Remove Host_system from the list of server types
			 */
			serverTypes.remove(hostSystemIndex);
		}

		showServerTypes = (serverTypes.size() > 1);
	}

	boolean showSearchOption = (servers != null && servers.size() < EgConstants.MIN_SERVERS_FOR_SEARCH);
	if ((showSearchOption || showServerTypes))
	{
%>
		<table align="center" cellspacing="6" cellpadding="2" border="0"><tr><td align="center">
		<table align="center" cellspacing="0" cellpadding="2" border="0">
			<tr>
				<td id="eg_cellbgmedium">
					<table align="center" cellspacing="0" cellpadding="2" height="32" border="0">
						<tr>
<%
		if (showServerTypes)
		{
%>
							<th class="eg_bodybg" id="eg_darktextbold" nowrap="nowrap"><font id="eg_color3">&nbsp;Type</font></th>
							<td class="eg_bodybg" nowrap="nowrap">
								<select name="stype">
<%
			String selectedOption = null;
			if (serverType == null)
			{
				selectedOption = (String)serverTypes.get(0);
			}
			else
			{
				selectedOption = serverType;
			}

			out.println(HtmlUtils.setSelectOptions(serverTypes.toArray(), selectedOption));
%>
								</select>
							</td>
<%
		}

		if (showSearchOption)
		{
			String searchKey = name;
			if (name == null || name.equalsIgnoreCase("null"))
			{
				searchKey = EgConstants.BLANK_STRING;
			}
%>
							<th class="eg_bodybg" id="eg_darktextbold" nowrap="nowrap"><font id="eg_color3">&nbsp; IP/Hostname</font></th>
							<td class="eg_bodybg"><input type="text" name="sname" size="12" style="width: 180px;" value="<%=searchKey%>" maxlength="128" class="eg_11"></td>
<%
		}
%>
							<td class="eg_bodybg"><input type="button" onClick="javascript:valform();" value="SEARCH" name="searchbutton" id="eg_darkbutton"></td>
							<td class="eg_bodybg" id="eg_blankspace" width="2" nowrap="nowrap">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		</td>
<%
		if (!showSearchOption)
		{
%>
		<td><p style="line-height:16px; font-size: 10px;"><sup>* </sup>You can search using any character of your component.&nbsp; Multiple search strings should be separated using a blank space.</p></td>
<%
		}
%>
		</tr></table>
	<br />
<%
	}
%>
<br>
	<input type='hidden' name='ServerType' value='<%=serverType%>'>
	<table align="center" cellspacing="0" cellpadding="5" width="100%" border="0">
<%

	if (servers != null && servers.size() > 0)
	{
		int count = 0;					//Counts number of cells drawn so far
		int maxPerRow = 5;				//Maximum cells per row
		int size = servers.size();		
		int rows = size/maxPerRow;		//Minimum number of rows in the table
		if (size % maxPerRow > 0)
		{
			rows++;						//If empty cells have to be drawn, that means an extra row
		}
		int emptyCount = Math.abs(size - (maxPerRow * rows));
		int width = 100/maxPerRow;		//By default width = 20
		if (size < maxPerRow)
		{
			width = 100 / size;
		}

		for (Iterator i=servers.iterator(); i.hasNext(); )
		{
			if (count == 0)
			{//Start new row
				out.print("<tr>");
			}

			String[] row = (String[])i.next();
			String compName = null;
			if (row[0].endsWith(EgConstants.NULL_PORT))
			{
				compName = Server.getServerNameWithoutPort(row[0], false);
			}
			else
			{
				compName = row[0];
			}
%>
		<td width="<%=width%>%" align="center" height="90" valign="top" nowrap="nowrap" id="eg_blackcontent">
			<table align="center" cellspacing="0" cellpadding="0" width="36" height="36" border="0">
				<tr>
					<td id="<%=row[2]%>border" align="center" valign="middle" width="36" height="36" nowrap background="eg_images/eg_layout/<%=row[2]%>big.gif">
						<a href="EgDispLayers.jsp?site=NULL&qctr=0&host=<%=row[0]%>&comptype=<%=row[1]%>" target="eg_operations"><img src="eg_images/eg_layout/eg_icons/<%=row[1]%>.gif" border="0" alt="<%=row[1]%>" align="center" width="30" height="30" hspace="0" vspace="0"></a>
					</td>
				</tr>
			</table>
<%
			while (compName.length() > 20)
			{
				out.print(compName.substring(0, 20));
				out.print("<br>");
				compName = compName.substring(20);
			}
			if (compName.length() <= 20)
			{
				out.print(compName);
			}
%>
		</td>
<%
			count++;
			size--;

			if ((maxPerRow == count) || (size == 0))
			{//End of the row
				if ((rows > 1) && (size == 0))
				{//Only if rows are more than 1. Otherwise the cells will be center-aligned by default
					for (int a=0; a<emptyCount; a++)
					{
						out.print("<td nowrap=\"nowrap\" width=\"");
						out.print(width);
						out.println("%\">&nbsp;</td>");
					}
				}
				out.print("</tr>");
				count = 0;
			}
		}//End of for (Iterator...)

		/*
		 * Put the servers into the session so that the results can be available when the search option is used
		 */
		if (flag == null)
		{
			session.setAttribute("alarmDistribution", servers);
		}
	}
	else
	{
		out.println("<tr>");
		if (name == null || name.equalsIgnoreCase("null"))
		{
			out.print("<th height=\"200\" width=\"100%\" align=\"center\" id=\"eg_alarmth\">No components found");
		}
		else
		{
			out.print("<th height=\"200\" width=\"100%\" align=\"center\" id=\"eg_alarmth\">No components found matching \"");
			out.print(name);
			out.print("\"");
		}
		out.println("</th>");
	}
%>
	</tr>
	</table>
</form>
</body>
</html>






