<%
/*******************************************************************************
*	File name		: egDashBoardTimeline.jsp
*	Purpose			: To display Fullview Graph in monitor Dashboard.
*	Version			: eG 4.3
*	Creation Date	: 20/03/2009
*	Authtor			: Simeon.D
*   Modified on     : 08/02/2010
					  Arivarasu. G -  To include Fusion Chart
  					20/12/2011  Sri Devi G User - VM Changes
********************************************************************************/
%>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import= "com.egurkha.monitor.*"%>
<%@ page import = "java.util.*"%>

<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgMappingInfo"%>

<%@ page import = "com.egurkha.EgMeasureGraphExt"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.egurkha.monitor.EgDashBoardDAO" %>
<%@ page import = "com.egurkha.monitor.EgInsideViewChartUtil" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import="net.sf.json.*"%>
<%@ page import = "com.egurkha.HighChartTimeline" %>
<%@ page import = "com.eg.supermanager.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
try
{
	if(EgInstallInfo.isSuperManager)
	{
		String s_comp = request.getParameter("host");
		if(s_comp != null && s_comp.length()>0 && !s_comp.equalsIgnoreCase("null"))
		{
			ArrayList managerIDs = EgElementInfo.getInstance().getManagerIDs("component",s_comp);
			if(managerIDs != null && !managerIDs.isEmpty())
			{
				SmSessionData smsData = new SmSessionData(session.getId(),managerIDs);
				EgThreadLocal egtl = new EgThreadLocal();
				egtl.set(smsData);
				new SMDateTimeConverter(managerIDs);
			}
		}
	}

	String currentBrowser = request.getHeader("User-Agent");

	boolean isFirefox = ( currentBrowser != null && currentBrowser.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 7.0" ) != -1 );
	boolean isChrome = ( currentBrowser != null && currentBrowser.indexOf( "Chrome" ) != -1 );

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgDashBoardDAO dashBoardDAO=new EgDashBoardDAO();
	EgDashBoardModel  egDashboard=new  EgDashBoardModel();
	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();

	ErUtils erUtils = new ErUtils();
	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	IniUI iniUI = IniUI.getInstance();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	EgInsideViewChartUtil fusionChart=new EgInsideViewChartUtil();// For fusionchart
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	//Highchart variables
	String chart_st_time = "";
	String chart_end_time = "";
	String chart_st_hr = "";
	String chart_end_hr = "";
	String uiFile = "eg_ui.ini";
	//String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	//String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String chartOption = egUI.getValue("CHART_TYPE","ChartOption");
	String chartTimeline = egUI.getValue("CHART_TYPE","Timeline");
	chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";
	 HashSet  optVec = new HashSet ();
	 boolean isFusionChart=HighChartTimeline.isFusion();
	//End
	Vector v_color = new Vector();
	String dashBoardColors[] = {"#663300","#8A62AF","#FFCC99","#AFCCFF","#C0FE70","#FFCCCC","#FFFF99",
	"#FE8243","#99CC33","#CCCC99","#CC99CC","#CCFFCC","#99CCCC","#336635","#CC9933"};
	
	/*for(int i=0;i<dashBoardColors.length;i++)
	{
		v_color.add(dashBoardColors[i]);
	}*/

	//String s_colors=iniObj.getValue("Dashboard_Graph_colors","LineGraph");
	String s_colors=egUI.getValue("CHART_COLORS","TIME_LINE_CHART");

	StringTokenizer colorTokens=new StringTokenizer(s_colors,",");
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	String thisLanguage = ui.getDefaultLanguage();
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	while(colorTokens.hasMoreTokens())
	{
		String token=colorTokens.nextToken();
		if(token!=null && token.indexOf("#")!=0)
			token="#"+token;

		v_color.add(token);
	}

	Vector v_priority=new Vector();
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 10");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.ALL"));
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 10");
	
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String userFormat=user.getUserDateFormat();
	EgTimeZoneConverter timeZoneConverterStart=null;
	EgTimeZoneConverter timeZoneConverterEnd=null;
	String startDateForDisplay = null;
	String startHourForDisplay = null;
	String endDateForDisplay = null;
	String endHourForDisplay = null;
	String startMinForDisplay=null;
	String endMinForDisplay=null;

	String comFormat = null;
	String startDateTime = null;
	String endDateTime = null;

	String startDate = "";
	String endDate = "";
	String dispDate = null;
	String defaultDateFormat = null;
	String disable = "disabled";
	String startMin="";
	String endMin="";

	String startDateForSummary=null;
	String endDateForSummary=null;

	String measure=request.getParameter("measure");
	String portNo=request.getParameter("port");
	String site=request.getParameter("site");
	String msmtHost=request.getParameter("msmt_host");
	msmtHost=(msmtHost==null)?"":msmtHost;
	String test=request.getParameter("test");
	String info=request.getParameter("info");
	info=(info==null)?"":info;
	String priority=request.getParameter("priority");
	String real_measure=request.getParameter("real_measure");
	String displayName=request.getParameter("displayName");
	String treeOpen=request.getParameter("treeOpen");
	String timeline = request.getParameter("timeline_compare");
	String showLegStr = request.getParameter("showLegend");

	EgTimeZoneConverter startDateConverter = null;
	EgTimeZoneConverter endDateConverter = null;
	
	// for Insideview Dashboard
	if(timeline==null)
	{
		timeline = request.getParameter("time_line");
	}
	//--end---

	// ******* for Transaction page *******
	String all_trans_names= request.getParameter("all_trans_names");
	String comp_name= request.getParameter("comp");
	String isZoomGraph= request.getParameter("isZoomGraph");
	String graphId= request.getParameter("graphId");
	// ******* end *******

	String hostName= request.getParameter("host");
	hostName=(hostName==null)?"":hostName;
	String compType=request.getParameter("compType");
	if(compType==null || compType.trim().length()==0)
		compType=request.getParameter("comptype");
	String duration=request.getParameter("duration");
	String trendType=request.getParameter("trendType");
	String graphType=request.getParameter("graphType");
	String display=request.getParameter("display");
	boolean isTimelineRequired = (display!=null && display.equals("false"));
	if(isTimelineRequired)
		display="none";
	else
		display="block";
		
	String format=request.getParameter("format");
	String ddformat=request.getParameter("ddformat");
	String module=request.getParameter("module");
	boolean LayerwiseHealth=graphType!=null && graphType.equalsIgnoreCase("LayerwiseHealth");
	String mode=request.getParameter("mode");
	String minmaxavgRequired=request.getParameter("minmaxavgRequired");
	String graphTitleValue=request.getParameter("graphTitle");
	graphTitleValue=(graphTitleValue==null)?"":graphTitleValue;
	String graphTitle=graphTitleValue;
	graphTitle=com.egurkha.util.StringUtils.replace(graphTitle,"|pct|","%");
	String durationChanged=request.getParameter("durationChanged");
	String minMaxAvgDisplay="none";
	String from_page=request.getParameter("from_page");
	String AggregateGraphs=request.getParameter("AggregateGraphs");
	if(minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true"))
		minMaxAvgDisplay="block";
	// for graph zoom ,from vmwareDashboard start
	String come_from=request.getParameter("come_from");
	String actualPriority = request.getParameter("actualPriority");
	String isOnChange = request.getParameter("isOnChange");
	String noOfInfosToDisplay = request.getParameter("noOfInfos");
	boolean isVM = false;
	String s_isVM = request.getParameter("isVM");
	isVM = (new Boolean(s_isVM)).booleanValue();
	List userVMs = new LinkedList();

	if(isVM)
	{
		if(u_ser!=null)
		{
			userVMs=u_ser.getOnlyVMs();
		
		}
	}

	// ******* for Transaction page *******
	boolean come_from_trans = false;
	come_from_trans = (come_from!=null) && (come_from.equalsIgnoreCase("Transactions"));
	// ******* end *******

	// ******* for Vmware Live Graph page *******
	boolean come_from_vmLG = false;
	come_from_vmLG = (come_from!=null) && (come_from.equalsIgnoreCase("vmwareLiveGraph"));
	// ******* end *******

	boolean come_from_vmware = false;
	come_from_vmware = (come_from!=null) && (come_from.equalsIgnoreCase("vmwareDashboard"));
	
	boolean come_from_insideview = false;
	come_from_insideview = (come_from!=null) && (come_from.equalsIgnoreCase("insideViewDashboard"));

	boolean come_from_cview = false;
	come_from_cview = (come_from!=null) && (come_from.equalsIgnoreCase("cview"));

	if(come_from_insideview || come_from_cview)
		minMaxAvgDisplay="block";

	if(come_from_vmware)
		minMaxAvgDisplay="block";
	String isTimeout=request.getParameter("isTimeout");

	String applyFusion=request.getParameter("applyFusion");
	boolean isApplyFusion=applyFusion!=null && applyFusion.equalsIgnoreCase("true");

	if(priority==null || priority.trim().length()==0 || priority.trim().equalsIgnoreCase("null"))
		priority="ALL";
	if(come_from != null && priority != null && actualPriority!=null && come_from.equalsIgnoreCase("vmwareLiveGraph") && priority.equalsIgnoreCase("ALL") && isOnChange==null)
		priority = actualPriority+" - "+noOfInfosToDisplay;
	String Qstring="";
	String queryString = request.getQueryString();
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam.equals("info"))
			{
				value=request.getParameter(reqparam);
				if(value!=null && value.trim().length()>0)
					value=EgURLEncoder.encode(value,"UTF-8");
			}
			else if(reqparam.equals("host"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("comptype"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("test"))
			{
				if(request.getParameter(reqparam)!=null)
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
				else
				{
					value=request.getParameter(reqparam);
				}
			}
			else if(reqparam.equals("layer"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("urlType"))
			{
				value=request.getParameter(reqparam);
				if(value!=null && value.trim().length()>0)
					value=EgURLEncoder.encode(value,"UTF-8");
			}
			Qstring=Qstring+"&"+reqparam+"="+value;
		}
	}
	
	JSONObject json  = new JSONObject(); 
	JSONObject screenLabels  = new JSONObject();
	JSONObject hiddenFields  = new JSONObject();
	
	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	SimpleDateFormat  dateFormatWithTime=new SimpleDateFormat("dd/MM/yyyy HH:mm");
	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
	SimpleDateFormat dateFormat=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm");
	SimpleDateFormat dfForParse=new SimpleDateFormat(currentDateFormat);
	SimpleDateFormat userdfForParse=new SimpleDateFormat(userFormat);
	SimpleDateFormat dateFormatDDMM=new SimpleDateFormat("dd/MM/yyyy");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	int graphWidth=1024;
	int graphHeight=768;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		graphWidth=Integer.parseInt(screenWidth);
		graphWidth=graphWidth-60;
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		graphHeight=Integer.parseInt(screenHeight);
		if(come_from_vmware)
		{
			graphHeight=graphHeight-130;
		}
		else
		{
			graphHeight=graphHeight-160;
		}
	}

	if(LayerwiseHealth)
	{
		JSONObject LayerwiseHealthJson  = new JSONObject(); 
		JSONObject LayerwiseHealthObject  = new JSONObject(); 
		String healthCompName=request.getParameter("hostName");
		String healthGraphURL="../servlet/com.egurkha.monitor.EventChart?hostName="+healthCompName+"&compType="+compType+"&module=Application&monitorSkin="+monitor_Skin+"&fromHealth=true&width=893&height=360&display=fullView&imgdate="+new java.util.Date();
		//for fusion chart
		compType=request.getParameter("compType");
		Vector chartAttributes=new Vector();
		chartAttributes.add("showLegend='0'");
		chartAttributes.add("numberSuffix='%'");
		chartAttributes.add("useRoundEdges='1'");
		chartAttributes.add("exportEnabled='0'");
		chartAttributes.add("exportAction='download'");
		chartAttributes.add("exportAtClient='0'");
		chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
		chartAttributes.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
		chartAttributes.add("showValues='0'");
		chartAttributes.add("clickURL='javascript:bigGraphOnClick()'");
		chartAttributes.add("yAxisMaxValue='100'");
		String tab="Application";
		String layerHealthXML=fusionChart.getXMLForLayerHealth(healthCompName,compType,tab,false,chartAttributes);
		LayerwiseHealthJson.put("minimizeIconSrc","/final/monitor/eg_images/"+monitor_Skin+"/icon_minimize_div.png");

		if(layerHealthXML!=null && layerHealthXML.trim().length()>0)
		{
			LayerwiseHealthObject.put("movie","/final/FusionCharts/swf/StackedBar2D.swf");
			LayerwiseHealthObject.put("chartWidth",graphWidth);
			LayerwiseHealthObject.put("chartHeight",graphHeight);
			LayerwiseHealthObject.put("WModeSrc","/final/FusionCharts/swf/StackedBar2D.swf");
			LayerwiseHealthObject.put("dataXml",layerHealthXML);
		}
		else
		{
			LayerwiseHealthObject.put("exclamationIcon","/final/monitor/eg_images/"+monitor_Skin+"/exclamation-icon.gif");
			LayerwiseHealthObject.put("NoMeasures",mappingInfo.getTextDescription("monitor.summary.No measures available"));
		}
		LayerwiseHealthJson.put("LayerwiseHealthObject",LayerwiseHealthObject);
		json.put("LayerwiseHealth",LayerwiseHealthJson);
	}
	else
	{
		if(mode==null)
			mode="3D";

		if(duration==null)
			duration="H";

		if(StringUtils.isNull(timeline))
			timeline = "1 hour";

		if(graphTitle==null || graphTitle.trim().equals(""))
			graphTitle="Graph";

		int startHour = 0;
		int endHour = 23;
		int[] hours = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};

		String[] options;

		if(durationChanged!=null && durationChanged.equalsIgnoreCase("true"))
		{
			if(duration!=null && duration.equalsIgnoreCase("D"))
			{
				timeline="1 week";
			}
			else if(duration!=null && duration.equalsIgnoreCase("M"))
			{
				timeline="3 months";
			}
			else
			{
				timeline="24 hours";
			}
		}

		if(duration!=null && duration.equalsIgnoreCase("D"))
		{
			options =new String[] {"Any","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else if(duration!=null && duration.equalsIgnoreCase("M"))
		{
			options =new String[] {"Any","1 month","3 months","6 months","9 months","12 months"};
		}
		else
		{
			options =new String[] {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}

		//String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String unit ="";
		int value=0;
		int timeValue=0;

		EgDateInfo edi = new EgDateInfo();
		Date today = edi.egetRealDate();
		startMin=Integer.toString(today.getMinutes());
		endMin=Integer.toString(today.getMinutes());
		if(timeline != null && !timeline.equals("Any") && !timeline.equalsIgnoreCase("Fixed"))
		{
			int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);

			if (blankSpaceIndex > 0)
			{
				value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
				timeValue=Integer.parseInt(timeline.substring(0, blankSpaceIndex));

				unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
				if (unit.startsWith("h"))
				{//hours
					value *= 3600;
				}
				else if (unit.startsWith("d"))
				{//days
					value *= (24 * 3600);
				}
				else if (unit.startsWith("w"))
				{//weeks
					value *= (7 * 24 * 3600);
				}
				else if (unit.startsWith("mo"))
				{//months
					value *= (30 * 24 * 3600);
				}

				long longValue=value;

				Date start = edi.egetRealDate();

				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if (unit.startsWith("h"))
					{
						start.setDate(start.getDate()-1);
					}
					else
					{
						start.setTime(today.getTime() - (longValue * 1000));
					}
				}
				else
				{
					start.setTime(today.getTime() - (longValue * 1000));
				}

				endDateTime = sdf.format(today);
				startDateTime = sdf.format(start);
			}

			if((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));

				endDate=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				startDate=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));

				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if(unit.startsWith("h"))
					{
						startHour = 24-timeValue;
						endHour = 0;
					}
					else
					{
						startHour = 0;
						endHour = 23;
					}
				}
				else
				{
					startHour = shr;
					endHour = en_hr;
				}
			}
		}
		else if(timeline!=null && timeline.equalsIgnoreCase("Fixed"))
		{
			disable="false";
			try
			{
				String startDateStr=request.getParameter("starttime_compare");
				if(startDateStr==null)
				{
					startDateStr=request.getParameter("starttime");
				}
				startDate = startDateStr;

				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr=request.getParameter("endtime");
				}
				endDate=endDateStr;
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}
		}
		else
		{
			disable="false";

			String stDate = request.getParameter("starttime");
			String enDate = request.getParameter("endtime");		
			if(!DateUtil.isDate(stDate,userFormat))
			{
				stDate = DateUtil.changeDateFormat(stDate,currentDateFormat,userFormat);
			}

			if(!DateUtil.isDate(enDate,userFormat))
			{
				enDate = DateUtil.changeDateFormat(enDate,currentDateFormat,userFormat);
			}

			try
			{

				String startDateStr=request.getParameter("starttime_compare");
				if(startDateStr==null)
				{
					startDateStr = stDate;
				}
				try
				{
				Date startDateFrmReq=new Date();
					startDateFrmReq=userdfForParse.parse(startDateStr);

				startDateForSummary=dateFormat.format(new Date(startDateFrmReq.getTime() -(24 * 60*60*1000)));
				startDate = dateFormat.format(startDateFrmReq);
				}
				catch(Exception e)
				{
					System.out.println(" ************* Exception ***************** "+e);
				}
				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr = enDate; 
				}
				Date endDateFrmReq=new Date();
				endDateFrmReq=userdfForParse.parse(endDateStr);

				endDate =dateFormat.format(endDateFrmReq);
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}
			String smin = request.getParameter("startmin");
			if(smin == null || smin.equals(""))
				smin="0";
			String emin = request.getParameter("endmin");
			if(emin == null || emin.equals(""))
				emin="0";
	
			startDateConverter = new EgTimeZoneConverter(stDate+" "+request.getParameter("starthr")+":"+smin+":00",user,true);

			startDate = DateUtil.changeDateFormat((String)startDateConverter.getDate(false),userFormat,"MM/dd/yyyy");

			startHour = Integer.parseInt(startDateConverter.getHour());
			startMin =startDateConverter.getMinute();

			endDateConverter = new EgTimeZoneConverter(enDate+" "+request.getParameter("endhr")+":"+emin+":00",user,true);
			endDate = DateUtil.changeDateFormat((String)endDateConverter.getDate(false),userFormat,"MM/dd/yyyy");
			endHour =Integer.parseInt(endDateConverter.getHour());
			endMin = endDateConverter.getMinute();
		}
		String s_gformat = "easychart";
		chartTimeline = (chartTimeline != null && !chartTimeline.equals(""))?chartTimeline:"1 hour";
		chartOption=(chartOption==null || chartOption =="")?"easycharts":chartOption;
		chartOption = chartOption.toLowerCase();
		if(chartOption != null && !chartOption.equalsIgnoreCase("") && chartOption.indexOf("easy") == -1)
		{
			s_gformat = chartOption;
			String tline = timeline;
			SimpleDateFormat sdfin = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
			String temp_start_time = "";
			String temp_end_time = "";
			try
			{
				String sDate = request.getParameter("starttime");
				if(!DateUtil.isDate(sDate,"MM/dd/yyyy"))
				{
					sDate = DateUtil.changeDateFormat(sDate,userFormat,"MM/dd/yyyy");
				}

				String eDate = request.getParameter("endtime");
				if(!DateUtil.isDate(eDate,"MM/dd/yyyy"))
				{
					eDate = DateUtil.changeDateFormat(eDate,userFormat,"MM/dd/yyyy");
				}
				
				if(timeline.equalsIgnoreCase("Any")){

				temp_start_time = startDate + " " + startHour+":00";
				temp_end_time = endDate + " " + endHour+":00";
				}else
				{
				temp_start_time = sDate + " " + request.getParameter("starthr")+":00";
				temp_end_time = eDate + " " + request.getParameter("endhr")+":00";
				}
				s_gformat = HighChartTimeline.getChartOption(tline,currentDateFormat,temp_start_time,temp_end_time);
			}
			catch(Exception e)
			{
				System.out.println("Exception  :"+e);
				e.printStackTrace();
			}
		}
		else
			s_gformat = "graph";
		//End
		if(info!=null && info.equals(""))
			info="*";
		if(!come_from_vmware && !come_from_cview)
		{
			if(info!=null && minMaxAvgDisplay!=null && !minMaxAvgDisplay.equalsIgnoreCase("none"))
			{
				if(info!=null && info.trim().length()>0)
				{
					info=com.egurkha.util.StringUtils.replace(info,"|plus|","+");
					info=com.egurkha.util.StringUtils.replace(info,"|amp|","&");
					info=com.egurkha.util.StringUtils.replace(info,"|pct|","%");
					info=com.egurkha.util.StringUtils.decodeSecurityChar(info);
				}
				StringTokenizer st=new StringTokenizer(info,",");
				if(st.hasMoreTokens())
				{
					String infoStr=st.nextToken();
					Hashtable avgMinMaxData=measureGraphInfo.getAvgMaxMinData(measure,test,hostName,portNo,site,test,com.egurkha.util.StringUtils.replace(infoStr,"|plus|","+"),startDate,endDate,msmtHost,compType,timeline,startHour+"",endHour+"","","",u_ser);
					if(avgMinMaxData==null || avgMinMaxData.size()==0)
					{
						minMaxAvgDisplay="none";
					}
				}
			}
		}
		// first row where minimize icon is place on extreme right 
		JSONObject graphLabels = new JSONObject();
		graphLabels.put("GraphHeader",mappingInfo.getTextDescription("monitor.Common.Graph"));
		graphLabels.put("minimizeIconImage","/final/monitor/eg_images/"+monitor_Skin+"/icon_minimize_div.png");
		
		json.put("graphLabels",graphLabels);
		JSONArray graphFilters = new JSONArray();
		
		if(graphType!=null && (graphType.equalsIgnoreCase("analysisBargraph") || graphType.equalsIgnoreCase("ComparisionGraph")))
		{
			//priority combo
			JSONObject prioritySelect = new JSONObject();
			JSONArray priorityOptionsArray = new JSONArray();
			prioritySelect.put("type","combo");
			prioritySelect.put("combo","timeline");
			prioritySelect.put("label",mappingInfo.getTextDescription("monitor.common.Show"));	
			priorityOptionsArray.add(erUtils.fillSelectBox(v_priority,"",priority));
			prioritySelect.put("options",priorityOptionsArray);

			graphFilters.add(prioritySelect);
		}
		else
		{
			//timeline div display at left 
		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("Trendgraph") || graphType.equalsIgnoreCase("Summarygraph")))
		{
			//duration combo display
			JSONObject durationSelect = new JSONObject();
			JSONArray durationOptionsArray = new JSONArray();
			String selectedDuration = "";
			durationSelect.put("type","combo");
			durationSelect.put("combo","duration");
			durationSelect.put("label",mappingInfo.getTextDescription("monitor.dashboard.Duration"));	

			String hourly="";
			String daily="";
			String monthly="";

			if(duration!=null && duration.equalsIgnoreCase("H")){
				hourly="selected";
				selectedDuration = "H";
				}

			if(duration!=null && duration.equalsIgnoreCase("D")){
				daily="selected";
				selectedDuration = "D";	
			}
			if(duration!=null && duration.equalsIgnoreCase("M")){
				monthly="selected";
				selectedDuration = "M";
			}
			JSONObject durationOurly = new JSONObject();
			durationOurly.put("text",mappingInfo.getTextDescription("monitor.common.Hourly"));
			durationOurly.put("value","H");
			
			JSONObject durationDaily = new JSONObject();
			durationDaily.put("text",mappingInfo.getTextDescription("monitor.common.Daily"));
			durationDaily.put("value","D");
			
			JSONObject durationMonthly = new JSONObject();
			durationMonthly.put("text",mappingInfo.getTextDescription("monitor.common.Monthly"));
			durationMonthly.put("value","M");
			
			durationOptionsArray.add(durationOurly);
			durationOptionsArray.add(durationDaily);
			durationOptionsArray.add(durationMonthly);
			durationSelect.put("options",durationOptionsArray);
			durationSelect.put("selectedValue",selectedDuration);			
			graphFilters.add(durationSelect);
		}
//			timeLine combo
		JSONObject timelineSelect = new JSONObject();
		JSONArray timelineOptionsArray = new JSONArray();
		String selectedTimeline = "";
		timelineSelect.put("display",display);
		timelineSelect.put("type","combo");
		timelineSelect.put("combo","timeline");
		timelineSelect.put("label",mappingInfo.getTextDescription("monitor.dashboard.TimeLine"));
		if(StringUtils.isNull(timeline) || timeline.equals("Fixed"))
			selectedTimeline = "1 hour";
		for(int e_ctr=0; e_ctr < options.length;e_ctr++)
		{
			JSONObject timelineOptionObject = new JSONObject();
			if(timeline!=null && timeline.equals((String)options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
				
				timelineOptionObject.put("text",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineOptionObject.put("value",timeline);
				selectedTimeline=timeline;
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" "; tempOptions=options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=options[e_ctr];
				}
				timelineOptionObject.put("text",tempOptions2+mappingInfo.getTextDescription("monitor.common."+tempOptions));
				timelineOptionObject.put("value",options[e_ctr]);
			}
			timelineOptionsArray.add(timelineOptionObject);
		}
		timelineSelect.put("options",timelineOptionsArray);
		timelineSelect.put("selectedValue",selectedTimeline);
		graphFilters.add(timelineSelect);
	// from date combo
		JSONObject fromDate = new JSONObject();
		fromDate.put("type","date");
		fromDate.put("combo","from");
		fromDate.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.From"));
		fromDate.put("dateError",mappingInfo.getTextDescription("monitor.layermodel.Start date should be lesser than end date"));
		String start_hour = String.valueOf(startHour);
		String end_hour = String.valueOf(endHour);
		String start_min = null;
		String end_min=null;
		if(timeline!=null && timeline.equalsIgnoreCase("any") && come_from_vmware)
		{
			fromDate.put("enabled","true");
			startDateForDisplay =  request.getParameter("starttime");
			startHourForDisplay =request.getParameter("starthr");
			startMinForDisplay = request.getParameter("startmin");
			if(start_hour.length() == 1)
				start_hour = "0"+start_hour;

			endDateForDisplay = request.getParameter("endtime");
			endHourForDisplay = request.getParameter("endhr");
			endMinForDisplay = request.getParameter("endmin");
			if(end_hour.length() == 1)
				end_hour = "0"+end_hour;
		}
		else
		{
			if(timeline!=null && (timeline.equalsIgnoreCase("any") || timeline.equalsIgnoreCase("Fixed")))
			{
				fromDate.put("enabled","true");
			}
			else
			{
				fromDate.put("enabled","false");
			}
			
			try
			{
				if(startDate!=null && !startDate.equals(""))
				{
					if(DateUtil.isDate(startDate,"MM/dd/yyyy"))
					{
						comFormat = "MM/dd/yyyy";
					}
					else
					{
						comFormat = currentDateFormat;
					}
					//startDate = DateUtil.changeDateFormat(startDate,comFormat,currentDateFormat);
					startDate = DateUtil.changeDateFormat(startDate,comFormat,"MM/dd/yyyy");
					dispDate = DateUtil.changeDateFormat(startDate,comFormat,currentDateFormat);

					timeZoneConverterStart = new EgTimeZoneConverter(dispDate+" "+startHour+":"+startMin+":"+"00",user);
					startDateForDisplay = (String) timeZoneConverterStart.getDate(false);
					startHourForDisplay = timeZoneConverterStart.getHour();
					startMinForDisplay = timeZoneConverterStart.getMinute();
					dispDate = DateUtil.changeDateFormat(endDate,comFormat,currentDateFormat);

					timeZoneConverterEnd = new EgTimeZoneConverter(dispDate+" "+endHour+":"+endMin+":"+"00",user);
					endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
					endHourForDisplay = timeZoneConverterEnd.getHour();
					endMinForDisplay = timeZoneConverterEnd.getMinute();
				}
				else
				{
					dispDate = "";
				}
			}
			catch(Exception ex)
			{
				out.println("ex..."+ex);
			}
		}

		fromDate.put("format",userFormat);
		fromDate.put("dispDate_h",dispDate);
		fromDate.put("dispDate",startDateForDisplay);
		fromDate.put("actualDate",startDate);
		fromDate.put("readOnly",disable);
		graphFilters.add(fromDate);

		//hr combo
		JSONObject hrSelect = new JSONObject();
		JSONArray hrOptionsArray = new JSONArray();
		hrSelect.put("type","combo");
		hrSelect.put("combo","fromhr");
		hrSelect.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.Hr"));
		hrSelect.put("enabled",disable);

		int selectedValueHr = 0;
		for(int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			JSONObject hrSelectOptions = new JSONObject();
			//if(s_ctr == startHour)
			if(s_ctr == Integer.parseInt(startHourForDisplay))
			{
				hrSelectOptions.put("value",s_ctr);
				hrSelectOptions.put("text",s_ctr);
				selectedValueHr = s_ctr;
			}
			else
			{
				hrSelectOptions.put("value",s_ctr);
				hrSelectOptions.put("text",s_ctr);
			}
			hrOptionsArray.add(hrSelectOptions);
		}
			hrSelect.put("options",hrOptionsArray);
			hrSelect.put("actualHr",start_hour);
			hrSelect.put("selectedValue_h",selectedValueHr);
			hrSelect.put("selectedValue",startHourForDisplay);
			graphFilters.add(hrSelect);

	 	JSONObject minSelect = new JSONObject();
				JSONArray minOptionsArray = new JSONArray();
				minSelect.put("type","combo");
				minSelect.put("combo","frommin");
				minSelect.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.Min"));
				minSelect.put("enabled",disable);

		int selectedValueMin = 0;
		for(int s_ctr = 0; s_ctr < 60; s_ctr++)
		{
			JSONObject minSelectOptions = new JSONObject();
			//if(s_ctr == startHour)
			if(s_ctr == Integer.parseInt(startMinForDisplay))
			{
				minSelectOptions.put("value",s_ctr);
				minSelectOptions.put("text",s_ctr);
				selectedValueMin = s_ctr;
			}
			else
			{
				minSelectOptions.put("value",s_ctr);
				minSelectOptions.put("text",s_ctr);
			}
			minOptionsArray.add(minSelectOptions);
		}
			minSelect.put("options",minOptionsArray);
			minSelect.put("actualMin",start_min);
			minSelect.put("selectedValue_m",selectedValueMin);
			minSelect.put("selectedValue",startMinForDisplay);
			graphFilters.add(minSelect);

			JSONObject toDate = new JSONObject();
			toDate.put("type","date");
			toDate.put("combo","to");
			toDate.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.To"));
		if(timeline!=null && timeline.equalsIgnoreCase("any") && come_from_vmware)
		{
			fromDate.put("enabled","true");
 			if(end_hour.length() == 1)
				end_hour = "0"+end_hour;
		}
		else
		{
			if(timeline!=null && (timeline.equalsIgnoreCase("any") || timeline.equalsIgnoreCase("Fixed")))
			{
				toDate.put("enabled","true");
			}
			else
			{
				toDate.put("enabled","true");
			}

			try
			{
				if(endDate!=null && !endDate.equals(""))
				{
					if(DateUtil.isDate(endDate,"MM/dd/yyyy"))
					{
						comFormat = "MM/dd/yyyy";
					}
					else
					{
						comFormat = currentDateFormat;
					}
					dispDate = DateUtil.changeDateFormat(endDate,comFormat,currentDateFormat);

					timeZoneConverterEnd = new EgTimeZoneConverter(dispDate+" "+endHour+":"+endMin+":"+"00",user);
					endDateForDisplay = (String) timeZoneConverterEnd.getDate(false);
					endHourForDisplay = timeZoneConverterEnd.getHour();
					endMinForDisplay = timeZoneConverterEnd.getMinute();
				}
				else
				{
					dispDate = "";
				}
			}
			catch(Exception ex)
			{
				out.println("exception......"+ex);
			}
		}
		toDate.put("format",userFormat);
		toDate.put("dispDate_h",dispDate);
		toDate.put("dispDate",endDateForDisplay);
		toDate.put("actualDate",endDate);
		toDate.put("readOnly",disable);
		graphFilters.add(toDate);
	//to date hr combo
		JSONObject ToHrSelect = new JSONObject();
		JSONArray TohrOptionsArray = new JSONArray();
		ToHrSelect.put("type","combo");
		ToHrSelect.put("combo","tohr");
		ToHrSelect.put("actualHr",end_hour);
		ToHrSelect.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.Hr"));
		ToHrSelect.put("enabled",disable);
		int toSelectedValue=0;

		for(int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			JSONObject hrSelectOptions = new JSONObject();
			//if(e_ctr == endHour)
			if(e_ctr == Integer.parseInt(endHourForDisplay))
			{
				hrSelectOptions.put("value",e_ctr);
				hrSelectOptions.put("text",e_ctr);
				toSelectedValue = e_ctr;
			}
			else
			{
				hrSelectOptions.put("value",e_ctr);
				hrSelectOptions.put("text",e_ctr);
			}
			TohrOptionsArray.add(hrSelectOptions);
		}
		ToHrSelect.put("options",hrOptionsArray);
		ToHrSelect.put("selectedValue_h",toSelectedValue);
		ToHrSelect.put("selectedValue",endHourForDisplay);
		graphFilters.add(ToHrSelect);


		JSONObject tominSelect = new JSONObject();
		JSONArray tominOptionsArray = new JSONArray();
		tominSelect.put("type","combo");
		tominSelect.put("combo","tomin");
		tominSelect.put("label",mappingInfo.getTextDescription("monitor.VirtualDashboard.Min"));
		tominSelect.put("enabled",disable);

		int selectedValueToMin = 0;
		for(int s_ctr = 0; s_ctr < 60; s_ctr++)
		{
			JSONObject tominSelectOptions = new JSONObject();
			//if(s_ctr == startHour)
			if(s_ctr == Integer.parseInt(startMinForDisplay))
			{
				tominSelectOptions.put("value",s_ctr);
				tominSelectOptions.put("text",s_ctr);
				selectedValueToMin = s_ctr;
			}
			else
			{
				tominSelectOptions.put("value",s_ctr);
				tominSelectOptions.put("text",s_ctr);
			}
			tominOptionsArray.add(tominSelectOptions);
		}
			tominSelect.put("options",tominOptionsArray);
			tominSelect.put("actualMin",start_min);
			tominSelect.put("selectedValue_m",selectedValueToMin);
			tominSelect.put("selectedValue",startMinForDisplay);
			graphFilters.add(tominSelect);


	 //


		//mode combo

		JSONObject modeSelect = new JSONObject();
		modeSelect.put("type","combo");
		modeSelect.put("combo","mode");
		modeSelect.put("enabled",disable);
		
		String visiblity="hidden";
		if(graphType!=null && (graphType.equalsIgnoreCase("Measuregraph") || graphType.equalsIgnoreCase("analysisMeasuregraph")))
			 visiblity="visible";
		if(come_from_vmware || come_from_trans)
		{
			modeSelect.put("visibility","visible");
		}
		else
		{
			modeSelect.put("visibility",visiblity);
		}
		JSONObject modeSelect2D = new JSONObject();
		JSONObject modeSelect3D = new JSONObject();
		JSONArray modeOptionsArray = new JSONArray();
		modeSelect2D.put("value","2D");
		modeSelect2D.put("text",mappingInfo.getTextDescription("monitor.common.2D"));
		modeSelect3D.put("value","3D");
		modeSelect3D.put("text",mappingInfo.getTextDescription("monitor.common.3D"));
		String selectedMode = "";
		if(mode!=null && mode.equalsIgnoreCase("3D"))
		{
			selectedMode = "3D";
		}
		else
		{
			selectedMode = "2D";
		}
		modeOptionsArray.add(modeSelect2D);
		modeOptionsArray.add(modeSelect3D);
		modeSelect.put("options",modeOptionsArray);
		modeSelect.put("selectedValue",selectedMode);
		graphFilters.add(modeSelect);
		//Image if  timeline is any
		JSONObject anyImage = new JSONObject();
		if(timeline != null && (timeline.equals("Any") || timeline.equalsIgnoreCase("Fixed")))
		{
			anyImage.put("type","image");
			anyImage.put("imageSrc","/final/admin/eg_images/"+monitor_Skin+"/arrow_1.gif");
			graphFilters.add(anyImage);
		}
		if(graphType!=null && (graphType.equalsIgnoreCase("Measuregraph") || graphType.equalsIgnoreCase("analysisMeasuregraph")))
		{
			// priority combo
			JSONObject priorityVMSelect = new JSONObject();
			JSONArray priorityVMOptionsArray = new JSONArray();
			priorityVMSelect.put("type","combo");
			if(come_from_vmware)
			{
				priorityVMSelect.put("combo","priorityVM");
			}
			else
			{
				priorityVMSelect.put("combo","priority");
			}
			priorityVMSelect.put("enabled",disable);
			priorityVMSelect.put("label",mappingInfo.getTextDescription("monitor.common.Show"));

			if(come_from_vmware)
			{
				priorityVMSelect.put("come_from_vmware","true");	
			}
			else
			{
				priorityVMSelect.put("come_from_vmware","false");	
			}

			for(int k=0;k<v_priority.size();k++)
			{
				String pri=(String)v_priority.get(k);
				JSONObject priorityVMOptionsObj = new JSONObject();
				priorityVMOptionsObj.put("value",pri);
				priorityVMOptionsObj.put("text",pri);
				priorityVMOptionsArray.add(priorityVMOptionsObj);
			}
			///priorityVMSelect.put("options",erUtils.fillSelectBox(v_priority,"",priority));
			priorityVMSelect.put("options",priorityVMOptionsArray);
			priorityVMSelect.put("selectedValue",priority);
			graphFilters.add(priorityVMSelect);
		}
		JSONObject showLegendObj = new JSONObject();
		showLegendObj.put("type","check");
		graphFilters.add(showLegendObj);
		
		if((graphType!=null) && (graphType.equalsIgnoreCase("ddGraph") || graphType.equalsIgnoreCase("DDOverviewGraph")))
		{
			//diagnosis image in anchor tag
			JSONObject diagnosis = new JSONObject();
			diagnosis.put("type","anchor");
			diagnosis.put("anchor","diagnosis");
			diagnosis.put("imgSrc","/final/monitor/eg_images/Diagnosis-o.gif");
			diagnosis.put("label",mappingInfo.getTextDescription("monitor.common.DIAGNOSIS"));
			graphFilters.add(diagnosis);
		}
		if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
			// combo if graph type is trendgraph  
			JSONObject trendSelect = new JSONObject();
			JSONArray trendOptionsArray = new JSONArray();
			String selectedTrend = "";
			trendSelect.put("type","combo");
			trendSelect.put("combo","trendGraph");
			trendSelect.put("label",mappingInfo.getTextDescription("monitor.dashboard.Graph"));

			String minmax="";
			String avg="";
			String sum="";

			if(trendType!=null && trendType.equalsIgnoreCase("avg")){
				avg="selected";
				selectedTrend = "avg";
			}
			else if(trendType!=null && trendType.equalsIgnoreCase("sum")){
				sum="selected";
				selectedTrend = "sum";
			}
			else{
				minmax="selected";
				selectedTrend = "min/max";
				}
			
			JSONObject trendMin = new JSONObject();
			trendMin.put("text",mappingInfo.getTextDescription("monitor.dashboard.Min"));
			trendMin.put("value","min/max");
			
			JSONObject trendAvg = new JSONObject();
			trendAvg.put("text",mappingInfo.getTextDescription("monitor.common.Avg"));
			trendAvg.put("value","avg");
			
			JSONObject trendSum = new JSONObject();
			trendSum.put("text",mappingInfo.getTextDescription("monitor.common.Sum"));
			trendSum.put("value","sum");
			
			trendOptionsArray.add(trendMin);
			trendOptionsArray.add(trendAvg);
			trendOptionsArray.add(trendSum);
			trendSelect.put("options",trendOptionsArray);
			trendSelect.put("selectedValue",trendSelect);
			graphFilters.add(trendSelect);
		}

		json.put("graphFilters",graphFilters);
		JSONObject showLegendParam = new JSONObject();
		if(showLegStr == null || showLegStr.equals(""))
		{
			showLegStr = egUI.getValue("CHART_TYPE","showLegendsInCharts");
			
		}

		json.put("showLegend",showLegStr.toLowerCase());
		String LegendInChart = egUI.getValue("CHART_TYPE","LegendInChart");
		LegendInChart = (LegendInChart == null || LegendInChart.equals(""))?"false":LegendInChart;
		json.put("LegendInChart",LegendInChart);
		json.put("isFusionChart",new Boolean( isFusionChart ));
		if(graphType!=null && graphType.equalsIgnoreCase("analysisBargraph"))
		{
			JSONObject analysisBargraph = new JSONObject();
			
			analysisBargraph.put("combo","trendGraph");
			analysisBargraph.put("label",mappingInfo.getTextDescription("monitor.dashboard.Graph"));

			if(displayName!=null && displayName.trim().length()>0)
			{
				analysisBargraph.put("displayName",egMappingInfo.getTextDescription("monitor.dashboard."+displayName));
			}
			else
			{
				analysisBargraph.put("displayName",test+":"+real_measure);			
			}

			boolean is_convert_MB_to_GB=false;
			String str_convert_MB_to_GB=iniObj.getValue("Display_Analysis","convert_MB_to_GB");
			if(str_convert_MB_to_GB!=null && str_convert_MB_to_GB.equalsIgnoreCase("yes"))
			{
				is_convert_MB_to_GB=true;
			}
			String unit_for_measure=tablesInfo.getUnitForMeasure(test,real_measure);
			if(unit_for_measure!=null && unit_for_measure.equals("MB") && is_convert_MB_to_GB)
			{
				unit_for_measure="GB";
			}
			analysisBargraph.put("unitForMeasure",unit_for_measure);

			json.put("analysisBargraph",analysisBargraph);
		}

		String fullviewGraphUrl="";
		String fullviewDataUrl="";
		if(come_from_vmware && graphType!=null && graphType.equalsIgnoreCase("Measuregraph"))
		{
			String layer_name=request.getParameter("layer");
			if(info!=null && (info.equalsIgnoreCase("*") || info.equalsIgnoreCase("+*") || info.equalsIgnoreCase("+")))
				info="";
			if(timeline.equalsIgnoreCase("any") && come_from_vmware)
			{



				fullviewGraphUrl="/final/servlet/com.egurkha.VmwareTimelineMeasures?endtime="+request.getParameter("endtime")+"&port="+portNo+"&site=NULL&sid=&starttime="+request.getParameter("starttime")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+request.getParameter("endhr")+"&gtype=1&mode="+mode+"&starthr="+request.getParameter("starthr")+"&min="+request.getParameter("startmin")+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&scrW="+graphWidth+"&scrH="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&showLegend="+showLegStr+Qstring;
				fullviewDataUrl="EgMeasureGraphData.jsp?endtime="+request.getParameter("endtime")+"&port="+portNo+"&site=NULL&sid=&starttime="+request.getParameter("starttime")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+request.getParameter("endhr")+"&gtype=1&mode="+mode+"&starthr="+request.getParameter("starthr")+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&showLegend="+showLegStr+Qstring;
			}
			else{
				

				fullviewGraphUrl="/final/servlet/com.egurkha.VmwareTimelineMeasures?endtime="+endDate+"&port="+portNo+"&site=NULL&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&min="+startMin+"&startmin="+startMin+"&endmin="+endMin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&scrW="+graphWidth+"&scrH="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&showLegend="+showLegStr+Qstring;
				fullviewDataUrl="EgMeasureGraphData.jsp?endtime="+endDate+"&port="+portNo+"&site=NULL&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&startmin="+startMin+"&endmin="+endMin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&showLegend="+showLegStr+Qstring;
			}
		}
		else
		{

			int count_infos=0;
			if(info!=null && info.trim().length()>0)
			{
				info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");
				info=com.egurkha.util.StringUtils.replace(info,"&","|amp|");
				info=com.egurkha.util.StringUtils.replace(info,"%","|pct|");
				StringTokenizer stt=new StringTokenizer(info,",");
				count_infos=stt.countTokens();
			}
			String priority_value=priority;
			if(priority!=null && priority.equalsIgnoreCase("ALL"))
				priority_value="TOP+-+"+count_infos;
			fullviewGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endDate+"&port="+portNo+"&site=NULL&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer=HOST&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&startmin="+startMin+"&endmin="+endMin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority_value+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&fullView=true&isVM="+isVM+"&showLegend="+showLegStr;
		}

		if(graphType!=null && graphType.equalsIgnoreCase("analysisMeasuregraph"))
		{
			int count_infos=0;
			if(info!=null && info.trim().length()>0)
			{
				info=com.egurkha.util.StringUtils.replace(info,"+","|plus|");
				info=com.egurkha.util.StringUtils.replace(info,"&","|amp|");
				info=com.egurkha.util.StringUtils.replace(info,"%","|pct|");
				StringTokenizer stt=new StringTokenizer(info,",");
				count_infos=stt.countTokens();
			}
			String priority_value=priority;
			if(priority!=null && priority.equalsIgnoreCase("ALL"))
				priority_value="TOP+-+"+count_infos;
			fullviewGraphUrl="/final/servlet/com.egurkha.monitor.DashboardTimelineMeasures?endtime="+endDate+"&port=NULL&site=NULL&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer=HOST&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&startmin="+startMin+"&endmin="+endMin+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority_value+"&threshold=no&minmaxavgRequired=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&fullView=true&isVM="+isVM+"&showLegend="+showLegStr;
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("analysisBargraph"))
		{
			fullviewGraphUrl="/final/servlet/com.egurkha.monitor.DDTopview?host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&module="+module+"&width="+graphWidth+"&height="+(graphHeight-40)+"&from=fullview&mode="+mode+"&monitorSkin="+monitor_Skin+"&graphdisplay=defaultView&fullview=true&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&port="+request.getParameter("port")+"&isFromAnalysis=true&layer="+request.getParameter("layer")+"&starttime="+startDate+"&starthr="+startHour+"&startmin="+today.getMinutes()+"&endtime="+endDate+"&endhr="+endHour+"&endmin="+today.getMinutes()+"&timeline="+timeline+"&displayName="+displayName+"&real_measure="+real_measure+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&isInfoSelected="+request.getParameter("isInfoSelected")+"&priority="+priority+"&display=true&isTimeout="+isTimeout+"&applyFusion="+applyFusion;
			if(!isTimelineRequired)
			{
				fullviewGraphUrl=fullviewGraphUrl+"&isTimelineRequired=yes";
			}
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("ddGraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.DDTopview?")+"host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&format="+EgURLEncoder.encode(format,"UTF-8")+"&module="+module+"&width="+graphWidth+"&height="+(graphHeight-40)+"&endtime="+endDate+"&starthr="+startHour+"&endhr="+endHour+"&starttime="+startDate+"&startmin="+today.getMinutes()+"&endmin="+today.getMinutes()+"&mode="+mode+"&monitorSkin="+monitor_Skin+"&showDDData=true&graphdisplay=defaultView&from=fullview&fullview=true&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&priority="+priority;
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Summarygraph"))
		{
			fullviewGraphUrl="/final/servlet/com.egurkha.monitor.EgDashboardSummaryGraph?endtime="+endDate+"&port="+portNo+"&site=NULL&starttime="+startDate+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&test="+test+"&state=GOOD&layer=HOST&comptype="+compType+"&endhr="+endHour+"&gtype=1&mode="+mode+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&starthr="+startHour+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&monitorSkin="+monitor_Skin+"&period="+duration+"&width="+graphWidth+"&height="+(graphHeight-40)+"&timeLine=3+hours&fullview=true";
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
		{
			fullviewGraphUrl="/final/servlet/com.egurkha.monitor.DDOverviewLineChart?host="+EgURLEncoder.encode(hostName,"UTF-8")+"&comptype="+compType+"&test="+test+"&measure="+measure+"&ddformat="+ddformat+"&module="+module+"&starttime="+startDate+"&starthr="+startHour+"&endtime="+endDate+"&endhr="+endHour+"&width="+graphWidth+"&height="+(graphHeight-40)+"&startMin="+today.getMinutes()+"&endMin="+today.getMinutes()+"&monitorSkin="+monitor_Skin+"&mode="+mode+"&AggregateGraphs="+AggregateGraphs+"&info="+EgURLEncoder.encode(info,"UTF-8")+"&from_page="+from_page+"&gType=fullImage";
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
			if(trendType!=null && trendType.equalsIgnoreCase("Avg"))
				fullviewGraphUrl="/final/servlet/com.eg.AvgTrendGraph?site=-1&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&layer=HOST&test="+test+"&port="+portNo+"&info="+com.egurkha.util.StringUtils.replace(info,"|plus|","")+"&gtype=0&draw=1&starttime="+startDate+"&mode="+mode+"&time="+timeline+"&endtime="+endDate+"&starthr="+startHour+"&endhr="+endHour+"&comptype="+compType+"&measure="+measure+"&monitorSkin="+monitor_Skin+"&period="+duration+"&qctr=5&stest=SystemTest-*Summary&search=&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comp="+compType+":"+EgURLEncoder.encode(hostName,"UTF-8")+":"+portNo+"&graphmode=avg&requestFrom=Avg&fromDashboard=true";

			else if(trendType!=null && trendType.equalsIgnoreCase("sum"))
				fullviewGraphUrl="/final/servlet/com.eg.AvgTrendGraph?site=-1&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&layer=HOST&test="+test+"&port="+portNo+"&info="+com.egurkha.util.StringUtils.replace(info,"|plus|","")+"&gtype=0&draw=1&starttime="+startDate+"&mode="+mode+"&time="+timeline+"&endtime="+endDate+"&starthr="+startHour+"&endhr="+endHour+"&comptype="+compType+"&measure="+measure+"&monitorSkin="+monitor_Skin+"&period="+duration+"&qctr=5&stest=SystemTest-*Summary&search=&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comp="+compType+":"+EgURLEncoder.encode(hostName,"UTF-8")+":"+portNo+"&graphmode=sum&&requestFrom=Sum&fromDashboard=true";
			else
				fullviewGraphUrl="/final/servlet/com.egurkha.monitor.EgDashboardTrendGraph?site=-1&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&layer=HOST&test="+test+"&port="+portNo+"&info="+com.egurkha.util.StringUtils.replace(info,"|plus|","")+"&gtype=0&draw=1&starttime="+startDate+"&mode="+mode+"&time="+timeline+"&endtime="+endDate+"&starthr="+startHour+"&endhr="+endHour+"&comptype="+compType+"&measure="+measure+"&monitorSkin="+monitor_Skin+"&period="+duration+"&qctr=5&stest=SystemTest-*Summary&search=&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comp="+compType+":"+EgURLEncoder.encode(hostName,"UTF-8")+":"+portNo+"&graphmode=minmax&fromDashboard=true&width="+graphWidth+"&height="+(graphHeight-40)+"&fullview=true";
		}
		// ******* for Transaction page *******
		else if(graphType!=null && graphType.equalsIgnoreCase("TransactionGraph"))
		{

			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.TransactionMeasures?")+"site="+EgURLEncoder.encode(site,"UTF-8")+"&comp="+EgURLEncoder.encode(comp_name,"UTF-8")+"&test="+test+"&measure="+measure+"&starttime="+request.getParameter("starttime")+"&starthr="+request.getParameter("starthr")+"&endtime="+request.getParameter("endtime")+"&endhr="+request.getParameter("endhr")+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&time_line="+timeline+"&all_trans_names="+EgURLEncoder.encode(all_trans_names,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&mode="+mode+"&monitorSkin="+monitor_Skin+"&gformat=graph&GraphSize=true&isZoomGraph="+isZoomGraph+"&graphId="+graphId+"&treeOpen="+treeOpen+"&showLegend="+showLegStr;
		}
		// ******* end *******
		String unit_val=tablesInfo.getUnitForMeasure(test,measure);
		if(measure!=null && measure.equals("Percent_busy"))
		{
			unit_val="Bytes/sec";
		}
		//String host=egMappingInfo.getComponentTypeDescription(hostName);
		String host=hostName;
		if(host!=null && host.length()>0)
		{
			if(host.indexOf(":")>-1)
			{
				host=host.substring(0,host.indexOf(":"));
			}
		}
		String vmNameStr=request.getParameter("info");
		vmNameStr=(vmNameStr==null)?"":vmNameStr;
		String caption="Component:"+host+" Test:"+egMappingInfo.getTestDescription(test)+" Measure :"+egMappingInfo.getMeasureDescription(test,measure)+"("+EgURLEncoder.encode(unit_val, "UTF-8")+")";
		String barCaption="VM Name:"+vmNameStr+" Test:"+egMappingInfo.getTestDescription(test)+" Measure :"+egMappingInfo.getMeasureDescription(test,measure)+"("+unit_val+")";
		if(graphType!=null && graphType.equalsIgnoreCase("ddGraph"))
		{
			String chartTypeStr = ( isFusionChart )?"fusionchart":"barhighchart";
			Vector ddChartAttribute=new Vector();
			ddChartAttribute.add("palette='1'");
			ddChartAttribute.add("caption='"+caption+"'");
			ddChartAttribute.add("showValues='1'");
			ddChartAttribute.add("decimals='4'");
			ddChartAttribute.add("formatNumberScale='0'");
			ddChartAttribute.add("exportEnabled='0'");
			ddChartAttribute.add("exportAction='download'");
			ddChartAttribute.add("exportAtClient='0'");					ddChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			ddChartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
			ddChartAttribute.add("useRoundEdges='1'");
			ddChartAttribute.add("showExportDialog='1'");
			//ddChartAttribute.add("exportAction='save'");
			ddChartAttribute.add("exportTargetWindow='1'");
			ddChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");
			ddChartAttribute.add("yAxisValueDecimals='2'");
			ddChartAttribute.add("canvasRightMargin='50'");
			String startMins=Integer.toString(today.getMinutes());
			String endMins=Integer.toString(today.getMinutes());
			format=com.egurkha.util.StringUtils.replace(format,"|pct|","%");
			String ddXMLData=fusionChart.getXMLforDD(module,hostName,compType,test,measure,startDate,startHour+"",startMins+"",endDate,endHour+"",endMins+"",format,null,false,priority,ddChartAttribute,info);
			if( isFusionChart )
				ddXMLData=com.egurkha.util.StringUtils.replace(ddXMLData,"\"","");

			JSONObject graphImageObject = new JSONObject();
			if(ddXMLData!=null && ddXMLData.trim().length()>0)
			{
				graphImageObject.put("divId","chartBar2DContainer");
				graphImageObject.put("fcId","myMaxBar2DChartId");
				graphImageObject.put("dataXML",ddXMLData);
				graphImageObject.put("graphWidth",graphWidth);
				graphImageObject.put("graphHeight",graphHeight);
				graphImageObject.put("movie","/final/FusionCharts/swf/Bar2D.swf");
				graphImageObject.put("wmodeSrc","/final/FusionCharts/swf/Bar2D.swf");
				graphImageObject.put("pluginspage","http://www.macromedia.com/go/getflashplayer");
				graphImageObject.put("title",barCaption);
			}
			else
			{
				graphImageObject.put("NoMeasuresImg","/final/images/"+monitor_Skin+"/nomeasures_custom.png");
				graphImageObject.put("ErrorMessage",mappingInfo.getTextDescription("monitor.summary.No measures available"));
			}
			JSONObject graphImage = new JSONObject();
			graphImage.put("imageSrc",fullviewGraphUrl);
			graphImage.put("chartType","fusionchart");
			graphImage.put("zoomGraphType",chartTypeStr);
			json.put("graphImage",graphImage);
			json.put("graphImageObject",graphImageObject);
		}
		else if(graphType!=null && (minMaxAvgDisplay!=null && !minMaxAvgDisplay.equalsIgnoreCase("none") && graphType.equalsIgnoreCase("Measuregraph")) || (graphType!=null && !graphType.equalsIgnoreCase("Measuregraph")))
		{
			JSONObject graphImage = new JSONObject();

			if(isApplyFusion && graphType!=null && graphType.equalsIgnoreCase("analysisBargraph"))
			{
				graphImage.put("iframeSrc",fullviewGraphUrl);
				graphImage.put("graphWidth",graphWidth);
				graphImage.put("graphHeight",graphHeight);
				graphImage.put("chartType","fcURL");
				
			}
			else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
			{
				graphImage.put("imageSrc",fullviewGraphUrl);
				graphImage.put("graphWidth",graphWidth);
				graphImage.put("graphHeight",graphHeight);
				graphImage.put("chartType","easychart");
			}
			else
			{
				graphImage.put("imageSrc",fullviewGraphUrl);
				graphImage.put("graphWidth",graphWidth);
				graphImage.put("graphHeight",graphHeight);
				graphImage.put("chartType",s_gformat);
			}
			json.put("graphImage",graphImage);
			if( !isFusionChart )
					json.put("isFusionChart",isFusionChart);
		}
		else
		{
			JSONObject graphImage = new JSONObject();
			JSONObject NoMeasuresObject = new JSONObject();
			NoMeasuresObject.put("NoMeasuresImg","/final/images/"+monitor_Skin+"/nomeasures_custom.png");
			NoMeasuresObject.put("ErrorMessage",mappingInfo.getTextDescription("monitor.summary.No measures available!"));
			graphImage.put("chartType","highchart");
			json.put("graphImage",graphImage);
			json.put("NoMeasuresObject",NoMeasuresObject);
		}
		json.put("minMaxAvgDivDisplay",minMaxAvgDisplay);

		if(!come_from_vmware && minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true"))
		{
			JSONObject minMaxObject = new JSONObject();
			Hashtable allAvgMinMax=new Hashtable();
			TreeMap treeMap = new TreeMap();
			String measureForDisp=dbInfo.getMeasureForColumn(test,measure);
			String measureForDB=dbInfo.getColumnForMeasure(test,measureForDisp);
			String s_layer=dashBoardDAO.getLayerForTest(hostName,test,measureForDisp);

			Vector tempVec=new Vector();
			if(info!=null && info.trim().length()>0)
			{
				info=com.egurkha.util.StringUtils.replace(info,"|plus|","+");
				info=com.egurkha.util.StringUtils.replace(info,"|amp|","&");
				info=com.egurkha.util.StringUtils.replace(info,"|pct|","%");
				info=com.egurkha.util.StringUtils.replace(info,"|hash|","#");
			}

			StringTokenizer commaTokenizer = new StringTokenizer(info,",");
			while(commaTokenizer.hasMoreTokens())
			{
				String infoVal =commaTokenizer.nextToken();
				infoVal = infoVal.replace("*","+");

				Vector measureNames=egDashboard.getMeasurenamesFromInfo(hostName,portNo,"NULL",s_layer,test,infoVal,msmtHost);
				if(measureNames!=null && measureNames.contains(measureForDB))
					tempVec.add(infoVal);
			}
			site=(site==null || site.trim().length()==0)?"NULL":site;
			if(site!=null && site.equalsIgnoreCase("-1"))
				site="NULL";
			Vector infos=dashBoardDAO.getInfosbyUsage(priority,test,hostName,portNo,info,site,
			startDate+" "+startHour+":"+today.getMinutes()+":00",
			endDate+" "+endHour+":"+today.getMinutes()+":00",measure,msmtHost,tempVec);
			if(infos.size()==1 && (((String)infos.get(0)).equals("+Summary")))
				info="";
			
			HashMap colorMap=new HashMap();
			int inc=-1;
			int v_color_size=v_color.size();
			for(int k=0;k<infos.size();k++)
			{
				//colorMap.put(((String)infos.get(k)).substring(1),v_color.get(k));
				inc++;
				if(v_color_size<=inc)
				{
					inc=0;
					colorMap.put(((String)infos.get(k)).substring(1),v_color.get(inc));
				}
				else
				{
					colorMap.put(((String)infos.get(k)).substring(1),v_color.get(inc));
				}
			}
			if(infos!=null && infos.size()>0)
			{
				for(int m=0;m<infos.size();m++)
				{
					String infoStr = (String)infos.get(m);
					Hashtable avgMinMaxData=measureGraphInfo.getAvgMaxMinData(measure,test,hostName,portNo,site,test,com.egurkha.util.StringUtils.replace(infoStr,"|plus|","+"),startDate,endDate,msmtHost,compType,timeline,startHour+"",endHour+"","","",u_ser);
					
					Iterator itr=avgMinMaxData.keySet().iterator();

					while(itr.hasNext())
					{
						String key=(String)itr.next();
						ArrayList data=(ArrayList)avgMinMaxData.get(key);
						String value_of_data=(String)data.get(1);
						if(value_of_data!=null && value_of_data.equals("-"))
							value_of_data="0.0";
						Float temp_data = new Float(Float.parseFloat(value_of_data));
						
						if(data!=null && data.size()>=3)
						{
							infoStr=com.egurkha.util.StringUtils.replace(infoStr,"|plus|","");
							infoStr=com.egurkha.util.StringUtils.replace(infoStr,"+","");
							infoStr=com.egurkha.util.StringUtils.replace(infoStr,"*","");
							String dispMeasure="";
							if(isVM)
							{
								if(infoStr.indexOf(":") > -1)
								{
									String s_infoStr = infoStr.substring(0,infoStr.indexOf(":"));
									if(!userVMs.contains(s_infoStr))
									{
										continue;
									}
								}
								else
								{
									if(!userVMs.contains(infoStr))
									{
										continue;
									}
								}
							}
							if(info==null || info.trim().equals("") || info.trim().equals("*") || info.trim().equals("+"))
							{
								String measureForDisplay=dbInfo.getMeasureForColumn(test,measure);
								dispMeasure=test+"^"+measureForDisplay;
								colorMap.put(dispMeasure,v_color.get(0));
							}
							else
							{
								dispMeasure =infoStr;
							}
							if(treeMap.size() >= 1)
							{
								if(treeMap.containsKey(temp_data))
								{
									String val=(String)treeMap.get(temp_data);
									val=val+"~eg~"+dispMeasure+"|"+data.get(0)+"|"+data.get(1)+"|"+data.get(2);
									treeMap.put(temp_data,val);
								}
								else
								{
									treeMap.put(temp_data,dispMeasure+"|"+data.get(0)+"|"+data.get(1)+"|"+data.get(2));
								}
							}
							else
							{
								treeMap.put(temp_data,dispMeasure+"|"+data.get(0)+"|"+data.get(1)+"|"+data.get(2));
							}
						}
					}
				}
			}
			JSONObject minMaxTable = new JSONObject();
			JSONArray minMaxTableHeadersArray = new JSONArray();
			if(treeMap!=null && !treeMap.isEmpty())
			{
				JSONObject minMaxStateHeaderObject = new JSONObject();
				minMaxStateHeaderObject.put("name","");
				minMaxStateHeaderObject.put("width","5");
				minMaxStateHeaderObject.put("textType","");
				
				JSONObject minMaxTextHeaderObject = new JSONObject();
				if(info==null || info.trim().equals("") || info.trim().equals("*") || info.trim().equals("+"))
				{
					minMaxTextHeaderObject.put("name",egMappingInfo.getTextDescription("monitor.measure.Measurement Name"));
					minMaxTextHeaderObject.put("width","50");
					minMaxTextHeaderObject.put("textType","string");
					if(treeMap.size()>1)
					{
						//minMaxTableHeaderObject.put("imageUrl","/final/monitor/eg_images/arrow_down_black.gif");
					}
					else
					{
						//minMaxTableHeaderObject.put("imageUrl","/final/monitor/eg_images/arrow_up_black.gif");	
					}					
				}
				else
				{
					minMaxTextHeaderObject.put("name",egMappingInfo.getTextDescription("monitor.common.Descriptor"));
					minMaxTextHeaderObject.put("width","50");
					minMaxTextHeaderObject.put("textType","string");
					if(treeMap.size()>1)
					{
						//minMaxTableHeaderObject.put("imageSrc","/final/monitor/eg_images/arrow_down_black_small.gif");
					}
					else
					{
					}
				}
				JSONObject avgHeader = new JSONObject();
				avgHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Avg"));
				avgHeader.put("width","15");
				avgHeader.put("textType","asFloat");

				JSONObject maxHeader = new JSONObject();
				maxHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Max"));
				maxHeader.put("width","15");
				maxHeader.put("textType","asFloat");

				JSONObject minHeader = new JSONObject();
				minHeader.put("name",egMappingInfo.getTextDescription("monitor.common.Min"));
				minHeader.put("width","15");
				minHeader.put("textType","asFloat");

				minMaxTableHeadersArray.add(minMaxStateHeaderObject);
				minMaxTableHeadersArray.add(minMaxTextHeaderObject);
				minMaxTableHeadersArray.add(avgHeader);
				minMaxTableHeadersArray.add(maxHeader);
				minMaxTableHeadersArray.add(minHeader);
				
				minMaxTable.put("minMaxTableHeadersArray",minMaxTableHeadersArray);
				
				Iterator ite = treeMap.keySet().iterator();
				
				JSONArray minMaxTableDataArray = new JSONArray();
				
				while(ite.hasNext())
				{
					float key = ((Float)ite.next()).floatValue();
					String values = (String)treeMap.get(new Float(key));
					//StringTokenizer st = new StringTokenizer(values,"$");
					ArrayList stList =  com.egurkha.util.StringUtils.egTokenizer(values, "~eg~",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim
					
					//while(st.hasMoreTokens())
					if(stList!=null)
					for(int i=0;i<stList.size();i++)
					{
						//String val = (String)st.nextToken();
						String val = (String)stList.get(i);
						StringTokenizer st1 = new StringTokenizer(val,"|");
						{
							while(st1.hasMoreTokens())
							{
								JSONObject minMaxTableDataObject = new JSONObject();
								String descriptor=(String)st1.nextToken();
								String colorValue =(String)colorMap.get(descriptor);
								if(descriptor.indexOf("^")>-1)
								{
									String testVal=descriptor.substring(0,descriptor.indexOf("^"));
									String measureVal=descriptor.substring(descriptor.indexOf("^")+1,descriptor.length());
									String unit1 = tablesInfo.getUnitForMeasure(testVal,measureVal);
									String tmp_test_meas = egMappingInfo.getMeasureDescription(testVal,measureVal);
									minMaxTableDataObject.put("value0","");
									minMaxTableDataObject.put("value1",tmp_test_meas+"("+unit1+")");
								}
								else
								{
									if(isVM)
									{
										if(descriptor.indexOf(":")>-1)
										{
											descriptor = descriptor.substring(descriptor.indexOf(":")+1);
										}
									}
									minMaxTableDataObject.put("value0",colorValue);
									minMaxTableDataObject.put("value1",descriptor);
								}
								minMaxTableDataObject.put("value2",st1.nextToken());
								minMaxTableDataObject.put("value3",st1.nextToken());
								minMaxTableDataObject.put("value4",st1.nextToken());
								
							minMaxTableDataArray.add(minMaxTableDataObject);
							}
							
						}
					}
				}
				minMaxTable.put("minMaxTableDataArray",minMaxTableDataArray);
				json.put("minMaxTable",minMaxTable);

				if(isFirefox || isChrome)
				{

				}
				else
				{
					

				}

				Set set = treeMap.keySet();
				ArrayList al = new ArrayList(set);
				JSONObject measuresTable = new JSONObject();
				JSONArray measuresTableDataArray = new JSONArray();
				ArrayList infoList =new ArrayList();
			
				HashMap infoColormap = new HashMap();
				if(info != null && info.trim().length()>0)
				{
					StringTokenizer commaTok = new StringTokenizer(info,",");
					while(commaTok.hasMoreTokens())
					{
						String infoVal1 = commaTok.nextToken();
						if(infoVal1 != null && infoVal1.indexOf("*")>-1)
							infoVal1=infoVal1.substring(infoVal1.indexOf("*")+1);
						infoList.add(infoVal1);
					}
				}

				if(infoList != null && infoList.size() > 0)
				{
					int count = -1;
					for(int k=infoList.size()-1;k >= 0;k--)
					{
						count++;
						if(v_color_size<=count)
						{
							count=0;
							infoColormap.put(((String)infoList.get(k)),v_color.get(count));
						}
						else
						{
							infoColormap.put(((String)infoList.get(k)),v_color.get(count));
						}
					}
				}
				for(int j=treeMap.size()-1; j >= 0; j--)
				{
					float key = ((Float)al.get(j)).floatValue();
					String values = (String)treeMap.get(new Float(key));
					
					//StringTokenizer st = new StringTokenizer(values,"$");
					ArrayList stList =  com.egurkha.util.StringUtils.egTokenizer(values, "~eg~",false,false,true);//param 3-->includeEmpty,4-->unique,5-->trim

					//while(st.hasMoreTokens())
					for(int i=0;i<stList.size();i++)
					{
						//String val = (String)st.nextToken();
						String val = (String)stList.get(i);
						
						StringTokenizer st1 = new StringTokenizer(val,"|");
						while(st1.hasMoreTokens())
						{
							JSONObject measuresTableDataObject = new JSONObject();
							String descriptor=(String)st1.nextToken();
							String colorValue =(String)infoColormap.get(descriptor);
							if(descriptor != null && infoList != null && infoList.size()>0 && infoList.contains(descriptor))
							{
								if(descriptor.indexOf("^")>-1)
								{
									String testVal=descriptor.substring(0,descriptor.indexOf("^"));
									String measureVal=descriptor.substring(descriptor.indexOf("^")+1,descriptor.length());
									String units = tablesInfo.getUnitForMeasure(testVal,measureVal);
									measuresTableDataObject.put("value0",colorValue);
									measuresTableDataObject.put("value1",testVal+":"+measureVal+"("+units+")");
								}
								else
								{
									if(isVM)
									{
										if(descriptor.indexOf(":")>-1)
										{
											descriptor = descriptor.substring(descriptor.indexOf(":")+1);
										}
									}
									measuresTableDataObject.put("value0",colorValue);
									measuresTableDataObject.put("value1",descriptor);
								}
								measuresTableDataObject.put("value2",st1.nextToken());
								measuresTableDataObject.put("value3",st1.nextToken());
								measuresTableDataObject.put("value4",st1.nextToken());
								measuresTableDataArray.add(measuresTableDataObject);
							}
						}
					}
				}
				measuresTable.put("measuresTableDataArray",measuresTableDataArray);
				json.put("measuresTable",measuresTable);
			}
		}
		else if(come_from_vmware)
		{
			JSONObject dbTimelineDiv = new JSONObject();
			dbTimelineDiv.put("fullviewDataUrl",fullviewDataUrl);
			json.put("dbTimelineDiv",dbTimelineDiv);
		}

		if(come_from_vmware || come_from_trans || come_from_vmLG || come_from_insideview)
		{
		/*	<!--Its need for Insideview Dashboard, please don't remove-->
			<!-- <form name="egDashboardTimeline">
			</form> -->
			<!--End-->*/
		}
	}
	hiddenFields.put("monitor_Skin",monitor_Skin);
	hiddenFields.put("compName",comp_name);
	hiddenFields.put("duration",duration);
	hiddenFields.put("durationChanged",durationChanged);
	hiddenFields.put("measure",measure);
	hiddenFields.put("test",test);
	hiddenFields.put("all_trans_names",all_trans_names);
	hiddenFields.put("msmt_host",msmtHost);
	hiddenFields.put("timeline",timeline);
	hiddenFields.put("site",site);
	
	json.put("hiddenFields",hiddenFields);
	response.getWriter().write(json.toString());
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>