Ext.Loader.setConfig({
    enabled:true,
	disableCaching:false,
	preserveScripts:false,
	garbageCollect:true,
	paths:{
		'Ext.ux':'/final/scripts/ux',
		'utilities': '/final/scripts/utilities',
		'widgets': '/final/scripts/widgets',
		'MyDashBoard':'/final/monitor/eg_scripts/myDashboard',
		'citrixDashboard':'/final/monitor/eg_scripts/citrixDashboard'
	}
});

	function isContainsOnlyDigits( str ) {
	 return /^[0-9]+$/.test(str);
	}

	Ext.data.Types.FLOATORSTRING = {
		convert : function(v) {

			if(!isContainsOnlyDigits(v))
			{
				return v;
			}
			if(v.lastIndexOf(".") > v.indexOf(".")) // this is to fix ip addr values sorting
			{
				return v;
			}
			var n = parseFloat(String(v).replace(Ext.data.Types.stripRe, ''), 10);
			return isNaN(n) ? v : n;
		},
		sortType : function(cellVal)
		{
			if(cellVal=="-")
			{
				return -1;
			}
			else
			{
				var parsedStrng = (String(cellVal).replace(Ext.data.Types.stripRe, ''));
				var n1 = parseFloat(parsedStrng, 10);
				if( isNaN(n1))
				{
					var cVal = parsedStrng;
					if(cVal!=null && cVal!='')
					{
						return cVal;
					}
					else
					{
						return 0;
					}
				}
				else
				{
					return n1;
				}
			}
		}	
	};

	Ext.application({
		name: 'ABAPDashboard',
		controllers:['ABAPDashboard.controller.Main'],
		requires:['ABAPDashboard.view.Main'],
		appFolder:'/final/monitor/eg_scripts/ABAPDashboard',
		launch: function() {
			ABAPDashboard.app=this;
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.egSAPDashboardController',
				scope: this,
				method : 'POST',
				params :defaultABAPDashboardParams,
				success: function(response)
				{
					var jsonData = Ext.decode(response.responseText);
					pubJson=jsonData;				
					Ext.create('ABAPDashboard.view.Viewport',{
						id : 'abapDashboardViewPort',
						items:[
							{
								xtype:'main'
							}
						]
					
					});								
				}
			});
		}
	});

function execute(){
	ABAPDashboard.app.getController('Main').refresh("execute");
}

function showDumpsDDPopupWindow(){
	ABAPDashboard.app.getController('Main').showDumpsDDPopupWindow();
}

function showStepsDDPopupWindow(){
	ABAPDashboard.app.getController('Main').showStepsDDPopupWindow();
}

function showInfoBasedStepsDDPopupWindow(measure,topInfosList){
	ABAPDashboard.app.getController('Main').showInfoBasedStepsDDPopupWindow(measure,topInfosList);
}

function showJobStatisticsPopupWindow(measureName){
	ABAPDashboard.app.getController('Main').showJobStatisticsPopupWindow(measureName);
}

function loadTasktypeDetails(infoName){
	ABAPDashboard.app.getController('Main').loadTasktypeDetails(infoName);
}
function gotoComponentLayer(){
	var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
	var selectedComp = SAPdashboard_combo.getValue();
	var dashboardUrl="/final/servlet/com.eg.EgDashboardController?site=NULL";
	window.location.href=dashboardUrl+"&from=SAP"+"&comptype=SAP_R3_server"+"&host="+encodeURIComponent(selectedComp)+"&tab=LayerModel";
}

