Ext.define('ABAPDashboard.controller.Main', {
    extend: 'Ext.app.Controller',
		requries:['ABAPDashboard.view.Drilldownwindow','widget.donutalert','ABAPDashboard.view.DistributionDonutchart','MyDashBoard.view.SummaryWidget','widgets.ChartParentPanel','widgets.GraphText','ABAPDashboard.view.Main','ABAPDashboard.view.DrillWindow','ABAPDashboard.view.SlowstepsDrillWindow'],
    init: function() {
		setInterval("execute()",refreshFrequency);
		//setInterval("execute()",10000);
        this.control({
            "viewport": {
                'afterrender' : this.onPanelRendered
            },
			'main': {
					'afterrender' : this.hideMainMask
			},
			'main combo[id="SAP_dashboard_combo"]' : {
				'select' : this.SAPComboChange
			}
        });
    },
	hideMainMask : function()
	{
		Ext.get('ABAPDashboardMask').remove();
	},
	refresh:function(currObj)
	{
		var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
		var selectedComp = '';

		if(!Ext.isEmpty(SAPdashboard_combo))
		{
			selectedComp = SAPdashboard_combo.getValue();
		}

		var URLparams = "loadSAPCombo=false&action=loadSAPDashboard&selectedComp="+encodeURIComponent(selectedComp);

		if(selectedInfo!=null && selectedInfo!='')
		{
			URLparams = URLparams+"&selectedInfo="+encodeURIComponent(selectedInfo);
		}
		
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSAPDashboardController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				if(jsonData.errorMsg != '-'){
					this.updateSAPData(jsonData);
				}
			}
		});
	},
	SAPComboChange: function(comboVal) {
		selectedInfo='';
		Ext.getBody().mask('loading');
		var selectedComp = comboVal.getValue();
		var URLparams = "loadSAPCombo=true&action=loadSAPDashboard&selectedComp="+encodeURIComponent(selectedComp);

		defaultABAPDashboardParams ='loadSAPCombo=true&action=loadSAPDashboard&selectedComp='+encodeURIComponent(selectedComp);
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSAPDashboardController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);				
				this.loadSAPData(jsonData);	
			}
		});

	},

    onPanelRendered: function() {
		var layerIconId = Ext.getCmp('layerIconId');
		var SAPcombo = Ext.getCmp('SAP_dashboard_combo');
		SAPcombo.getStore().removeAll();
		var SAPcomboStore = SAPcombo.getStore();
		if(pubJson.errorMsg == '-'){
			SAPcombo.hide();
			layerIconId.hide();
			var mainView = Ext.getCmp('mainView');
			mainView.removeAll(true);
			mainView.add({
				xtype:'box',
				html:'<div style="height:calc(100% - 30px);width:100%;display:table; position: fixed;"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noCompFoundMsg+'</div></div></div>'
			})

		}else{
			if(!Ext.isEmpty(pubJson.SAPCompCombo[0][0])){
				SAPcombo.show();
				layerIconId.show();
				SAPcomboStore.loadRawData(pubJson.SAPCompCombo[0][0]);
				SAPcombo.setValue(pubJson.SAPCompCombo[0][1]);
					
				this.loadSAPData(pubJson);
			}
		}
	},
	loadSAPData: function(jsonData)
	{			
		Ext.getCmp('availability').getStore().removeAll();
		Ext.getCmp('availability').store.loadData(jsonData.avalibility);

		if(jsonData.userDistribution!=null)
		{
			var userDistributionAdd = Ext.getCmp('userDistribution');
			userDistributionAdd.removeAll();
			
			if(!Ext.isEmpty(jsonData.userDistribution))
			{
				userDistributionAdd.add(
				{
					xtype:'panel',
					flex:1,
					width:'100%',
					height:140,						
					autoDestroy:true,
							
					items:[
					{
						xtype:'donutalert',
						ifSAP:true,
						cls: 'newDottedRight',
						margin: '10px 0 10px',
						padding: '0px 10px 0 0',
						height:130,
						data:jsonData.userDistribution,
						id:"donutalert-graph_donut_2_overviewCtx",
						num:"donutalert-graph_donut_2_overviewCtx1",
						title: '<div class="newFont_bold14"></div>',

					}]
				});
			}else{
				userDistributionAdd.add(
				{
					xtype:'panel',
					flex:1,
					width:'100%',
					height:138,
					items:[
						{
						xtype:'panel',
						cls: 'newDottedRight',
						margin: '10px 0 10px',
						padding:0,
						height:130,
						ui:'newGraphPanel',
						html : '<div class="newFont_bold14" style="position:absolute;">'+userDistributionLbl+'</div><div style="height:100%;width:100%;display:table;padding: 17px 0 0 0;"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
						}
					]
				});
			}
		}

		if(jsonData.dialogActivity!=null)
		{
			var dialogActivityContainer = Ext.getCmp('dialog_activity');
			dialogActivityContainer.removeAll();
			if(jsonData.dialogActivity !='-')
			{	
				dialogActivityContainer.add(
				{
						xtype : 'summarywidget',
						cls: 'newDottedRight',
						height : '130px',
						margin: '10px 0 0px',
						padding:'0px 0 0',
						id : 'dialog_activity_summaryWidgetCont',
						chartID: 'dialog_activity_scwid',
						chartType:jsonData.dialogActivity[0]['summaryGraphType'],
						html: '<div class="newFont_bold14">'+jsonData.dialogActivity[0]['heading']+'</div>',
						chartData : jsonData.dialogActivity,
						needDDIcon : true,
						showToolTip:true
						
				});
			}else{
				dialogActivityContainer.add(
				{
					
					xtype : 'container',
					cls: 'newDottedRight',
					height : '130px',
					margin: '10px 0 0px',
					padding:'0px 0 0',
					html : '<div class="newFont_bold14" style="position:absolute;">'+dialogActivityLbl+'</div><div style="height:100%;width:100%;display:table;padding: 17px 0 0 0;"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
					
				});
			}
		}

		if(jsonData.dialogResponse!=null)
		{
			var dialogResponseContainer = Ext.getCmp('dialog_response');
			dialogResponseContainer.removeAll();
			
			if(jsonData.dialogResponse !='-')
			{
				dialogResponseContainer.add(
				{
						xtype : 'summarywidget',
						cls: '',
						padding: '0px 0 0',
						height : '130px',
						margin: '10px 0 0px',
						id : 'dialog_response_summaryWidgetCont',
						chartID: 'dialog_response_scwid',
						chartType:jsonData.dialogResponse[0]['summaryGraphType'],
						html:'<div class="newFont_bold14" style="overflow:hidden; text-overflow:ellipsis; white-space: nowrap; padding: 0 10px 0 0;" >'+jsonData.dialogResponse[0]['heading']+'</div>',
						chartData : jsonData.dialogResponse,
						needDDIcon : true,
						showToolTip:true
				});
			}else{
				dialogResponseContainer.add(
				{
					xtype : 'container',
					cls: '',
					padding: '0px 0 0',
					height : '130px',
					margin: '10px 0 0px',
						html : '<div class="newFont_bold14" style="position:absolute;overflow:hidden; padding: 0 10px 0 0; text-overflow:ellipsis; white-space: nowrap; padding: 0 10px 0 0;">'+dialogResponseTimeLbl+'</div><div style="height:100%;width:100%;display:table;padding: 17px 0 0 0;"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
					
				});
			}
		}

		if(jsonData.dump!=null)
		{
			var dumpsContainer = Ext.getCmp('dumps_Container');
			dumpsContainer.removeAll();

			if(!Ext.isEmpty(jsonData.dump))
			{			
				dumpsContainer.add(
					{
						xtype : 'summarywidget',
						cls: '',
						height: 140,
						margin:0,
						padding:'10px 0 0',
						id : 'dumps_summaryWidgetCont',
						chartID: 'dumps_scwid',
						chartType:jsonData.dump[0]['summaryGraphType'],
						html: '<div class="newFont_bold14">'+jsonData.dump[0]['heading']+'</div>',
						chartData : jsonData.dump,
						needDDIcon : true,
						showToolTip:true
				});
			}else{
				dumpsContainer.add(
				{
					xtype : 'container',
					cls: '',
					padding: '0px 0 0',
					height : '130px',
					margin: '10px 0 0px',
						html : '<div class="newFont_bold14" style="position:absolute;">'+dumpsLbl+'</div><div style="height:100%;width:100%;display:table;padding: 17px 0 0 0;"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
					
				});
			}
		}

		if(jsonData.responseTime !=null)
		{
			if(!Ext.isEmpty(jsonData.responseTime) && jsonData.responseTime.hasOwnProperty('selectedDesc'))
			{	
				selectedInfo= jsonData.responseTime[0].selectedDesc;
			}
			Ext.getCmp('saptopology').store.loadData(jsonData.responseTime);
		}

		if(jsonData.workProcess)
		{
			var workprocessContainerObj = Ext.getCmp('workprocessContainer');
			workprocessContainerObj.removeAll();
			if(!Ext.isEmpty(jsonData.workProcess))
			{			
				workprocessContainerObj.add(
				{
					xtype : 'workprocesses',
					id : 'workprocessesWidgetCont',
					data1:jsonData.workProcess[0][0],					
					data2:jsonData.workProcess[1][0],
					padding:0,				
				});
			}else{
				workprocessContainerObj.add(
				{
					xtype : 'panel',
					cls: '',
					padding: '0px 0 0',
					height : '100%',
					margin: '0px 0 0px',
					html : '<div class="newFont_bold14" style="position:absolute;padding: 10px 10px;">'+workProcessesLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'				
				});
			}
		}

		if(jsonData.loginAndActiveUsers!=null)
		{
			var loggedactivityContainer = Ext.getCmp('loggedactivity_1');
			loggedactivityContainer.removeAll();

			loggedactivityContainer.add({
				xtype:'container',
				ui: 'eg-container',
				layout:'fit',
				padding:0,
				border:false,
				frame:false,
				autoScroll:false,
				scroll:false,
				items:[],
				listeners:{
					'afterrender':function(e){
						var me = this;
						me.add({
							xtype:'sapsessionsconnected',
							id:'logginVsActive_Id',
							data:jsonData.loginAndActiveUsers[0][0],
							isFromSapDB:true,			
							height:215,
							padding:'0 0 0px 0',
							margin:'-2px 0 0',
							ui:'newGraphPanel'	
						});	
					}
				}
			});
		}
		
		var colsArrJob = [];
		var fields2StoreJob = [];
		var gridJobCols = jsonData.jobStatistics[0].gridColumns;
		
		for (var colVal in gridJobCols) 
		{
			var colName = gridJobCols[colVal];
			fields2StoreJob.push({
				name : colVal,
				type : 'FLOATORSTRING'
			});

			if(colVal=='Column_0'){
				colsArrJob.push({
					header: '',
					width:25,
					dataIndex: colVal,
						renderer : function(value, metaData, record, row, col, store, gridView) {
						metaData.style = 'width:25px;padding:3px 0px 2px 5px';
						return  '<span class="stateSymbol_'+value+'" style="float:left"></span>'
					}
				});
			}else if(colVal=='Column_2'){
				fields2StoreJob.push({
					name : colVal+"_url",
					type : 'string'
				});
				colsArrJob.push({
					header: colName,
					dataIndex: colVal,
					align: 'right',
					renderer : function(value, metaData, record, row, col, store, gridView) {
						metaData.style = 'padding-right:30px;';
						var href = record.get("Column_" + col + '_url');
						var jobDD = record.get("Column_" + col + '_DD');
						if (href != null && !Ext.isEmpty(href) && href != "-") {
							href=decodeURI(href);
							if (jobDD != null && !Ext.isEmpty(jobDD) && jobDD != "-") {
								var measureName = record.get('Column_1');
								value = '<a style="cursor:pointer; position: relative;  top:-3px; right:33px;" onclick="javascript:showJobStatisticsPopupWindow(\''+measureName+'\');\"><img src="../images/clear.png" class="sap_search"  style="position:absolute;  right: -30px;"/></a><a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}else{
							value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
						}
						return value; 						 
					}
				});
			}else if(colVal=='Column_1'){
				fields2StoreJob.push({
					name : colVal,
					type : 'string'
				});
				colsArrJob.push({
					header: colName,
					dataIndex: colVal,
					flex: 1,
					renderer : function(value, metaData, record, row, col, store, gridView) {
						metaData.style = 'padding-left:2px;';
						return value; 
					}
				});
			}
		}
		

		var jobStatisticsgrid = Ext.getCmp('jobStatistics_grid');
		jobStatisticsgrid.getStore().removeAll();

		var storeVal1 = Ext.create('Ext.data.Store',{
			fields:fields2StoreJob,
			data:jsonData.jobStatistics[0].gridData,
		});
		jobStatisticsgrid.reconfigure(storeVal1,colsArrJob);

		if(jsonData.bufferSwap!=null)
		{			
			var bufferswapContainer = Ext.getCmp('bufferswap');
			bufferswapContainer.removeAll();
			if(!Ext.isEmpty(jsonData.bufferSwap[0]))
			{	
				bufferswapContainer.add(
				{
					xtype:'chartparentpanel',
					id:'multBarIns_overview',
					data:jsonData.bufferSwap,
					margin:0,
					padding: 0,						
					flex:1,
					layout:{
					type: 'vbox',
					align:'stretch'
					},
					defaults:{
						flex:1
					},
					isSAP:true										
				});
			}else{
				bufferswapContainer.add(
				{
					xtype : 'panel',
					cls: '',
					padding: '0px 0 0',
					height : '100%',
					margin: '0px 0 0px',
					html : '<div class="newFont_bold14" style="position:absolute;padding: 10px 10px;">'+bufferSwapsLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
				});
			}
		}
		
		Ext.getCmp('diskActivity').getStore().removeAll();
		Ext.getCmp('diskActivity').store.loadData(jsonData.diskActivity);

		if(!Ext.isEmpty(jsonData.diskActivity)){
			Ext.getCmp('diskactivity-panel').setTitle(jsonData.diskActivity[0]["diskactivityTitle"]);
		}
		else{
			Ext.getCmp('diskactivity-panel').setTitle(diskActivityLbl);
		}
		
		if(jsonData.sapMemory!=null)
		{
			var meController = this;
			var sapMemoryContainer = Ext.getCmp('sapMemory');
			sapMemoryContainer.removeAll();

			for(var b in jsonData.sapMemory[0].sapMemory)
			{		
				sapMemoryContainer.add(
				{
					xtype:'graphtext',
					cls:'newFont_bold14',
					width:'50%',
					style:{'display':'inline-block'},
					data:jsonData.sapMemory[0].sapMemory[b],
					id:'sapMemory'+b,
					num:'sapMemory'+'_'+b,
					aid:b,
					cls:'sapiteration_'+b 							
				});
			}
		}

		if(jsonData.actTrans[0]!=null && !Ext.isEmpty(jsonData.actTrans[0]) )
		{			
			var colsArrTrans = [];
			var fields2StoreTrans = [];
			var gridCols = jsonData.actTrans[0].gridColumns;

			for (var colVal in gridCols) 
			{
				var colName = gridCols[colVal];
				fields2StoreTrans.push({
					name : colVal,
					type : 'FLOATORSTRING'
				});

				
				if(colVal=='Column_0'){
					colsArrTrans.push({
						header: colName,
						dataIndex: colVal,
						
						flex: 1,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							var value = '<span style="cursor:default;" data-qtip="' + value + '">' + value + '</span>';
							return value; 								
						}
					});
				}
				else if(colVal=='Column_2'){
					fields2StoreTrans.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrTrans.push({
						header: colName,
						dataIndex: colVal,
						minWidth:110,
							renderer : function(value, metaData, record, row, col, store, gridView) {
							metaData.style = 'text-align:center';
							var href = record.get("Column_" + col + '_url');
						
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
							return value; 
						}
					});
				}else{
					fields2StoreTrans.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrTrans.push({
						header: colName,
						dataIndex: colVal,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							
							metaData.style = 'text-align:right; padding-right:30px;';
							var href = record.get("Column_" + col + '_url');
							
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							} 
							return value; 
						}
					});
				}
			}
		}	
			
		if(jsonData.actUser[0]!=null && !Ext.isEmpty(jsonData.actUser[0]) )
		{
			var gridColsUser = jsonData.actUser[0].gridColumns;
			var colsArrUser = [];
			var fields2StoreUser = [];

			for (var colVal in gridColsUser) 
			{
				var colName = gridColsUser[colVal];
				fields2StoreUser.push({
					name : colVal,
					type : 'FLOATORSTRING'
				});

				if(colVal=='Column_0'){
					colsArrUser.push({
						header: colName,
						dataIndex: colVal,
						flex: 1,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							var value = '<span style="cursor:default;" data-qtip="' + value + '">' + value + '</span>';
							return value; 								
						}
					});
				}
				else if(colVal=='Column_2'){
					fields2StoreUser.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrUser.push({
						header: colName,
						dataIndex: colVal,
						//flex: 1,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							metaData.style = 'text-align:center';
							var href = record.get("Column_" + col + '_url');
							
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
							return value; 
						}
					});
				}else{
					fields2StoreUser.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrUser.push({
						header: colName,
						dataIndex: colVal,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							metaData.style = 'text-align:right;  padding-right:30px;';
							var href = record.get("Column_" + col + '_url');
							
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
							return value; 
						}
					});
				}
			}
		}

		if(jsonData.actTask[0]!=null && !Ext.isEmpty(jsonData.actTask[0]) )
		{
			var gridColsTask = jsonData.actTask[0].gridColumns;
			var colsArrTask = [];
			var fields2StoreTask = [];

			for (var colVal in gridColsTask) 
			{
				var colName = gridColsTask[colVal];
				fields2StoreTask.push({
					name : colVal,
					type : 'FLOATORSTRING'
				});

				if(colVal=='Column_0'){
					colsArrTask.push({
						header: colName,
						dataIndex: colVal,
						flex: 1,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
							return value; 								
						}
					});
				}
				else if(colVal=='Column_2'){
					fields2StoreTask.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrTask.push({
						header: colName,
						dataIndex: colVal,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							metaData.style = 'text-align:center';
							var href = record.get("Column_" + col + '_url');
							
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
							return value; 
						}
					});
				}else{
					fields2StoreTask.push({
						name : colVal +"_url",
						type : 'string'
					});
					colsArrTask.push({
						header: colName,
						dataIndex: colVal,
						minWidth:110,
						renderer : function(value, metaData, record, row, col, store, gridView) {
							metaData.style = 'text-align:right;  padding-right:30px;';
							var href = record.get("Column_" + col + '_url');
							
							if (href != null && !Ext.isEmpty(href) && href != "-") {
								href=decodeURI(href);
								value = '<a href=\'javascript:goToLayerModel("' + href + '")\'>' + value + '</a>';
							}
							return value; 
						}
					});
				}
			}
		}
		
		if(jsonData.actTrans[0]!=null && !Ext.isEmpty(jsonData.actTrans[0]))
		{
			var gridID1Add = Ext.getCmp('gridID1');
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel'))){
				Ext.getCmp('emptyPanel').hide();
				
			}
			var storeVal1 = Ext.create('Ext.data.Store',{
				fields:fields2StoreTrans,
				 data:jsonData.actTrans[0].gridData,
			 });
			 Ext.get('gridID1').removeCls('border_less');
			gridID1Add.reconfigure(storeVal1,colsArrTrans);
		}else{
			
			var gridID1Add = Ext.getCmp('gridID1');
			Ext.each(Ext.getCmp('gridID1').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID1').addCls('border_less')
			gridID1Add.getStore().removeAll();
			gridID1Add.store.loadData('');			
		}
		
		if(jsonData.actUser[0]!=null && !Ext.isEmpty(jsonData.actUser[0]))
		{
			var gridID2Add = Ext.getCmp('gridID2');
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel2'))){
				Ext.getCmp('emptyPanel2').hide();
				
			}
			var storeVal2 = Ext.create('Ext.data.Store',{
				fields:fields2StoreUser,
				data:jsonData.actUser[0].gridData,
			});
			 Ext.get('gridID2').removeCls('border_less');
			gridID2Add.reconfigure(storeVal2,colsArrUser);
		}else{
			var gridID2Add = Ext.getCmp('gridID2');
			Ext.each(Ext.getCmp('gridID2').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID2').addCls('border_less')
			gridID2Add.getStore().removeAll();
			gridID2Add.store.loadData('');
		}

		if(jsonData.actTask[0]!=null && !Ext.isEmpty(jsonData.actTask[0]))
		{
			var gridID3Add = Ext.getCmp('gridID3');
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel3'))){
				Ext.getCmp('emptyPanel3').hide();
				
			}
			var storeVal3 = Ext.create('Ext.data.Store',{
				fields:fields2StoreTask,
				data:jsonData.actTask[0].gridData,
			});
			 Ext.get('gridID3').removeCls('border_less');
			gridID3Add.reconfigure(storeVal3,colsArrTask);
		}else{
			var gridID3Add = Ext.getCmp('gridID3');
			Ext.each(Ext.getCmp('gridID3').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID3').addCls('border_less');
			gridID3Add.getStore().removeAll();
			gridID3Add.store.loadData('');
		}
		Ext.getBody().unmask();
	},

	updateSAPData:function(jsonData)
	{
		Ext.getCmp('availability').getStore().removeAll();
		Ext.getCmp('availability').store.loadData(jsonData.avalibility);

		if(!Ext.isEmpty(jsonData.userDistribution))
		{
			var donutAlertGraphObj = Ext.getCmp('donutalert-graph_donut_2_overviewCtx');
			if(!Ext.isEmpty(donutAlertGraphObj))
			{
				donutAlertGraphObj.updateData(jsonData.userDistribution);
			}else{
				var userDistributionAdd = Ext.getCmp('userDistribution');
				userDistributionAdd.removeAll();
				userDistributionAdd.add(
				{
					xtype:'panel',
					flex:1,
					width:'100%',
					height:140,					
					autoDestroy:true,
							
					items:[{
						xtype:'donutalert',
						ifSAP:true,
						cls: 'newDottedRight',
						margin: '10px 0 10px',
						padding: '0px 10px 0 0',
						height:130,
						data:jsonData.userDistribution,
						id:"donutalert-graph_donut_2_overviewCtx",
						num:"donutalert-graph_donut_2_overviewCtx1",
						title: '<div class="newFont_bold14"></div>',
					}]
				});

			}
		}else{
			var userDistributionAdd = Ext.getCmp('userDistribution');
			userDistributionAdd.removeAll();
			userDistributionAdd.add({
				xtype:'panel',
				flex:1,
				width:'100%',
				height:138,
					items:[
						{
						xtype:'panel',
						cls: 'newDottedRight',
						margin: '10px 0 10px',
						padding:0,
						height:130,
						html : '<div class="newFont_bold14" style="position:absolute;">'+userDistributionLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
						}
					]
				});
		}

		if(jsonData.dialogActivity !='-')
		{	
			var dialog_activityObj=Ext.getCmp('dialog_activity_summaryWidgetCont');
			if(!Ext.isEmpty(dialog_activityObj))
			{
				dialog_activityObj.updateData(jsonData.dialogActivity);
			}else{
				var dialogActivityContainer = Ext.getCmp('dialog_activity');
				dialogActivityContainer.removeAll();
				dialogActivityContainer.add(
				{
					xtype : 'summarywidget',
					cls: 'newDottedRight',
					height : '130px',
					margin: '10px 0 0px',
					padding:'0px 0 0',
					id : 'dialog_activity_summaryWidgetCont',
					chartID: 'dialog_activity_scwid',
					chartType:jsonData.dialogActivity[0]['summaryGraphType'],
					html: '<div class="newFont_bold14" >'+jsonData.dialogActivity[0]['heading']+'</div>',
					chartData : jsonData.dialogActivity,
					needDDIcon : true
				});
			}
		}else{
			var dialogActivityContainer = Ext.getCmp('dialog_activity');
			dialogActivityContainer.removeAll();
			dialogActivityContainer.add(
			{
				xtype : 'container',
				cls: 'newDottedRight',
				height : '130px',
				margin: '10px 0 0px',
				padding:'0px 0 0',
				html : '<div class="newFont_bold14" style="position:absolute;">'+dialogActivityLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'	
			});
		}

		if(jsonData.dialogResponse !='-')
		{
			var dialog_responseObj=Ext.getCmp('dialog_response_summaryWidgetCont');
			if(!Ext.isEmpty(dialog_responseObj))
			{
				dialog_responseObj.updateData(jsonData.dialogResponse);
			}else{
				var dialogResponseContainer = Ext.getCmp('dialog_response');
				dialogResponseContainer.removeAll();

				dialogResponseContainer.add(
				{
					xtype : 'summarywidget',
					cls: '',
						padding: '0px 0 0',
						height : '130px',
						margin: '10px 0 0px',
						id : 'dialog_response_summaryWidgetCont',
						chartID: 'dialog_response_scwid',
						chartType:jsonData.dialogResponse[0]['summaryGraphType'],
						html:'<div class="newFont_bold14 s" style="overflow:hidden; text-overflow:ellipsis; padding: 0 10px 0 0; white-space: nowrap;">'+jsonData.dialogResponse[0]['heading']+'</div>',
						chartData : jsonData.dialogResponse,
						needDDIcon : true
					});
			}
		}else{
			var dialogResponseContainer = Ext.getCmp('dialog_response');
			dialogResponseContainer.removeAll();
			dialogResponseContainer.add(
			{
				xtype : 'container',
				cls: '',
				padding: '0px 0 0',
				height : '130px',
				margin: '10px 0 0px',
				html : '<div class="newFont_bold14 s" style="overflow:hidden; text-overflow:ellipsis; position:absolute;">'+dialogResponseTimeLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'	
			});
		}	


		if(!Ext.isEmpty(jsonData.dump))
		{
			var dumps_summaryObj=Ext.getCmp('dumps_summaryWidgetCont');
			if(!Ext.isEmpty(dumps_summaryObj))
			{
				dumps_summaryObj.updateData(jsonData.dump);
			}else{
				var dumpsContainer = Ext.getCmp('dumps_Container');
				dumpsContainer.removeAll();
				dumpsContainer.add({
						xtype : 'summarywidget',
						cls: '',
						height: 140,
						margin:0,
						padding:'10px 0 0',
						id : 'dumps_summaryWidgetCont',
						chartID: 'dumps_scwid',
						chartType:jsonData.dump[0]['summaryGraphType'],
						html: '<div class="newFont_bold14">'+jsonData.dump[0]['heading']+'</div>',
						chartData : jsonData.dump,
						needDDIcon : true
				});
			}
		}else{
			var dumpsContainer = Ext.getCmp('dumps_Container');
			dumpsContainer.removeAll();
			dumpsContainer.add({
					xtype : 'container',
					cls: '',
					padding: '0px 0 0',
					height : '130px',
					margin: '10px 0 0px',
					html : '<div class="newFont_bold14" style="position:absolute;">'+dumpsLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
				});
		}

		Ext.getCmp('saptopology').getStore().removeAll();

		Ext.getCmp('saptopology').store.loadData(jsonData.responseTime);

		if(!Ext.isEmpty(jsonData.workProcess))
		{
			var data1  =jsonData.workProcess[0][0];
			var data2  =jsonData.workProcess[1][0];
			var workprocessesObj = Ext.getCmp('workprocessesWidgetCont');
			if(!Ext.isEmpty(workprocessesObj))
			{
				workprocessesObj.updateChart(data1,data2);
			}else{
				var workprocessContainerObj = Ext.getCmp('workprocessContainer');
				workprocessContainerObj.removeAll();
				workprocessContainerObj.add(
				{
					xtype : 'workprocesses',
					id : 'workprocessesWidgetCont',
					data1:jsonData.workProcess[0][0],					
					data2:jsonData.workProcess[1][0],
					padding:0,				
				});
			}
		}else{
			var workprocessContainerObj = Ext.getCmp('workprocessContainer');
			workprocessContainerObj.removeAll();
			workprocessContainerObj.add(
			{
					xtype : 'panel',
					cls: '',
					padding: '0px 0 0',
					height : '100%',
					margin: '0px 0 0px',
					html : '<div class="newFont_bold14" style="position:absolute;padding: 10px 10px;">'+workProcessesLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'				
			});
		}

		var logginVsActiveObj=Ext.getCmp('logginVsActive_Id');
		if(!Ext.isEmpty(logginVsActiveObj))
		{
			logginVsActiveObj.updateData(jsonData.loginAndActiveUsers[0][0]);
		}

		var jobStatisticsgrid = Ext.getCmp('jobStatistics_grid');
		jobStatisticsgrid.getStore().removeAll();
		jobStatisticsgrid.getStore().loadRawData(jsonData.jobStatistics[0].gridData,true);

		if(!Ext.isEmpty(jsonData.bufferSwap[0]))
		{	
			var bufferswapObj=Ext.getCmp('multBarIns_overview');
			if(!Ext.isEmpty(bufferswapObj))
			{
				bufferswapObj.updateChart(jsonData.bufferSwap);
			}else{
				var bufferswapContainer = Ext.getCmp('bufferswap');
				bufferswapContainer.removeAll();
				bufferswapContainer.add({

					xtype:'chartparentpanel',
					id:'multBarIns_overview',
					data:jsonData.bufferSwap,
					margin:0,
					padding: 0,						
					flex:1,
					layout:{
					type: 'vbox',
					align:'stretch'
					},
					defaults:{
						flex:1
					},
					isSAP:true										
				});
			}
		}else{
			var bufferswapContainer = Ext.getCmp('bufferswap');
			bufferswapContainer.removeAll();
			bufferswapContainer.add({
					xtype : 'panel',
					cls: '',
					padding: '0px 0 0',
					height : '100%',
					margin: '0px 0 0px',
						html : '<div class="newFont_bold14" style="position:absolute;padding: 10px 10px;">'+bufferSwapsLbl+'</div><div style="height:100%;width:100%;display:table"><div  class="msgFont" style="display:table-cell;vertical-align:middle"><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasuresFoundMsg+'</div></div></div>'
				});
		}

		Ext.getCmp('diskActivity').getStore().removeAll();
		if(!Ext.isEmpty(jsonData.diskActivity))
		{	
			Ext.getCmp('diskActivity').store.loadData(jsonData.diskActivity);
			Ext.getCmp('diskactivity-panel').setTitle(jsonData.diskActivity[0]["diskactivityTitle"]);
		}

		var sapMemoryContainer = Ext.getCmp('sapMemory');
		if(!Ext.isEmpty(sapMemoryContainer))
		{
			for(var b in jsonData.sapMemory[0].sapMemory)
			{		
				var sapMemoryObj=Ext.getCmp('sapMemory'+b);
				if(!Ext.isEmpty(sapMemoryObj))
				{
					sapMemoryObj.updateData(jsonData.sapMemory[0].sapMemory[b]);
				}				
			}
		}
	
		if(jsonData.actTrans[0]!=null && !Ext.isEmpty(jsonData.actTrans[0]))
		{
			var gridID1Add = Ext.getCmp('gridID1');
			gridID1Add.getStore().removeAll();
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel'))){
				Ext.getCmp('emptyPanel').hide();
				
			}
			Ext.get('gridID1').removeCls('border_less');
			gridID1Add.getStore().loadRawData(jsonData.actTrans[0].gridData,true);
		}else{
			var gridID1Add = Ext.getCmp('gridID1');
			Ext.each(Ext.getCmp('gridID1').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID3').addCls('border_less');
			gridID1Add.getStore().removeAll();
			gridID1Add.store.loadData('');		
		}
		
		if(jsonData.actUser[0]!=null && !Ext.isEmpty(jsonData.actUser[0]))
		{
			var gridID2Add = Ext.getCmp('gridID2');
			gridID2Add.getStore().removeAll();
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel2'))){
				Ext.getCmp('emptyPanel2').hide();
				
			}
			Ext.get('gridID2').removeCls('border_less');
			gridID2Add.getStore().loadRawData(jsonData.actUser[0].gridData,true);
		}else{
			var gridID2Add = Ext.getCmp('gridID2');
			Ext.each(Ext.getCmp('gridID2').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID3').addCls('border_less');
			gridID2Add.getStore().removeAll();
			gridID2Add.store.loadData('');
		}

		if(jsonData.actTask[0]!=null && !Ext.isEmpty(jsonData.actTask[0]))
		{
			var gridID3Add = Ext.getCmp('gridID3');
			if(!Ext.isEmpty(Ext.getCmp('emptyPanel3'))){
				Ext.getCmp('emptyPanel3').hide();
				
			}
			gridID3Add.getStore().removeAll();
			Ext.get('gridID3').removeCls('border_less');
			gridID3Add.getStore().loadRawData(jsonData.actTask[0].gridData,true);
		}else{
			var gridID3Add = Ext.getCmp('gridID3');
			Ext.each(Ext.getCmp('gridID3').columns,function(d){
				this.hidden =  true;
				
			}); 
			Ext.get('gridID3').addCls('border_less');
			gridID3Add.getStore().removeAll();
			gridID3Add.store.loadData('');
		}				
	},

	showDumpsDDPopupWindow:function()
	{
		var win = Ext.widget('drillwindow', {
			blockId : 'dumps',
			listeners:
			{
				show: function(win)
				{
					Ext.getBody().mask('loading');
					var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
					var selectedComp = SAPdashboard_combo.getValue();
					var URLparams = "loadSAPCombo=false&selectedComp="+encodeURIComponent(selectedComp)+"&action=loadDumpsDDPopup";
			
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.egSAPDashboardController',
						scope: this,
						method : 'POST',
						params :URLparams,
						success: function(response)
						{
							var jsonData = Ext.decode(response.responseText);
							win.setTitle(DumpMessagesLbl);

							if(jsonData.DDDumpsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDDumpsPopupJson[0]) )
							{

								var gridColsDumbs = jsonData.DDDumpsPopupJson[0].gridColumns;
								var colsArrDumbs = [];
								var fields2StoreDumbs = [];

								for (var colVal in gridColsDumbs) 
								{
									var colName = gridColsDumbs[colVal];
													
									fields2StoreDumbs.push({
										name : colVal,
										type : 'FLOATORSTRING'
									});

									if(colVal=='Column_0'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											width:'168',
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
									if(colVal=='Column_1'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											width:'102',
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
									if(colVal=='Column_2'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											width:'153',
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
									if(colVal=='Column_3'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											width:'130',
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}	
										});
									}
									if(colVal=='Column_4'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											width:'140',
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
									if(colVal=='Column_5'){
										colsArrDumbs.push({
											header: colName,
											dataIndex: colVal,
											flex:1,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
								}

								if(jsonData.DDDumpsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDDumpsPopupJson[0]))
								{
									var dumpsGridObj = Ext.getCmp('dumpsGrid');
									var storeVal3 = Ext.create('Ext.data.Store',{
										fields:fields2StoreDumbs,
										data:jsonData.DDDumpsPopupJson[0].gridJson,
									});
									dumpsGridObj.reconfigure(storeVal3,colsArrDumbs);
								}
							}else{
								var dumpsGridObj = Ext.getCmp('dumpsGrid');
								dumpsGridObj.getStore().removeAll();
								dumpsGridObj.store.loadData('');
							}
							Ext.getBody().unmask();
						}		
					});
				},
				hide: function(win)
				{
					Ext.getBody().unmask();
				}
			}
		});
						
		if (win != null) {
			win.show();
		}
	},
	showStepsDDPopupWindow:function()
	{
		var win = Ext.widget('slowstepsdrillwindow', {
			blockId : 'slowStepswindow',
			listeners:
			{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[0]);
							el.addCls('windowModal');
					}

					Ext.getBody().mask('loading');
					win.setTitle(slowStepsTitleLbl);
					var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
					var selectedComp = SAPdashboard_combo.getValue();
					var URLparams = "loadSAPCombo=false&selectedComp="+encodeURIComponent(selectedComp)+"&action=loadSlowStepsDDPopup";
					
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.egSAPDashboardController',
						method : 'POST',
						scope: this,
						params :URLparams,
						success: function(response)
						{
							var jsonData = Ext.decode(response.responseText);
							if(jsonData.DDSlowStepsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDSlowStepsPopupJson[0]) )
							{
								var gridColsSteps = jsonData.DDSlowStepsPopupJson[0].gridColumns;
								var colsArrSteps = [];
								var fields2StoreSteps = [];

								for (var colVal in gridColsSteps) 
								{
									var colName = gridColsSteps[colVal];
												
									fields2StoreSteps.push({
										name : colVal,
										type : 'FLOATORSTRING'
									});

									if(colVal=='Column_0'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:100,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else if(colVal=='Column_1'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:100,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else if(colVal=='Column_2'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:125,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else if(colVal=='Column_3'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:100,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}	
										});
									}else {
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:100,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
								}

								if(jsonData.DDSlowStepsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDSlowStepsPopupJson[0]))
								{
									var slowStepsGridObj = Ext.getCmp('slowStepsGrid');
									var storeVal3 = Ext.create('Ext.data.Store',{
										fields:fields2StoreSteps,
										data:jsonData.DDSlowStepsPopupJson[0].gridJson,
									});
									slowStepsGridObj.reconfigure(storeVal3,colsArrSteps);
								}
							}else{
								var slowStepsGridObj = Ext.getCmp('slowStepsGrid');
								slowStepsGridObj.getStore().removeAll();
								slowStepsGridObj.store.loadData('');
							}	
							Ext.getBody().unmask();
						}
					});
				},
				hide: function(win)
				{
					Ext.getBody().unmask();
				}
			}
		});
		
		if (win != null) {
			win.show();
		}
	},
	showInfoBasedStepsDDPopupWindow:function(measure,topInfosList)
	{
		var enableGridSorter = false; 
		if(measure == '7'){
			enableGridSorter = true;
		}
		
		var win = Ext.widget('slowstepsdrillwindow', {
			blockId : 'slowStepswindow',
			listeners:
			{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[0]);
							el.addCls('windowModal');
					}
					Ext.getBody().mask('loading');
		
					var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
					var selectedComp = SAPdashboard_combo.getValue();
				
					var URLparams = "loadSAPCombo=false&selectedComp="+encodeURIComponent(selectedComp)+"&action=loadSortedSlowStepsDDPopup&selMeasure="+encodeURIComponent(measure)+"&topInfos="+encodeURIComponent(topInfosList);
								
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.egSAPDashboardController',
						method : 'POST',
						scope: this,
						params :URLparams,
						success: function(response)
						{
							var jsonData = Ext.decode(response.responseText);
							if(jsonData.DDSlowStepsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDSlowStepsPopupJson[0]) )
							{
								if(jsonData.DDSlowStepsPopupJson[0].slowStepsTitle!=null && !Ext.isEmpty(jsonData.DDSlowStepsPopupJson[0].slowStepsTitle) )
								{
									win.setTitle('<div class="newFont_bold14" >'+'Slowest steps by '+jsonData.DDSlowStepsPopupJson[0].slowStepsTitle+'</div>');
								}
								var gridColsSteps = jsonData.DDSlowStepsPopupJson[0].gridColumns;
								var colsArrSteps = [];
								var fields2StoreSteps = [];

								for (var colVal in gridColsSteps) 
								{
									var colName = gridColsSteps[colVal];
												
									fields2StoreSteps.push({
										name : colVal,
										type : 'FLOATORSTRING'
									});

									if(colVal=='Column_0'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:110,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else if(colVal=='Column_1'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:90,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else if(colVal=='Column_2'){
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:125,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}else {
										colsArrSteps.push({
											header: colName,
											dataIndex: colVal,
											width:100,
											renderer : function(value, metaData, record, row, col, store, gridView) {
												var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
												return value; 								
											}
										});
									}
								}

								var storeVal3="";
								if(jsonData.DDSlowStepsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDSlowStepsPopupJson[0]))
								{
									var slowStepsGridObj = Ext.getCmp('slowStepsGrid');
											
									if(enableGridSorter == true){
										storeVal3 =new Ext.create('Ext.data.Store',{
											fields:fields2StoreSteps,
											data:jsonData.DDSlowStepsPopupJson[0].gridJson,
											sortableColumns:enableGridSorter,
											sortOnLoad : enableGridSorter,
											sorters : {
												property : 'Column_12',
												direction : 'desc'
											}
										});	
									}else{
										storeVal3 =new Ext.create('Ext.data.Store',{
											fields:fields2StoreSteps,
											data:jsonData.DDSlowStepsPopupJson[0].gridJson,
										});
									}
									slowStepsGridObj.reconfigure(storeVal3,colsArrSteps);
									slowStepsGridObj.getView().refresh();
								}
							}else{
								win.setTitle('Slowest steps');
								var slowStepsGridObj = Ext.getCmp('slowStepsGrid');
								slowStepsGridObj.getStore().removeAll();
								slowStepsGridObj.store.loadData('');
							}		
							Ext.getBody().unmask();
						}
					});
				},
				hide: function(win)
				{
					Ext.getBody().unmask();
				}
			}
		});
		
		if (win != null) {
			win.show();
		}
	},
	showJobStatisticsPopupWindow:function(measureName)
	{
		var win = Ext.widget('slowstepsdrillwindow', {
			blockId : 'jobStatisticswindow',
			listeners:
			{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
							var el = Ext.fly(dom[0]);
							el.addCls('windowModal');
					}
					Ext.getBody().mask('loading');
					win.setTitle('JobStatisticsPopupWindow');
					var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
					var selectedComp = SAPdashboard_combo.getValue();
					var URLparams = "loadSAPCombo=false&selectedComp="+encodeURIComponent(selectedComp)+"&action=loadJobStatisticsDDPopup&selMeasure="+encodeURIComponent(measureName);
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.egSAPDashboardController',
						method : 'POST',
						scope: this,
						params :URLparams,
						success: function(response)
						{
							var jsonData = Ext.decode(response.responseText);
							if(jsonData.DDJobStatisticsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDJobStatisticsPopupJson[0]))
							{
								win.setTitle('Details of '+measureName);
								var gridColsJobs = jsonData.DDJobStatisticsPopupJson[0].gridColumns;
									var colsArrJobs = [];
									var fields2StoreJobs = [];
									for (var colVal in gridColsJobs) 
									{
										var colName = gridColsJobs[colVal];
										fields2StoreJobs.push({
											name : colVal,
											type : 'FLOATORSTRING'
										});
										var widthCol;
										if(colVal=='Column_0'){
											if(measureName=='Aborted or cancelled jobs'){
												widthCol  = {
												header: colName,
												dataIndex: colVal,
												width:130,
												renderer : function(value, metaData, record, row, col, store, gridView) {
													var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
													return value; 								
												}
												};
											}else{
												widthCol  = {
													header: colName,
													dataIndex: colVal,
													flex:1,
													renderer : function(value, metaData, record, row, col, store, gridView) {
														var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
														return value; 								
													}
												};
											}
											colsArrJobs.push(widthCol);
										}else if(colVal=='Column_2'){
											colsArrJobs.push({
												header: colName,
												dataIndex: colVal,
												width:130,
												renderer : function(value, metaData, record, row, col, store, gridView) {
													var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
													return value; 								
												}
											});
										}else if(colVal=='Column_8' && measureName=='Aborted or cancelled jobs'){
											colsArrJobs.push({
												header: colName,
												dataIndex: colVal,
												width:500,
												renderer : function(value, metaData, record, row, col, store, gridView) {
													var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
													return value; 								
												}
											});
										}else {
											colsArrJobs.push({
												header: colName,
												dataIndex: colVal,
												width:100,
												renderer : function(value, metaData, record, row, col, store, gridView) {
													var value = '<span style="cursor:default;"data-qtip="' + value + '">' + value + '</span>';
													return value; 								
												}
											});
										}
									}
									var storeVal3="";
									if(jsonData.DDJobStatisticsPopupJson[0]!=null && !Ext.isEmpty(jsonData.DDJobStatisticsPopupJson[0]))
									{
										var JobsGridObj = Ext.getCmp('slowStepsGrid');
										storeVal3 =new Ext.create('Ext.data.Store',{
											fields:fields2StoreJobs,
											data:jsonData.DDJobStatisticsPopupJson[0].gridJson,
										});
										Ext.get('slowStepsGrid').removeCls('border_less');
										JobsGridObj.reconfigure(storeVal3,colsArrJobs);
										JobsGridObj.getView().refresh();
									}
							}else{
								win.setTitle('Details of '+measureName);
								var JobsGridObj = Ext.getCmp('slowStepsGrid');
								Ext.each(Ext.getCmp('slowStepsGrid').columns,function(d){
									this.hidden =  true;
				
								}); 
								Ext.get('slowStepsGrid').addCls('border_less');
								JobsGridObj.getStore().removeAll();
								JobsGridObj.store.loadData('');
							}	
							Ext.getBody().unmask();
						}
					});
				},
				hide: function(win)
				{
					Ext.getBody().unmask();
				}
			}
		});
		if (win != null) {
			win.show();
		}
	},

	loadTasktypeDetails:function(infoName)
	{
		var SAPdashboard_combo = Ext.getCmp('SAP_dashboard_combo');
		var selectedComp = SAPdashboard_combo.getValue();

		var URLparams = "loadSAPCombo=false&selectedComp="+encodeURIComponent(selectedComp)+"&action=loadTasktypeDetails&selectedDesc="+encodeURIComponent(infoName);

		Ext.Ajax.request({
			url: '/final/servlet/com.eg.egSAPDashboardController',
			scope: this,
			params :URLparams,
			method : 'POST',
			success: function(response)
			{
				var jsonData = Ext.decode(response.responseText);
				if(jsonData.errorMsg != '-'){					
									
					if(jsonData.TasktypeDetailsJson !=null)
					{
						selectedInfo= jsonData.TasktypeDetailsJson[0].selectedDesc;
						Ext.getCmp('saptopology').store.loadData(jsonData.TasktypeDetailsJson);
					}
				}
			}
		});

	}
});