Ext.define('SessionsConnectedModel1', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'graphID', type:'string' }
    ]
});

var AlertsTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
	'<div class="s_box">',
		 '<div style="float:left;width:100%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span class="font_bold14 " >{heading}</span></div>',
		 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
		 '<div style="clear:both"></div>',
		 '</div>',
        '<div class="b_box">',
		  '<div class="font_bold14"><span>{heading}</ span></div>',
			 '<div  style="text-align:center;width:260px;height:370px;float:left;margin-top:10px" id="session-graph"></div>',
			 '</div>',
        '</div>',
    '</tpl>',
	'</div>'
);

Ext.define('ABAPDashboard.view.SAPSessionsConnected', {
     extend: 'Ext.panel.Panel',
	alias:'widget.sapsessionsconnected',
	ui:'uniqueSessions',
	autoDestroy:true,
	items:[],
	data:'',
	layout: {
         type: 'vbox',
        align: 'stretch'
     },
	updateData:function(refData){
		var	jsonData1 = '';
		if(!Ext.isEmpty(refData)){
			try
			{
				var lineChart = {};	
				if(!Ext.isEmpty(refData.Error) && refData.Error != undefined && refData.Error != null){
					jsonData1 = null;
				}else{
					lineChart = jQuery.extend(true, {},getHighchartsForArea('session-graph'+this.id,null,null,''), lineChart);
					lineChart.setData(refData,mgrDateFormat,'','','bottom');
					jsonData1 = lineChart.highchart;
				}								
			}
			catch (eer)
			{
				console.log("eer=-=->",eer)
			}
		}
		
		if(jsonData1 == null)
			$('#session-graph_'+this.id).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>'); 
		else
			$('#session-graph_'+this.id).highcharts(jsonData1);			
	},
	listeners:{
		afterrender:function(e){
			var chartData = this.data;
			var isFromSapDB = this.isFromSapDB;
			var gId = this.id;

			if(!Ext.isEmpty(this.isFromSapDB) && this.isFromSapDB)
			{	
				areaChartTpl = new Ext.XTemplate(
					'<div class="widgetholders ">',
					'<tpl for=".">',
						'<div class="b_box1">',
						  '<div class="newFont_bold14 fontStyleRobot" style="padding:10px 10px 0 10px;">'+loggedAndActiveLbl+'<span class="sap_hours newFont_normal9">'+lastHourLbl+'</ span></div>',
							 '<div  class="" style="border:0px solid blue !important;width:100%;text-align:center;height:188px;float:left;padding:0px 10px 10px 5px;" id="session-graph_'+gId+'"></div>',
							 '</div>',
						'</div>',
					'</tpl>',
					'</div>'
				);
			}
			this.add({
				xtype:'dataview',
				store: Ext.create('Ext.data.Store', {
					model: 'SessionsConnectedModel1',
					autoLoad:true,
					data:chartData
				}),
				tpl: areaChartTpl,
				autoDestroy:true,
				listeners:{
					'resize':function(x){
						var sesHighObj = $('#session-graph_'+gId).highcharts();
					},
					viewready:function(x){
						var	jsonData = '';
						if(!Ext.isEmpty(chartData)){
							try
							{
								var lineChart = {};	
								if(!Ext.isEmpty(chartData.Error) && chartData.Error != undefined && chartData.Error != null){
									jsonData = null;
								}
								else
								{
									if(!Ext.isEmpty(chartData.legendEnabled) && chartData.legendEnabled)
										chartData["legendEnabled"] = true;
									else
										chartData["legendEnabled"] = false;

									lineChart = jQuery.extend(true, {},getHighchartsForArea('session-graph'+gId,null,null,''), lineChart);
						
									lineChart.setData(chartData,mgrDateFormat,'','','bottom');
									jsonData = lineChart.highchart;
								}								
							}
							catch (eer)
							{
								console.log("eer=-=->",eer)
							}
						}
						if(jsonData == null)
							$('#session-graph_'+gId).html('<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+noMeasuresFoundMsg+'</div></div></div>'); 
						else
							$('#session-graph_'+gId).highcharts(jsonData);
							
					},
				}
			
			});
		}
	 }
 });

