Ext.define('ABAPDashboard.view.WorkProcesses', {
    extend: 'Ext.view.View',
    alias: 'widget.workprocesses',
    initComponent: function() {
        var me = this;
        me.callParent();
    },
    height: 100,
    padding: '0',
	id:'workprocesses',
    data1: null,
    data2: null,
    data: [{
        "workprocesslegend": [{
                "labelcolor": "running",
                "legend": runningLbl,
            },
            {
                "labelcolor": "hold",
                "legend": holdLbl,
            },
			{
                "labelcolor": "free",
                "legend": freeLbl,
            },
            {
                "labelcolor": "priv",
                "legend": stoppedLbl,
            }
        ]

    }],
    itemSelector: 'div.thumb-wrap',
    emptyText: 'No Data Available',
    tpl: new Ext.XTemplate(
		'<tpl for=".">',
        '<div  class="b_box">',
        '<div class="newFont_bold14" style="padding:10px 10px 7px 10px">'+workProcessesLbl+'<span></span><img src="../images/clear.png" style="vertical-align: middle;cursor:pointer;position: absolute;right: 0px;top: 0;"/></div>',
                    
        '<div  class="workprocesslegend" style="text-align:center;">',
        '<ul style="display:inline-block;">',
        '<tpl for="workprocesslegend" >',
        '<li style="float:left; text-align:center"><div><span class="legend_{labelcolor}"  ></span><span  class="font_normal9" style="margin-right:10px;">{legend} </span><!--<span class="legend_name" style="margin-right:10px;">{value}</span>--></div></li>',
        '</tpl>',
        '</ul>',
        '<div class="workprocesscharts" style="clear:both; padding : 0 0px 0 0; margin-top:-8px; width:100%;">',
        '<div id="workprocessA" style="width:50%; height:90px;  float:left;"></div>',
        '<div id="workprocessB" style="width:50%; height:90px;  float:left;"></div>',
        '</div>',
        '</div>',
        '</div>',
        '</tpl>'
    ),
    updateChart: function(data1,data2) {
        var me = this;
		var chartDataA = me.data1['series'],
		chartDataB = me.data2['series'],
		chartCategoriesA = me.data1['xLabel'],
		chartCategoriesB = me.data2['xLabel'];
        $('#workprocessA').highcharts(me.chartProps(chartDataA,chartCategoriesA));
        $('#workprocessB').highcharts(me.chartProps(chartDataB,chartCategoriesB));
    },
	chartProps:function(series,categories){
			var me = this;
			var chartProps = {
                    chart: {
                        type: 'bar',
                         reflow: true,
						resizeChart:false
                    },
                    title: {
                        text: '',
                    },
                    tooltip: {
                        enabled: false
                    },
                    exporting: {
                        enabled: false
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: categories, //me.data1['xLabel'],
                        className: 'highcharts-cat-color',
                        labels: {
                            style: {
                                color: strSkin=='Dark' ? "#c3c3c3" : "#000000",
								textShadow: false,
								textOutline: 0
                            },
                            text:{
                            	fill:'#c6c6c6'
                            }
                        },
                        visible: true,
						textShadow: false,
						textOutline: 0,
                        gridLineWidth: 0,
                        minorGridLineWidth: 0,
                        lineWidth: 0,
                        lineColor: '#fff',
                        tickWidth: 0,
                    },
                    yAxis: {
					
                        visible: false,
                        gridLineWidth: 0,
                        minorGridLineWidth: 0,
                        labels: {
                            enabled: false
                        }
                    },
                    legend: {

                        enabled: false,

                    },
                    tooltip: {
						shape: 'square',
						style: {
							color : 'black',
							fontFamily: 'Arial',
							fontSize: '11px',
						}, 
						formatter: function() {
							return '' + this.y + ' '+ this.series.name;
						}
					},
                    spacing: 20,
                    plotOptions: {
                        series: {
                            stacking: 'percent',
                            borderColor: '#e1e1e1',
                            pointWidth: 11,
                            borderWidth: 1,
                            pointPadding: 16,
                            dataLabels: {
                                enabled: true,
								textShadow: false,
								textOutline: 0,
                                formatter: function() {
                                    if (this.y > 0)
                                        return this.y;
                                },
                                style: {
                                    "fontSize": "9px",
									"textOutline": 0
                                }

                            },
                            point: {
                                events: {
                                    mouseOver: function () {                                         
                                    }
                                }
                            },
                        }
                    },
                    series: series //me.data1['series']
                }
			return chartProps;
	},
    
    listeners: {
    	 resize: function() { 
         },
        viewready: function(cmp) {
            var me = this;
            if (me.data1 != null && me.data2 != null) {
				var chartDataA = me.data1['series'],
				chartDataB = me.data2['series'],
				chartCategoriesA = me.data1['xLabel'],
				chartCategoriesB = me.data2['xLabel'];
                $('#workprocessA').highcharts(me.chartProps(chartDataA,chartCategoriesA));
                $('#workprocessB').highcharts(me.chartProps(chartDataB,chartCategoriesB));
            } else {
                console.log('ERROR');
            }
        }
    }
});