Ext.define('AppFlowDashboard.controller.Main',
{
	extend : 'Ext.app.Controller',
	requires: [
        'AppFlowDashboard.view.AppFlowTopology',
        'AppFlowDashboard.view.AppflowKPIHeader'
    ],
	refs : [{
		ref : 'mainform',
		selector : 'mainform'
	}],
	init : function() 
	{
		setInterval("refresh()", refreshFrequency);
		this.control({
			'mainform':
			{
				'render':this.mainFormLoad
			},
			'mainform button[id="backButton"]':
			{
				'click': this.goBack
			},
			'button[itemId="overviewtoggle"]': {
                toggle: this.toggleOverView
            },
			'combo[name="timeLineId"]': {
                change: this.loadTimeline
            },
		});

		if(Ext.get('loadingMask')){
			Ext.get('loadingMask').hide();
		}
		//alert('AppFlowDashboard')
	},
	loadTimeline: function()
	{
		var timeline = null;
		if(!Ext.isEmpty(Ext.getCmp('timeLineId')))
			timeline = Ext.getCmp('timeLineId').getValue();
		var applicationNameele = "";
		var contId = Ext.getCmp('mainContainer');
		if(!Ext.isEmpty(contId) && !Ext.isEmpty(contId.addParam))
		{
			applicationNameele = contId.addParam;
		}
		this.goToAppDetailsPage(applicationNameele,timeline);
	},
	toggleOverView: function(btn, pressed, eOpts) {
		var me = this,
		toggleOuterEl = Ext.get('appflowkpiheader'),
		toggleIn = 58,
		toggleOut = 131,
		toggleDuration = 250,
		sbox = Ext.get('appflowkpiheader').select('.b_box'),
		bbox = Ext.get('appflowkpiheader').select('.s_box');
		//alert(pressed);
		if (!pressed) {
          //  btn.setText("<b>+</b>");
          btn.setIconCls('toggle_p');
            Ext.getCmp('appflowkpiheader').suspendLayouts();
            bbox.setStyle('display', 'none');
            sbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleIn
                },
                listeners: {
                    beforeanimate: function() {
						bbox.animate({
							duration: 200,
                            to: {
								opacity:0
                            }
                        });
                        sbox.animate({
							 duration: 300,
                            to: {
								opacity:1
                            }
                        });
                    },
                    afteranimate: function() {
                        Ext.getCmp('appflowkpiheader').setHeight(toggleIn);
						sbox.stopAnimation();
						bbox.stopAnimation();
						
                        //Ext.get('appflowkpiheader').doLayout();
                    }
                }
            });
            Ext.getCmp('appflowkpiheader').resumeLayouts(true);

        } else if (pressed){

           // btn.setText("<b>-</b>");
            btn.setIconCls('toggle_m');
			 Ext.getCmp('appflowkpiheader').suspendLayouts();
				bbox.setStyle('display', 'block');
			 sbox.setStyle('display', 'none');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleOut
                },
                listeners: {
                    beforeanimate: function() {
                        sbox.animate({
							duration: 300,
                            to: {
								opacity:0
                            }
                        });
                        bbox.animate({
							 duration: 200,
                            to: {
								opacity:1
                            }
                        });
						 Ext.getCmp('appflowkpiheader').setHeight(toggleOut);
                    },
                    afteranimate: function() {
						 Ext.getCmp('appflowkpiheader').setHeight(toggleOut);
						sbox.stopAnimation();
						bbox.stopAnimation();
                        //Ext.get('appflowkpiheader').doLayout();
                    }
                }
            });
			Ext.getCmp('appflowkpiheader').resumeLayouts(true);
        }
		Ext.getCmp('mainContainer').doComponentLayout();
		//this.getMain().doComponentLayout();
    },
	goBack : function()
	{
		var url = '/final/monitor/AppFlowDashboard.jsp?isAppFlow=true&iniName=eg_dashboardConfig.ini';
		/*try
		{
			if(!Ext.isEmpty(params))
				url +="&"+params;
		}
		catch (e)
		{
		}*/
		window.location.href=url;		
	},
	refresh : function()
	{
		var backbutton = Ext.getCmp('backButton');
		if(!Ext.isEmpty(backbutton) && backbutton.isHidden())
		{
			this.mainFormRender();
		}
		else
		{
			var paramele = "";
			var contId = Ext.getCmp('mainContainer');
			if(!Ext.isEmpty(contId) && !Ext.isEmpty(contId.addParam))
			{
				paramele = contId.addParam;
			}
			this.goToAppDetailsPage(paramele);			
		}
	},
	mainFormLoad : function()
	{
		if(isMainReq)
			this.mainFormRender();
		else
			this.goToAppDetailsPage(applicationName);
	},
	mainFormRender : function()
	{		
		var url = "/final/servlet/com.eg.EgCommonDashboardController?isMainPage=true";
		try
		{
			if(!Ext.isEmpty(params))
				url +="&"+params;
		}
		catch (e)
		{
		}
		var me = this;

		var resultObj = Ext.getCmp('mainId');
		var jsonDataObj =null;
		Ext.getBody().mask("Loading...");
		Ext.Ajax.request({
			url:url,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				if (!Ext.isEmpty( jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonDataObj = jsonData;
					delete jsonText;
					Ext.destroy(jsonText);
					jsonText = null;
					Ext.getCmp('mainId').setTitle('<div id="titleDiv" style="float:left">'+pageTitle+'</div>');

					if (!Ext.isEmpty(jsonData))
					{
						if (!Ext.isEmpty( resultObj))
						{
							var resultItems=resultObj.items.items;
							for(var item=resultItems.length-1; item>-1 ; item--)
							{
								resultItems[item].destroy()
							}
						}

						if(!Ext.isEmpty(jsonData.noData))
						{
							var errorMsg='<div style="display:table;height:100%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconExclamation"></div><div>No Data Found!</div></div></div>';
							var err ={
										xtype:'panel',
										html:errorMsg
									};
							Ext.getCmp('mainId').add(err);
						}
						else if (!Ext.isEmpty(jsonData.appDetailsArray))
						{
							var appDetailsJson = jsonData.appDetailsArray;
							for(var item=0; item<appDetailsJson.length; item++)
							{
								var appDetailItem = appDetailsJson[item];
								var title= "<div style='float:left'><a href='javascript:void(0);' onclick=\"goToAppDetailsPage('"+appDetailItem.appName+"',false);\">"+appDetailItem.appName+"</a> </div>";

								var site = {
									xtype:'panel',
									//cls:'rumDatapanel rumRequestPanelPadding',
									ui:'rumPanel',
									id:'site_'+item,
									name:'site',
									title:'<span class="newFont_bold16">'+title+'</span>',
									margin:'10 10 10 10',
									//baseCls:'rumLeft rumRight',
									//style:{'border':'0px solid red'},
									height:170,
									border:true,
									collapsible: false,
									frame:false,
									idNo:item,
									bodyPadding:'14 0 10 0',
									layout:'column',
									//align:'fit',
									width:'100%',
									appDetailItem:appDetailItem,
									defaults:{/*columnWidth:.24,*/padding:'0 0 0 0'},
									items:[],
									listeners:{
										'afterrender': function(thisObj){
											var appDetailArray = this.appDetailItem.details;
											if(appDetailArray.length==0)
											{
												var errorMsg='<center><div style="margin:2% 0 auto 0"><div class="iconExclamation" ></div><div class="commonErrorMsgText">No Traffic Detected</div></div></center>';
												thisObj.setTitle(noLinkTitleVal);
												var err ={
															xtype:'container',
															columnWidth:1.0,
															html:errorMsg
														};
												thisObj.add(err);
											}
											else
											{
												for(var mditem=0; mditem<appDetailArray.length; mditem++)
												{
													var appDetailItemJson=appDetailArray[mditem];
													if(Ext.isEmpty( appDetailItemJson) || appDetailItemJson.length == 0)
													{
														var errorMsg='<table height="100%" align="center" style="margin:2% auto"><tr><td ><img style="margin-top:-2px" src="/final/images/spacer.gif" class="iconAlert"/></td><td>&nbsp;<span class="rumGraphErrorMsgText">Daily limit has been exceeded</span></td><tr></table>';
														var err ={
															xtype:'container',
															columnWidth:1.0,
															html:errorMsg
														};
														thisObj.add(err);
													}
													else
													{
														var topDataVal = appDetailItemJson.title;
														var conDiv = "";
														var panelWidth = "33%";
														if(mditem == 0)
															panelWidth = "20%";
														else if(mditem == 1)
															panelWidth = "60%";
														else if(mditem == 2)
															panelWidth = "19%";
														conDiv=conDiv+"<div >";
														conDiv=conDiv+"<div class='d_m_l10 appflowHeader newFont_bold15' style='text-align:left;' data-qclass='yellowTip'>"+topDataVal+"</div>";
														conDiv=conDiv+"</div><div class='crl'></div>";
														var conMiddleDiv = "";
														var middleDataValArray=appDetailItemJson["AppFlow_Block_"+(mditem+1)];
														for(var t in middleDataValArray)
														{
															if(middleDataValArray.length == 1)
															{
																var unitText = middleDataValArray[t].unitText;
																if(unitText == undefined || unitText == null)
																	unitText = "";
																conMiddleDiv=conMiddleDiv+"<div style='border:0px solid green;display:inline-block;float:none;width:100%;height:60px'><div style='text-align:center;float:none;margin-right:3px'><span style='display:block' class=' newFont_light38'>"+middleDataValArray[t].value+"<span  class=' newFont_normal24' >"+unitText+"</span></span><span style='display:block;' class='d_m_t10 appflowLabel newFont_normal12'>"+middleDataValArray[t].heading+"</span></div></div>";
															}
															else if(middleDataValArray.length == 4)
															{
																var unitText = middleDataValArray[t].unitText;
																if(unitText == undefined || unitText == null)
																	unitText = "";
																conMiddleDiv=conMiddleDiv+"<div style='border:0px solid yellow;display:inline-block;float:none;width:25%;height:60px'><div style='text-align:center;float:none;margin-right:3px'><span style='display:block' class=' newFont_light38'>"+middleDataValArray[t].value+"<span class=' newFont_normal24' >"+unitText+"</span></span> <span style='display:block;' class='d_m_t10 appflowLabel newFont_normal12'>"+middleDataValArray[t].heading+"</div></div>";
															}
															else if(middleDataValArray.length == 2)
															{
																var unitText = middleDataValArray[t].unitText;
																var errorCls="";

																if(unitText == undefined || unitText == null)
																	unitText = "";
																var specTitle = middleDataValArray[t].title;
																if(specTitle == undefined || specTitle == null)
																	specTitle = "";

																if(specTitle=="Java Errors")
																	errorCls="appflowErrorValue";
																//else
																	//errorCls="appflowValue";
																
																var tempHeading = "";
																if(middleDataValArray[t].heading != "Errors")
																	tempHeading = middleDataValArray[t].heading;
																
																tempHeading = tempHeading+' '+specTitle;
																conMiddleDiv=conMiddleDiv+"<div style='border:0px solid orange;display:block;float:left;width:50%;'><div style='text-align:center;float:none;margin-right:3px'><span style=' display: block;height:45px' class=' "+errorCls+" newFont_light38'>"+middleDataValArray[t].value+"<span class=' newFont_normal16 appflowUnit' style='position: absolute;margin-top: 10px;'>"+unitText+"</span><span style='border:0px solid blue;display:block;text-align:center;padding-left:10px;' class='d_m_t10 rumHeaderText newFont_normal12'>"+tempHeading+"</span></span></div></div>";
															}
														}
														var separator={
															xtype:'tbseparator',
															cls:'appflowSeparator',
															height:106,
															padding:0,
															margin:0
														};
														var newPanel = {
															id:'dataConId_'+mditem+'_'+item,
															name:'sitePanelContainer',
															xtype:'container',
															//layout:'column',
															width:panelWidth,
															style:{'text-align':'left !important','border':'0px solid yellow !important'},
															layout:'vbox',
															border:	false,
															height:'auto',
															margin:'0 0 0 0',
															collapsible: false,
															items:[
																{
																	xtype:'component',
																	name:'topPanel',
																	itemid:'top_'+mditem+'_'+item,
																	html:conDiv,
																	align:'center',
																	layout:{type:'vbox',pack:'center'},
																	collapsible: false,
																	style:{'text-align':'left !important','border':'0px solid green !important'},
																	width:'100%'
																},
																{
																	xtype:'component',
																	name:'middlePanel',
																	itemid:'middle_'+mditem+'_'+item,
																	html:conMiddleDiv,
																	align:'center',
																	layout:{type:'vbox',pack:'top',align:'stretch'},
																	height:90,
																	cls:'d_m_t30',
																	collapsible: true,
																	hidden:false,
																	style:{'border':'0px solid red !important','margin-top':'0px  !important','text-align':'center !important'},
																	width:'100%'
																}																					
															]
														};														
														thisObj.add(newPanel);
														if(mditem != 2)
															thisObj.add(separator);
													}
												}
											}
										}
									}
								};
								Ext.getCmp('mainId').add(site);
							}
						}
					}					
				}
				Ext.getBody().unmask();
			}
		});
	},
	goToAppDetailsPage : function(param,timeline)
	{
		var url = "/final/servlet/com.eg.EgCommonDashboardController?application="+param;
		try
		{
			if(!Ext.isEmpty(params))
				url +="&"+params;
		}
		catch (e)
		{
		}
		if(timeline != undefined && timeline != null)
			url +="&timeline="+timeline;
		else
		{
			url +="&timeline="+req_timeline;
			timeline = req_timeline;
		}
		
		// console.log("url=-=-=-=->>",url)
		var me = this;
		var resultObj = Ext.getCmp('mainId');
		var jsonDataObj =null;
		Ext.getBody().mask("Loading...");
		Ext.Ajax.request({
			url:url,
			timeout:300000,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonDataObj = jsonData;
				delete jsonText;
				Ext.destroy(jsonText);
				Ext.getCmp('mainId').setTitle('<div id="titleDiv" style="float:left">'+pageTitle+' - '+param+'</div>');

				if (!Ext.isEmpty(jsonData))
				{
					if (!Ext.isEmpty( resultObj))
					{
						var resultItems=resultObj.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy()
						}
					}
					///resultObj.layout.type= "fit";
					//Ext.apply(resultObj,{layout:{type:'fit'}});
					resultObj.add({
						xtype: 'container',
						flex:1,
						layout: {
							type: 'vbox',
							align: 'stretch'
						},
						id:"mainContainer",
						addParam:param,
						items: [],
						listeners:{
							'afterrender':function(e)
							{
								// console.log("timeline=-=-=-=->>",timeline)
								this.add(
								/*{
									xtype: 'appflowkpiheader',
									id:'appflowkpiheader',
									jsonData: jsonData,
									height:58
								},*/
								{
									xtype: 'appflowtopology',
									param:this.addParam,
									flex : 1,
									timeline : timeline,
									margin : '10 10 10 10'
								});
							}
						}
						
					});
					resultObj.doLayout();
					var backButton = Ext.getCmp('backButton');
					backButton.show();
					var timelineCombo = Ext.getCmp('timeLineId');
					timelineCombo.show();
				}
				Ext.getBody().unmask();
			}
		});
	}
});