	/* Defines the backend UI  
     * @param selector is the current node 
     */
	Ext.define('AppFlowDashboard.util.BackEndTierUI', {
	override: 'AppFlowDashboard.view.AppFlowTopology',
	constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
	 backendTypeUI: function(selector) {
        var me = this,
        currentGrp = d3.select(selector),
        datax = currentGrp.datum(),
		zoomInnertierUI  = d3.select(selector).append('g').attr('class','zoomInnertierUI'),
        zoomOutertierUI  = d3.select(selector).append('g').attr('class','zoomOuttierUI');
        
        
        var outerbox = zoomInnertierUI.append("path").attr("d", me.roundedRectangleSVG(0, 0, me.backEndDimension.width, me.backEndDimension.height, 3, true, true, true, true)).attr('class', 'tireBox');
        // @ ref AppFlowDashboard.util.ZoomOuttierUI.js
		me.zoomOuttierUI(zoomOutertierUI);
        var outerbox_dimension = outerbox.node().getBBox();
        //Header
        var header = zoomInnertierUI.append("path").attr("d", me.roundedRectangleSVG(0, 0, outerbox_dimension.width, 20, 3, true, true, false, false)).attr('class', 'tireheader');
        var header_dimension = header.node().getBBox();
        zoomInnertierUI.append('line').attr("x1", 0).attr("y1", header_dimension.height).attr("x2", outerbox_dimension.width).attr("y2", header_dimension.height).attr('class', 'headerline');
        zoomInnertierUI.append('text').attr('class', 'svgtext_header_10').text(function(d) {
            return _.truncate(d.displayName, {
                'length': 21,
                'separator': ' '
            });
        }).attrs({
            'x': 5,
            'y': 0,
            'dy': '1.35em'
        });
        var componentIcon = zoomInnertierUI.append('svg:image')
            .attrs({
                'xlink:href': function(d, i) {
                    return '../images/component_icons/svg/'+me.getSkin(skinColor)+'/' + d.iconName + '.svg';
                },
                'width': 32,
                'height': 32,
                'x': 10,
                'y': 38

            });
        //node count and label
        componentIcon.node().getBBox();
        var countG = zoomInnertierUI.append('g').attr('transform', function() {
            return 'translate(' + (componentIcon.node().getBBox().x + componentIcon.node().getBBox().width + 10) + ',' + componentIcon.node().getBBox().y + ')';
        });
        var nodeCountText = countG.append('text').attrs({
            'x': 120,
            'y': 0
        });
        nodeCountText.append('tspan')
            .text(function(d) {
                return d.nodeCount
            }).attrs({
                'x': '10',
                'dy': '15',
                'class': 'svgtext_18',
                'text-anchor': 'end'
            });
        nodeCountText.append('tspan')
            .text(function(d) {
                if (d.componentType) {
                    return d.componentType;
                }
            }).attrs({
                'x': '0',
                'dy': '15',
                'class': 'svgtext_9',
                'text-anchor': 'start'
            }).style("text-transform", "lowercase");
    }
	});