Ext.define('AppFlowDashboard.util.ListofNodeDetails', {
	override: 'AppFlowDashboard.view.AppFlowTopology',
	constructor: function (config) {
		this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
	},
	clickFrom: 1,
	listOfNode: function (selector, ndata, chunk, margintop) {
		//setting up the margintop value
		
		var me = this,
		parent = d3.select(selector),
			datax = parent.datum(),
			outer_dimension = me.getSVGDimension(d3.select(selector.node().parentNode)),
			consolidatedArry = _.map(ndata, function (item) {
				// finds the List of nodeID node JSON
				//console.log('items', item)
				return _.find(me.topologyData.node, {
					'nodeId': item.nodeId
				});
			});
		
		margintop = typeof margintop === 'undefined' ? 0 : margintop;
		if (selector.classed("fromTier")) {
			me.clickFrom = 1;
			margintop = 0;
		} else {
			me.clickFrom = 0;
			margintop = 50;
		}

		chunk = typeof chunk === 'undefined' ? 5 : chunk;
		// default list length is 5 
		if (consolidatedArry.length - 1 > chunk) {
			consolidatedArry.length = chunk
		} else {
			chunk = consolidatedArry.length;
		}
		//consolidatedArry.length = chunk;
		// console.log('consolidatedArry', consolidatedArry);
		if (selector.select('.listGrp')) {
			selector.select('.listGrp').remove();
			selector.select('.area').remove();
		}

		//for 1 tier 
		// a dirty hack to append background 
		parentInner = selector.append('g').attr('class','listGrpInner');
		var outerSVG = "";
		var ourtWidth = selector.node().getBBox().width;
		if (me.clickFrom == 1) {
			me.paginationLength = 5;
			
			outerSVG = parentInner.append('path').attr("d", me.roundedRectangleSVG(0, 0, ourtWidth, 115, 3, 3, 3, 0, 0)).attr('class', 'area');
		}
		//for 0 tierHealth
		else {
			me.paginationLength = 3;
			outerSVG = parentInner.insert('path', '.healthstatchart').attr("d", me.roundedRectangleSVG(0, 0, ourtWidth, 115, 3, 3, 3, 0, 0)).attr('class', 'area');
		}
		//alert(me.paginationLength)
		//Prevent click 
		outerSVG.on('click', function () {
			d3.event.stopPropagation();

		});
		//	console.log('outerSVG',me.getSVGDimension(outerSVG))
		var listGrp = parentInner.append('g').attr('class', 'listGrp').attr('transform', function () {
			return "translate(" + me.getSVGDimension(outerSVG).x + " ," + margintop + ")";
		});

		listGrp.on('click', function () {
			d3.event.stopPropagation();

		});
		//console.log('consolidatedArry', consolidatedArry);
		
		var listG = listGrp.selectAll('.listG').data(consolidatedArry);

		var grp = listG.enter().append('g').attr('id',function(d,i){
			//setting up the node id
			return 'node_'+d.nodeId+'_id';
		}).merge(listG).attr('class', 'listG');


		grp.each(function (d, i) {
			var grp = d3.select(this),
				LISTHEIGHT = 20,
				LISTWIDTH = 144;
			grp.attr('transform', function () {
				return "translate(0 ," + LISTHEIGHT * i + ")";
			});
			var layerrect = grp.append('rect').attr('class', 'layerrect').attr('width', LISTWIDTH).attr('height', LISTHEIGHT);
			d3.select(this).append('line').attr("x1", 0).attr("y1", LISTHEIGHT).attr("x2", LISTWIDTH).attr("y2", LISTHEIGHT).attr('class', 'linex');
			var componentIcon = grp.append('svg:image').attrs({
				'xlink:href': function (d, i) {
					return '../images/component_icons/svg/'+me.getSkin(skinColor)+'/' + d.iconName + '.svg'
				},
				'width': 18,
				'height': 18,
				'x': 5,
				'y': 1
			});
			grp.append('text').attr('class', 'svgtext_9').text(function (d) {
				return _.truncate(d.displayName, {
					'length': 23,
					'separator': ' '
				});
			}).attrs({
				'y': LISTHEIGHT / 2 + 3,
				'x': me.getSVGDimension(componentIcon).x + me.getSVGDimension(componentIcon).width + 5
			});
			grp.append('svg:image')
				.attrs({
					'xlink:href': function (d, i) {
						return me.stateImagePro(d.state);
					},
					'width': 14,
					'height': 14,
					'x': me.getSVGDimension(componentIcon).x + 9,
					'y': me.getSVGDimension(componentIcon).y + 7
				});

		});
				

		
		grp.on('click', function(d,i){
		/* Initialize tooltip */
		me.D3tip = me.toolTip();
		/* Invoke the tip in the context of your visualization */
		me.svg.call(me.D3tip);
		if(Ext.select('#tooltipID_'+d.tierId)){
			
			//Remove if tooltip exists :(
			//d3.selectAll(".listG").classed("active", false);
			d3.select('#tierId_'+d.tierId).selectAll(".listG").classed("active", false);
			Ext.select('#tooltipID_'+d.tierId).remove();
			//adding active class
			d3.select(this).classed("active", true);
			//setting the offset position of the tooltip
			TOOLTIP_WIDTH = LEFT = 200;
			TOOLTIP_HEIGHT = TOP = 200;
			OFFSET_POSITION = 215;
			OFFSET_WIDTH = me.getWidth() - LEFT;
			OFFSET_HEIGHT = me.getHeight() - TOP;
			clickEventX = d3.event.pageX;
			clickEventY = d3.event.pageY;
			//console.log('OFFSET_WIDTH',OFFSET_WIDTH);
			//console.log('OFFSET_HEIGHT',OFFSET_HEIGHT);
			//console.log('LEFT',LEFT);
			// console.log('clickEventX',d3.event.pageX);
			//console.log('clickEventX',d3.event.pageY);
			// node_tooltip.direction('e');
			if (LEFT > clickEventX) {
				me.D3tip.direction('e');
				me.D3tip.offset(function () {
					return [0, 0]
				});
			}
			if (TOP > clickEventY) {
				me.D3tip.direction('n');
				me.D3tip.offset(function () {
					return [OFFSET_POSITION, 0]
				});
			}
			if (OFFSET_HEIGHT < clickEventY) {
				me.D3tip.direction('s');
				me.D3tip.offset(function () {
					return [-OFFSET_POSITION, 0]
				});
			}
			if (clickEventX > OFFSET_WIDTH) {
				me.D3tip.direction('w');
				me.D3tip.offset(function () {
					return [0, 0]
				});
			}
			//showing the tooltip on click @ dependencies /final/scripts/d3.tip.v0.6.3.js
			// close function @ AppFlowDashboard.util.TopologyTooltip.js
			me.D3tip.click(d);

			//insert each ID @ AppFlowDashboard.util.KeyboardEvents
			me.popupArray.push({id:'closeBt_' + d.tierId +'_tooltip'});
		}
		
		});
		listG.exit().remove();
		
		
	}
});