Ext.define('AppFlowDashboard.util.Pagination', {
    override: 'AppFlowDashboard.view.AppFlowTopology',
    constructor: function (config) {
        this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
    },
    pagination: function (selectorx, ndata, chunk) {
        var me = this,
            paginationEl = selectorx,
            PAGINATIONHEIGHT = 20,
            PAGINATIONWIDTH = 144,
            PAGINATIONCORNER = 3,
            LOAD_ANIMATION = 200,
            pageCounter = 1,
            arrayCounter = 0,
            pagenationObj = [],
            pagesof = 1,
            starts = true,
            chunkData = _.chunk(ndata, chunk),
            showingData = chunkData[arrayCounter].length,
            record_per_page = 0,
            totalData = ndata.length;

        //define the pagination length 
        if (me.clickFrom == 1) {
            //i.e is from tier 

        }

        //Remove at first instance
        paginationEl.select('.pagination_g').remove();
        var paginationElGrp = paginationEl.append('g').attr('class', 'pagination_g').attrs({
            'transform': function (d) {
                return 'translate(0,115)'
            }
        }).on('click', function () {
            d3.event.stopPropagation()
        });
        //perdefining the pagination nos.
        for (var j = 0; j < chunkData.length; j++) {
            record_per_page += chunkData[j].length;
            if (j == 0) {
                pagesof = 1;
                starts = true;
            } else {
                pagesof = pagesof + chunkData[j].length;
                starts = false;
            }
            pagenationObj.push({
                page: (j == chunkData.length - 1 ? totalData - chunkData[chunkData.length - 1].length + 1 : pagesof),
                totalList: record_per_page
            });
        }

        var pagination_rect = paginationElGrp.append("path").attr("d", me.roundedRectangleSVG(0, 0, PAGINATIONWIDTH, PAGINATIONHEIGHT, PAGINATIONCORNER, false, false, true, true)).attr('class', 'pagination');
        var paginationtext = paginationElGrp.append('text').styles({
            'text-anchor': 'middle'
        }).attrs({
            'class': 'svgtext_9',
            'y': (me.getSVGDimension(paginationElGrp).height + 8) / 2,
            'x': me.getSVGDimension(paginationElGrp).width / 2
        });
        paginationtext.append('tspan').text('Showing ');
        var page_no = paginationtext.append('tspan').text(pageCounter);
        paginationtext.append('tspan').text('-');
        var no_list = paginationtext.append('tspan').text(showingData);
        paginationtext.append('tspan').text(' of ');
        var totaltext = paginationtext.append('tspan').text(totalData);


        //>
        paginationElGrp.append('svg:image')

            .attrs({
                'class': 'next-btn',
                'xlink:href': function (d, i) {
                    return '../images/'+me.getSkin(skinColor)+'/rightarrow.svg';
                },
                'width': 16,
                'cursor': 'pointer',
                'height': 16,
                "opacity": disbaleFn,
                'x': me.getSVGDimension(pagination_rect).width - 20,
                'y': (me.getSVGDimension(pagination_rect).height - 16) / 2

            }).on('click', function () {
                d3.event.stopPropagation();
                arrayCounter += 1;
                if (totalData == pagenationObj[arrayCounter]['totalList']) {
                    paginationElGrp.append('rect').call(nextSelection);
                }
                paginationElGrp.select('.disableprevious-btn').remove();
                //@ AppFlowDashboard.util.ListofNodeDetails
                me.listOfNode(selectorx, chunkData[arrayCounter], me.paginationLength);
                page_no.text(pagenationObj[arrayCounter]['page']);
                no_list.text(pagenationObj[arrayCounter]['totalList']);

                //Remove the tooltip if present
                var parentID = d3.select(this).datum().tierId;
                if($('#closeBt_'+parentID+'_tooltip').length){
                    $('#closeBt_'+parentID+'_tooltip').d3TriggerClick();
                }

            });
        //<
        paginationElGrp.append('svg:image')

            .attrs({
                'xlink:href': function (d, i) {
                    return '../images/'+me.getSkin(skinColor)+'/leftarrow.svg';
                },
                'width': 16,
                'height': 16,
                'cursor': 'pointer',
                'class': 'previous-btn',
                "opacity": disbaleFn,
                'x': 5,
                'y': (me.getSVGDimension(pagination_rect).height - 16) / 2

            }).on('click', function () {
                d3.event.stopPropagation();
                arrayCounter -= 1;
                if (pagenationObj[arrayCounter]['page'] == 1) {
                    paginationElGrp.append('rect').call(previousSelection);

                }
                paginationElGrp.select('.disablenext-btn').remove();
                page_no.text(pagenationObj[arrayCounter]['page']);
                me.listOfNode(selectorx, chunkData[arrayCounter], me.paginationLength);
                no_list.text(pagenationObj[arrayCounter]['totalList']);

                //Remove the tooltip if present
                var parentID = d3.select(this).datum().tierId;
                if($('#closeBt_'+parentID+'_tooltip').length){
                    $('#closeBt_'+parentID+'_tooltip').d3TriggerClick();
                }
            });
        // Next,Pervoius button disbaleFn
        function previousSelection(selection) {
            selection.attrs({
                'width': 16,
                'height': 16,
                //'fill': '#ebebeb',
                'opacity': '0.6',
                'cursor': 'default',
                'class': 'disableprevious-btn',
                'x': 5,
                'y': (me.getSVGDimension(pagination_rect).height - 16) / 2

            });
        }

        function nextSelection(selection) {
            selection.attrs({
                'width': 16,
                'height': 16,
                //'fill': '#ebebeb',
                'opacity': '0.6',
                'cursor': 'default',
                'class': 'disablenext-btn',
                'x': me.getSVGDimension(pagination_rect).width - 20,
                'y': (me.getSVGDimension(pagination_rect).height - 16) / 2

            });
        }
        // @ load disable function
        function disbaleFn() {
            if (totalData > me.paginationLength) {
                if (d3.select(this).attr("class") == 'previous-btn') {
                    paginationElGrp.append('rect').call(previousSelection);
                }
            } else {
                if (d3.select(this).attr("class") == 'next-btn') {
                    paginationElGrp.append('rect').call(nextSelection);
                } else {
                    paginationElGrp.append('rect').call(previousSelection);
                }
            }
        };
    }
});