 Ext.define('AppFlowDashboard.util.SVGAssets', {
     override: 'AppFlowDashboard.view.AppFlowTopology',
     constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
     loadingSVG: function () {
         var me = this,
             selector = me.body.id,
             margin = {
                 top: 0,
                 left: 0,
                 bottom: 0,
                 right: 0
             };
         me.FITPADDING = 20;
         me.width = Ext.get(selector).getWidth() - (margin.left + margin.right) - (me.bodyPadding + me.bodyPadding);
         me.height = Ext.get(selector).getHeight() - (margin.top + margin.bottom) - (me.bodyPadding + me.bodyPadding);
         me.translateX = (margin.left + me.width) / 2;
         me.translateY = (margin.top + me.height) / 2;
         me.scale = me.defaultZoomValue();
         me.svg = d3.select("#" + selector).append("svg").attr("id", "svgcontainerID").attr("viewBox", "0 0 " + me.width + " " + me.height).attr("preserveAspectRatio", "xMidYMid meet").attr('width', me.width).attr('height', me.height).attr("transform", "translate(" + [margin.left, margin.top] + ")");
         me.zoomer = me.svg.append('svg:g').attr('class', 'rect');
         me.canvas = me.svg.append('svg:g').attr('class', 'canvas').attr('transform', 'translate(' + [me.translateX, me.translateY] + ') scale(' + me.scale + ')');
         me.zoomer.append('rect').style("fill", "none").style("pointer-events", "all").attr('width', "100%").attr('height', "100%");



         //min map



         me.linkGrp = me.canvas.append('g').attr('class', 'linkGrp');
         me.nodeGrp = me.canvas.append('g').attr('class', 'nodeGrp');
         me.NODEPADDING = 10;

         //Rendering the sliderComponent @sliderComponent
         me.sliderComponent();
         me.topologyData = {}, groupMap = {};

     },
     /*
      * Reusable markers arrow based on the eG state  
      *  @param {String} .css class is defined in the .CSS file (Light and Dark theme)
      * returns the URL path
      */
     createArrowMarker: function (data, bool, width) {
         width = (typeof width !== 'undefined') ? width : 150;
         var me = this;
        
         if (data.state == null) data.state = "DEFAULT";
         var markerPosition = d3.scaleLinear().domain([me.minZoom(), me.maxZoom()]).range([width, width * me.scale]);
         var marker = me.svg.append("svg:defs")
             .append("svg:marker")
             .attr("viewBox", "-0 -5 10 10")
             .attr("markerWidth", function () {
                 if (me.scale > me.minZoom()) {
                     return 10 / me.scale;
                 } else {
                     return 8 / me.scale;
                 }

             })
             .attr("markerHeight", function () {
                 if (me.scale > me.minZoom()) {
                     return 10 / me.scale;
                 } else {
                     return 8 / me.scale;
                 }

             })
             .attr("orient", "auto")
             .attr('markerUnits', 'userSpaceOnUse')
             .attr("preserveAspectRatio", "none")
             .attr("xOverflow", "visible");
         if (bool) {

             marker.attr("refX", function (d, i) {
                     return 0;
                 })
                 .attr("refY", function (d, i) {
                     if (me.scale > me.minZoom()) {
                         return -0.5 * me.maxZoom();
                     } else {
                         return -0.5 * me.minZoom();
                     }
                 }).attr("id", function () {
                    // if (data.state == null) data.state = "DEFAULT";
                     return data.state + "marker_self";
                 }).append("svg:path")
                 .attr("class", "marker")
                 .attr("d", "M0,-5L10,0L0,5").attr('class', function (d, i) {
                     //if (data.state == null) data.state = "DEFAULT";
                     
                     return data.state;
                 });
            // if (data.state == null) data.state = "DEFAULT";
             return "url(#" + data.state + "marker_self)";
         } else {

             marker.attr("refX", function (d, i) {



                     if (me.scale >= me.minZoom()) {
                         return markerPosition(me.scale * me.maxZoom());
                     } else {
                         return markerPosition(me.scale * me.minZoom());
                     }

                 })
                 .attr("refY", function (d, i) {
                     // return -0.5*me.scale;
                     if (me.scale > me.minZoom()) {
                         return -0.5 * me.maxZoom();
                     } else {
                         return -0.5 * me.minZoom();
                     }
                 }).attr("id", function () {
                     
                     return data.state + "marker";
                 }).append("svg:path")
                 .attr("class", "marker")
                 .attr("d", "M0,-5L10,0L0,5").attr('class', function (d, i) {
                     //if (data.state == null) data.state = "DEFAULT";
                    // console.log('data.state',data.state)
                     return data.state;
                 });
            // if (data.state == null) data.state = "DEFAULT";
             return "url(#" + data.state + "marker)";
         }
     },
     svgAssets: function (svg) {
         svg.append("defs").append("clipPath").attr("id", "clip").append("rect").attrs({
             'width': 150,
             'height': 160,
             'x': 0,
             'y': 0
         });
         svg.append("defs").append("filter").attr("id", "shadow").append("feDropShadow").attrs({
             "dx": "0",
             "dy": "0",
             "stdDeviation": "10",
             "flood-color": "red",
             "flood-opacity": "1"
         });


         svg.append("filter")
             .attrs({
                 'x': 0,
                 'y': 0,
                 "width": "1",
                 "height": "1",
                 "id": "solid"
             }).append("feFlood").attrs({
                 "flood-color": "yellow",

             }).append("feComposite").attrs({
                 "in": "SourceGraphic",
                 "operator": "xor"
             });

         /* var stroke = svg.append("defs").append("filter").attr("id", "whiteOutlineEffect")
          stroke.append('feMorphology').attr('in', "SourceAlpha").attr('result', "MORPH").attr('operator', "dilate").attr('radius', "8");
          stroke.append('feColorMatrix').attr('in', "MORPH").attr('result', "WHITENED").attr('type', "matrix").attr('values', "1 -1 2 2 2 2 1 -1 2 2 2 2 2 2 2 2 2 2 2 -1");
          var feMerge = stroke.append('feMerge');
          feMerge.append('feMergeNode').attr('in', "WHITENED");
          feMerge.append('feMergeNode').attr('in', "SourceGraphic");*/
     }
 });