	/* Defines the sparkline chart in the tooltip
     * basic functionality in the high chart ref: https://www.highcharts.com/demo/sparkline
     * sparkline data is fetch from the JSON 
     * chart renders in the tooltip 
     * @ param {renderTo : "DOM element ID ",data : json object array, chartattr: json object (color properties) }
	 * included in AppFlowDashboard.util.TopologyTooltip.js
     */
	Ext.define('AppFlowDashboard.util.SparkLineChart',{
	override: 'AppFlowDashboard.view.AppFlowTopology',
	constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
	 sparkLineChart: function(renderTo, data, chartattr) {
        var sortedData = _.orderBy(data, ['x'], ['asc']);
        Highcharts.setOptions({
            chart: {
                width: 80,
                height: 20,
                margin: [0, 0, 0, 0],
                backgroundColor: null,
                style: {
                    overflow: 'visible'
                }
            },
            title: {
                text: ''
            },
            credits: {
                enabled: false
            },
            exporting: {
                enabled: false
            },
            legend: {
                enabled: false
            },
            xAxis: {
                labels: {
                    enabled: false
                },
                gridLineColor: 'transparent',
                lineColor: 'transparent',
                tickColor: 'transparent',
                tickLength: 0,
				 min: null,
                max: null
            },
            yAxis: {
                title: {
                    text: null
                },
                maxPadding: 0,
                minPadding: 0,
                gridLineWidth: 0,
                ticks: false,
                endOnTick: false,
                labels: {
                    enabled: false
                },
                min: null,
                max: null
            },
            tooltip: {
                formatter: function() {
                    if (this.point.date == undefined) {
                        return '<b>' + this.series.name + '</b><br/>' + this.point.status;
                    } else {
                        return '<b>' + this.series.name + '</b><br/>' + this.point.date + " - " + this.point.status;
                    }
                },
                borderWidth: 0,
                shadow: false,
                useHTML: true,
                hideDelay: 0,
                padding: 0,
                positioner: function(w, h, point) {
                    return {
                        x: point.plotX - w / 2,
                        y: point.plotY - h
                    };
                }
            },
            plotOptions: {
                series: {
                    enableMouseTracking: true,
                    lineWidth: 2,
                    shadow: false,
                    states: {
                        hover: {
                            lineWidth: 2
                        }
                    },
                    marker: {
                        radius: 0
                    }
                }
            }
        });
        if ($('#' + renderTo).length) {
            var sparkLIne = new Highcharts.Chart({
                chart: {
                    renderTo: renderTo,
                },
                series: [{
                    fillColor: chartattr.fill,
                    lineColor: chartattr.borderColor,
                    type: 'area',
                    data: sortedData
                }]
            });
        }
    }
	});
   