	Ext.define('AppFlowDashboard.util.StaticFunctionVaribales', {
	override: 'AppFlowDashboard.view.AppFlowTopology',
	constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
	  /*Checks if  browser is IE (bug in IE)
     * which is used in the tick method of force layout for appending the Links 
     */
    isIE: function() {
        return ((navigator.appName == 'Microsoft Internet Explorer') || ((navigator.appName == 'Netscape') && (new RegExp("Trident/.*rv:([0-9]{1,}[\.0-9]{0,})").exec(navigator.userAgent) != null)));
    },
    getSkin:function(skin){
        skin = (typeof skin !== 'undefined') ?  skin : 'Light';
        return skin;
    },
    // standard animation 
    animationDuration: 700,
    tierDimension:{
        'width':145,
        'height':121
    },
    backEndDimension:{
        'width':108,
        'height':81
    },
    userDimension:{
        'width':48,
        'height':48
    },
    getSVGDimension: function(svg) {
        var el = svg.node().getBBox();
        return {
            x: el.x,
            y: el.y,
            width: el.width,
            height: el.height
        }
    },
    getTranslation: function(transform) {
        var g = document.createElementNS("http://www.w3.org/2000/svg", "g");
        g.setAttributeNS(null, "transform", transform);
        var matrix = g.transform.baseVal.consolidate().matrix;
        return [matrix.e, matrix.f];
    },
    getGraphBound: function(nodes) {
        //property represents the negative Infinity value.
        var me = this,
            x = Number.POSITIVE_INFINITY,
            X = Number.NEGATIVE_INFINITY,
            y = Number.POSITIVE_INFINITY,
            Y = Number.NEGATIVE_INFINITY;
        
        nodes.each(function(v) {
            x = Math.min(x, v.x - (v.width + me.NODEPADDING) / 2);
            X = Math.max(X, v.x + (v.width + me.NODEPADDING) / 2);
            y = Math.min(y, v.y - (v.height + me.NODEPADDING) / 2);
            Y = Math.max(Y, v.y + (v.height + me.NODEPADDING) / 2);
        });
        return {
            x: x,
            X: X,
            y: y,
            Y: Y
        };
    },

    /**Creating svg rounded rectangle 
     *@cfg {number,number,number,boolean,boolean,boolean,boolean}
     * x : x position  ,y : y position
     * width : width of rectangle , height : height of rectangle
     * radius : round corner value 
     * topleft : top left round corner
     * topright : top right round corner
     * bottomleft : bottom left round corner
     * bottomright : bottom right round corner
     */
    roundedRectangleSVG: function(x, y, width, height, radius, topleft, topright, bottomleft, bottomright) {
        var me = this,
            coordinates;
        coordinates = "M" + (x + radius) + "," + y;
        coordinates += "h" + (width - 2 * radius);
        if (topright) {
            coordinates += "a" + radius + "," + radius + " 0 0 1 " + radius + "," + radius;
        } else {
            coordinates += "h" + radius;
            coordinates += "v" + radius;
        }
        coordinates += "v" + (height - 2 * radius);
        if (bottomright) {
            coordinates += "a" + radius + "," + radius + " 0 0 1 " + -radius + "," + radius;
        } else {
            coordinates += "v" + radius;
            coordinates += "h" + -radius;
        }
        coordinates += "h" + (2 * radius - width);
        if (bottomleft) {
            coordinates += "a" + radius + "," + radius + " 0 0 1 " + -radius + "," + -radius;
        } else {
            coordinates += "h" + -radius;
            coordinates += "v" + -radius;
        }
        coordinates += "v" + (2 * radius - height);
        if (topleft) {
            coordinates += "a" + radius + "," + radius + " 0 0 1 " + radius + "," + -radius;
        } else {
            coordinates += "v" + -radius;
            coordinates += "h" + radius;
        }
        coordinates += "z";
        return coordinates;
    },
    stateImagePro: function(data) {
        var path = "";
        switch (data) {
            case "GOOD":
                path = '../images/state_GOOD.svg';
                break;
            case "INTERMEDIATE":
                path = '../images/state_INTERMEDIATE.svg';
                break;
            case "HIGH":
                path = '../images/state_HIGH.svg';
                break;
            case "LOW":
                path = '../images/state_LOW.svg';
                break;
            case "UNKNOW":
                path = '../images/state_UNKNOW.svg';
                break;
        }
        return path;
    },
    stateImage: function(data) {
        var path = "";
        //Healthy , Slow, Error, Stalled
        switch (data) {
            case "normalNodes":
                path = '../images/state_white_GOOD.svg';
                break;
            case "minorNodes":
                path = '../images/state_white_LOW.svg';
                break;
            case "unknownNodes":
                path = '../images/state_white_UNKNOWN.svg';
                break;
            case "criticalNodes":
                path = '../images/state_white_HIGH.svg';
                break;
            case "majorNodes":
                path = '../images/state_white_INTERMEDIATE.svg';
                break;
        }
        return path;
    }
	});