 /**
  * Renders the tier health bar chart 
  * @param selector is the current node 
  */
 Ext.define('AppFlowDashboard.util.TierNodeHealthStatsChart', {
     override: 'AppFlowDashboard.view.AppFlowTopology',
     constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
     tierNodeHealthStatsChart: function (selector) {
         var me = this,
             outer_dimension = me.getSVGDimension(d3.select(selector)),
             rawData = d3.select(selector).data().filter(function (d) {
                 // console.log('data', d)
                 return d.nodeHealthStats != null || d.nodeHealthStats == undefined;
             }),

             tierNodeHealthStats_data = rawData[0]['nodeHealthStats'],
             obj = {},
             data = [],
             healthStatsArry = [];



         //pushing obj into Array
         healthStatsArry.push(tierNodeHealthStats_data);

         // Transforming data to stacked bar
         if (!Ext.isEmpty(healthStatsArry)) {
             if (healthStatsArry.length !== undefined) {
                 for (var i = 0; i < healthStatsArry.length; i++) {
                     var o = healthStatsArry[i];
                     for (var key in o) {
                         if (o[key] != null) {

                             obj[key] = o[key]['nodeCount'];
                         }
                     }
                 }
             }
         }

         data.push(obj);

         var CHARTWIDTH = 130,
             CHARTHEIGHT = 10,
             chartDataLength = data.length, //m
             stack = d3.stack().keys(d3.keys(data[0])).order(d3.stackOrderNone).offset(d3.stackOffsetNone),
             yGroupMax = d3.max(stack(data), function (layer) {
                 return d3.max(layer, function (d) {
                     var x = d[0],
                         y = d[1];
                     return y;
                 });
             }),
             yStackMax = d3.max(stack(data), function (layer) {
                 return d3.max(layer, function (d) {
                     var x = d[0],
                         y = d[1];
                     return d[0] + y;
                 });
             }),
             y = d3.scalePoint().domain(d3.range(chartDataLength)).range([2, CHARTHEIGHT], .08),
             x = d3.scaleLinear().domain([0, yGroupMax]).range([0, CHARTWIDTH]),
             layers = stack(data),
             healthstatchart = d3.select(selector).filter(function (d) {
                 return d.nodeHealthStats != null
             }).append('g').attr('class', 'healthstatchart').attr('transform', 'translate(' + (outer_dimension.width - CHARTWIDTH) / 2 + ',' + (outer_dimension.height - 15) + ')');
         healthstatchart.on('click', function () {
             d3.event.preventDefault();
         });

         var sortedList = _.orderBy(layers, function (d, i) {
             return [d['key'] === 'critical', d['key'] === 'major', d['key'] === 'minor', d['key'] === 'normal'];
         }, ['desc', 'asc']);
         // console.log('sortedList', sortedList)

         var barHolder = healthstatchart.append('g').attr('class', 'barHolder'),
             eachbar = barHolder.selectAll('g').data(sortedList);

         var barData = eachbar.enter();
         eachbar.exit().remove();
         var bar_g = barData.filter(function (d, i) {
             var nodecount = d[0].data[d.key];
             return nodecount != 0;

         }).append('g').merge(eachbar).attr("class", function (d, i) {
             return 'layer ' + d.key + 'Nodes'; //Nodes belongs to stylesheet
         });
         var bardata = bar_g.selectAll(".healthstat_bar").data(function (d) {
             return d;
         }).enter();

         bardata.exit().remove();
         bardata.append("rect").merge(bardata).attr('class', 'healthstat_bar').attr('stroke-linecap', 'butt').attr('stroke-width', '0.5')
             .attr("y", function (d) {
                 return 0;
             }).attr("x", function (d) {
                 return x(d[0]);
             })
             .attr("height", CHARTHEIGHT)
             .attr("width", function (d) {
                 return x(d[1]) - x(d[0]);
             });

         // mouseenter , mouseleave and click  on the rect
         var activeLayer = healthstatchart.append('g');
         bar_g.on('mouseenter', function (d, i) {
                 if (d3.event.defaultPrevented) return;
                 var index = d3.select(this).datum().index;
                 var keyData = d3.select(this).datum().key,
                     tierNodeHealthStats_dataDetails = healthStatsArry[0][keyData],

                     tierNodeHealthStats_dataDetailsLength = tierNodeHealthStats_dataDetails.nodeId.length;
                 //console.log('tierNodeHealthStats_dataDetails',tierNodeHealthStats_dataDetails);

                 //hide the selected Node
                 if (d3.select("g.detailNodeActive")) {
                     d3.select(selector).select("g.detailNodeActive").style('display', 'none')
                 }
                 var rect = d3.select(this).append('g').attr('class', 'detailNodeg');

                 // reusable UI for hover as well as click
                 function healthSatatUI(element) {
                     var textLabel = element.append('text')
                         .attrs({
                             'x': (me.getSVGDimension(element).width / 2),
                             'y': (me.getSVGDimension(element).height / 2) + 14
                         })
                         .append('tspan').attr('class', 'svgtext_bold_11')
                         .text(tierNodeHealthStats_dataDetailsLength + " ")
                         .append('tspan').text(function (d) {
                             if (tierNodeHealthStats_dataDetailsLength) {
                                 return tierNodeHealthStats_dataDetails.displayText;
                             }
                         }).attr('class', 'svgtext_normal_9');
                     element.append('svg:image')
                         .attrs({
                             'xlink:href': function (d, i) {
                                 //console.log('keyData', keyData)
                                 return me.stateImage(keyData + 'Nodes'); //@Nodes Stylesheet class
                             },
                             'width': 16,
                             'height': 16,
                             'x': (me.getSVGDimension(textLabel).x) - 18,
                             'y': (me.getSVGDimension(textLabel).y / 2) + 8

                         });
                 }

                 rect.append('rect').attr('class', 'detailNode ' + d['key']).attr('width', CHARTWIDTH).attr('height', 30)
                     .attr('x', 0).attr('y', 9.5)
                     .attr('stroke', 'red')
                     .attr('stroke-linecap', 'butt')
                     .attr('stroke-dasharray', '0')
                     .attr('stroke-dashoffset', 0)
                     .attr('stroke-width', '0');

                 healthSatatUI(rect);

                 rect.on('click', function () {
                     if (d3.event.defaultPrevented) return;
                     //d3.event.preventDefault();
                     if (d3.select(selector).select('.listGrpInner')) {
                         d3.select(selector).select('.listGrpInner').remove();
                     }
                     activeLayer.select('.detailNodeActive_g').remove();

                     var detailNodeActive = activeLayer.attr('class', 'detailNodeActive').append('g').attr('class', 'detailNodeActive_g');
                     detailNodeActive.append('rect')
                         .attr('class', d['key'] + 'Nodes') //@Nodes stylesheet class
                         .attr('width', CHARTWIDTH).attr('height', 30)
                         .attr('x', 0).attr('y', 9.5)
                         .attr('stroke', 'red')
                         .attr('stroke-linecap', 'butt')
                         .attr('stroke-dasharray', '0')
                         .attr('stroke-dashoffset', 0)
                         .attr('stroke-width', '0').on('click', function (e) {

                             d3.event.stopPropagation();
                             return false;
                         }).on('mouseenter', function (d, i) {
                             if (d3.event.stopPropagation()) return;
                         }).on('mouseleave', function (d, i) {
                             if (d3.event.stopPropagation()) return;
                         });

                     healthSatatUI(detailNodeActive);

                 });

             })

             .on('mouseleave', function (d, i) {
                 if (d3.event.stopPropagation()) return;
                 d3.selectAll('.detailNodeg').remove();
                 if (d3.select("g.detailNodeActive")) {
                     d3.select(selector).select("g.detailNodeActive").style('display', 'block')
                 }
             }).on('click', function (d, i) {
              
                 d3.event.stopPropagation();
                 var keyData = d.key;
                 me.clickFrom = 0;

                 if (healthStatsArry[0][keyData]['nodeId'].length != 0) {
                     var dataNode = healthStatsArry[0][keyData]['nodeId'],
                         nodeArry = [];
                     _.forEach(dataNode, function (nodeID, index) {
                         //adding nodeId in the flat array in the JSON 
                         //nodeId is been used in the AppFlowDashboard.util.ListofNodeDetails.js 
                         // @ variable consolidatedArry 
                         nodeArry.push({
                             "nodeId": nodeID
                         });

                     });
                     // console.log('nodeArry-->', nodeArry)
                     /*******************************
                     Loading the pagination and nodelevel UI here
                     ********************************/
                     me.paginationLength = 3;
                     d3.select(healthstatchart.node().parentNode).classed('fromChart', false);
                     me.pagination(d3.select(healthstatchart.node().parentNode), nodeArry, me.paginationLength);
                     me.listOfNode(d3.select(healthstatchart.node().parentNode), nodeArry, me.paginationLength, 40);

                 }

                 function closeDetails() {
                     d3.event.stopPropagation();
                     healthstatchart.transition().duration(me.animationDuration).attr('transform', 'translate(' + (outer_dimension.width - 130) / 2 + ',' + (outer_dimension.height - 15) + ')');
                     d3.select(healthstatchart.node().parentNode).select('.area').remove();
                     d3.select(healthstatchart.node().parentNode).select('.listGrp').remove();
                     d3.select(healthstatchart.node().parentNode).select('.pagination_g').remove();
                     healthstatchart.select('.detailNodeActive_g').remove();
                 }
                 me.closeDetailsButtonUI(selector, closeDetails);
                 healthstatchart.transition().duration(me.animationDuration).attr('transform', 'translate(' + (outer_dimension.width - 130) / 2 + ',' + 5 + ')');
                 //@moveToFront in topologyinit.js
                 healthstatchart.moveToFront();
             });


     }
 });