/* Defines the tierUI 
 * @param selector is the current node 
 */
Ext.define('AppFlowDashboard.util.TierUI', {
    override: 'AppFlowDashboard.view.AppFlowTopology',
    constructor: function (config) {
        this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
    },
    tierOuterUI: function (selector) {
        var me = this,
            currentGrp = d3.select(selector),
            datax = currentGrp.datum();

        var zoomInnertierUI = d3.select(selector).append('g').attr('class', 'zoomInnertierUI'),
            zoomOutertierUI = d3.select(selector).append('g').attr('class', 'zoomOuttierUI');

        // @ AppFlowDashboard.util.ZoomOuttierUI.js
        me.zoomOuttierUI(zoomOutertierUI);
        var outerbox = zoomInnertierUI.append("path").attr("d", me.roundedRectangleSVG(0, 0, me.tierDimension.width, me.tierDimension.height, 3, true, true, true, true)).attr('class', 'tireBox'),
            outerbox_dimension = outerbox.node().getBBox(),
            //Header
            header = zoomInnertierUI.append("path").attr("d", me.roundedRectangleSVG(0, 0, outerbox_dimension.width, 20, 3, true, true, false, false)).attr('class', 'tireheader'),
            linex = zoomInnertierUI.append('line').attr("x1", 45).attr("y1", 32).attr("x2", 45).attr("y2", 99).attr('class', 'headerline'); //divider
        header_dimension = header.node().getBBox();
        zoomInnertierUI.append('line').attr("x1", 0).attr("y1", header_dimension.height).attr("x2", outerbox_dimension.width).attr("y2", header_dimension.height).attr('class', 'headerline');
        // component icon
        zoomInnertierUI.append('svg:image')
            .attrs({
                'xlink:href': function (d, i) {
                    return '../images/component_icons/svg/'+me.getSkin(skinColor)+'/' + d.iconName + '.svg'
                },
                'width': 32,
                'height': 32,
                'x': 5,
                'y': 32,
                'class': 'componentIcon'
            });
        //Tier Header
        zoomInnertierUI.append('text').attr('class', 'svgtext_header_10').text(function (d) {
            return _.truncate(d.displayName, {
                'length': 23,
                'separator': ' '
            });
        }).attrs({
            'x': 5,
            'y': 0,
            'dy': '1.35em'
        });

        //node count and label
        var nodeCountText = zoomInnertierUI.append('text').attr('class', 'innernode_count').attrs({
            'x': 0,
            'y': 62
        });
        nodeCountText.append('tspan')
            .text(function (d) {
                return d.nodeCount
            }).attrs({
                'x': 25,
                'dy': '1.2em',
                'class': 'svgtext_18',
                'text-anchor': 'middle'
            });
        nodeCountText.append('tspan')
            .text(function (d) {
                if (d.nodeCount == 1) {
                    return "node";
                } else {
                    return "nodes";
                }
            }).attrs({
                'x': 25,
                'dy': '1.2em',
                'class': 'svgtext_9',
                'text-anchor': 'middle'
            });

        //zoomInnertierUI.each(function(data,i){
        // console.log('data',data)
        //})
        if (datax.callStats !== null) {
            var posX = linex.node().getBBox().x - 4;
            var posY = linex.node().getBBox().y;

            var list = zoomInnertierUI.append('g').attr('transform', function () {
                return 'translate(' + posX + ',' + (posY) + ')';
            }).attr('class', 'list');
            var gap = 0,
                data_value, unit, state, tierStats = [];

            _.forEach(datax.callStats, function (value, key) {
                if (value.statsType == "Async") {
                    return;
                }

                _.forOwn(value, function (val, k) {
                    if (k == "overallResponseTimeStats" || k == "statsType") {
                        return;
                    }
                    gap += 20;
                    /*
                     * Each object is iterates  
                     */
                    switch (k) {
                        case 'responseTimeStats':
                            _.forEach(val, function (valuex, key) {
                                var obj = valuex;
                                data_value = obj.value;
                                state = obj.state;
                                unit = obj.unit;
                            });
                            break;
                        case 'errorStats':
                            _.forEach(val, function (valuex, key) {
                                if (key == "numberOfErrors" || key == "errorPercent") return;
                                var obj = valuex;
                                data_value = obj.value;
                                state = obj.state;
                                unit = obj.unit;
                            });
                            break;
                        case 'trafficStats':
                            _.forEach(val, function (valuex, key) {
                                if (key == "numberOfCalls") return;
                                var obj = valuex;
                                data_value = obj.value;
                                state = obj.state;
                                unit = obj.unit;
                            });
                            break;
                    }
                    me.callStats(list, gap, data_value, unit, me, state);
                });




            });
        }
        /*tierNodeHealthStatsChart  bar chart 
         *refer to AppFlowDashboard.util.TierNodeHealthStatsChart.js
         */
        me.tierNodeHealthStatsChart(zoomInnertierUI.node());
    },
    callStats: function (list, gap, data_value, unit, me, state) {
        var listgrp = list.append('g').attr('transform', 'translate(10,' + (gap) + ')');
        listgrp.append('text').attrs({
            'x': listgrp.node().getBBox().x + 12,
            'y': listgrp.node().getBBox().y - 5
        }).append('tspan').attr('class', 'svgtext_11').text(function () {
            return data_value + " ";
        }).append('tspan').attr('class', 'svgtext_10').text(function () {
            return unit;
        });
        listgrp.append('svg:image').attrs({
            'xlink:href': function (d, i) {
                return me.stateImagePro(state);
                //'../images/component_icons/svg/state_bl_'+state+'.svg' 
            },
            'width': 15,
            'height': 15,
            'x': listgrp.node().getBBox().x - 15,
            'y': listgrp.node().getBBox().y + 1
        });
    },
    nodeDetailsUI: function (selector) {
        var me = this,
            parent = d3.select(selector),
            datax = parent.datum(),
            outerbox_dimension = d3.select('.zoomInnertierUI').node().getBBox();
        //filter by tierId 
        var filterData = _.filter(me.topologyData.node, function (node) {
            return datax.tierId == node.tierId;
        });
        //Sort by State 
        var sortedList = _.orderBy(filterData, function (o) {
            return [o.state === 'HIGH', o.state === 'INTERMEDIATE', o.state === 'LOW', o.state === 'UNKNOWN', o.state === 'GOOD'];
        }, ['desc', 'asc']);

        //alert(me.clickFrom);
        //console.log('filterData',filterData)
        function closeDetails() {
            parent.select('.area').remove();
            parent.select('.listGrp').remove();
            parent.select('.pagination_g').remove();
        }
        parent.classed('fromTier', true);
        /*tierNodeHealthStatsChart  bar chart 
         *@ me.pagination  AppFlowDashboard.util.Pagination
         *@ me.pagination  AppFlowDashboard.util.Pagination
         */
        me.paginationLength = 5;
        me.listOfNode(parent, sortedList, me.paginationLength, 5);
        me.pagination(parent, sortedList, me.paginationLength);
        me.closeDetailsButtonUI(selector, closeDetails);
    },
    closeDetailsButtonUI: function (selector, fn) {
        var me = this,
            parent = d3.select(selector),
            datax = parent.datum();
        d3.select(selector).select('.closeDetails').remove();
        if (d3.select(selector).select('.closeDetails').empty()) {
            var closeBt = d3.select(selector).append('svg:image')
                .attrs({
                    'xlink:href': function (d, i) {
                        return '../images/'+me.getSkin(skinColor)+'/close_details.svg';
                    },
                    'class': 'closeDetails',
                    'id':'closeBt_' + datax.tierId +'_tier',
                    'width': 16,
                    //'opacity':0,
                    'height': 16,
                    'x': (d3.select(selector).node().getBBox().width) - 20,
                    'y': -16
                }); //.transition().duration(me.animationDuration).attrs({'y':-35,'opacity':1});
            closeBt.on('click', function (btn) {
                d3.event.stopPropagation();

                //remove the ID @ AppFlowDashboard.util.KeyboardEvents
                _.remove(me.popupArray, function (obj) {
                    return obj.id === 'closeBt_' + datax.tierId +'_tier';
                  });
                
                if (me.D3tip) {
                    me.D3tip.remove(datax.tierId);
                }
                d3.select(this).remove();
                //callback method
                fn();
            });


        }
        //insert each ID @ AppFlowDashboard.util.KeyboardEvents
        me.popupArray.push({id:'closeBt_' + datax.tierId +'_tier'});
    }
});