Ext.define('AppFlowDashboard.util.TopologyLayoutRendering', {
    override: 'AppFlowDashboard.view.AppFlowTopology',
    constructor: function(config) {
        this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
    },
    renderTopolgy: function(data) {
        var me = this;
        //Loading SVG @ AppFlowDashboard.util.SVGAssets.js
        me.loadingSVG();
        me.svgAssets(me.svg);

        /********************************************************
        * Respective JSON is formed by the back end team 
        * if something makes very odd please check your JSON data
        ********************************************************/
        me.topologyData = data;
        me.topologyData.userDetails = data['eg_user'];
        me.topologyData.node = _.orderBy(data['applicationStats']['nodes'],['nodeId'],['asc']);//Soreted by nodeId
        me.topologyData.tier = _.orderBy(data['applicationStats']['tiers'],['tierId'], ['asc']); //Soreted by tierId
        me.topologyData.nodeLink = data['applicationStats']['nodeLinks'];
        me.topologyData.tierLink = data['applicationStats']['tierLinks'];
        me.topologyDataGroups = [];
        //console.log('------------------>',me.topologyData);
        //console.log('me.topologyData.node',me.topologyData.node);
        //console.log('me.topologyData.nodeLink',me.topologyData.nodeLink);
        //console.log('me.topologyData.tier',me.topologyData.tier);
        //console.log('me.topologyData.tierLink',me.topologyData.tierLink);

        //init the toloplogy @ AppFlowDashboard.util.Topologyinit.js
        me.init(me.topologyData.tier, me.topologyData.tierLink);

    }
 
});