 Ext.define('AppFlowDashboard.util.TopologyLineDetails', {
     override: 'AppFlowDashboard.view.AppFlowTopology',
     constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
     selfLinkPath: function (pathdata, radius_x, radius_y, startangle, endangle) {
         var x1 = pathdata.source.x,
             y1 = pathdata.source.y,
             x2 = pathdata.target.x,
             y2 = pathdata.target.y,
             dx = x2 - x1,
             dy = y2 - y1,
             dr = Math.sqrt(dx * dx + dy * dy),
             drx = dr,
             dry = dr,
             xRotation = 0,
             largeArc = 1,
             sweep = 1,
             drx = radius_x,
             dry = radius_y,
             x2 = x2 + endangle,
             y2 = y2 + startangle;
         return 'M' + x1 + ',' + y1 + 'A' + drx + ',' + dry + '' + xRotation + ',' + largeArc + ',' + sweep + ',' + x2 + ',' + y2;

     },
     calcTranslationPositions: function (targetDistance, point0, point1) {
         //inspired by https://gist.github.com/ramtob/3658a11845a89c4742d62d32afce3160
         var x1_x0 = point1.x - point0.x,
             y1_y0 = point1.y - point0.y,
             x2_x0, y2_y0;
         if (y1_y0 === 0) {
             x2_x0 = 0;
             y2_y0 = targetDistance;
         } else {
             var angle = Math.atan((x1_x0) / (y1_y0));
             x2_x0 = -targetDistance * Math.cos(angle);
             y2_y0 = targetDistance * Math.sin(angle);
         }
         return {
             dx: x2_x0,
             dy: y2_y0
         };

         /*  var x1_x0 = point1.x - point0.x,
               y1_y0 = point1.y - point0.y,
               x2_x0, y2_y0;
             if (targetDistance === 0) {
               x2_x0 = y2_y0 = 0;
             } else if (y1_y0 === 0 || Math.abs(x1_x0 / y1_y0) > 1) {
               y2_y0 = -targetDistance ;
               x2_x0 = targetDistance * y1_y0 / x1_x0;
             } else {
               x2_x0 = targetDistance * (-y1_y0) / y1_y0;
               y2_y0 = targetDistance * (-x1_x0) / y1_y0;
             }
             return {
               dx: x2_x0,
               dy: y2_y0
             };*/
     },
     LINK_GAP: 21,
     prepareLinksForBidirection: function (linkData) {
         var me = this,
             linksFromNodes = {};
         linkData.forEach(function (val, idx) {
             //console.log('prepareLinksForBidirection',val)
             var sid = val.source.tierId,
                 tid = val.target.tierId,
                 key = (sid < tid ? sid + ',' + tid : tid + ',' + sid);
             if (linksFromNodes[key] === undefined) {
                 linksFromNodes[key] = [idx];
                 val.multiIdx = 1;
             } else {
                 val.multiIdx = linksFromNodes[key].push(idx);
             }
             // Calculate target link distance, from the index in the multiple-links array:

             val.targetDistance = (val.multiIdx % 2 === 0 ? me.LINK_GAP : - me.LINK_GAP);
             val.labelAlignment = (val.multiIdx % 2 === 0 ? 'start' : 'end');

         });
     },
     //filter in the lineExperience text
     renderlineExperienceData: function (filterstate, data) {
         var me = this;
         //console.log('renderlineExperienceData',data)
         //TODO
         data = data || mergeLinkData;
         if (d3.selectAll('.link-label')) {
             d3.selectAll('.link-label').remove();
         }
         var filterArray = _.filter(data, function (o) {
             return o.state != filterstate;
         });

         // console.log('renderlineExperienceData filterArray',filterArray)
         linkExpdata = me.linkGrp.selectAll('.link-label').data(filterArray);
         linkExpDetails = linkExpdata.enter().append('g').attr('class', 'link-label-grp').attr('id',function(d){
            return 'link-label-'+d.index;
        });
        var rectBg = linkExpDetails.append('rect').attr('y', '0').attr('x', '0').attr('class','rectBg');
        var textDetails = linkExpDetails.append('text').attr("class", function (d) {
             // setting the class to filter the link text 
             return 'svgtext_11_' + d.state + '_state link-label';
         }).attr('y', '0').attr('x', '0').attr('text-anchor','start');//.style('filter', 'url(#whiteOutlineEffect)');

         

         textDetails.exit().remove();
         var onlinkText = {},
             data_value, unit, state;

            textDetails.each(function (d) {
             var line = this;
             if (!Ext.isEmpty(d.callStats)) {
                 _.forEach(d.callStats, function (items, index) {
                     if (items.statsType == 'Sync') {
                         _.forOwn(items, function (itemsObj, idx) {
                             //console.log(idx,"items",itemsObj)
                             switch (idx) {
                                 case 'responseTimeStats':
                                     _.forEach(itemsObj, function (valuex, key) {
                                         onlinkText['onlink_averageResponseTime'] = {
                                             value: valuex.value,
                                             label: valuex.unit
                                         };
                                     });
                                     break;
                                 case 'errorStats':
                                     _.forEach(itemsObj, function (valuex, key) {
                                         if (key == "errorPercent" || key == "numberOfErrors") return;
                                         onlinkText['onlink_errorsPerMinute'] = {
                                             value: valuex.value,
                                             label: valuex.unit
                                         };
                                     });
                                     break;
                                 case 'trafficStats':
                                     _.forEach(itemsObj, function (valuex, key) {
                                         if (key == "numberOfCalls") return;
                                         onlinkText['onlink_trafficStats'] = {
                                             value: valuex.value,
                                             label: valuex.unit
                                         };
                                     });
                                     break;
                             }

                         });
                     }
                 });

             }


             me.linkStatsDetails(line, onlinkText);
             //set BG to text
             me.textBg(line);
        

         });
         linkExpDetails.merge(linkExpdata);
         //Comes in topologyZoom.js 
         me.scaling(me.scale);
         me.simulationx.restart();
         //me.topologyLayout.resume();
     },
     textBg: function (selector) {
        var lineText = d3.select(selector);
        lineText.each(function(d){
            var bBox = d3.select(this).node().getBBox();
            d3.selectAll('.rectBg').attr('width',bBox.width).attr('height',bBox.height-5).attr('x',bBox.x).attr('y',bBox.y+3);
        });
     },
     linkStatsDetails: function (selector, onlinkText) {

         var dy = 0;
         var lineText = d3.select(selector);
         
         _.forEach(onlinkText, function (onlinkTextItems, keys) {
             // dy = 12;
             dy += 1;
             //console.log('onlinkTextItems',onlinkTextItems)
            
             lineText.append('tspan').attr('class', 'svgtext_11')
                 .attr("x", "-3.5em")
                 .attr('dy', function (d, i) {
                     //console.log('onlinkText', d);
                     //console.log('i',dy);
                     if (dy == 1) {
                         return -13;
                     } else {
                         return 13;
                     }
                 })
                 .text(onlinkTextItems.value + " ")
                 .append('tspan')
                 .text(onlinkTextItems.label)
                 .attr('class', 'svgtext_10').attr('text-anchor','end');
         });
        
     }
 });