/* Defines the tooltip on click
*	for more in details ref "/final/scripts/d3-tip.js"
* content is manipulated with given JSON
* returns the toolTip object
*/
Ext.define('AppFlowDashboard.util.TopologyTooltip', {
    override: 'AppFlowDashboard.view.AppFlowTopology',
    requires: ['AppFlowDashboard.util.SparkLineChart'],
    constructor: function (config) {
        this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
    },
    toolTopHTML: function (state, obj, data_value, unit, chartID) {
        return '<li><div>' +
            '<div style="display:inline-block;width:80px">' +
            '<div><img class="iconComponent_' + state + '" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="  width="16px" height="16px" style="vertical-align:middle;margin-right:5px;"><span class="newFont_normal11">' + obj.displayName + '</span></div>' +
            '<div style="margin-top:5px;"><span style="margin-right:2px;" class="newFont_bold12">' + data_value + '</span><span  class="newFont_normal10">' + unit + '</span></div>' +
            '</div>' +
            '<div style="display:inline-block;margin-left:10px;text-alight:left" class="trafficStatsChart">' +
            //'<svg width="80" height="22" class="trafficStatsChart"></svg>'+
            '<div style="width:100px;height:20px;" id="chart_' + chartID + '"></div>' +
            '</div>' +
            '</div></li>';
    },
    toolTip: function () {
        var me = this,
            unqID = Ext.id(),
            tool_tip = d3.tip()
                .attr("class", "d3-tip")
                .offset([0, 0])
                .direction('e')
                .html(function (d, i) {
                    var data_value,
                        unit,
                        state,
                        toolTipIdentifier = d.tierId,
                        layerModelURL = d.layerModelLink,
                        chartData;
                    var $outer = $("<div class='tooltip_content' id=" + toolTipIdentifier + "_tooltip_con_id></div>");

                    _.forEach(d.callStats, function (value_x, key) {
                        if (value_x.statsType == "Async") { return; }
                        _.forOwn(value_x, function (val, k) {
                            if (k == "overallResponseTimeStats") return;
                            switch (k) {
                                case 'responseTimeStats':
                                    _.forEach(val, function (v, j) {
                                        var obj = v, chartID = Ext.id();
                                        data_value = obj.value;
                                        state = obj.state;
                                        unit = obj.unit;
                                        var chartColor = {
                                            fill: '#f4f0fe',
                                            borderColor: '#c3b4d5'
                                        };
                                        if (!Ext.isEmpty(obj.value)) {
                                            //stateSymbol_GOOD
                                            //console.log('responseTimeStats_state',responseTimeStats_state)
                                            var htm = me.toolTopHTML(state, obj, data_value, unit, chartID);
                                            $outer.append(htm);
                                            Ext.defer(function () {
                                                // @ AppFlowDashboard.util.SparkLineChart.js
                                                me.sparkLineChart('chart_' + chartID + '', v.chartData, chartColor);
                                            }, 500);
                                        }
                                    });
                                    break;
                                case 'errorStats':
                                    _.forEach(val, function (v, j) {
                                        if (j == "numberOfErrors" || j == "errorPercent") return;
                                        var obj = v, chartID = Ext.id();
                                        data_value = obj.value;
                                        state = obj.state;
                                        unit = obj.unit;
                                        var chartColor = {
                                            fill: '#e1f2fa',
                                            borderColor: '#2fa8ef'
                                        };

                                        if (!Ext.isEmpty(obj.value)) {
                                            var htm = me.toolTopHTML(state, obj, data_value, unit, chartID);
                                            $outer.append(htm);
                                            Ext.defer(function () {
                                                // @ AppFlowDashboard.util.SparkLineChart.js
                                                me.sparkLineChart('chart_' + chartID + '', v.chartData, chartColor);
                                            }, 500);
                                        }
                                    });
                                    break;
                                case 'trafficStats':
                                    _.forEach(val, function (v, j) {
                                        if (j == "numberOfCalls") return;
                                        var obj = v, chartID = Ext.id();
                                        data_value = obj.value;
                                        state = obj.state;
                                        unit = obj.unit;
                                        var chartColor = {
                                            fill: '#feeeef',
                                            borderColor: '#dd848a'
                                        };

                                        if (!Ext.isEmpty(data_value)) {
                                            if (j == "callsPerMinute") {
                                                var htm = me.toolTopHTML(state, obj, data_value, unit, chartID);
                                                $outer.append(htm);
                                                Ext.defer(function () {
                                                    // @ AppFlowDashboard.util.SparkLineChart.js
                                                    me.sparkLineChart('chart_' + chartID + '', v.chartData, chartColor);
                                                }, 500);
                                            }
                                        }
                                    });
                                    break;
                            }
                        });
                    });
                    // time out due to,  DOM Element is null
                    Ext.defer(function () {
                        //close the tooltip by self
                        if (Ext.select('#tooltipID_' + toolTipIdentifier)) {
                            Ext.select("#closeBt_" + toolTipIdentifier + "_tooltip").on('click', function () {
                                Ext.select('#tooltipID_' + toolTipIdentifier).remove();
                                d3.select('#tierId_'+toolTipIdentifier).selectAll(".listG").classed("active", false);

                                //remove the ID @ AppFlowDashboard.util.KeyboardEvents
                                _.remove(me.popupArray, function (obj) {
                                    return obj.id === 'closeBt_' + toolTipIdentifier +'_tooltip';
                                  });

                            });
                            //way to the layermodel 
                            Ext.select("#layermodel_" + toolTipIdentifier + "_ID").on('click', function () {
                                window.location.href = layerModelURL;
                            });
                        }
                    }, 800);
                    return '<div class="tooltip_content" id="tooltip_content_' + toolTipIdentifier + '_ID"><img src="/final/images/'+me.getSkin(skinColor)+'/close_details.png" style="cursor:pointer;top: -22px;position: absolute;left: 90%;"  id="closeBt_' + toolTipIdentifier + '_tooltip" /><div class="tooltipHeader" id="header_' + toolTipIdentifier + '_tooltip"><span class="newFont_bold12">' + d.displayName + '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" id="layermodel_' + toolTipIdentifier + '_ID" class="iconLayerstack" style="cursor:pointer;margin-left: 5px;vertical-align:middle"/></span></div><div><ul class="tooltiplist">' + $outer.html() + '</ul></div></div>';
                });

        //me.canvas.call(tool_tip);
        return tool_tip;
    }
});


