Ext.define('AppFlowDashboard.util.TopologyZoom', {
	override: 'AppFlowDashboard.view.AppFlowTopology',
	requires: ['AppFlowDashboard.util.ZoomSliderUI'],
	constructor: function (config) {
		this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
	},
	// Defines the default zoom  
	defaultZoomValue: function () {
		var me = this;
		var defaultZoomValue = _.meanBy(me.zoomExtend, function (val) {
			return val;
		});
		return defaultZoomValue;
	},
	minZoom: function () {
		var me = this,
			min = me.zoomExtend[0],
			defaultZoomValue = me.defaultZoomValue(),
			minZoomValue = _.meanBy([min, defaultZoomValue], function (val) {
				return val;
			});

		return _.meanBy([min, minZoomValue], function (val) {
			return val;
		});

	},
	maxZoom: function () {
		var me = this,
			max = me.zoomExtend[1],
			defaultZoomValue = me.defaultZoomValue(),
			maxZoomValue = _.meanBy([max, defaultZoomValue], function (val) {
				return val;
			});
		return _.meanBy([max, maxZoomValue], function (val) {
			return val;
		});

	},
	maxZoom1: function () {
		var me = this,
			max = me.zoomExtend[1],
			defaultZoomValue = me.defaultZoomValue(),
			maxZoomValue = _.meanBy([max, defaultZoomValue], function (val) {
				return val;
			});
		return maxZoomValue;
	},
	// Defines the zoomExtend used in the d3 zoom functionality [0.2,2]
	zoomExtend: [0.2, 2],
	// Returns the d3 zoom object
	zoomObj: function () {
		return d3.zoom();
	},
	/*
	 *method is called on the SVG for zooming and panning
	 * returns d3 function 
	 */
	zoom: function () {
		var me = this;
		var zoom = me.zoomObj().scaleExtent(me.zoomExtend);
		zoom.on("zoom", function () {
			me.reZoom();
		});
		return zoom;
	},
	reZoom: function () {
		var me = this,
			e = d3.event,
			zoomtransform = d3.zoomTransform(me.svg.node());
		me.translateX = zoomtransform.x;
		me.translateY = zoomtransform.y;
		me.scale = zoomtransform.k;
		me.zoomEl(zoomtransform.x, zoomtransform.y, zoomtransform.k);

		me.translateX = zoomtransform.x;
		me.translateY = zoomtransform.y;
		me.scale = zoomtransform.k;
		me.zoomEl(me.translateX, me.translateY, me.scale);
		Ext.getCmp('slider').setValue(zoomtransform.k, true);
		//console.log('---------->',zoomtransform.k)
		me.scaling(zoomtransform.k);

	},
	isZoomed: true,
	scaling: function (scale) {
		var me = this;
		//console.log('scale', scale, me.translateY, me.translateX)
		if (scale < me.defaultZoomValue()) {
			//zoomOut

			me.visibilityEl('.zoomInnertierUI', false);
			me.visibilityEl('.zoomOuttierUI', true);
			me.visibilityEl('.selflink', false);
			//--------------------------popup ui
			me.visibilityEl('.node_x .pagination_g', false);
			me.visibilityEl('.node_x .listGrpInner', false);
			me.visibilityEl('.node_x .closeDetails', false);
			//--------------------------


			me.zoomUI('.link-label', scale, 1.1);
			me.zoomUI('.rectBg', scale, 1.1);

			me.isZoomed = false;
			var width = d3.select('.zoomOuttierUI').node().getBBox().width / 1.1;
			me.lineZoom(scale, width);
			if (scale < me.minZoom()) {
				var width = d3.select('.zoomOuttierUI').node().getBBox().width;
				me.visibilityEl('.link-label', false);
				me.visibilityEl('.rectBg', false);
				me.lineZoom(scale, width);
			} else {

				me.visibilityEl('.link-label', true);
				me.visibilityEl('.rectBg', true);

			}
			me.zoomUI('.user_grp', scale, 1.2);
		} else {
			//zoomIn

			//--------------------------popup ui
			me.visibilityEl('.node_x .pagination_g', true);
			me.visibilityEl('.node_x .listGrpInner', true);
			me.visibilityEl('.node_x .closeDetails', true);
			//--------------------------

			me.visibilityEl('.zoomInnertierUI', true);
			me.visibilityEl('.zoomOuttierUI', false);
			me.visibilityEl('.selflink', true);
			me.visibilityEl('.link-label', true);
			me.visibilityEl('.rectBg', true);
			me.zoomUI('.link-label', scale, 1.5);
			me.zoomUI('.rectBg', scale, 1.5);

			//d3.selectAll('.zoomInnertierUI').style("opacity", 1).style("display", "block");
			//d3.selectAll('.zoomOuttierUI').style("opacity", 0).style("display", "none");
			//d3.selectAll('.selflink').style("opacity", 1).style("display", "block");

			//d3.selectAll('.link-label').style("opacity", 1);
			//d3.selectAll('.rectBg').style("opacity", 1);

			if (scale > me.minZoom()) {
				me.visibilityEl('.link-label', true);
				me.visibilityEl('.rectBg', true);
			}
			me.isZoomed = true;
			var width = d3.select('.zoomInnertierUI').node().getBBox().width / scale;
			me.lineZoom(scale, width);
			
		}


		me.nodeZoom('.zoomOuttierUI', scale, 1);

		


		//me.zoomUI('.rectBg',scale,1);
		
	},
	nodeZoom: function (selector, scale, zoomAdjust) {
		var me = this,
			zoomDelta = zoomAdjust / scale,
			element = d3.selectAll(selector);
		element.each(function (d, i) {
			var cx = d.vx + (d.width / 2),
				cy = d.vy + (d.height / 2),
				zx = cx - zoomDelta * cx,
				zy = cy - zoomDelta * cy;
			d3.select(this).attr('transform', 'matrix(' + zoomDelta + ', 0, 0, ' + zoomDelta + ', ' + zx + ', ' + zy + ')');
		});


	},
	lineZoom: function (scale, width) {
		var me = this;
		d3.selectAll("defs").remove();
		d3.selectAll('.link').attr("marker-end", function (d, i) {
			//adding color arrows

			//console.log('d.target', d.target, d.source);
			if (d.source.x === d.target.x && d.source.y === d.target.y) {
				return me.createArrowMarker(d, true, width);
			} else {
				return me.createArrowMarker(d, false, width);
			}
		}).style("stroke-width", 1 / scale);
	},
	visibilityEl: function (selector, bool) {
		var cssStyle = "none",
			me = this,
			selectorTo = d3.selectAll(selector).transition().duration(200).ease(d3.easeLinear);
		if (bool) {
			cssStyle = "block";
			selectorTo.style("opacity", 1).style("display", cssStyle);
		} else {
			selectorTo.style("opacity", 0).style("display", cssStyle);
		}

	},

	zoomUI: function (selector, scale, zoomAdjust) {
		
		var me = this;
		if(!Ext.isEmpty(selector)){
			var zoomDelta = zoomAdjust / scale,
			element = d3.selectAll(selector),
			bbox = element.node().getBBox(),
			cx = bbox.x + (bbox.width / 2),
			cy = bbox.y + (bbox.height / 2),
			zx = cx - zoomDelta * cx,
			zy = cy - zoomDelta * cy;
		element.attr('transform', 'matrix(' + zoomDelta + ', 0, 0, ' + zoomDelta + ', ' + zx + ', ' + zy + ')');
		}

	},
	zoomEl: function (translateX, translateY, scale) {
		var me = this;
		translateX = (typeof translateX !== null || typeof translateX !== '') ? me.translateX : translateX;
		translateY = (typeof translateY !== null || typeof translateY !== '') ? me.translateY : translateY;
		d3.select('.canvas').attr("transform", ["translate(" + [translateX, translateY] + ")", "scale(" + scale + ")"].join(" "));
	},
	interpolateZoom: function (transform) {
		var me = this;
		me.svg.transition().duration(me.animationDuration).call(me.zoom().transform, transform);
		me.simulationx.restart();
	},
	fitGraph: function (bounds,w,h) {
		var me = this,
			width = bounds.X - bounds.x,
			height = bounds.Y - bounds.y,
			h = (typeof h !== 'undefined') ?  h : me.body.getHeight(),
			w = (typeof w !== 'undefined') ?  w : me.body.getWidth(),
			panelWidth = w - me.bodyPadding,
			panelHeight = h - 50;
			me.svg.attr('width', panelWidth).attr('height',  panelHeight).attr('viewBox', '0 0 '+panelWidth+' '+panelHeight);
		// console.log('--->',panelWidth,panelHeight)
		if (width == 0 || height == 0) return; //no need to fit
		//me.scale = Math.min(panelWidth / width, panelHeight / height);
		me.scale = Math.min(me.defaultZoomValue(), Math.min(panelWidth / width, panelHeight / height));
		me.translateX = (-bounds.x * me.scale + (panelWidth / me.scale - width) * me.scale / 2);
			me.translateY = (-bounds.y * me.scale + (panelHeight / me.scale - height) * me.scale / 2);
		
		// console.log('zoomToFit()',me.translateX,me.translateY,me.scale);
		me.transform = d3.zoomIdentity.translate(me.translateX, me.translateY).scale(me.scale);
		me.interpolateZoom(me.transform);

		
		// me.svg.transition().duration(750).call( me.zoom().transform, me.transform ); // updated for
		
	},
	zoomNode: function (bounds, callback, obj) {
		var me = this,
			width = bounds.X - bounds.x,
			height = bounds.Y - bounds.y,

			panelWidth = Ext.get(me.body.id).getWidth() - me.bodyPadding,
			panelHeight = Ext.get(me.body.id).getHeight() - me.bodyPadding;
		if (width == 0 || height == 0) return; //no need to fit
		me.scale = 1.2;
		me.translateX = (-bounds.x * me.scale + (panelWidth / me.scale - width) * me.scale / 2),
			me.translateY = (-bounds.y * me.scale + (panelHeight / me.scale - height) * me.scale / 2);

		me.transform = d3.zoomIdentity.translate(me.translateX, me.translateY).scale(me.scale);
		//me.interpolateZoom(me.transform);
		// me.svg.transition().duration(750).call( me.zoom().transform, me.transform ); // updated for

		me.svg.transition().duration(me.animationDuration).call(me.zoom().transform, me.transform).on("end", function () {
			callback(obj)

		});

	}
});