Ext.define('AppFlowDashboard.util.Topologyinit', {
    override: 'AppFlowDashboard.view.AppFlowTopology',
    requires:['AppFlowDashboard.util.KeyboardEvents'],
    constructor: function (config) {
        this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
    },
    graphLibAPI: function (me) {
        /*****************************************
         * @ dagre.graphlib.Graph
         * Dagre is a JavaScript library that makes it easy to lay out directed graphs on the client-side.
         * Completely client-side computed layout
         * ref @ https://github.com/dagrejs/dagre/wiki
         *****************************************/
        me.dagreNodes = [],
            me.dagreLinks = [];
        var g = new dagre.graphlib.Graph();
        // Set an object for the graph label
        g.setGraph({
            nodesep: 150,
            ranksep: 150,
            rankdir: "LR",
            ranker: "network-simplex",
            marginx: me.width / 2,
            marginy: me.height / 2
        });
        // Default to assigning a new object as a label for each new edge.
        g.setDefaultEdgeLabel(function () {
            return {};
        });
        //console.log('graphLib', g);
        me.updatedNode.forEach(function (node, index) {
            //default dimensions of node 150*150
            var nodeWidth = nodeHeight = 150;
            // @AppFlowDashboard.util.StaticFunctionVaribales 
            if (node['type'] != null && node['type'] == "BACKEND") {
                nodeWidth = me.backEndDimension.width;
                nodeHeight = me.backEndDimension.height;
            } else if (node['type'] == "user") {
                nodeWidth = me.userDimension.width;
                nodeHeight = me.userDimension.height;
            } else {
                nodeWidth = me.tierDimension.width;
                nodeHeight = me.tierDimension.height;
            }
            g.setNode(node.tierId, {
                //'metaData': node,
                'tierId': node.tierId,
                'label': node.name,
                'width': nodeWidth,
                'height': nodeHeight
            });
        });

        function biDirectionalLinkAssignment() {
            /*for (var i = 0; i < me.updatedLink.length; i++) {
                if (i < me.updatedLink.length - 1) {
                    if (me.updatedLink[i].source == me.updatedLink[i + 1].target || me.updatedLink[i + 1].source == me.updatedLink[i].target) {
                        if(me.updatedLink[i].biDirection != true){
                            me.updatedLink[i].biDirection = true;
                        }
                        me.updatedLink[i + 1].biDirection = true;

                    }else {
                        if(me.updatedLink[i].biDirection != true){
                            me.updatedLink[i].biDirection = false;
                        }
                        me.updatedLink[i + 1].biDirection = false;
                    }
                   
                } 
            }*/
            _.map(me.updatedLink, function (item) {
                if (!!_.find(me.updatedLink, function (i) {
                        return (item.source == i.target && item.target == i.source)
                    })) {
                    item.biDirectionalLink = true;
                } else {
                    item.biDirectionalLink = false;
                }
            });

        }
        biDirectionalLinkAssignment();
        me.updatedLink.forEach(function (link, index) {
            link['index'] = index;
            g.setEdge(link.source, link.target, {
                "width": 300,
                "height": 150,
                "minlen":1,
                "labelpos":"r",
                "labeloffset":10
            });
        });
        dagre.layout(g);
        g.nodes().forEach(function (dagreNode, index) {
            me.dagreNodes.push(g.node(dagreNode));
        });
        
        g.edges().forEach(function (dagerlink, index) {
           
            me.dagreLinks.push({
                //'metaData': me.updatedLink[index],
                'pathSvgData':g.edge(dagerlink),
                'source': dagerlink.v,
                'target': dagerlink.w,
                'index': index
            });
        });
    },
    
    init: function (nodeData, linkData, groupData) {
        
        var me = this;
        me.updatedNode = nodeData;
        me.updatedLink = linkData;
        me.updatedGrp = groupData; //future enhancement 
        me.updatedGrp = (typeof me.updatedGrp !== 'undefined') ? [] : me.topologyDataGroups;

        //initialization of x and y position of the node based on the dagre.graphlib.Graph @ graphLibAPI(this) 
        me.graphLibAPI(me);
        //initialization of d3-force @ AppFlowDashboard.view.AppFlowTopology.js
        me.simulationx = me.d3forceSimulation();

        // console.log("me.dagreNodes", me.dagreNodes);
        // console.log("me.updatedNode", me.updatedNode);
        // console.log("dagreLinks", me.dagreLinks);
        // console.log("updatedLink", me.updatedLink);

        // Moving an node selection to the front/back while hover and drag
        d3.selection.prototype.moveToFront = function () {
            return this.each(function () {
                this.parentNode.appendChild(this);
            });
        };
        d3.selection.prototype.moveToBack = function () {
            return this.each(function () {
                var firstChild = this.parentNode.firstChild;
                if (firstChild) {
                    this.parentNode.insertBefore(this, firstChild);
                }
            });
        };



        // @ AppFlowDashboard.util.TopologyLineDetails.js

        me.prepareLinksForBidirection(me.updatedLink);
        /*************************
         * Data binding with  me.graphLibAPI(me) with
         * JSON
         **************************/
        mergeLinkData = _.map(me.dagreLinks, function (item) {
            // console.log(item)
            return _.merge(item, _.find(me.updatedLink, {
                'index': item.index
            }));
        });

        mergeNodeData = _.map(me.dagreNodes, function (item) {
            return _.merge(item, _.find(me.updatedNode, {
                'tierId': item.tierId
            }));
        });

        me.simulationx.nodes(mergeNodeData).force('link').links(mergeLinkData);
        //me.simulationx.force('charge', d3.forceManyBody().strength(5));
        //me.simulationx.force('center', d3.forceCenter(me.width / 2, me.height / 2));
        me.simulationx.force('collision', d3.forceCollide().radius(function(d) {
            return d.height;
          }));
        /*************************
         * node 
         * mapping the dagreNodes with
         * existing JSON using tierId
         * TODO
         **************************/

        me.node = me.nodeGrp.selectAll(".node_x");
        me.node = me.node.data(mergeNodeData);
        me.node.exit().remove();
        me.node = me.node.enter().append("g").attr('class', 'node_x').attr('id', function (d) {
            return 'tierId_' + d.tierId;
        }).merge(me.node);

        me.node.each(function (d, i) {
            if (d['type'] != null && d['type'] == "BACKEND") {
                me.backendTypeUI(this);
            } else if (d['type'] == "user") {
                me.userUI(this, me.topologyData.userDetail);
            } else {
                me.tierOuterUI(this);
            }
        });

        //node drag handler
        me.node.call(d3.drag()
            .on("start", dragstarted)
            .on("drag", dragged)
            .on("end", dragended));



        //node click
        me.node.on('click', function (d, k) {
               
                if (d3.event.defaultPrevented) return;
                d3.select(this).moveToBack();
                //if (me.active.node() === this) return reset();
                //me.active = d3.select(this).classed("active", true);
                d3.select(this).select('.listGrpInner').remove();
                // return if user and backend node 
                if ((d['type'] != null && d['type'] == "BACKEND") || d['type'] == "user") {
                    return;
                } else {
                    me.clickFrom = 1;
                   
                    //@ AppFlowDashboard.util.TierUI.js
                    var nodeObj = this;
                    me.zoomNode(me.getGraphBound(d3.select(nodeObj)),function(){
                        me.nodeDetailsUI(nodeObj);
                    },nodeObj);
                    //me.nodeDetailsUI(this);
                }
                //d3.select('.active',this).on('mousedown.drag', null);
                


            })
            .on("mouseover", function (d, i) {
                d3.select(this).moveToFront();
                d3.selectAll(".link").transition().duration(100)
                    .attr('stroke-width', function (o, i) {
                        if (o.source === d || o.target === d) {
                            //show text below zoom level only
                            if (me.scale < me.defaultZoomValue()) {
                               // d3.select('#link-label-' + i).style("opacity", 1);
                            }
                            return 1.9;
                        } else {
                            return 1;
                        }
                        //return o.source === d || o.target === d ? 1.9 : 1;
                    });
            }).on("mouseout", function (d, i) {
                d3.selectAll(".link").transition().duration(100)
                    .attr('stroke-width', 1);
                if (me.scale < me.defaultZoomValue()) {
                    //d3.selectAll('.link-label').style("opacity", 0);
                }
            });



        /*************************
         * link 
         **************************/
        me.link = me.linkGrp.selectAll(".line_grp").data(mergeLinkData);
        me.link.exit().remove();
        me.link = me.link.enter().append("g").attr('class', 'line_grp').attr("id", function (d) {
            return "line-group-" + d.index;
        });
        var link = me.link.merge(me.link).append('path').attr('class', 'link');
        //path class is add here
        link.attr("marker-end", function (d, i) {
            //adding color arrows
            if (d.source.x === d.target.x && d.source.y === d.target.y) {
                return me.createArrowMarker(d, true);
            } else {
                return me.createArrowMarker(d, false);
            }
        }).each(function (d, i) {
            if (d.source.x === d.target.x && d.source.y === d.target.y) {
                d3.select(this).classed(d.state + '_Experience', true);
                d3.select(this).classed('selflink', true);
            }
            d3.select(this).classed(d.state + '_Experience', true);
            // console.log(d.pathSvgData.points);
            
            var line = d3.line().x(function(d, i) {
                return d.x;
              })
              .y(function(d) {
                return d.y;
              });
              d.pathData = line(d.pathSvgData.points);
                // console.log(line(d.pathSvgData.points),"line")

        });
        //mouseover link
        link.on("mouseover", function (d, i) {
            //show text below zoom level only
            if (me.scale < me.defaultZoomValue()) {
                //d3.select('#link-label-' + i).style("opacity", 1);
            }
            d3.select(this).transition().duration(100)
                .attr('stroke-width', function (o) {
                    return 1.9;
                });
        }).on("mouseout", function (d, i) {
            if (me.scale < me.defaultZoomValue()) {
                //d3.select('#link-label-' + i).style("opacity", 0);
            }
            d3.select(this).transition().duration(100)
                .attr('stroke-width', 1);
        });

        //self Link
        var selflink = me.link.filter(function (d) {
            return d.source.x === d.target.x && d.source.y === d.target.y;
        }).append("svg:path").attr("class", "link").style("stroke-width", function (d) {
            return 1;
        }).attr("marker-end", function (d) {
            //adding color arrows
            d.self = true;
            return me.createArrowMarker(d, true);
        }).each(function (d, i) {
            d3.select(this).classed(d.state + '_Experience', true);
        });

        //loading and showing all the line exp.
        //ref @ AppFlowDashboard.util.TopologyLineDetails.js
        me.renderlineExperienceData('ALL', mergeLinkData);

        /*********************************** 
         * re-initialization of x and y position
         * Dont ignore this block
         ***********************************/
        me.node.each(function (d) {
            d.fx = d.x;
            d.fy = d.y
        });

        /**********************************
         * d3 force layout tick function
         **********************************/
        me.simulationx.on('tick', ticked).on("end", function () {
            //modifying the points 
            me.node.each(function (d) {
                d.fx = d.x;
                d.fy = d.y
            });
        });

        function ticked() {
            // selflink
            selflink.attr("d", function (d) {
                return me.selfLinkPath(d, 20, 20, 2, 30);
            }).attr("transform", function (d) {
                var dx = d.target.x - d.source.x + 30,
                    dy = d.target.y - d.source.y - 20;
                if (d.source.x === d.target.x && d.source.y === d.target.y) {
                    return "translate(" + dx + "," + dy + ")"
                }
            });
            //link            
            link.attr('d', function (d) {
               
                if (d.source.x === d.target.x && d.source.y === d.target.y) {
                    return me.selfLinkPath(d, 40, 40, 0, 40);
                } else {


                    return "M" +
                        d.source.x + "," +
                        d.source.y + "L" +
                        d.target.x + "," +
                        d.target.y;


                }
            }).attr("transform", function (d) {

                var dx = d.target.x - d.source.x + 40,
                    dy = d.target.y - d.source.y - 40;
                if (d.source.x === d.target.x && d.source.y === d.target.y) {
                    return "translate(" + dx + "," + dy + ")"
                }
                if (d.biDirectionalLink) {
                    var delta = me.calcTranslationPositions(d.targetDistance, d.target, d.source);
                    return "translate(" + delta.dx + "," + delta.dy + ")"
                }


            });


            //Text on links 
            linkExpDetails.attr("transform", function (d) {

                var height = me.getSVGDimension(linkExpDetails).height - d.source.height;
                var width = me.getSVGDimension(linkExpDetails).width - d.source.width;
                if (d.source.x === d.target.x && d.source.y === d.target.y) {
                    return "translate(" + ((d.source.x + d.target.x) / 2 - width) + "," + ((d.source.y + d.target.y) / 2 + height) + ")"
                } else {
                    if (d.biDirectionalLink) {
                        var delta = me.calcTranslationPositions(d.targetDistance, d.target, d.source);
                        if (d.source.tierId < d.target.tierId) {

                            return "translate(" +
                                (((d.source.x + d.target.x - delta.dy) / 2) + (me.getSVGDimension(linkExpDetails).width / 2)) + "," +
                                (((d.source.y + d.target.y - delta.dx) / 2) + (me.getSVGDimension(linkExpDetails).height / 2)) + ")"
                        } else {

                            return "translate(" +
                                (((d.source.x + d.target.x - delta.dx) / 2) - (me.getSVGDimension(linkExpDetails).width / 2)) + "," +
                                (((d.source.y + d.target.y - delta.dy) / 2) - (me.getSVGDimension(linkExpDetails).height / 2)) + ")"
                        }

                    } else {
                        return "translate(" + (d.source.x + d.target.x) / 2 + "," + (d.source.y + d.target.y) / 2 + ")"
                    }


                }
            });

            me.node.attr("transform", function (d) {
                dx = d.x - d.width / 2;
                dy = d.y - d.height / 2;
                return "translate(" + dx + "," + dy + " ) ";
            });

        }
        //end of tick

        //Getting the x and y bound in the layout 
        var bounds = me.getGraphBound(me.node);
        /**********************************
         * d3 drag function
         **********************************/
        function dragstarted(d) {
            d3.event.sourceEvent.stopPropagation();
            if (!d3.event.active) me.simulationx.alphaTarget(0.3).restart();
            d.fx = d.x, d.fy = d.y;

        }

        function dragged(d) {
            d.fx = d3.event.x, d.fy = d3.event.y;
        }

        function dragended(d) {
            if (!d3.event.active) me.simulationx.alphaTarget(0);
            //Getting the x and y bound in the layout after drag 
            bounds = me.getGraphBound(me.node);

        }
        //end of drag

        //setting up the bounds in the method fitGraph method
        me.fitGraph(bounds);
        //toolbar autofit button
        Ext.get('autoFit').on('click', function () {
           var bounds = me.getGraphBound(me.node);

            me.fitGraph(bounds,me.body.getWidth(),me.body.getHeight());
        });
        // initial zoom method is called  @ zoom method 
        me.svg.call(me.zoom()).call(me.zoom().transform, me.transform).on("dblclick.zoom", null).on("click", function () {
            if (d3.event.defaultPrevented) d3.event.stopPropagation();
        }, true);
        me.escapeEvents();

    }
});