 Ext.define('AppFlowDashboard.util.ZoomOuttierUI', {
     override: 'AppFlowDashboard.view.AppFlowTopology',
     constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
     zoomOuttierUI: function (selector) {
         var me = this,
             currentGrp = d3.select(selector),
             data = currentGrp.datum(),
             selectorHeight = me.getSVGDimension(selector).height,
             selectorY = me.getSVGDimension(selector).y,
             selectorWidth = me.getSVGDimension(selector).width,
             selectorX = me.getSVGDimension(selector).x,
             thisUIWidth = 84,
             thisUIHeight = 44;

         function centerXY(parent, width, height) {
             parentY = me.getSVGDimension(parent).height / 2,
                 parentX = me.getSVGDimension(parent).width / 2,
                 heightY = height,
                 widthX = width / 2,
                 x = widthX + parentX,
                 y = parentY + heightY;
             return {
                 X: x,
                 Y: y
             }
         }

         //calculation TODO
         var outerbox = selector.append("path").attr("d", function (d) {
             return me.roundedRectangleSVG(d.width / 2 - thisUIWidth / 2, d.height / 2 - thisUIHeight / 2, thisUIWidth, thisUIHeight, 0, true, true, true, true)
         }).attr('class', 'zoomout_tireBox');
         selector.append('svg:image')
             .attrs({
                 'xlink:href': function (d, i) {
                     return '../images/component_icons/svg/'+me.getSkin(skinColor)+'/' + d.iconName + '.svg'
                 },
                 'width': 32,
                 'height': 32,
                 'x': function(d){ return ((d.width / 2) - (thisUIWidth/2)) + 8;},
                 'y': function(d){ return ((d.height / 2) - (thisUIHeight / 2)) + 8;}
             });
         var nodeCountText = selector.append('text').attr('class', 'innernode_count').attrs({
            'x': function(d){ return (d.width/2) - 18;},
            'y':  function(d){ return ((d.height / 2) - (thisUIHeight / 2)) + 8;}
         });
         nodeCountText.append('tspan')
             .text(function (d) {
                 return d.nodeCount;
             }).attrs({
                 'x': function(d){ return (d.width/2) + 15;},
                 'dy': '1em',
                 'class': 'svgtext_18',
                 'text-anchor': 'middle'
             });
         nodeCountText.append('tspan')
             .text(function (d) {
                 if (d.nodeCount == 1) {
                     return "node";
                 } else {
                     return "nodes";
                 }
             }).attrs({
                 'x': function(d){ return (d.width/2) + 15;},
                 'dy': '1em',
                 'class': 'svgtext_9',
                 'text-anchor': 'middle'
             });
     }
 });