 /*
  * Creating the Ext js silder component
  * renders in the container body 
  * this component is aligned by the method "alignTo"
  * returns the Ext.container.Container with ["button(+)","slider","button(-)"]
  * included in AppFlowDashboard.util.TopologyZoom.js
  */

 
 Ext.define('AppFlowDashboard.util.ZoomSliderUI', {
     override: 'AppFlowDashboard.view.AppFlowTopology',
     constructor: function (config) {
         this.callParent(arguments); // calls AppFlowDashboard.view.AppFlowTopology constructor
     },
     sliderComponent: function () {
         var me = this,
            scalingValue = d3.scaleLinear().domain([me.zoomExtend[0], me.zoomExtend[1]]).range([1, 100]);
             sc = Ext.create('Ext.container.Container', {
                 floating: true,
                 height: 140,
                 padding: 0,
                 cls: 'slidercontainer',
                 id: 'slidercontainer',
                 margin: 0,
                 style: {
                     'z-index': 9
                 },
                 layout: {
                     type: 'vbox'
                 },
                 items: [{
                     xtype: 'button',
                     cls: 'zoomInbt',
                     id: 'zoom_in',
                     width: 20,
                     height: 20,
                     style: {
                         'z-index': 9
                     },
                     margin: '0 0 -4 0',
                     listeners: {
                         click: function (btn, e) {
                             var slider = Ext.ComponentQuery.query('slider')[0];
                             slider.zoomFn(btn, e);
                         }
                     }
                 }, {
                     xtype: 'slider',
                     width: 20,
                     style: {
                         'z-index': 8
                     },
                     tipText: function (thumb) {
                         return Math.round(scalingValue(thumb.value))+"%";
                     },
                     height: 100,
                     margin: 0,
                     value: me.defaultZoomValue(),
                     id: 'slider',
                     zoomFn: function (btn, e) {
                         var slider = this,
                             clicked = e.target,
                             direction = 1,
                             factor = 0.1,
                             target_zoom = 1,
                             center = [me.getWidth() / 2, me.getHeight() / 2],
                             extent = me.zoom().scaleExtent(),
                             translate = d3.zoomTransform(me.svg.node()),
                             translate0 = [],
                             l = [],
                             view = {
                                 x: translate.x,
                                 y: translate.y,
                                 k: translate.k
                             };
                         direction = (btn.id === 'zoom_in') ? me.zoomExtend[0] : -me.zoomExtend[0];
                         //console.log('DIRECTiON:', direction);
                         target_zoom = view.k * (1 + factor * direction);
                         //console.log('extent[0]',extent[0])
                         if (target_zoom < extent[0] || target_zoom > extent[1]) {
                             return false;
                         }
                         translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
                         view.k = target_zoom;
                         l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];
                         view.x += center[0] - l[0];
                         view.y += center[1] - l[1];
                         //console.log('view.k',view.k);
                         //me.interpolateZoom([view.x, view.y], view.k);
                         me.translateX = view.x;
                         me.translateY = view.y;
                         me.scale = view.k;
                         slider.setValue(view.k, true)
                         slider.paperZoom(view.x, view.y, view.k)
                     },
                     paperZoom: function (vx, vy, scale) {
                         me.svg.call(me.zoom().transform, d3.zoomIdentity.translate(vx, vy).scale(scale));
                     },
                     //increment: me.zoomExtend[0],
                     listeners: {
                         drag: function (slider, e, eOpts) {
                             me.zoom().scaleTo(me.svg, slider.getValue());
                         }
                     },
                     decimalPrecision: 2,
                     vertical: true,
                     minValue: me.zoomExtend[0],
                     maxValue: me.zoomExtend[1]
                 }, {
                     xtype: 'button',
                     cls: 'zoomOutbt',
                     id: 'zoom_out',
                     width: 20,
                     style: {
                         'z-index': 9
                     },
                     height: 20,
                     margin: '-2 0 0 0',
                     listeners: {
                         click: function (btn, e) {
                             var slider = Ext.ComponentQuery.query('slider')[0];
                             slider.zoomFn(btn, e.target);
                         }
                     }
                 }],
                 listeners: {
                     afterrender: function (cmp, eOpts) {
                         cmp.alignTo(me.id, 'bl-bl', [25, -25]);
                     }
                 },
                 renderTo: me.body.id
             });
         return sc;
     }
 });