Ext.define('AppFlowDashboard.view.AppFlowMoreInfo', {
		extend: 'Ext.tip.ToolTip',
		alias:'widget.appflowmoreinfo',
		anchor: 'top',
		anchorOffset:125,
		width:160,
		shadow:true,
		 anchorToTarget: false,
        stateful: false,
		autoHide:false,
		renderTo:Ext.getBody(),
		id:'moreInfo',
		cls : 'moreoptionstooltip',
		items:[{
					xtype: 'fieldcontainer',
					labelSeparator:'',
					fieldLabel:'More Options',
					margin:'0 0 15 0'
				},{
					xtype: 'fieldcontainer',
					labelAlign:'top',
					cls:'fieldcontainer',
					defaultType: 'checkboxfield',
					items: [
						{
							boxLabel  : 'Show Healthy Metrics',
							inputValue: '2',
							cls:'checkbt',
							itemId:'healthyMetrics',
							checked:true,
							id:'healthyMetrics',
							listeners:{
								change:function( btn, newValue, oldValue, eOpts ){
									//console.log(newValue)
									if(!newValue){
										Ext.getCmp('appflowtopology').renderlineExperienceData("GOOD");
									}else{
										Ext.getCmp('appflowtopology').renderlineExperienceData("ALL");
									}
								}
							}
						},
						{
							xtype:'button',
							hidden:true,
							text:'healthyMetrics1',
							id:'healthyMetrics1',
							handler:function(){
								Ext.getCmp('appflowtopology').filterState("HIGH");
							}
						}
					]
				}]
});