/**
 * view.AppFlowTopology is a container that has specific functionality and structural components that make it the perfect building
 * AppFlow topology diagram.
 * This container is the combination of 
 * d3.js(v4x) (https://d3js.org/)  @ responsible for svg rendering , zoom and pan
 * https://github.com/dagrejs/dagre/wiki @ responsible to form the layout such as X , Y positions and drag 
 * Lodash (https://lodash.com/)  @ js utility library delivering consistency, modularity, performance on the array , objects
 */
Ext.define('AppFlowDashboard.view.AppFlowTopology', {
    extend: 'Ext.panel.Panel',
    requires: [
        'AppFlowDashboard.util.AjaxCall',
        'AppFlowDashboard.util.StaticFunctionVaribales',
        'AppFlowDashboard.util.SVGAssets',
        'AppFlowDashboard.util.TopologyLayoutRendering',
        'AppFlowDashboard.util.Topologyinit',
        'AppFlowDashboard.util.TopologyLineDetails',
        'AppFlowDashboard.util.UserUI',
        'AppFlowDashboard.util.TierUI',
        'AppFlowDashboard.util.ZoomOuttierUI',
        'AppFlowDashboard.util.BackEndTierUI',
        'AppFlowDashboard.util.TierNodeHealthStatsChart',
        'AppFlowDashboard.util.TopologyZoom',
        'AppFlowDashboard.util.TopologyTooltip',
        'AppFlowDashboard.util.ListofNodeDetails',
        'AppFlowDashboard.util.Pagination',
        'AppFlowDashboard.view.AppFlowTopologyToolbar',
        'AppFlowDashboard.view.AppFlowMoreInfo',
        'AppFlowDashboard.util.KeyboardEvents'
    ],
    alias: 'widget.appflowtopology',
    id: 'appflowtopology',
    ui: 'newGraphPanel',
    tools: [{
        xtype: 'toolbar',
        items: [{
            xtype: 'appflowtoolbar'
        }]
    }],
    initComponent: function () {
        var me = this;
        me.mon(me, 'afterrender', function (c) {
           me.ajaxCall('/final/servlet/com.eg.apm.APMTopologyServlet');
           // me.ajaxCall('eg_scripts/AppFlowDashboard/data/test.json');
           // me.ajaxCall('eg_scripts/AppFlowDashboard/data/appflowData_Tue_Sep_18_18-03-00_IST_2018.json');
           // me.ajaxCall('eg_scripts/AppFlowDashboard/data/differentState.json');
		   
           //me.ajaxCall('eg_scripts/AppFlowDashboard/data/file_AllPC.json');
           // me.ajaxCall('eg_scripts/AppFlowDashboard/data/2tier1node1SqlCall.json');
          
           // me.ajaxCall('/final/servlet/com.eg.apm.AppFlowTopologyServlet');
            //Responsive behaviour
            me.viewport = Ext.ComponentQuery.query('viewport')[0];
            me.viewport.on('resize', function (viewport, width, height, oldWidth, oldHeight, eOpts) {
                if (me.svg) {
                    //me.svg.attr('width', width).attr('height',  height);
                    var sliderheight = Ext.getCmp('slidercontainer').getHeight() + 50;
                    Ext.getCmp('slidercontainer').setPosition(25, (height - 50) - sliderheight);

                    var bounds = me.getGraphBound(me.node);
                    me.fitGraph(bounds);

                }

            });

        }, me);
        me.callParent();
    },
    d3forceSimulation: function() {
        /****************************************************
         * ref @ https://github.com/d3/d3-force 
         ****************************************************/
        var me = this;
        var force = d3.forceSimulation(me.dagreNodes)
        .force("charge", d3.forceManyBody())
        .force("link", d3.forceLink().id(function (d) {
            return d.index
        }))
        .force("collide",d3.forceCollide().strength(0).radius(0))
        .force("x", d3.forceX())
        .force("y", d3.forceY())
        .alphaTarget(1);

        return force;
    },
    ajaxCall: function(uri) {
		var fileNO="0";
		var tempCommand=this.param;
		if(parent.document.getElementById('appFlowFileNo')== null){
		// console.log(' >>>> appFlowFileNo not found using default :  ',);
		}else {
			fileNO=parent.document.getElementById('appFlowFileNo').value;
			// console.log(' >>>> New appFlowFileNo :  ',fileNO);
			if(fileNO != "0"){
				tempCommand = "test";
				// console.log(' >>>> Appflow on Testing mode : command -  ',tempCommand);
			}
		}
     var me = this;
	//@ AppFlowDashboard.util.AjaxCall.js
	//console.log("applicationName >>>",this.param)
	AppFlowDashboard.util.AjaxCall.request({
	 method: 'POST',
	 params: {
                applicationName: this.param,
                topologyType: 'APPFLOW',
				// command: 'test',
				// command: this.param,
				command: tempCommand,
                skin: 'Light',
				appFlowFileNo: fileNO,
				timeline: this.timeline
				//startTime : '',
				//endTime : ''
            },
		url: uri,
		success: function(response){
				var data = Ext.decode(response.responseText);
                if (Ext.isFunction(me.renderTopolgy)) {
                    //AppFlowDashboard.util.TopologyLayoutRendering.js 
                    me.renderTopolgy(data);						
                }
		}
	});
    },
    //title: 'Application Flow Across Tiers',
    header: {
        style: {
            'padding-top': '0 !important'
        }
    },
    margin: '0px 10px 10px 10px',
    flex: 1,
    //title: 'Application Flow Across Tiers',
    bodyPadding: 10,
    border: true
});