/**
 * @author
 * This js file contains graph render , Snapshot Default View and Legends
 * Directed graph renderer for javascript based on D3.
 * For info https://github.com/cpettitt/dagre/
 */
 
 // Graph render IIFE function
 var graphObjTools ={};
(function(selector, graphData) {

	// Override the "Ext.dom.Element" to align tootip in IE 10 & IE11 @ graphObjTools.userToolTipUI method

	Ext.define('Ext.dom.Element', {
		override:'Ext.dom.Element',
		adjustDirect2DDimension: function(dimension) {
		  var me = this,
            dom = me.dom,
            display = me.getStyle('display'),
            inlineDisplay = dom.style.display,
            inlinePosition = dom.style.position,
            originIndex = dimension === "WIDTH" ? 0 : 1,
            currentStyle = dom.currentStyle,
            floating;
        return floating;
    }
 });
	//console.log('JSON Data -->',graphData);

 //var graphDataBTM = graphData.BTM,
// graphDataRUM = graphData.RUM;
  var graphDataBTM = graphData;
  var drawGraph = function() {
        graphObjTools = {
            graphRender: new dagreD3.render(),
            zoom: d3.behavior.zoom(),
            minZoom: 0.2,
            maxZoom: 2,
            initialScale: 1.1,

            d3Translate: d3.behavior.zoom().translate(),
            d3Scale: d3.behavior.zoom().scale(),
            assets: {},
            fontSize: 10,
            graphWidth: window.innerWidth,
            graphHeight: window.innerHeight,
            getWidth: function() {
                return this.graphWidth;
            },
            getHeight: function() {
                return this.graphHeight;
            },
			userToolTipUI:function(ele,anchorpos,x,y,eleWidth,eleHeight,targetEleOffsetLeft,targetEleOffsetTop,eleX,eleY){
				var dataforRUM = graphData.userTooltip.tabRUM;
				var dataforBTM = graphData.userTooltip.tabBTM;
				var noDataIcon = "noDataIcon";
				var tooltipTitle = "<span data-qtip='"+graphData.userTooltip.headerText+"' data-qclass='yellowTip para'>"+graphData.userTooltip.headerText+"</span>";
				// RUM
				var rumData = false,
				rumTabTitle = dataforRUM.tabName,
				showActiveTab = 0,
				rumStateIcon = noDataIcon,
				rumState = dataforRUM.transactionExperience,
				rumContent="",
				hideTab = false;

				if(dataforRUM.isDataPresent == "No"){
					rumData = true;
					hideTab = true;
					rumTabTitle = dataforRUM.tabName+"<br><span style='font-size:11px;'><span><span>No data available</span>";
					showActiveTab = 1;

				}else{
					showActiveTab = 0;
					if(rumState){
						rumStateIcon = rumState == 'HEALTHY' ? 'btm_rum_dd_icons_healthy' : rumState == 'ERROR' ? 'btm_rum_dd_icons_error' : rumState == 'SLOW' ? 'btm_rum_dd_icons_slow' : rumState == 'STALLED' ? 'btm_rum_dd_icons_stalled' : 'iconAlert';
					}
					if(dataforRUM.tabData){
						var transactionProcessingTime = "",
							frontEnd ="",
							backEnd ="",
							network ="",
							browser="",
							device="",
							userLocation="",
							requestTime="";
						for(var keys in dataforRUM.tabData){
							switch(dataforRUM.tabData.hasOwnProperty(keys)){
								case "Transaction Processing Time":
								transactionProcessingTime= "<div class='tpt'><span>"+keys+" : </span><span class='font_bold13'>"+dataforRUM.tabData[keys]+"</span></div>";
								break;

								case "Front End":
								frontEnd = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								break;

								case "Back End":
								backEnd = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								break;

								case "Network":
								network = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								break;

								case "browser":
								findBrowser = dataforRUM.tabData[keys] == 'Chrome' ? 'endUserBrowserChrome' : dataforRUM.tabData[keys] == 'Opera' ? 'endUserBrowserOpera' : dataforRUM.tabData[keys] == 'Internet Explorer' ? 'endUserBrowserIE' : dataforRUM.tabData[keys] == 'Firefox' ? 'endUserBrowserFireFox' : dataforRUM.tabData[keys] == 'Safari' ?
										'endUserBrowserSafari' : /*default*/'endUserBrowserOther';
								browser = "<li><img src='/final/images/clear.png' class='"+findBrowser+"'/>"+dataforRUM.tabData[keys]+"</li>";
								break;

								case "device":
								findDevice = dataforRUM.tabData[keys] == 'Desktop' ? 'endUserDeviceDesktop' : dataforRUM.tabData[keys] == 'iPad' || 'Tablet' ? 'endUserDeviceTab' : dataforRUM.tabData[keys] == 'Mobile' || 'Phone' ? 'endUserDeviceMobile' : /*default*/'endUserDeviceDesktop';

								device = "<li><img src='/final/images/clear.png' class='"+findDevice+"'/>"+dataforRUM.tabData[keys]+"</li>";
								break;

								case "location":
								userLocation = "<li><img src='/final/images/clear.png' class='endUserLocation'/>"+dataforRUM.tabData[keys]+"</li>";
								break;

								case "requestTime":
								requestTime = "<li><img src='/final/images/clear.png' class='endUserDuration'/>"+dataforRUM.tabData[keys]+"</li>"; 
								break;
							}
							rumContent = "<div class='rumContent'>"
											+"<div>"+transactionProcessingTime+"</div>"
											+"<div class='rumblock'>"
											+frontEnd +network +backEnd
											+"</div>"
											+"<ul class='latency'>"
											+device +browser +userLocation +requestTime
											+"</ul>"
											+"<div>";
							/*if(dataforRUM.tabData.hasOwnProperty(keys)){
								if(keys == "Transaction Processing Time"){
									transactionProcessingTime= "<div class='tpt'><span>"+keys+" : </span><span class='font_bold13'>"+dataforRUM.tabData[keys]+"</span></div>";
								}
								if(keys == "Front End"){
										frontEnd = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								}
								if(keys == "Back End"){
										backEnd = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								}
								if(keys == "Network"){
										network = "<div class='x-box'><div style='padding-bottom: 5px;'>"+keys+"</div><div class='font_bold13'>"+dataforRUM.tabData[keys]+"</div></div>";
								}
								if(keys == "browser"){
										findBrowser = dataforRUM.tabData[keys] == 'Chrome' ? 'endUserBrowserChrome' : dataforRUM.tabData[keys] == 'Opera' ? 'endUserBrowserOpera' : dataforRUM.tabData[keys] == 'Internet Explorer' ? 'endUserBrowserIE' : dataforRUM.tabData[keys] == 'Firefox' ? 'endUserBrowserFireFox' : dataforRUM.tabData[keys] == 'Safari' ?
										'endUserBrowserSafari' : default'endUserBrowserOther';
										browser = "<li><img src='/final/images/clear.png' class='"+findBrowser+"'/>"+dataforRUM.tabData[keys]+"</li>";
								}
								if(keys == "device"){
										findDevice = dataforRUM.tabData[keys] == 'Desktop' ? 'endUserDeviceDesktop' : dataforRUM.tabData[keys] == 'iPad' || 'Tablet' ? 'endUserDeviceTab' : dataforRUM.tabData[keys] == 'Mobile' || 'Phone' ? 'endUserDeviceMobile' : default'endUserDeviceDesktop';

										device = "<li><img src='/final/images/clear.png' class='"+findDevice+"'/>"+dataforRUM.tabData[keys]+"</li>";
								}
								if(keys == "location"){
									userLocation = "<li><img src='/final/images/clear.png' class='endUserLocation'/>"+dataforRUM.tabData[keys]+"</li>";
								}
								if(keys == "requestTime"){
									requestTime = "<li><img src='/final/images/clear.png' class='endUserDuration'/>"+dataforRUM.tabData[keys]+"</li>";

								}

								rumContent = "<div class='rumContent'>"
											+"<div>"+transactionProcessingTime+"</div>"
											+"<div class='rumblock'>"
											+frontEnd +network +backEnd
											+"</div>"
											+"<ul class='latency'>"
											+device +browser +userLocation +requestTime
											+"</ul>"
											+"<div>";
							}*/
						}
					}
				}

				// BTM
				var btmStateIcon = noDataIcon,
				btmserver=[],arryTierLegend = [],arryServerLegend = [],
				btmTabTitle = dataforBTM.tabName,
				btmState = dataforBTM.transactionExperience,
				chartDataByServer = dataforBTM.tabData.byServer,
				chartDataByTier = dataforBTM.tabData.byTier,
				chartTitle = "",
				chartVal = "";
				chartDataByTierLegend = chartDataByTier.series[0].data;
				chartDataByServerLegend = chartDataByServer.series[0].data;
				for (var g=0;g< chartDataByTierLegend.length;g++ )
				{
					arryTierLegend.push(chartDataByTierLegend[g].name);

				}
				for (var g=0;g< chartDataByServerLegend.length;g++ )
				{
					arryServerLegend.push(chartDataByServerLegend[g].name);

				}


				for (var keys in dataforBTM.tabData )
				{
					if(keys == "Transaction Processing Time"){
						chartTitle = keys+" : ";
						chartVal = dataforBTM.tabData[keys];
					}
				}
				if(btmState){
					//btmStateIcon = btmState == 'HEALTHY' ? 'state_GOOD' : btmState == 'ERROR' ? 'state_HIGH' : btmState == 'SLOW' ? 'state_LOW' : btmState == 'STALLED' ? 'state_INTERMEDIATE' : 'iconAlert';
						btmStateIcon = btmState == 'HEALTHY' ? 'btm_rum_dd_icons_healthy' : btmState == 'ERROR' ? 'btm_rum_dd_icons_error' : btmState == 'SLOW' ? 'btm_rum_dd_icons_slow' : btmState == 'STALLED' ? 'btm_rum_dd_icons_stalled' : 'iconAlert';
				}

				if (userToolTip) {
					userToolTip.destroy();
					userToolTip = null;
				}
				// Close the tooltip on mousewheel
				whenScroll = function (e) {
					if (userToolTip) {
						userToolTip.destroy();
						userToolTip = null;
					}
					e.preventDefault();
				};

				if (window.addEventListener) {
					window.addEventListener("mousewheel", whenScroll, false);
					window.addEventListener("DOMMouseScroll", whenScroll, false);
				} else {
					window.attachEvent("onmousewheel", doScroll);
				}

				var userToolTip = Ext.create('Ext.tip.ToolTip',{
									renderTo:document.body,
									width:486,
									maxWidth:486,
									padding:'10 20 10 20',
						
									height:322,
									layout: {
										type: 'fit'
									},
									model:false,
									target:ele.id,
									anchor: anchorpos,
									constrainPosition:true,
									anchorToTarget:true,
							
									//trackMouse: true,
									getTargetXY: function() {
											var me = this,
												mouseOffset,
												offsets, xy, dw, dh, de, bd, scrollX, scrollY, axy, sz, constrainPosition;
											if (me.delegate) {
												me.anchorTarget = me.triggerElement;
											}
												
											if (me.anchor) {
												me.targetCounter++;
												offsets = me.getOffsets();
												
												xy = (me.anchorToTarget && !me.trackMouse) ? me.el.getAlignToXY(me.anchorTarget, me.getAnchorAlign()) : me.targetXY;
											
												dw = Ext.Element.getViewWidth() - me.getWidth();
												dh = Ext.Element.getViewHeight() - 45;
												de = document.documentElement;
												bd = document.body;
												scrollX = (de.scrollLeft || bd.scrollLeft || 0) + 45;
												scrollY = (de.scrollTop || bd.scrollTop || 0) + me.getHeight();
												axy = [xy[0] + offsets[0], xy[1] + offsets[1]];
												sz = me.getSize();
												constrainPosition = me.constrainPosition;
												
												me.anchorEl.removeCls(me.anchorCls);

												if (me.targetCounter < 2 && constrainPosition) {
													if (axy[0] < scrollX) {
														if (me.anchorToTarget) {
															me.defaultAlign = 'l-r';
															if (me.mouseOffset) {
																me.mouseOffset[0] *= -1;
															}
														}
														me.anchor = 'left';

														return me.getTargetXY();
													}
													if (axy[0] + sz.width > dw) {
														if (me.anchorToTarget) {
															me.defaultAlign = 'r-l';
															if (me.mouseOffset) {
																me.mouseOffset[0] *= -1;
															}
														}
														me.anchor = 'right';
														return me.getTargetXY();
													}
													if (axy[1] < scrollY) {
														if (me.anchorToTarget) {
															me.defaultAlign = 't-b';
															if (me.mouseOffset) {
																me.mouseOffset[1] *= -1;
															}
														}
														me.anchor = 'top';
														return me.getTargetXY();
													}
													if (axy[1] + sz.height > dh) {
														if (me.anchorToTarget) {
															me.defaultAlign = 'b-t';
															if (me.mouseOffset) {
																me.mouseOffset[1] *= -1;
															}
														}
														me.anchor = 'bottom';
														return me.getTargetXY();
													}
												}

												me.anchorCls = Ext.baseCSSPrefix + 'tip-anchor-' + me.getAnchorPosition();
												me.anchorEl.addCls(me.anchorCls);
												me.targetCounter = 0;
												return axy;
											} else {

												mouseOffset = me.getMouseOffset();
												return (me.targetXY) ? [me.targetXY[0] + mouseOffset[0], me.targetXY[1] + mouseOffset[1]] : mouseOffset;
											}
										},
									getOffsets: function() {

											var me = this,
												mouseOffset,
												offsets,
												ap = me.getAnchorPosition().charAt(0),
												anchorSize = 32;

											if (me.anchorToTarget && !me.trackMouse) {
												switch (ap) {
												case 't':
													offsets = [((-me.getWidth()/2) + (eleWidth/2) + anchorSize),eleHeight];
													break;
												case 'b':
													offsets = [((-me.getWidth()/2) + (eleWidth/2) - anchorSize),0];
													break;
												case 'r':
													offsets = [(eleWidth/2 - anchorSize), ((-me.getHeight()/2) + (eleHeight/2) + anchorSize)];
													break;
												default:
													offsets = [(-(eleWidth /2) + anchorSize), ((-me.getHeight()/2) + (eleHeight/2) + anchorSize)];
													break;
												}
											} else {
												switch (ap) {
												case 't':
													offsets = [ - 15 - me.anchorOffset, 30];
													break;
												case 'b':
													offsets = [ - 19 - me.anchorOffset, -13 - me.el.dom.offsetHeight];
													break;
												case 'r':
													offsets = [ - 15 - me.el.dom.offsetWidth, -13 - me.anchorOffset];
													break;
												default:
													offsets = [25, -13 - me.anchorOffset];
													break;
												}
											}
											mouseOffset = me.getMouseOffset();
											offsets[0] += mouseOffset[0];
											offsets[1] += mouseOffset[1];

											return offsets;
										},
									 syncAnchor: function() {

										var me = this,
											anchorPos,
											targetPos,
											offset;

										switch (me.tipAnchor.charAt(0)) {
										case 't':

											anchorPos = 'b';
											targetPos = 'tl';
											offset = [me.getWidth()/2, 1];
											break;
										case 'r':
											anchorPos = 'l';
											targetPos = 'tr';
											offset = [ - 1, me.getHeight()/2];
											break;
										case 'b':
											anchorPos = 't';
											targetPos = 'bl';
											offset = [me.getWidth()/2, -1];
											break;
										default:
											anchorPos = 'r';
											targetPos = 'tl';
											offset = [1, me.getHeight()/2];
											break;
										}
										me.anchorEl.alignTo(me.el, anchorPos + '-' + targetPos, offset);
										me.anchorEl.setStyle('z-index', parseInt(me.el.getZIndex(), 10) || 0 + 1).setVisibilityMode(Ext.Element.DISPLAY);
									},
									closeAction:'destroy',
									title:tooltipTitle,
									ui :'userToolTip',
									autoHide:false,
									listeners:{
										 hide: function () {
											userToolTip.destroy();
											userToolTip = null;
										},
										render:function(tooltip){
												
												Ext.EventManager.onWindowResize(function(w, h){
													tooltip.destroy();
												});
												Ext.DomHelper.append(tooltip.getEl(), {
													tag: 'div',
													text:'closeMe',
													id:tooltip.id+'closeMe',
													cls:'BubbleCloseBtn'
													});
												Ext.get(tooltip.id+'closeMe').on('click',function(){
													if(tooltip.isVisible(true)){
														tooltip.destroy();
													}
												});
										}
									},
									items: new Ext.create('Ext.tab.Panel', {
											layout:{type:'vbox',align:'stretch'},
											border:true,
											cls:'mainTab',
											frame:0,
											frameHeader:false,
											plain : true,
											tabBar: {
												defaults: {
													cls:'maintabBt',
													disabledCls:'mainTab-disabled'
												}
											},
											activeTab: showActiveTab,
											items: [
												{
													title: rumTabTitle,// disabled when no rum data
													iconCls:rumStateIcon,
													bodyPadding: 10,
													hidden:hideTab,
													disabled:rumData, // disabled when no rum data
													cls:'tabChild',
													margin:'10 0 0 0',
													flex:1,
													html : rumContent
												},
												{
													title: btmTabTitle,
													bodyPadding:0,
													iconCls:btmStateIcon, // disabled no BTM data
													margin:'10 0 0 0',
													flex:1,
													layout:{type:'vbox',align:'stretch'},
													items:[
														{
															xtype: 'tabpanel',
															flex:1,
															frame:0,
															ui:'subTab',
															cls:'leftalignTab',
															frameHeader:false,
															plain : true,
															border:false,
															tabBar: {
															defaults: {
																flex: 1,
																border:false,
																cls:'btn-vertical-text'

															},
															dock: 'left',
															layout: {
																pack: 'vbox',
																align:'stretch'
															}
															},
															items:[
																{
																	title:'By Server',
																	flex:1,
																	cls:'tabChild',
																	ui:'innerSubTab',
																	padding:10,
																	layout:{
																		type:'vbox',
																		align:'stretch'
																	},
																	items:[{
																		xtype:'container',
																		height:18,
																		html:'<div class="titlecolor"><span class="font_bold12">'+chartTitle+'</span><span class="font_bold14"><b >'+chartVal+'</b></span></div>'
																	},{
																		xtype:'container',
																		flex:1,
																		listeners:{
																		boxready:function(c){
																			//Ext.defer(function(){
																				//chartDataByTier.title.text = chartTitle + chartVal;
																				$('#'+c.id).highcharts(chartDataByServer);
																				$('#'+c.id+' .highcharts-legend text').each(function(index, element) {
																						$(element).attr({'data-qclass':'yellowTip','data-qtip':arryServerLegend[index]});
																				});
																			//},100);

																		}
																	}
																		}]


																},{
																	title:'By Tier',
																	flex:1,
																	cls:'tabChild',
																	ui:'innerSubTab',
																	padding:10,
																	layout:{
																		type:'vbox',
																		align:'stretch'
																	},
																	items:[{
																		xtype:'container',
																		height:18,
																		html:'<div class="titlecolor"><span class="font_bold12">'+chartTitle+'</span><span class="font_bold14"><b >'+chartVal+'</b></span></div>'
																	},{
																		xtype:'container',
																		flex:1,
																		listeners:{
																		boxready:function(c){
																			//Ext.defer(function(){
																				//chartDataByTier.title.text = chartTitle + chartVal;
																				$('#'+c.id).highcharts(chartDataByTier);
																				//highcharts-legend-item
																				$('#'+c.id+' .highcharts-legend text').each(function(index, element) {
																					//console.log('arryTierLegend-----',index);
																						$(element).attr({'data-qclass':'yellowTip','data-qtip':arryTierLegend[index]});
																					});
																			//},100);

																		}
																	}
																		}]

																}
															]

														}

													]
												}
											]
										})

								});

								//userToolTip.show();
								return userToolTip;

			},
            lineInterpolate: "monotone",
            graphAlign: "LR",
            nodeData: [],
            linkData: [],
			textTruncateLength : !graphData.paper.displayCount ?  32 : graphData.paper.displayCount,
			textTruncate: function (fullStr, strLen, separator) {
											if(!Ext.isEmpty(fullStr)){
											if (fullStr.length <= strLen) return fullStr;
											separator = separator || '...';
											var sepLen = separator.length,
												   charsToShow = strLen - sepLen,
												   frontChars = Math.ceil(charsToShow/2),
												   backChars = Math.floor(charsToShow/2);
												return fullStr.substr(0, frontChars) +  separator +   fullStr.substr(fullStr.length - backChars);
											}
			},
			highLightNodeCheck:0,
			hightLightCheckType:'all',//'componentName','componentType'
			highLightNode:function(el,width,height,x,y){
					//var t = d3.transition().duration(750).ease(d3.easeLinear);
					d3.select(el).selectAll('rect')
						.attr('class', 'highlight userExpLine').transition()
									.attr({
										'width':  width + 20 ,
										'height': height,
										'x':  x - 10 ,
										'y': y
									}) .style({
										'fill': '#40b5c5'
										})
					//d3.select(this).selectAll('.highlight').attr("width", d3.select(this).node().getBBox().width).attr("height", 35);
			}

        }
		// Removing All child nodes
		d3.select(selector[0]).selectAll("*").remove();

        var rootSVG = d3.select(selector[0]).append("svg").attr("width", graphObjTools.graphWidth).attr("height", graphObjTools.graphHeight).attr("class", "graph-attach");
        rootSVG.attr('viewBox', "0 0 " + graphObjTools.graphWidth + " " + graphObjTools.graphHeight + "").attr('preserveAspectRatio', 'xMinYMin meet');
        rootSVG.attr('xmlns', "http://www.w3.org/2000/svg");
        var innerGroupNode = rootSVG.append('g').attr("class", "graphinnergrp");

        graphObjTools.baseSvg = d3.select("svg.graph-attach");
        graphObjTools.innerGrp = d3.select("g.graphinnergrp");

		// Adding cursor
		$('.graph-attach').mousedown(function() {
            $(this).css("cursor", "url('/final/images/closedhand.cur'),default");
        }).mouseover(function() {
            $(this).css("cursor", "url('/final/images/openhand.cur'),default");
        }).mouseup(function() {
            $(this).css("cursor", "url('/final/images/openhand.cur'),default");
        });
        // Adding zoom slider width jquery UI

        var slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
            position: 'absolute',
            top: -1,
            left: 20
        }).hide();

		 // Slider UI destroy
		if($(".slider").slider()){
			$(".slider").slider("destroy");
			$(".slider").remove();
		}
        var addSlider = function() {
			if($('.slider')){
				$('.slider').remove();
			}
            var slider = $('<div class="slider btmslider"></div>');
            var sliderFake = $('<div class="slider_buttons"></div>');
            var slider_buttons = slider.append(sliderFake);
            var zoomslider_in = slider_buttons.append('<button style="top:-27px;left: -7px;z-index:99" data-qtip="ZoomIn" id="zoom_in" class="button_zoom zoomInbt zoomtop"></button>');
            var zoomslider_out = slider_buttons.append('<button style="bottom: -17px;left: -7px;z-index:99" data-qtip="ZoomOut" id="zoom_out" class="button_zoom zoomOutbt zoombottom"></button>');
            cssObj = {
                'left': '35px',
                'top': graphObjTools.graphHeight - 240 + 'px'
            };
            slider.css(cssObj);
            sliderFake.css(cssObj);
            slider.appendTo(selector[0]);
        }

        addSlider();
		// info
		if(graphDataBTM.incompleteDataText == "None"){
			$('#info').hide();
		}else if(graphDataBTM.incompleteDataText == "Note"){
			$('#info').html('<span class="btminfoholder"><span ></span><span class="btmhelptext">*Topology above represents the complete request flow</span>&nbsp;<span class="iconTooltipHelp" id="btminfo"  style="cursor:pointer;padding:4px 7px"></span></span>').show();
		}
		else{
			$('#info').html('<span class="btminfoholder"><span >Incomplete Data</span><span class="btmhelptext">*Topology above represents the complete request flow</span><span id="btminfo" class="iconTooltipHelp" style="cursor:pointer;padding:4px 7px">&nbsp;</span></span>').show();
		}
		if(Ext.get('btminfo')){
			Ext.get('btminfo').on('click',function(e){
				var bottom = $('#info').position().top ;
				var left = $('#info').position().left;
				var negativeTimeInTopologyStr = "";
				if(graphData.NegativeTimeInTopology == 'none'){
					negativeTimeInTopologyStr ="";
				}else{
						negativeTimeInTopologyStr = graphData.NegativeTimeInTopology;
				}	
				Ext.apply(infotooltip,{
					target: 'btminfo',
					anchorToTarget: true,
					width:220,
					mouseOffset:[0,0],
					anchor: 'bottom',
					html:'<div style="font-size:11px;font-weight: bold;margin-bottom:5px;">'+graphData.incompleteDataTextTitle+'</div><div>'+graphData.incompleteDataDetails+'</div><div>'+negativeTimeInTopologyStr+'</div>',
					getTargetXY: function() {
						  this.anchorOffset = this.getWidth()/2 - 22;
						  return [left + this.getWidth() - 8 ,bottom - this.getHeight()];
					 }
					});
				infotooltip.show();
				
					//infotooltip.el.alignTo('btminfo', "tl-c", [-90, -90])

			});
		}
		// Slider function

		var sliderUI = $(".slider").slider({
            animate: "slow",
            orientation: "vertical",
            min: graphObjTools.minZoom,
            max: graphObjTools.maxZoom,
            height: 83,
            value: graphObjTools.initialScale,
            step: ((graphObjTools.maxZoom - graphObjTools.minZoom) / 100),
            slide: function(event, ui) {
                cal.sliderFn(ui.value);
                slider_tooltip.text(Math.round(ui.value * 100) + '%');

            }
        });
		// Slider tooltip remove
		if(slider_tooltip){
			$(slider_tooltip).remove();
		}
		sliderUI.find(".ui-slider-handle").append(slider_tooltip).hover(function() {
            slider_tooltip.text(Math.round(zoom.scale() * 100) + '%');
            slider_tooltip.fadeIn('fast');
        }, function() {
            slider_tooltip.fadeOut('slow');
        });
        // Finding the total number of nodes and links
        Object.size = function(obj) {
            var size = 0;
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    size++;
                }
            }
            return size;
        }

        var graphObj = new dagreD3.graphlib.Graph().setGraph({
            //ranksep: (graphObjTools.graphWidth /Object.size(graphData.nodes[0])) /Object.size(graphData.nodes[0]) * Object.size(graphData.nodes[0]),
            ranksep: 175,
            //edgesep: graphObjTools.graphHeight /Object.size(graphData.links[0]),
            edgesep: 10,
            nodesep: 70,
            width: graphObjTools.graphWidth,
            height: graphObjTools.graphHeight,
            rankdir: graphObjTools.graphAlign,
            marginx: 20,
            marginy: 20
        });

        var creatingNodeAndLinks = function() {
                for (var n = 0; n < graphDataBTM.nodes.length; n++) {
                    graphObjTools.assets.nodeObject = graphDataBTM.nodes[n];
                    graphObjTools.nodeData.push(graphObjTools.assets.nodeObject);

                }
                for (var l = 0; l < graphDataBTM.links.length; l++) {
                    graphObjTools.assets.linkObject = graphDataBTM.links[l];
                    graphObjTools.linkData.push(graphObjTools.assets.linkObject);

                }


            }

        //  Rendering the edgeData
		var labelRect = ""; //.attr('height','20px').attr('width','100px');
        function creatingEdgesLabels(data) {
			
            this.group = d3.select(document.createElementNS(d3.ns.prefix.svg, 'g'));
            if (data) {
                group.classed("labelgrp", true);
                group.style('cursor', 'pointer');
				labelRect = group.append('rect').classed("labelpatch", true);
				
                if (data.lineCall !='None') {
					 // duplicate
					var lineCall =  group.append('text')
					.attr('class', 'commonsize_stroke lineCall')
                    .attr('text-anchor', 'start')
                       .attr('dy', function(){
						 if (data.linePercent == "None" || data.lineTime == "None"){
								return '0.58em';
						 }else{
							return '1.2em';
						 }
					 })
                    .text(function(d) {
                            return data.lineCall
                        });

                     group.append('text')
					.attr('class', 'commonsize lineCall')
                    .attr('text-anchor', 'start')
                    .attr('dy', function(){
						 if (data.linePercent == "None" || data.lineTime == "None"){
								return '0.58em';
						 }else{
							return '1em';
						 }
					 })
                    .text(function(d) {
                            return data.lineCall
                        });
					
                }

                if (data.linePercent !== "None" || data.lineTime !== "None") {

					// duplicate
					var timeStroke = group.append('text').attr('text-anchor', 'start').attr('class', 'commonsize_stroke linedata').attr('dy', '2.3em');
					if(data.lineTime !== "None"){
						timeStroke.append('tspan').attr('class', 'nodeTime').text(function(d) {
							return " "+data.lineTime
						});
					}
                    timeStroke.append('tspan').attr('class', 'nodePercent').text(function(d) {
                       if(data.linePercent !== "None"){
							return " "+data.linePercent;
						}else{
							return " ";
						}
                    }).style('opacity', function(){
							return Ext.ComponentQuery.query('checkbox[itemId=type%]')[0].value ? "1": "0";
					}).style('display', function(){
							return Ext.ComponentQuery.query('checkbox[itemId=type%]')[0].value ? "block": "none";
					});

						
                    var time = group.append('text').attr('text-anchor', 'start').attr('class', 'commonsize linedata').attr('dy', '2.3em');
						if(data.lineTime !== "None"){
								time.append('tspan').attr('class', 'nodeTime').text(function(d) {
									return " "+data.lineTime
								});
							}
                    time.append('tspan').attr('class', 'nodePercent').text(function(d) {
						if(data.linePercent !== "None"){
							return " "+data.linePercent;
						}else{
							return " ";
						}
                    }).style('opacity', function(){
							return Ext.ComponentQuery.query('checkbox[itemId=type%]')[0].value ? "1": "0";
					}).style('display', function(){
							return Ext.ComponentQuery.query('checkbox[itemId=type%]')[0].value ? "block": "none";
					});

		
                }
            }
			//Duplicate
			if(data.asynclineTime !== "None"){
				var asynclineTime = group.append('text')
					.style({'font-style':'italic','font-size':'9px'})
					.attr('class', 'commonsize_stroke asynclineTime')
					.attr('dy', function(d,i){
									
									return data.lineTime == "None" ? "2em" : "3.9em";
							});
				asynclineTime
				.append('tspan')
				.attr('class', 'asynclineTime')
				.text(function(d) {
			
                        return "  "+data.asynclineTime;
                });
			}
			if(data.asynclineTime !== "None"){
				var asynclineTime = group.append('text')
					.style({'font-style':'italic','font-size':'9px'})
					.attr('text-anchor', 'start')
					.attr('class', 'commonsize asynclineTime')
					.attr('dy', function(d,i){
								
									return data.lineTime == "None" ? "2em" : "3.9em";
							});

				asynclineTime
				.append('tspan')
				.attr('class', 'asynclineTime')
				.text(function(d) {
						//console.log(data.asynclineTime);
                        return "  "+data.asynclineTime;
                });
			}
			
            if ( data.lineExperience != "None" && data.lineExperience != undefined && data.lineExperience != 'undefined') {
				
				group.append('rect').attr('width',18).attr('height', 18)
				.attr('class','linestateiconpatch')
				.attr('y', -2)
                .attr('x', -21);

                group.append('image')
                    .attr('xlink:href', function() {
                        if (data.lineExperience == 'HEALTHY') { 
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_GOOD.svg'
                        } else if (data.lineExperience == 'ERROR') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_HIGH.svg'
                        } else if (data.lineExperience == 'SLOW') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_LOW.svg'
                        } else if (data.lineExperience == 'STALLED') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_INTERMEDIATE.svg'
                        }
                    })
                    .attr('class', 'lineState lineState' + data.lineExperience)
                    .attr('height', 15)
                    .attr('width', 15)
                    .attr('y', -2)
                    .attr('x', -18);
            }
            this.group.on('click', function(y) {
			
				//console.log(this);
				d3.event.stopPropagation();
				var point = d3.mouse(this), p = {x: point[0], y: point[1] };
							//var toolTipObj = graphObjTools.userToolTipUI();

							eleWidth = d3.select(this).node().getBBox().width * zoom.scale();
							eleHeight = d3.select(this).node().getBBox().height * zoom.scale();
							eleX = d3.select(this).node().getBBox().x / zoom.scale();
							eleY = d3.select(this).node().getBBox().y / zoom.scale();
							dx = Math.max(0, d3.event.pageX);
							dy = Math.max(0, d3.event.pageY);
							popupWidth = 527;
							popupHeight = 322;
							outerHeight = graphObjTools.graphHeight;
							outerWidth = graphObjTools.graphWidth;
							targetEleOffsetTop = $(this).offset().top;
							targetEleOffsetLeft = $(this).offset().left;

							getRight = dx + targetEleOffsetLeft;
							getLeft = dx - targetEleOffsetLeft;
							getBottom = dy + popupHeight;
							getTop = dy - targetEleOffsetTop;
				if(data.isModalWindowToShow != null && data.isModalWindowToShow)
				{
					var tooltip = new graphObjTools.userToolTipUI(Ext.get(this),'right',dx,dy,eleWidth,eleHeight,targetEleOffsetTop,targetEleOffsetLeft,eleX,eleY);
						// tooltip.maxWidth = 900;
						//tooltip.setWidth(700);
						var viewSize =  Ext.getBody().getViewSize();
						var viewSizeWidth = viewSize.width;
						var viewSizeHeight = viewSize.height;
						var dyWidth = Math.round(viewSizeWidth);
						var dyHeight = Math.round(viewSizeHeight);
					
						/* setting the tooltip width dynamically ,dividing the viewsize / 2 and adding 40px to width*/
						tooltip.maxWidth = (dyWidth/2)+ 10;
						tooltip.maxHeight = (dyHeight/2)+ 10;
						tooltip.setHeight(dyHeight/2 - 50);
						tooltip.removeAll();
						//tooltip.setTitle('There are multiple call graphs available for this node. Select a call to drilldown into');
						tooltip.setTitle('Select a call to drill down');
						tooltip.add(showModalwindow(data.modalWindowGridData));
						tooltip.show();
					//showModalwindow(data.modalWindowGridData);
				
				}
				else
				{
					if (data.drillDownUrl != 'None') {
                        var guidnode =  data.guid+"#"+data.nodeOrder;
                        var url = data.drillDownUrl;
						if(isReporterRequest == 'yes'){
							baseStackTrace(url, guidnode, 'topologyBuildWindow');
						}
						else{
							window.parent.baseStackTrace(url, guidnode, 'topologyBuildWindow');
						}
                    }
				}
            });
            this.group.attr('transform', 'translate(0,5)');

            return this.group.node();
        }

        // Setting the marker, Yet to optimize :(
        var marker = function() {
            var marker = d3.select('g.graphinnergrp')
                .selectAll("marker")
                .data([{
                    "name": "default",
                    "color": "#909090"
                }, {
                    "name": "undefined",
                    "color": "#909090"
                }, {
                    "name": "HEALTHY",
                    "color": "#588c73"
                }, {
                    "name": "SLOW",
                    "color": "#d74141"
                }, {
                    "name": "ERROR",
                    "color": "#d74141"
                }, {
                    "name": "STALLED",
                    "color": "#d74141"
                }]).enter();

            marker.append("svg:marker")
                .attr("id", function(d) {
                    return d.name
                })
                .attr("fill", function(d) {
                    return d.color;
                })
                .attr("viewBox", "0 0 13 13")
                .attr("markerWidth", 10)
				.attr("markerUnits", "strokeWidth")
				.attr("stroke-width", 1)
				.attr("stroke-dasharray", function(l) {
						return 0 + " " + 0
                 })
                 .attr("stroke-dashoffset", function(l) {
						return 0

                 })
                .attr("markerHeight", 16)
                .attr("refX", function(d) {
                    return 5
                })
                .attr("refY", 7)
                .attr("orient", "auto")
                .append("svg:path").attr('d', function(d) {
                    return d.path
                })
                .attr("d", "M2,2 L2,13 L8,7 L2,2");

        }
        var markerOver = function() {
            var marker = d3.select('g.graphinnergrp')
                .selectAll("marker.overmarker")
                .data([{
                    "name": "defaultover",
                    "color": "#909090"
                }, {
                    "name": "undefinedover",
                    "color": "#909090"
                }, {
                    "name": "HEALTHYover",
                    "color": "#588c73"
                }, {
                    "name": "SLOWover",
                    "color": "#d74141"
                }, {
                    "name": "ERRORover",
                    "color": "#d74141"
                }, {
                    "name": "STALLEDover",
                    "color": "#d74141"
                }]).enter();

            marker.append("marker")
                .attr("id", function(d) {
                    return d.name
                })
                .attr("fill", function(d) {
                    return d.color;
                })
                .attr("viewBox", "0 0 13 13")
                .attr("markerWidth", 5)
                .attr("markerHeight", 8)
                .attr("markerUnits", "strokeWidth")
				.attr("stroke-width", 1)
				.attr("stroke-dasharray", function(l) {
					return 0 + " " + 0;

                }).attr("stroke-dashoffset", function(l) {
					 return 0;
                })
                .attr("refX", function(d) {
                    return 5
                })
                .attr("refY", 7)
                .attr("orient", "auto")
                .append("svg:path").attr('d', function(d) {
                    return d.path
                })
                .attr("d", "M2,2 L2,13 L8,7 L2,2");

        }
        marker();
        markerOver();
        var renderingNodeLinks = function() {
            creatingNodeAndLinks();

			for (var keys in graphObjTools.nodeData[0])
			{
				 graphObj.setNode(keys, {
                        label: "",
                        width: 30,
                        height: 30
                    });
			}

            graphObjTools.linkData.forEach(function(d, i) {
				
                //Object.keys(d).forEach(function(c, t) {
					// Static node user to start component
					graphObj.setEdge(0, 1, {
                        label:'  ',
						width:-80,
                        labelpos: "c",
                        lineInterpolate: graphObjTools.lineInterpolate
                    });

					// Rest of others
					if(d.source === d.target){
						graphObjTools.lineInterpolate =  "basis";
					}
                    graphObj.setEdge(d.source, d.target, {
                        labelType: 'svg',
                        label: creatingEdgesLabels(d),
                        labelpos: "c",
                        lineInterpolate: graphObjTools.lineInterpolate
                    });
               // });
            });
            graphObjTools.graphRender(graphObjTools.innerGrp, graphObj);
        }

        renderingNodeLinks();

        // Setting the  Zoom object thanks to d3
        var zoom = graphObjTools.zoom.scaleExtent([graphObjTools.minZoom, graphObjTools.maxZoom])
            .size([graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2]);


        // Indexing the link source & target coz for line animation
        var connectedIndex = [];
        var count = 0;
        for (var i in graphObj._edgeObjs) {
            count = count + 1;
            if (graphObj._edgeObjs.hasOwnProperty(i)) {
                connectedIndex.push({
                    'index': count,
                    'target': graphObj._edgeObjs[i].w,
                    'source': graphObj._edgeObjs[i].v
                })
            }
        };
        var pathLine = graphObjTools.innerGrp.selectAll('.path').data(connectedIndex);
		var edgePath = graphObjTools.innerGrp.selectAll('.edgePath').data(graphObjTools.linkData);
        var pathlineExperience = edgePath.filter(function(d) {
            return d.lineExperience == 'undefined';
        });
		
		// @ adding pointer to the line path to click
	var incalltextArr = [], linedatatextArr =[];
		d3.selectAll('text.lineCall').each(function(d){
				incalltextArr.push(d3.select(this).node().getBBox().width);
				
		});
	d3.selectAll('.linedata').each(function(d,i){
			linedatatextArr.push(d3.select(this).node().getBBox().width);
	});
	
		d3.selectAll('rect.labelpatch').each(function(d,g){
				if(linedatatextArr[g] >  incalltextArr[g]){
					d3.select(this).attr({
                                'width': incalltextArr[g],
                                'height': 30,
                                'x': 0,
                                'y': 0
                            });
				}else{
				d3.select(this).attr({
                                'width': linedatatextArr[g] ,
                                'height': 30,
                                'x': 0,
                                'y': 0
                            });
				}
		});

		/*labelRect.attr({
                                'width': (lineCall.node().getBBox().width /2) - (lineCall.node().getBBox().x * 2),
                                'height': 35,
                                'x': ((-lineCall.node().getBBox().width/2)/2)+ ((lineCall.node().getBBox().x* 2) /2),
                                'y': 23
                            }) .style({
                                'fill': '#40b5c5'
                            });*/
		// setting up the line style
        pathLine.attr("stroke-linecap","round").attr("stroke-dasharray", function(l,i) {
								//console.log(graphObjTools.linkData[i])
                                if (graphObjTools.linkData[i].asynclineTime == "None") {
                                    return 0 + " " + 0;
                                }else{
									return 5 + " " + 5;
								}
                            })	.attr('marker-end', '').attr('marker-end', 'url(#default)');
        var cal = {
            fontSize: graphObjTools.fontSize,
            getScale: function(scale) {
                return scale;
            },
            getFontSize: function(scale) {
                return this.fontSize / scale;
            },
            interpolateZoom: function(translate, scale, duration) {
                var self = this;
                return d3.transition().duration(duration).tween("zoom", function() {
                    var iTranslate = d3.interpolate(zoom.translate(), translate),
                        iScale = d3.interpolate(zoom.scale(), scale);
                    return function(t) {
						zoom.scale(iScale(t)).translate(iTranslate(t)).event(rootSVG);
                    };
                });
            },
            sliderFn: function(value) {
                var scale = zoom.scale();
                var extent = zoom.scaleExtent();
                var newScale = value;
                if (extent[0] <= newScale && newScale <= extent[1]) {
                    var t = zoom.translate();
                    var c = [graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2];
                    zoom.scale(newScale)
                        .translate([c[0] + (t[0] - c[0]) / scale * newScale, c[1] + (t[1] - c[1]) / scale * newScale])
                        .event(rootSVG);
                }
            },
            zoomBtFn: function() {
                var clicked = d3.event.target,
                    direction = 1,
                    factor = 0.2,
                    target_zoom = ((graphObjTools.maxZoom - graphObjTools.minZoom) / 100),
                    center = [graphObjTools.graphWidth / 2, graphObjTools.graphHeight / 2],
                    extent = zoom.scaleExtent([graphObjTools.minZoom, graphObjTools.maxZoom]),
                    translate = zoom.translate(),
                    translate0 = [],
                    l = [],
                    view = {
                        x: translate[0],
                        y: translate[1],
                        k: zoom.scale()
                    };

                d3.event.preventDefault();
                direction = (this.id === 'zoom_in') ? 1 : -1;
                target_zoom = zoom.scale() * (1 + factor * direction);
                if (target_zoom < extent[0] || target_zoom > extent[1]) {
                    return false;
                }
                translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
                view.k = target_zoom;
                l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];
                view.x += center[0] - l[0];
                view.y += center[1] - l[1];
                if (view.k <= graphObjTools.minZoom || view.k >= graphObjTools.maxZoom) {
                    $(".slider").slider("value", view.k);
                    return false;
                } else {
                    cal.interpolateZoom([view.x, view.y], view.k, 200);
                }
            },
            hideText: function(scale, val) {

                if (val > scale) {
                    graphObjTools.innerGrp.selectAll('text').style("visibility", "hidden");
                    graphObjTools.innerGrp.selectAll('.componentState, .userExpLine, .labelpatch').style("visibility", "hidden");
                    graphObjTools.innerGrp.selectAll('.lineState').style("visibility", "hidden");
                    graphObjTools.innerGrp.selectAll('.greyCompIcon').style("display", "none");
                    graphObjTools.innerGrp.selectAll('.linestateiconpatch').style("display", "none");
                    graphObjTools.innerGrp.selectAll('.colorCompIcon').style("visibility", "visible").style("display", "block");
                    pathLine.attr('class', function() {
						if(d3.select(this.parentNode).datum().lineExperience){
							return 'link ' + d3.select(this.parentNode).datum().lineExperience;
						}
                    });
                    pathLine.attr('marker-end', '').style('stroke-width', 2)
                        .attr('marker-end', function() {
							if(d3.select(this.parentNode).datum().lineExperience){
								return 'url(#' + d3.select(this.parentNode).datum().lineExperience + 'over)';
							}
                        });



                } else {
                    graphObjTools.innerGrp.selectAll('text').style("visibility", "visible");
                    graphObjTools.innerGrp.selectAll('.componentState, .userExpLine, .labelpatch').style("visibility", "visible");
                    graphObjTools.innerGrp.selectAll('.lineState').style("visibility", "visible");
					graphObjTools.innerGrp.selectAll('.linestateiconpatch').style("display", "block");
                    pathLine.attr('class', function() {
						if(d3.select(this.parentNode).datum().lineExperience){
							return 'path ' + d3.select(this.parentNode).datum().lineExperience;
						}
                    });
                    pathLine.attr('marker-end', '').style('stroke-width', 1)
                        .attr('marker-end', function() {
                            return 'url(#default)';
                        });
                    graphObjTools.innerGrp.selectAll('.greyCompIcon').style("display", "block");
                    graphObjTools.innerGrp.selectAll('.colorCompIcon').style("visibility", "hidden").style("display", "none");
                }

            }
        }

		/*if (navigator.appVersion.indexOf("MSIE 10") != -1) {
			pathLine.each(function() {this.parentNode.insertBefore(this, this); });
		}*/
        var serverType, serverTypeHoverImages, displayName, displayName_stroke, compName, userExpLine, isJavaComp, componentState, componentTranValue, startImg, displayName_compName, displayName_compName_stroke, compNametrick, compNametrick_stroke, serverTypeState;
        var renderNode = function(scale) {
            graphObj.nodes().forEach(function(i) {
                // Yet to optimize
                d3.selectAll('.linedata,.lineCall, .linedataStroke, .lineCallStroke')
				.style("font-size", cal.getFontSize(scale) + "px");
                d3.selectAll('.linedata')
                    .attr('x', function() {
                        return d3.select(this).attr('x') / cal.getScale(scale)
                    })
                    .attr('y', function() {
                        return d3.select(this).attr('y') / cal.getScale(scale)
                    });

                d3.selectAll('.lineCall')
                    .attr('x', function() {
                        return d3.select(this).attr('x') / cal.getScale(scale)
                    })
                    .attr('y', function() {
                        return d3.select(this).attr('y') / cal.getScale(scale)
                    });

                d3.selectAll('.lineState')
                    .attr('x', function() {
                        return -18 / cal.getScale(scale);
                    })
                    .attr('y', function() {
                        return -2 / cal.getScale(scale);
                    })
                    .attr('width', function() {
                        return 15 / cal.getScale(scale);
                    })
                    .attr('height', function() {
                        return 15 / cal.getScale(scale);
                    });
					
				

                var node = graphObj.node(i);
		
                var parentNode = d3.select(node.elem).data(graphObjTools.nodeData);
                parentNode.attr('id', function(d) {
                    return d[i].componentName;
                }).style('opacity', function(d) {
					if(!d[i].activeNode) return '0.6';
                 }).attr('class',function(d){
				if (d[i].drillDownUrl != 'None') {
							return 'pointer';
						}
				});

                //parentNode.classed('node',false);
                parentNode.classed('parentNode', true);
                parentNode.selectAll("*").remove();
                //-- TODO

				isHighlight =  parentNode.filter(function(d){  return d[i].highlight == true  }).classed('isHighlightNode',true).append('rect').attr('class', 'isHighlight');
                d3.select(node.elem).on('click', function(y) {
					// creating tooltip
					d3.event.stopPropagation();
						//TODO
							var point = d3.mouse(this), p = {x: point[0], y: point[1] };
							//var toolTipObj = graphObjTools.userToolTipUI();

							eleWidth = d3.select(node.elem).node().getBBox().width * zoom.scale();
							eleHeight = d3.select(node.elem).node().getBBox().height * zoom.scale();
							eleX = d3.select(node.elem).node().getBBox().x / zoom.scale();
							eleY = d3.select(node.elem).node().getBBox().y / zoom.scale();
							dx = Math.max(0, d3.event.pageX);
							dy = Math.max(0, d3.event.pageY);
							popupWidth = 527;
							popupHeight = 322;
							outerHeight = graphObjTools.graphHeight;
							outerWidth = graphObjTools.graphWidth;
							targetEleOffsetTop = $(this).offset().top;
							targetEleOffsetLeft = $(this).offset().left;

							getRight = dx + targetEleOffsetLeft;
							getLeft = dx - targetEleOffsetLeft;
							getBottom = dy + popupHeight;
							getTop = dy - targetEleOffsetTop;
					if(data.txnSnapshotToShow){
						if(y[i].componentName === "User"){	
							graphObjTools.userToolTipUI(Ext.get(this),'right',dx,dy,eleWidth,eleHeight,targetEleOffsetTop,targetEleOffsetLeft,eleX,eleY).show();
						}
					}

					if(y[i].isModalWindowToShow != null && y[i].isModalWindowToShow)
					{	
						//console.log(y[i].modalWindowGridData);
					
						var tooltip = new graphObjTools.userToolTipUI(Ext.get(this),'right',dx,dy,eleWidth,eleHeight,targetEleOffsetTop,targetEleOffsetLeft,eleX,eleY);
						var viewSize =  Ext.getBody().getViewSize();
						var viewSizeWidth = viewSize.width;
						var viewSizeHeight = viewSize.height;
						var dyWidth = Math.round(viewSizeWidth);
					
						/* setting the tooltip width dynamically ,dividing the viewsize / 2 and adding 40px to width*/
						tooltip.maxWidth = (dyWidth/2)+ 40;
						tooltip.setWidth(700);
						tooltip.removeAll();
						//tooltip.setTitle('There are multiple call graphs available for this node. Select a call to drilldown into');
						tooltip.setTitle('Select a call to drill down');
						tooltip.add(showModalwindow(y[i].modalWindowGridData));
						tooltip.show();
						//showModalwindow(y[i].modalWindowGridData);
					}
					else
					{
						if (y[i].drillDownUrl != 'None') {
							var guidnode =  y[i].guid+"#"+y[i].nodeOrder;
							var url = y[i].drillDownUrl;
							if(isReporterRequest == 'yes'){
								baseStackTrace(url, guidnode, 'topologyBuildWindow')
							}
							else{
								window.parent.baseStackTrace(url, guidnode, 'topologyBuildWindow')
							}
						}
					}
                }).on('mouseenter', function(d) {
					//@ hightLight
					if(d[i].highlight){
						var compName = d3.select(this).selectAll('.compName');
						var dispName = d3.select(this).selectAll('.displayName');
						var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
						compName.text(d[i]['componentName']);
						dispName.text(d[i]['displayName']);

						if(dispName.node().getBBox().width >= compName.node().getBBox().width){
									graphObjTools.highLightNode(this,dispName.node().getBBox().width,hightLightHeight,dispName.node().getBBox().x,23);
							}else{
									graphObjTools.highLightNode(this,compName.node().getBBox().width,hightLightHeight,compName.node().getBBox().x,23);
						}
						/*if(graphObjTools.highLightNodeCheck == 1){
								graphObjTools.highLightNode(this,d3.select(this).node().getBBox().width,20,d3.select(this).node().getBBox().x,23);
							}else{			
								graphObjTools.highLightNode(this,d3.select(this).node().getBBox().width,35,d3.select(this).node().getBBox().x,23);
							}*/
					}else{
					 // function if any
					}
                    animateFn = function() {
                        pathLine
                            .attr('marker-end', function(l) {
                                if (i === l.source || i === l.target) {
                                    if (d[i].nodeExperience) {
                                        if (zoom.scale() < 0.600) {
                                            return 'url(#' + d3.select(this.parentNode).datum().lineExperience + 'over)';
                                        } else {
                                            return 'url(#defaultover)';
                                        }
                                    } else {
                                        return 'url(#defaultover)';
                                    }

                                } else {
                                    if (d[i].nodeExperience) {
                                        if (zoom.scale() < 0.600) {
                                            return 'url(#' + d3.select(this.parentNode).datum().lineExperience + ')';
                                        } else {
                                            return 'url(#default)';
                                        }
                                    }
                                }
                            })
                            .style('stroke', function() {
                                return '#797777';
                            })
                            .style("stroke-width", function(l) {
                                if (i === l.source || i === l.target) {
                                    return 2;
                                } else {
                                    return 1;
                                }
                            })
                            .transition()
                            .duration(200)
                            .ease("linear")
                            .attr("stroke-dashoffset", 0).each("end", animateFn);
                    }
                    animateFn();

                }).on('mouseleave', function(d) {
							//@ hightLight
							if(d[i].highlight){

										var compName = d3.select(this).selectAll('.compName');
										var dispName = d3.select(this).selectAll('.displayName');
										var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
										compName.text(graphObjTools.textTruncate(d[i]['componentName'],graphObjTools.textTruncateLength));
										dispName.text(graphObjTools.textTruncate(d[i]['displayName'],graphObjTools.textTruncateLength));
										if(dispName.node().getBBox().width >= compName.node().getBBox().width){
											graphObjTools.highLightNode(this,dispName.node().getBBox().width,hightLightHeight,dispName.node().getBBox().x,23);
										}else{
											graphObjTools.highLightNode(this,compName.node().getBBox().width,hightLightHeight,compName.node().getBBox().x,23);
										}
										//console.log(d3.select(this).selectAll('.compName').node().getBBox().width);
										//console.log(d3.select(this).selectAll('.displayName').node().getBBox().width);
							}else{
									// function if any
							}
						pathLine
                        .attr('marker-end', '')
                        .attr('marker-end', function(l) {
                            if (i === l.source || i === l.target) {
                                if (d[i].nodeExperience) {
                                    if (zoom.scale() < 0.600) {
                                        return 'url(#' + d3.select(this.parentNode).datum().lineExperience + ')';
                                    } else {
                                        return 'url(#default)';
                                    }
                                } else {
                                    //return 'url(#default)';
                                }
                            } else {
                                if (d[i].nodeExperience) {
                                    if (zoom.scale() < 0.600) {
                                        return 'url(#' + d3.select(this.parentNode).datum().lineExperience + ')';
                                    } else {
                                        return 'url(#default)';
                                    }
                                }
                            }
                        })
                        .style("stroke-width", function(l) {
                            if (i === l.source || i === l.target) {
                                return 1;
                            }
                        }).interrupt().transition();
                });
			
				isHighlight =  parentNode.filter(function(d){  return d[i].highlight == true  }).append('rect').attr('class', 'isHighlight');
                          
                serverTypeState = parentNode.append('image').attr('xlink:href', function(d) {
                        if (d[i].nodeExperience != 'None') {
                            return "../images/component_icons/svg/"+graphDataBTM.paper.skin+"/"+d[i].serverType+"_"+d[i].nodeExperience+".svg";
                        }else{
							return "../images/clear.png";
						}
                    }).attr({
                        'width': function(d) {
                            if (d[i].componentName === "User") {
                                if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
                            } else {
                                if (0.4 >= scale >= 0.2) {
                                    return 44;
                                }
                                return 44 / cal.getScale(scale);
                            }
                        },
                        'height': function(d) {
                            if (d[i].componentName === "User") {
                                if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
                            } else {
                                if (0.4 >= scale >= 0.2) {
                                    return 55;
                                }
                                return 55 / cal.getScale(scale);
                            }
                        }
                    })
                    .attr('x', function(d) {
                        if (d[i].componentName === "User") {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-19 * cal.getScale(scale));
                            } else {
                                return Math.round(-35 / cal.getScale(scale));
                            }
                        } else {

                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-100 * cal.getScale(scale));
                            }
                            return Math.round(-24 / cal.getScale(scale));
                        }
                    })
                    .attr('y', function(d) {
                        if (d[i].componentName === "User") {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-135 * cal.getScale(scale));
                            }
                            return Math.round(-38 / cal.getScale(scale));
                        } else {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-95 * cal.getScale(scale));
                            }
                            return Math.round(-24 / cal.getScale(scale));
                        }

                    }).attr('class', 'colorCompIcon').style('display', 'none');

                serverType = parentNode.append('image').attr('xlink:href', function(d) {
                        if (d[i].nodeExperience != 'None') {
                            if (scale > 0.600) {
                                return "../images/component_icons/svg/"+graphDataBTM.paper.skin+"/"+d[i].serverType+".svg";
                            } else {
                                return "../images/component_icons/svg/"+graphDataBTM.paper.skin+"/"+d[i].serverType+"_"+d[i].nodeExperience+".svg";
                            }
                        } else {
                            return "../images/component_icons/svg/"+graphDataBTM.paper.skin+"/"+d[i].serverType+".svg";
                        }

                    }).attr({
                        'width': function(d) {
							if(d[i].serverType === "CUSTOM"){
								if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
							}
                            if (d[i].componentName === "User") {
                                if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
                            } else {
                                if (0.4 >= scale >= 0.2) {
                                    return 44;
                                }
                                return 44 / cal.getScale(scale);
                            }
                        },
                        'height': function(d) {
							if(d[i].serverType === "CUSTOM"){
								if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
							}
                            if (d[i].componentName === "User") {
                                if (0.4 >= scale >= 0.2) {
                                    return 75;
                                }
                                return 75 / cal.getScale(scale);
                            } else {
                                if (0.4 >= scale >= 0.2) {
                                    return 55;
                                }
                                return 55 / cal.getScale(scale);
                            }
                        }
                    })
                    .attr('x', function(d) {

                        if (d[i].componentName === "User" || d[i].serverType === "CUSTOM") {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-19 * cal.getScale(scale));
                            } else {
                                return Math.round(-35 / cal.getScale(scale));
                            }
                        } else {

                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-100 * cal.getScale(scale));
                            }
                            return Math.round(-24 / cal.getScale(scale));
                        }
                    })
                    .attr('y', function(d) {

                        if (d[i].componentName === "User" || d[i].serverType === "CUSTOM") {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-135 * cal.getScale(scale));
                            }
                            return Math.round(-38 / cal.getScale(scale));
                        } else {
                            if (0.4 >= scale >= 0.2) {
                                return Math.round(-95 * cal.getScale(scale));
                            }
                            return Math.round(-24 / cal.getScale(scale));
                        }

                    }).attr('class', function(d) {
                        if (d[i].nodeExperience != 'None') {
                            return 'greyCompIcon';
                        }
                    });

				// duplicate
				displayName_compName_stroke = parentNode.append('text').attr('text-anchor', 'middle')
					.attr('x', function(d){
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								return 5;
							}else{
								return  0 / cal.getScale(scale);
							}
					})
                    .attr('y', function(d) {
                        return 35 / cal.getScale(scale);
                    })
                    .attr('class', 'displayName_compName_stroke commonsize_stroke')
                    .style("font-size", cal.getFontSize(scale) + "px")
                    .style('opacity', '0').style('display', 'none');

                displayName_compName = parentNode.append('text').attr('text-anchor', 'middle')
					.attr('x', function(d){
						if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								return 5;
							}else{
								return  0 / cal.getScale(scale);
							}
					})
                    .attr('y', function(d) {
                        return 35 / cal.getScale(scale);
                    })
                    .attr('class', 'displayName_compName commonsize')
					.style("fill", function(d){
						if(d[i].highlight ){
							return  "#ffffff"
					}})
                    .style("font-size", cal.getFontSize(scale) + "px")
                    .style('opacity', '0').style('display', 'none');

                /*displayNametrick = displayName_compName.filter(function(d) {
						return d[i].displayName != "None"
					}).append('tspan').text(function(d) {
						return d[i].displayName
					}).attr('class', 'displayName').attr('text-anchor', 'middle');*/
				//@textTruncate
				 compNametrick_stroke = displayName_compName_stroke.append('tspan').text(function(d) {
                    //return '---------'+d[i].componentName;
					if(d[i].highlight){
						return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
					}else{
                    return  graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
					}
                })
				.attr('title', function(d){
						return  d[i].componentName;
				}).attr('data-qtip',function(d){
						return  d[i].componentName;
				}).attr('data-qclass',function(d){
						return  'yellowTip qtipwidth';
					})
				.attr('class', 'displayName_compName')
				.attr('text-anchor', 'middle');

                compNametrick = displayName_compName.append('tspan').text(function(d) {
                    // return '---------'+d[i].componentName;
						if(d[i].highlight){
							return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
						}else{
                    return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
						}
                }).attr('class', 'displayName_compName').attr('text-anchor', 'middle');

				//duplicate
				// @textTruncate
				displayName_stroke = parentNode.filter(function(d) {
                        return d[i].displayName != "None" && !d[i].highlight ;
                    })
					.append('text').text(function(d) {
						if(d[i].highlight){
                        return graphObjTools.textTruncate(d[i].displayName,graphObjTools.textTruncateLength);
						}else{
							return graphObjTools.textTruncate(d[i].displayName,graphObjTools.textTruncateLength);
						}
                    }).attr('data-qtip',function(d){
                        return d[i].displayName;
                    }).attr('data-qclass',function(d){
						return  'yellowTip qtipwidth';
					})
					.attr('title', function(d){
                        return d[i].displayName;
                    })
					.attr('text-anchor', 'middle')
					.attr('class', 'displayName')
                    .attr('x', function(d){
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								return 5;
							}else{
								return  0 / cal.getScale(scale);
							}
					})
                    .attr('y', function(d) {
                       if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								  return 35 / cal.getScale(scale);
							}else{
								return 36 / cal.getScale(scale);	
							}
                    })
					.style("font-size", cal.getFontSize(scale) + "px")
					.classed('commonsize_stroke', true);

				// @textTruncate
                displayName = parentNode.filter(function(d) {
                        return d[i].displayName != "None";
                    })
					.append('text').text(function(d) {
						if(d[i].highlight){
							return graphObjTools.textTruncate(d[i].displayName,graphObjTools.textTruncateLength);
						}else{
                        return  graphObjTools.textTruncate(d[i].displayName,graphObjTools.textTruncateLength);
						}
                    })
					.attr('title', function(d){
							return d[i].displayName;
                    }).attr('data-qtip',function(d){
                        return d[i].displayName;
                    }).attr('data-qclass',function(d){
						return  'yellowTip qtipwidth';
					})
					.attr('text-anchor', 'middle')
					.attr('class', function(d){
						if(d[i].highlight ){
							return 'displayName highlight';
						}else{
							return 'displayName';
						}
						})
                    .attr('x',function(d){
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								return 5;
							}else{
								return  0 / cal.getScale(scale);
							}
					})
                    .attr('y', function(d) {
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
								  return 35 / cal.getScale(scale);
							}else{
								return 36 / cal.getScale(scale);	
							}
                        
                    })
					.style("font-size", cal.getFontSize(scale) + "px")
					.style("fill", function(d){
						if(d[i].highlight ){
							return  "#ffffff"
						}
					})
					.classed('commonsize', true);

				// duplicate
				// @textTruncate
				compName_stroke = parentNode.append('text').text(function(d) {
					if(!d[i].highlight && d[i].componentName != 'None' ){
							if(d[i].highlight){
									return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
							}else{
									if(d[i].componentName === "User" || d[i].displayName === "None"){
										return d[i].UserName;
									}else{
										return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
									}
									
							}
					}else{
						return "";	
					}
                })
				.attr('title', function(d){
					return d[i].componentName;
				})
				.attr('text-anchor', 'middle')
				.attr('class', function(d){
					if(!d[i].highlight && d[i].componentName === "User" || d[i].displayName === "None"){
						return 'commonsize_stroke compName USER'
					}else{
						return 'commonsize_stroke_highlight compName '
					}
				})
				.attr('x', function(d){
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
									return 5;
							} else {
									return 0;
						}	
					}).attr('y', function(d) {
                    if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
                        return 35 / cal.getScale(scale);
                    } else {
                        return 50 / cal.getScale(scale);
                    }
                }).style("font-size", cal.getFontSize(scale) + "px");

				// @textTruncate
                compName = parentNode.append('text').text(function(d) {
                  if(d[i].componentName != 'None'){
					  if(d[i].highlight){
									return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
							}else{
									 if(d[i].componentName === "User" || d[i].displayName === "None"){
										return d[i].UserName;
									}else{
										return graphObjTools.textTruncate(d[i].componentName,graphObjTools.textTruncateLength);
									}
										
							}
					}else{
						return "";	
					}
                }).attr('data-qtip',function(d){
                        return d[i].componentName;
                    }).attr('data-qclass',function(d){
						return  'yellowTip qtipwidth';
					})
				.attr('title', function(d){ 
					return d[i].componentName;
				})
				.attr('text-anchor', 'middle')
				.attr('class', function(d){
					if(!d[i].highlight && d[i].componentName === "User" || d[i].displayName === "None"){
						return 'commonsize compName USER'
					}else{
						return 'commonsize compName '
					}
				})	
				.attr('x', function(d){
							if (d[i].componentName == "User" || d[i].serverType === "CUSTOM") {
									return 5;
							} else {
									return 0;
						}	
					})
					.attr('y', function(d) {

                    if (d[i].componentName == "User" || d[i].serverType === "CUSTOM" ||  d[i].displayName === "None") {
                        return 35 / cal.getScale(scale);
                    } else {
                        return 50 / cal.getScale(scale);
                    }
                }).style("fill", function(d){
						if(d[i].highlight ){
							return  "#ffffff"
				}}).style("font-size", cal.getFontSize(scale) + "px");

                userExpLine = parentNode.filter(function(d) {
                    if (d[i].componentName == "User") {
                        var src = "../images/clear.png";
                        if (d[i].nodeExperience == 'HEALTHY') {
                            src = "../images/component_icons/svg/stateicon/"+graphDataBTM.paper.skin+"/state_GOOD.svg";
                        } else if (d[i].nodeExperience == 'ERROR') {
                            src = "../images/component_icons/svg/stateicon/"+graphDataBTM.paper.skin+"/state_HIGH.svg";
                        } else if (d[i].nodeExperience == 'SLOW') {
                            src = "../images/component_icons/svg/stateicon/"+graphDataBTM.paper.skin+"/state_LOW.svg";
                        } else if (d[i].nodeExperience == 'STALLED') {
                            src = "../images/component_icons/svg/stateicon/"+graphDataBTM.paper.skin+"/state_INTERMEDIATE.svg";
                        }
                        d3.select(this)
                            .append('image').attr('class', 'userExpLine')
                            .attr({
                                'width':16,
                                'height': 16,
                                'x': compName.node().getBBox().x - 20,
                                'y': compName.node().getBBox().y - 2
                            }) .attr('xlink:href', function(d) { return src });
                            
                    } else {
                        return true;
                    }
                });
				

				/*
				*@ setting the highlight rectangle node
				*/
					
					parentNode.filter(function(d) {
						if(d[i].highlight){
						
								var compName = d3.select(this).selectAll('.compName').text(graphObjTools.textTruncate(d[i]['componentName'],graphObjTools.textTruncateLength));
								var dispName = d3.select(this).selectAll('.displayName').text(graphObjTools.textTruncate(d[i]['displayName'],graphObjTools.textTruncateLength));
								var hightLightHeight = graphObjTools.highLightNodeCheck == 1 ? 20 : 35;
								//compName.text(graphObjTools.textTruncate(d[i]['componentName'],graphObjTools.textTruncateLength));
								//dispName.text(graphObjTools.textTruncate(d[i]['displayName'],graphObjTools.textTruncateLength));
								if(dispName.node().getBBox().width >= compName.node().getBBox().width){
											graphObjTools.highLightNode(this,dispName.node().getBBox().width,hightLightHeight,dispName.node().getBBox().x,23);
									}else{
											graphObjTools.highLightNode(this,compName.node().getBBox().width,hightLightHeight,compName.node().getBBox().x,23);
								}
							 //graphObjTools.highLightNode(this,d3.select(this).node().getBBox().width,35,d3.select(this).node().getBBox().x,23);
							
							//if(displayName.node().getBBox().width >= compName_stroke.node().getBBox().width){
								//d3.select(this).selectAll('.highlight').attr("width", d3.select(this).node().getBBox().width).attr("height", 35);
									/*d3.select(this).selectAll('.isHighlight').attr('class', 'highlight userExpLine')
									.attr({
										'width':  d3.select(this).node().getBBox().width + 20 ,
										'height': 35,
										'x':  d3.select(this).node().getBBox().x - 10,
										'y': 23
									}) .style({
										'fill': '#40b5c5'
									});*/
						}
						//}
				});
					
			
			
				// duplicate
				 isJavaComp_stroke = parentNode.filter(function(d) {
                        return d[i].nodeText !== "None";
                    })
                    .append('text').text(function(d) {
                        return d[i].nodeText;
                    })
                    .attr('text-anchor', 'start')
                    .attr('class', 'commonsize_stroke isJavaComp')
                    .attr('x', -5 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -38 / cal.getScale(scale);
                    }).style("font-size", cal.getFontSize(scale) + "px");

                isJavaComp = parentNode.filter(function(d) {
                        return d[i].nodeText !== "None";
                    }).append('text').attr('class', 'commonsize isJavaComp')
					.attr('text-anchor', 'start')
                    .attr('x', -5 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -38 / cal.getScale(scale)
                    }).style("font-size", cal.getFontSize(scale) + "px");
					
					// duplicate
					/*isJavaComp_stroke .append('tspan').text(function(d) {
                        return d[i].nodeText +' ';
                    }).attr('class', 'commonsize isJavaComp commonsize_stroke');*/


                    isJavaComp.append('tspan').text(function(d) {
                        return d[i].nodeText +' ';
                    }).attr('class', 'commonsize isJavaComp');
					

					// duplicate
					 isJavaComp_stroke.filter(function(d) {
                        return d[i].isAsync;
                    }).append('tspan').attr('class', 'nodeTime').text(function(d) {
                        return d[i].nodeTime +' ';
                    });
					isJavaComp_stroke.filter(function(d) {
                        return d[i].isAsync;
                    }).append('tspan').attr('class', 'nodePercent').text(function(d) {
                        return d[i].nodePercent +' ';
                    }).style('opacity', '0').style('display', 'none');

                    isJavaComp.filter(function(d) {
                        return d[i].isAsync;
                    }).append('tspan').attr('class', 'nodeTime').text(function(d) {
                        return d[i].nodeTime +' ';
                    });
					isJavaComp.filter(function(d) {
                        return d[i].isAsync;
                    }).append('tspan').attr('class', 'nodePercent').text(function(d) {
                        return d[i].nodePercent +' ';
                    }).style('opacity', '0').style('display', 'none');


				// duplicate
				isAsyncComp_stroke = parentNode.filter(function(d) {
                        return d[i].isAsync ;
                    })
                    .append('text').text(function(d) {
                        return  ' (async) ' +d[i].asyncTime;
                    })
                    .attr('text-anchor', 'start')
                    .attr('class', 'commonsize_stroke isAsyncComp')
					.style("font-style", "italic")
                    .attr('x', -5 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -25 / cal.getScale(scale);
                    }).style("font-size","9px");

				isAsyncComp = parentNode.filter(function(d) {
                        return d[i].isAsync ;
                    })
                    .append('text').text(function(d) {
                        return ' (async) ' +d[i].asyncTime;
                    })
                    .attr('text-anchor', 'start')
                    .attr('class', 'commonsize isAsyncComp')
					.style("font-style", "italic")
			
                    .attr('x', -5 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -25 / cal.getScale(scale);
                    }).style("font-size", "9px");

                componentState = parentNode.filter(function(d) {
                        return d[i].nodeExperience != 'None' && d[i].componentName != "User";
                    }).append('image')
                    .attr('xlink:href', function(d) {
                        if (d[i].nodeExperience == 'HEALTHY') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_GOOD.svg'
                        } else if (d[i].nodeExperience == 'ERROR') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_HIGH.svg'
                        } else if (d[i].nodeExperience == 'SLOW') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_LOW.svg'
                        } else if (d[i].nodeExperience == 'STALLED') {
                            return '../images/component_icons/svg/stateicon/'+graphDataBTM.paper.skin+'/state_INTERMEDIATE.svg'
                        }
                    })
                    .attr('class', function(d) {
                        return 'componentState componentState' + d[i].nodeExperience
                    })
                    .attr('height', 16 / cal.getScale(scale))
                    .attr('width', 16 / cal.getScale(scale))
                    .attr('x', function() {
                        return 16 / cal.getScale(scale);
                    }).attr('y', function() {
                        if (isJavaComp.node() != null) {
                            isJavaCompbox = isJavaComp.node().getBBox();
                            return isJavaCompbox.y - 2;
                        }

                    }).attr('x', function() {
                        if (isJavaComp.node() != null) {
                            isJavaCompbox = isJavaComp.node().getBBox();
                            return isJavaCompbox.x - 20 / cal.getScale(scale);
                        }
                    });

				// duplicate
				 componentTranValue_stroke = parentNode.filter(function(d) {
                        return (d[i].nodeTime !== "None") && !d[i].isAsync;
                    })
                    .append('text')
                    .attr('text-anchor', 'start')
                    .attr('class', 'commonsize_stroke componentTranValue')
                    .attr('x', -6 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -24 / cal.getScale(scale);
                    })
                    .style("font-size", cal.getFontSize(scale) + "px");

                componentTranValue_stroke.append('tspan').attr('class', 'nodeTime').text(function(d) {
                    return d[i].nodeTime + " ";
                });
                componentTranValue_stroke.append('tspan').attr('class', 'nodePercent').text(function(d) {
                    return d[i].nodePercent + "  ";
                }).style('opacity', '0').style('display', 'none');


                componentTranValue = parentNode.filter(function(d) {
                        return (d[i].nodeTime != "None") && !d[i].isAsync;
                    })
                    .append('text')
                    .attr('text-anchor', 'start')
                    .attr('class', 'commonsize componentTranValue')
                    .attr('x', -6 / cal.getScale(scale))
                    .attr('y', function(d) {
                        return -24 / cal.getScale(scale);
                    })
                    .style("font-size", cal.getFontSize(scale) + "px");

                componentTranValue.append('tspan').attr('class', 'nodeTime').text(function(d) {
                    return d[i].nodeTime + " ";
                });
                componentTranValue.append('tspan').attr('class', 'nodePercent').text(function(d) {
                    return d[i].nodePercent + "  ";
                }).style('opacity', '0').style('display', 'none');

			
            });
		// For performance TODO
        serverType = null;
		serverTypeHoverImages = null;
		displayName = null;
		displayName_stroke = null;
		compName = null;
		userExpLine = null;
		isJavaComp = null;
		componentState = null;
		componentTranValue = null;
		startImg = null;
		displayName_compName = null;
		displayName_compName_stroke = null;
		compNametrick = null;
		compNametrick_stroke = null;
		serverTypeState = null;


		delete serverType;
		delete serverTypeHoverImages;
		delete displayName;
		delete displayName_stroke;
		delete compName;
		delete userExpLine;
		delete isJavaComp;
		delete componentState;
		delete componentTranValue;
		delete startImg;
		delete displayName_compName;
		delete displayName_compName_stroke;
		delete compNametrick;
		delete compNametrick_stroke;
		delete serverTypeState;
        }

		// Rendering the nodeData
        renderNode(graphObjTools.d3Scale);



        // Removing the existing tooltip
		//if($(".BubbleDiv").length){
			//$(".BubbleDiv").remove();
		//}
		 // Displaying the tooltip
         /*var bubble = $("#User").bubble({
                title: "Transaction user Experience",
                content: graphObjTools.userToolData
          });*/


        // Taking the bound of the graph
        var allparentnodes = graphObjTools.innerGrp.selectAll('.parentNode');
        var graphBounds = function() {
            var x = Number.POSITIVE_INFINITY,
                X = Number.NEGATIVE_INFINITY,
                y = Number.POSITIVE_INFINITY,
                Y = Number.NEGATIVE_INFINITY;
            allparentnodes.each(function(v, i) {
				for (keys in v)
				{
					if (v.hasOwnProperty(keys)){
						x = Math.min(x, graphObj.node(keys).x - this.getBBox().width * zoom.scale());
						X = Math.max(X, graphObj.node(keys).x + this.getBBox().width * zoom.scale());
						y = Math.min(y, graphObj.node(keys).y - this.getBBox().height * zoom.scale());
						Y = Math.max(Y, graphObj.node(keys).y + this.getBBox().height * zoom.scale());
					}
				}


            });
            return {
                x: x,
                X: X,
                y: y,
                Y: Y
            };
        }

        var graph_bound = graphBounds();
        var zoomToFit = function() {

            var graph_width = graph_bound.X - graph_bound.x,
                graph_height = graph_bound.Y - graph_bound.y,
                total_width = graphObjTools.graphWidth - graphObj.graph().marginx,
                total_height = graphObjTools.graphHeight - graphObj.graph().marginy,
                fit_scale = Math.min(total_width / graph_width, total_height / graph_height);

            graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
            graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);
			 cal.interpolateZoom(graphObjTools.d3Translate, fit_scale, 200);
            //innerGroupNode.attr("transform", "translate(" + xPrime + ", " + yPrime + ") scale(" + scale + ")");

            delete fit_scale, total_width, total_height;
        }
		// setting the graph position on load
        var xCenterOffset = (rootSVG.attr("width") - graphObj.graph().width);

        var bbox = d3.select('g.graphinnergrp')[0][0].getBBox(),
			graphWidth = graphObj.graph().width,
			graphHeight = graphObj.graph().height
            graph_width = graph_bound.X - graph_bound.x,
            graph_height = graph_bound.Y - graph_bound.y,
            total_width = graphObjTools.graphWidth - graphObj.graph().marginx - 15,
            total_height = graphObjTools.graphHeight - graphObj.graph().marginy - 15,
			// fit_scale = Math.min(graphWidth - graphObj.graph().marginx, graphHeight - graphObj.graph().marginy);
            fit_scale = Math.min(total_width / graph_width, total_height / graph_height),
			graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
            graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);

			// condition for signal line components
			//if((total_height/2) > graph_height){
			if((total_height/2) > graph_height && (total_width/2) > graph_width){ 
				//fit_scale= Math.min(total_width / graph_width, total_height / graph_height);
				fit_scale= graphObjTools.initialScale;
				graphObjTools.d3Translate[0] = (-graph_bound.x * fit_scale + (total_width / fit_scale - graph_width) * fit_scale / 2),
				graphObjTools.d3Translate[1] = (-graph_bound.y * fit_scale + (total_height / fit_scale - graph_height) * fit_scale / 2);
			}
			
			//cal.interpolateZoom(graphObjTools.d3Translate, fit_scale, 10);
			rootSVG.transition().duration(10).call(zoom.translate(graphObjTools.d3Translate).scale(fit_scale).event);


        var zoomFunction = function() {
            //innerGroupNode.attr("transform", "translate(" + d3.event.translate + ")"+"scale(" + d3.event.scale + ")");

            translation = d3.event.translate,
			scale = d3.event.scale;
            /* --
				This is to controll the panning options to happen within the boundries
			--*/
            /*canvasWidth = bbox.width * scale,
                        canvasHeight = bbox.height * scale,
                        canvasAspect = canvasWidth / canvasHeight,
                        screenAspect = graphObjTools.graphWidth / graphObjTools.graphHeight,
                        xPrime = translation[0],
                        yPrime = translation[1],
                        left = -bbox.x * scale,
                        right = -bbox.x * scale,
                        top = -bbox.y * scale,
                        bottom = -bbox.y * scale;

						graphObjTools.graphWidth > canvasWidth && graphObjTools.graphHeight > canvasHeight ? (right += -(canvasWidth - graphObjTools.graphWidth),
						bottom += -(canvasHeight - graphObjTools.graphHeight),
						xPrime = Math.min(right, Math.max(left, xPrime)),
						yPrime = Math.min(bottom, Math.max(top, yPrime))) : canvasAspect > screenAspect ? canvasHeight > graphObjTools.graphHeight ? (right += -(canvasWidth - graphObjTools.graphWidth),
						bottom += -(canvasHeight - graphObjTools.graphHeight),
						xPrime = Math.max(right, Math.min(left, xPrime)),
						yPrime = Math.max(bottom, Math.min(top, yPrime))) : (right += -(canvasWidth - graphObjTools.graphWidth), bottom += graphObjTools.graphHeight - canvasHeight,
						xPrime = Math.max(right, Math.min(left, xPrime)),
						yPrime = Math.max(top, Math.min(bottom, yPrime))) : canvasWidth > graphObjTools.graphWidth ? (right += -(canvasWidth - graphObjTools.graphWidth),
						bottom += -(canvasHeight - graphObjTools.graphHeight),
						xPrime = Math.max(right, Math.min(left, xPrime)),
						yPrime = Math.max(bottom, Math.min(top, yPrime))) : (right += graphObjTools.graphWidth - canvasWidth, bottom += -(canvasHeight - graphObjTools.graphHeight),
						xPrime = Math.max(left, Math.min(right, xPrime)),
						yPrime = Math.max(bottom, Math.min(top, yPrime))),
						translation[0] = xPrime,
						translation[1] = yPrime, */
            //zoom.scale(scale).translate(translation);
            //innerGroupNode.attr("transform", "translate(" + xPrime + ", " + yPrime + ") scale(" + scale + ")");
            //innerGroupNode.attr("transform", "translate(" + translation[0] + ", " + translation[1] + ") scale(" + scale + ")");
            innerGroupNode.attr("transform", "translate("+ translation +") scale(" + scale + ")");

            //renderNode(d3.event.scale);
            $(".slider").slider("value", scale);
			if(slider_tooltip.text(Math.round(scale * 100) + '%').hide()){
					slider_tooltip.text(Math.round(scale * 100) + '%').show();
			}
            cal.hideText(scale, 0.600);

			sliderUI.slider("option","value",scale);
        }

        var zoomStartFunction = function() {
            //--fn
        }
        var zoomEndFunction = function() {
            //--fn
			slider_tooltip.delay(10).fadeOut('slow');
        }
        zoom.on("zoom", zoomFunction);
        //zoom.on("zoomstart", zoomStartFunction);
		zoom.on("zoomend", zoomEndFunction);

        d3.selectAll('button.button_zoom').on('click', cal.zoomBtFn);
        d3.select('#autofit').on('click', zoomToFit);
        rootSVG.call(zoom);




	// Adding scroll plugin in table of tooltip
	/*$('.tooltiptable').scrolltable({
						setWidths: true,
						maxHeight: 125
				});*/
	Ext.defer(function(){
		Ext.get('btm_url').animate({top:65});
		
	},500);
	
    }
    //drawGraph();


	// window resize event
    $(window).resize(function() {
        selector.empty();
		//var testGraph = setInterval(function(){
		drawGraph();
		//},1000);
		//testGraph = null;
		//delete testGraph;
		selector.unbind();
		// closing the moreoptions tooltip
		if(moreoptions){
			moreoptions.close();
		}

    }).resize();


})($('#paper'), data);

// Snapshot Default View
function transactionSnapshot(selector,transactionsnapshot){

			var container = $(document.createElement('div')),
			titleCon =$(document.createElement('div')),errorMsg,
			listof = $(document.createElement('ul')),
			toogleBtn = $(document.createElement('div')),
			closeBtn = $(document.createElement('div')),
			keys;
			toogleBtn.attr('id','togglebutton');
			toogleBtn.attr('class','togglebuttonDown');
			//closeBtn.attr('id','closebuttonDown');
			//closeBtn.attr('class','closebuttonDown');
			if(selector === "undefined" || selector === null){
				selector="body";
			};
			if(transactionSnapshot == "undefined" || transactionsnapshot == null){
				errorMsg = "Error in data"
			}

			if(typeof(transactionsnapshot) === "object" || typeof(transactionsnapshot) === Array){

				var innnerHtml="",color="#000",imgscr,segementValue;
				for (keys in transactionsnapshot[0])
				{

					list = $(document.createElement('li'));

					if(keys === "blocks"){
						listTable = $(document.createElement('table'));
						listTabletr = $(document.createElement('tr'));
						for (var Bkeys in transactionsnapshot[0].blocks[0])
						{
							if(transactionsnapshot[0].blocks[0].hasOwnProperty(Bkeys))
							{
								listTabletd = $(document.createElement('td'));
								$(listTabletr).append(listTabletd);
								$(listTabletd).html('<div style="font-size:11px;padding-bottom:5px;text-align:center">'+Bkeys+'</div><div class="f13-bold" style="text-align:center">'+transactionsnapshot[0].blocks[0][Bkeys]+'</div>')
							}
						}
						$(list).attr('id','blockstable');

						$(list).html('<div class="listitle" style="">Tier Execution Time Breakup&nbsp;:</div>');
						$(list).append(listTable);
						$(listTable).append(listTabletr);
					}else{
						
						switch(transactionsnapshot[0][keys]){
							case "Error":
								color="#000000";
								segementValue ="Error Segment";
								imgscr ="<img src='../images/"+data.paper.skin+"/error.png'/>"
								break;
							case "Healthy":
								color="#000000";
								segementValue ="Healthy Segment";
								imgscr ="<img src='../images/"+data.paper.skin+"/healthy.png'/>"
								break;
							case "Slow":
								color="#000000";
								segementValue ="Slow Segment";
								imgscr ="<img src='../images/"+data.paper.skin+"/slow.png'/>"
								break;
							case "Stalled":
								color="#000000";
								segementValue ="Stalled Segment";
								imgscr ="<img src='../images/"+data.paper.skin+"/stalled.png'/>";
								break;
							default:

								imgscr ="<img src='../images/clear.png'/>";

						}

//						console.log(keys ,'==', segementValue)
						if(keys == "User Experience" || keys == "Request Processing"){

							innnerHtml = "<div style='float:left;text-align:left;'>"+imgscr+"</div>";
						}
						else if(keys == "Execution Time"){
							if(transactionsnapshot[0][keys]){
								var str = transactionsnapshot[0][keys];
								var splited = str.split(" ");
							}
							innnerHtml = "<div style='float:left;text-align:left;'><span class='f15-bold'>"+splited[0]+ "</span> <span>"+splited[1]+"</span></div>";

						}else{
							innnerHtml = "<div class='f12-normal' style='width:185px;word-wrap:break-word;float:left;text-align:left;'>"+transactionsnapshot[0][keys]+"</div>";
						}
						$(list).html('<div class="clrfix"><div style="float:left;text-align:left;width:108px;" class="f12-bold">'+keys+'</div><div style="float:left;padding:0px 10px 0 0px;text-align:left">:</div>'+innnerHtml+'</div>');
					}

					$(listof).append(list);


				}
			}

			$(container).css({'position':'absolute'});
			$(container).draggable({ containment: "#paper",scroll: false,handle: "#transactionsnapshotbox",grid: [ 20, 20 ] });
			$(container).hover(function(){
				$(container).fadeTo( "slow" , 1)
			},function(){
				$(container).fadeTo('slow',1);
			});
			$(titleCon).css({
				'position':'absolute',
				'top':'-13px',
				'left':'10px',
				'text-transform':'uppercase'
			}).addClass('transactionsnapshotboxtitle').attr('id','downtoggle');

			$(titleCon).append('<span style="float:left">transaction Snapshot</span><span data-qtip="Collapse" data-qclass="yellowTip" class="closebuttonDown" style="float:left"></span>'); //-- Adding Title

			$(container).append(toogleBtn);//-- Adding toggle button
			//$(container).append(closeBtn);//-- Adding close button
			$(container).attr('id','transactionsnapshotbox');
			$(container).addClass('transactionsnapshotbox');
			$(container).html(errorMsg);
			$(container).append(listof);
			$(selector).append(container);
			$(container).append(titleCon);

			$('#blockstable').hide();
			currentWidth = $(container).width() -5;
			currentHeight = $(container).outerHeight(true) -9;
			$(toogleBtn).css({left:currentWidth+'px'});
			//$(closeBtn).css({left:currentWidth+20+'px'});

			$('body').on('click','#togglebutton',function(){

				$(toogleBtn).css({left:currentWidth+'px'});
					$('#blockstable').slideToggle( "normal",function(){
					$('#togglebutton').toggleClass("togglebutton");
				});

			});
			$('body').on('click','.closebuttonDown',function(event,btn){
				event.preventDefault();

				 $( '#transactionsnapshotbox' ).css('visibility','hidden');
				$(selector).append('<div class="transactionsnapshotboxtitle" id="uptoggle" style="position:absolute;z-index:999;top:33px;left:1px;"><span style="font-size:12px;float:left;text-transform: uppercase;">transaction Snapshot</span><span class="closebuttonUp" data-qclass="yellowTip" data-qtip="Expand" style="float:left"></span></div>');

			});
			$('body').on('click','#uptoggle',function(event,btn){
				 $( '#transactionsnapshotbox' ).css('visibility','visible');
				$(this).remove();

			});

		}
	// Shows the transaction Snapshot details if txnSnapshotToShow  is true
	if(data.txnSnapshotToShow){
		transactionSnapshot('body',data.headerDetails);
	}

//-- Render Legends
function showLegends(){
	var imgs =[
				/*{'Healthy':'../images/Light/state_transition_GOOD.png'},
				{'Slow':'../images/Light/state_transition_LOW.png'},
				{'Stalled':'../images/Light/state_transition_INTERMEDIATE.png'},
				{'Error':'../images/Light/state_transition_HIGH.png'}*/
				{'Healthy':'btm_rum_dd_icons_healthy'},
				{'Slow':'btm_rum_dd_icons_slow'},
				{'Stalled':'btm_rum_dd_icons_stalled'},
				{'Error':'btm_rum_dd_icons_error'}
			].reverse(),imgcon= document.createElement('div'),t,imglist,legendDOM;
	imgcon.setAttribute('class','btmlegends');

	$(imgcon).css({
		'position':'absolute',
		//'width':140,
		'right':15,
		'left': 'auto',
		'top':$(window).height() - 30
	});
	for (t=0;t<imgs.length;t++ )
	{
		for (imglist in imgs[t])
		{

				imglistdiv= document.createElement('div');
				$(imglistdiv).attr('class','imglist');
				$(imglistdiv).attr('data',imglist);
				switch($(imglistdiv).attr('data')){
							case "Healthy":
								legendDOM ="<span class='legendover'><img src='../images/clear.png' class='btm_healthy' data-qclass='staticTop' data-qtip='User Experience'  /></span>";

								break;
							case "Slow":
								legendDOM ="<span class='legendover'><img src='../images/clear.png' class='btm_slow' data-qclass='staticTop' data-qtip='User Experience'/></span>";

								break;
							case "Stalled":
								legendDOM ="<span class='legendover'><img src='../images/clear.png' class='btm_stalled'  data-qclass='staticTop' data-qtip='User Experience'/></span>";

								break;
							case "Error":
								legendDOM ="<span class='legendover'><img src='../images/clear.png' class='btm_error' data-qclass='staticTop' data-qtip='User Experience'/><span>";

								break;
							//default:
						}
				imgDiv = document.createElement('img');
				$(imgDiv).attr('class','state_icons');
				imgDiv.src = '../images/clear.png';
				$(imgDiv).attr('class','imgdiv  '+imgs[t][imglist]+'');
				$(imglistdiv).append(imgDiv,$(legendDOM));
				$(imgcon).append(imglistdiv);
		}

	}

	$(imgcon).append('<div style="clear:both"></div>');
	if($('.btmlegends')){
		$('.btmlegends').remove();
	}

	$('body').append(imgcon);
	var contrlResizeEvent = null;
	$(window).resize(function () {
		if(contrlResizeEvent != null) clearTimeout(contrlResizeEvent);
			contrlResizeEvent = setTimeout(function(){
			showLegends();
		},200);

	});
}
showLegends();

// Rest of topologyParentCall
function topologyParentCall()
{
	if(isReporterRequest == 'yes') {
		setFocusToWindow('topologyBuildWindow');
	}
	else {
		window.parent.setFocusToWindow('topologyBuildWindow');
	}
}

function topologyTitleChange()
{
	var title = '<%=topologyPageTitle%>';
	if(isReporterRequest == 'yes') {
		setTitleTopologyPage(title);
	}
	else {
		window.parent.setTitleTopologyPage(title);
	}
}

function reply_click(id)
{
 //alert(id);
}

//TODO
function showModalwindow(modalWindowGridData)
{

	//console.log( data.paper.skin);
	//alert(modalWindowGridData);
	var grid = Ext.create('Ext.grid.Panel', {
			cls:'gridSkin',
			margin: '0',
			frame:false,
			border:true,
			//style:  data.paper.skin  === "Light" ?  '{"border": "red 1px solid !important"}' : '{"border":" #c5c5c5 1px solid !important"}',
			autoScroll:true,
			flex:1,
			scroll : true,
			id: 'IntermediateDetailsTable',
			height:158,
			padding:0,
			store:new Ext.data.Store(
			{
				fields: ['User_Exp','Call_Type','Called_From','Start_Time','Self_Time','Execution_Time','Exit_Calls','Node_Order','Drilldown_URL','GUID'],
				data: modalWindowGridData
			}),
			tdAttrs:{
				style:{
					'vertical-align':'middle !important'
				}
			},
			viewConfig: {
				deferEmptyText: true,
				forceFit:true,
			},
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: true,
					resizable: true
				},
				items: [
					{
						text: "",
						dataIndex: 'User_Exp',
						renderer: function(value, metadata,record){
								//metadata.tdAttr = 'data-qtip="' + value + '"';
								//console.log(record);
								
								return '<div><img src="../images/clear.png" class="btm_rum_dd_icons_'+value+'"  data-qtip="'+value.charAt(0).toUpperCase() + value.slice(1)+'" /></div>' ;
							},
						width: 32
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Call Type"+"</span>",
						dataIndex: 'Call_Type',
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Source"+"</span>",
						dataIndex: 'Called_From',
						flex:2,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Start time"+"</span>",
						dataIndex: 'Start_Time',
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						flex:2
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Self time"+"<span style='text-transform:none'> ("+"ms"+")</span></span>",
						dataIndex: 'Self_Time',
						//width: 90,
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Execution time"+"<span style='text-transform:none'> ("+"ms"+")</span></span>",
						dataIndex: 'Execution_Time',
						//width: 90,
						flex:1,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							}

					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Exit calls"+"</span>",
						dataIndex: 'Exit_Calls',
						hidden:true,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						flex:2
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Node Order"+"</span>",
						dataIndex: 'Node_Order',
						hidden:true,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						width:100
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"Drilldown URL"+"</span>",
						dataIndex: 'Drilldown_URL',
						hidden:true,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						width:100
					},
					{
						text: "<span style='white-space:normal;word-wrap: break-word'>"+"GUID"+"</span>",
						dataIndex: 'GUID',
						hidden:true,
						renderer: function(value, metadata,record){
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value ;
							},
						width:100
					}
					
				],
			},
			listeners: {
				"itemclick": function ( grid, record, item,index, eOpts )
				{
					 var row = grid.getStore().getAt(index);
					if (row.data.Drilldown_URL != 'None') {
                        var guidnode =  row.data.GUID+"#"+row.data.Node_Order;
                        var url = row.data.Drilldown_URL;
						if(isReporterRequest == 'yes') {
							baseStackTrace(url, guidnode, 'topologyBuildWindow');
						}
						else {
	                        window.parent.baseStackTrace(url, guidnode, 'topologyBuildWindow');
						}
                    }
				},
				"viewready": function (grid) {
					var view = grid.view;
					// record the current cellIndex
//					grid.mon(view, {
//						uievent: function (type, view, cell, recordIndex, cellIndex, e) {
//							grid.cellIndex = cellIndex;
//							grid.recordIndex = recordIndex;
//						}
//					});

//					grid.tip = Ext.create('Ext.tip.ToolTip', {
//						target: view.el,
//						delegate: '.x-grid-cell',
//						trackMouse: true,
//						maxWidth: 500,
//						minWidth: 100,
//						cls:'yellowTip para',
//						style:{'word-wrap':'break-word'},
//						renderTo: Ext.getBody(),
//						listeners: {
//							beforeshow: function updateTipBody(tip) {
//								if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex != 1) {
//									header = grid.headerCt.getGridColumns()[grid.cellIndex];
//									var temp = grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
//									if(!Ext.isEmpty(temp))
//									{
//										tip.update(grid.getStore().getAt(grid.recordIndex).get(header.dataIndex)+"");
//									}
//									else
//									{
//										return false;
//									}
//								}
//								else
//								{
//									return false;
//								}
//							}
//						}
//					});
				}
			}
	});
	return grid;
}

function baseStackTrace(url, windowId, child)
{
	var y =21,x= 10;
	y = ++y + 30;
	x = ++x + 12;
	/*if(Ext.getCmp(windowId) != null)
	{
		Ext.getCmp(windowId).toFront();
		return;
	}*/
	url = url + '&prevWindowId=' + encodeURIComponent(windowId);
	var win = Ext.create('Ext.window.Window', {
		title: '',
		cls:'btmWindow',
		height: Ext.getBody().getViewSize().height -50,
		width: Ext.getBody().getViewSize().width-50,
		//width:900,
		//height:0,
		minimizable : false,
		layout: 'fit',
		//header:false,
		modal:true,
		closeAction:'destroy',
		ghost:false,
		id: windowId,
		shim:true,
		resizable:true,
		parentNodeName: child,
		isBaseStackTrace : true,
		html: '<iframe src="' + url+ '" scrolling="no" frameborder="0"style="width:100%;height:100%" ></iframe>',
		listeners: {
			"minimize": function (window, opts) {
				window.collapse();
			},
			"close": function (win, eOpts ) {
				destroyInnerChilds(win);
				y = --y - 30;
				x = --x - 12;
				if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						if(el){
							el.removeCls('windowModal');
							el.hide();
						}
					}
			},
			show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						if(el){
							el.show();
							el.addCls('windowModal');
						}
					}
				}
		}

		/*tools: [{
			type: 'restore',
			handler: function (evt, toolEl, owner, tool) {
				var window = owner.up('window');
				window.setWidth(980);
				window.expand('', false);
				window.center();
			}
		}]*/
	//}).showAt(x,y);
	}).show();


	win.resizer.addListener('beforeresize', function(){
	Ext.get(win.body.id).mask();
  });
   win.resizer.addListener('resize', function(){
    Ext.get(win.body.id).unmask();
  });
 win.dd.addListener('dragstart', function(){
 Ext.get(win.body.id).mask();
  });
  win.dd.addListener('dragend', function(){
 Ext.get(win.body.id).unmask();
  });
	//win.setPosition(i,i);
	Ext.EventManager.onWindowResize(function()
				{
					//var me = this;
					//Ext.suspendLayouts();
					//win.setSize(Ext.getBody().getViewSize().width-10,Ext.getBody().getViewSize().height-10);
					win.setSize(Ext.getBody().getViewSize().width-50,Ext.getBody().getViewSize().height-50);
                    win.center();
					win.doComponentLayout();
					//Ext.resumeLayouts();
					//win.setPosition(0, 0);
					//location.reload();
				}, win);
}
function setTitleTopologyPage(title)
{
	if(Ext.getCmp('topologyBuildWindow') != null)
	{
		Ext.getCmp('topologyBuildWindow').setTitle(title);
	}
}
function setTitle(title , id)
{
	var tracewindowTitle = title;
	if(title.indexOf('^%^')>0)
	{
		tracewindowTitle = title.substring(0,title.indexOf('^%^'));
		//Ext.getCmp('topologyBuildWindow').setTitle(title.substring(title.indexOf('^%^')+3));
	}
	if(Ext.getCmp(id) != null && Ext.getCmp(id) != undefined)
	{
		Ext.getCmp(id).setTitle(tracewindowTitle);
	}
}
function closeChildWindow()
{
	var panelsArray = Ext.ComponentQuery.query('window');
	if (panelsArray != null && panelsArray.length > 0)
	{
		for(var i=0;i<panelsArray.length;i++)
		{
			if(panelsArray[i].isBaseStackTrace)
			{
				var windowId = panelsArray[i].id;
				if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
				{
					Ext.getCmp(windowId).destroy();
				}
			}
		}
	}
	Ext.getCmp('topologyBuildWindow').destroy();
}

function destroyInnerChilds(win)
{
	var panelsArray = Ext.ComponentQuery.query('window');
	if (panelsArray != null && panelsArray.length > 0)
	{
		for(var i = 0; i < panelsArray.length; i++)
		{
			if(panelsArray[i].isBaseStackTrace && panelsArray[i].parentNodeName == win.id)
			{
				var windowId = panelsArray[i].id;
				if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
				{
					traverseInnerChilds(panelsArray, win, panelsArray[i].parentNodeName, panelsArray[i].id);
					Ext.getCmp(windowId).destroy();
				}
			}
		}
	}
	if(isReporterRequest == 'yes'){
		setFocusToWindow(win.parentNodeName);
	}
	else{
		window.parent.setFocusToWindow(win.parentNodeName);
	}
}
var arrayWinObjStore = new Array();

function traverseInnerChilds(panelsArray, win , parentName, currentWindowId)
{
	for(var i = 0; i < panelsArray.length; i++)
	{
		if(panelsArray[i].isBaseStackTrace && panelsArray[i].parentNodeName == currentWindowId)
		{
			var windowId = panelsArray[i].id;
			if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
			{
				arrayWinObjStore.push(Ext.getCmp(windowId));
				Ext.getCmp(windowId).destroy();
			}
		}
	}
	if(arrayWinObjStore.length>0)
	{
		for(var j = 0; j < arrayWinObjStore.length; j++)
		{
			var tempId = arrayWinObjStore[j].id;
			arrayWinObjStore.pop(arrayWinObjStore[j]);
			destroyInnerChilds(panelsArray, win , parentName, tempId);
		}
	}
	else
		return;
}
function setFocusToWindow(currentWindowId)
{
	if(currentWindowId==undefined)
	{
		Ext.getCmp('topologyBuildWindow').focus();
		return;
	}
	if(Ext.getCmp(currentWindowId) != null)
	{
		Ext.getCmp(currentWindowId).focus();
	}

}