(function(data){
	if(Ext){
		Ext.tip.QuickTipManager.init();	
	}
	var test = data.topology.header_Info.Test,
		descriptor = data.topology.header_Info.INFO,
		msmt_time = data.topology.header_Info.MeasureTime,
		pagetitle = data.topology.header_Info.title,
		userData = data.topology.user_Info,
		browserData = data.topology.browser_Info,
		contentData = data.topology.contentDownload_Info,
		networkData = data.topology.network_Info,
		backendData = data.topology.backend_Info,
		skin = data.topology.skin,
		gridData = data.gridData,
		headerSubData = data.HeaderSubData;

	function trimString(str,len,stringlen) {
	  if (str.length > len) {
		return str.substr(0, stringlen) + ' ... ' + str.substr(str.length-10, str.length);
	  }
	  return str;
	}

	$.fn.loadData = function(){
		this.userBlock = function(data) {
			$toogle = $("<div>",{id:"toogleGrp","class":"toogleGrp"});
			$toogleList = $("<div>",{id:"toogleList"});
			$toogle.append($toogleList);
			$toogle.append('<button id="toggleButton" class="rumtogglearrow"></button>');
			if(!Ext.isEmpty(userData)){
				var _this = $(this);
				if(!Ext.isEmpty(data['USER_NAME']))
					_this.append('<div class="username">'+data['USER_NAME']+'</div>');
				_this.append('<div class="externalUserIcon" style="border:0px solid red"></div>');
			}
		};
		if(!Ext.isEmpty(browserData)){
			this.browserBlock = function(browserData){
				$bwrDiv = $('<div>',{"class":"bwrDiv"});
				$bwrContentDiv = $('<div>',{"class":"bwrContent"});
				$bwrDiv.append($bwrContentDiv);
				if(browserData){
					var _this = $(this);
					$bwrContentDiv.append("<div style='padding:15px 0px 0px 0px'><div class='font24 nfont'>"+browserData["MeasureVal"]+"<span style='font-size:12px;letter-spacing: 0px;vertical-align: 2px' class='ms'>  ('"+browserData["MeasureUnit"]+"')</span></div><div><div class='font_bold' style='margin:5px auto 0px auto;padding:0px 0px 15px 0px '>"+browserData["MeasureDispName"]+"</div>");
					_this.append($bwrDiv);
				}
			};
		}
		this.contentDownload = function(contentdownloaddata){
			if(contentdownloaddata){
				var _this = $(this);
				_this.append('<div><div class="f24-normal"><span class="fbg cntText">'+contentdownloaddata["MeasureVal"]+'</span></div><div class="font_bold" style="margin:5px auto;width:150px"><span class="fbg"><img src="/final/images/clear.png" class="state_'+contentdownloaddata["MeasureState"]+'"/>'+contentdownloaddata['MeasureDispName']+'</span><span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms">  ('+contentdownloaddata['MeasureUnit']+')</span></div></div>');
			}
		};
		this.networkInfo = function(networkInfodata){
			if(networkInfodata){
				var _this = $(this);
				_this.append('<div id="networkBlock"><div class="f24-normal"><span class="fbg ntText">'+networkInfodata["MeasureVal"]+'</span></br></span></div><div class="font_bold" style="margin:5px auto;width:140px"><img src="/final/images/clear.png" class="state_'+networkInfodata["MeasureState"]+'"/><span class="fbg">'+networkInfodata['MeasureDispName']+'</span><span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms"> ('+networkInfodata['MeasureUnit']+')</span></div></div>');
			}
		};
		this.backendInfo = function(backendInfodata){
			if(backendInfodata){
				var _this = $(this);
				 _this.append('<div style="position:absolute;top:25%;bottom:50%;left:5%;right:0%"><div class="f24-normal"><span >'+backendInfodata['MeasureVal']+'</span></div><div class="font_bold" style="margin:5px auto;"><img src="/final/images/clear.png" class="state_'+backendInfodata["MeasureState"]+'"/><span class="fbg">'+backendInfodata['MeasureDispName']+'</span></br></span><span style="font-size:12px;letter-spacing: 0px;vertical-align:2px" class="ms">   ('+backendInfodata['MeasureUnit']+')</span></div></div>');
			}
		};
		this.loadGridData = function(data){
			$nwtlistDiv = $('<div>',{"class":"listDiv",id:"gridDiv","data-qclass":"yellowTip","data-qtip":""});
			$nwtDetail = $('<div>',{"class":"nwtDetail"});
			$nwtDetail.html('<div class="font_bold"  style="text-align:center;margin:0px auto" >'+data[0]['Title']+'</div>');
			$nwtlistDiv.append($nwtDetail);
			if(data){
				var _this = $(this);
				$list = $("<table>",{"class":"list","style":"margin-left:-3px"});
				for (var keys in data)
				{
					if(data.hasOwnProperty(keys)){
						if(keys == 0)
							continue;
						$list.append('<tr><td><img src="/final/images/clear.png" class="state_'+data[keys]['MeasureState']+'"/></td><td>'+data[keys]['MeasureDispName']+' '+'('+data[keys]['MeasureUnit']+')'+'</td><td >'+data[keys]['MeasureVal']+'</td></tr>');
						$nwtlistDiv.append($list);
					}
				}
				_this.append('</table>');
				_this.append($nwtlistDiv);
				$nwtlistDiv.show();
			}
		}
		return this;
	}


	var $mainDiv = $("<div>", {id: "measureTopology", "class": "extMonTopologywrapper"});
	var $mainBODY = $("<div>", {id: "measureTopology-body", "class": "extMonTopologybodywrapper"});
	var $headerDiv = $("<div>", {"class": "extMonTopologyheader"});
	var $rumTopologyTitle = $("<div>", {"class": "extMonTopologyTitle"});
	var $topologyBlock = $("<div >", {id:"topologyBlock","class": "topologyBlock",style:'left:0px'});
	var $userBlock = $("<div>", {"class": "userBlock"});
	var $arrowBlock,$browerBlock,$browerlayerBlock;
	if(!Ext.isEmpty(browserData)){
		$arrowBlock = $("<div>", {"class": "arrowBlock"});
		$browerBlock = $("<div>", {"class": "browerblock"});
		$browerlayerBlock = $("<div>", {"class": "browerlayer"});
	}
	var $requestrespondblock = $("<div>", {"class": "requestrespondblock"});
	var $contentDownloadInfo = $("<div>", {"class": "contentdownloadinfo"});
	var $networkInfo = $("<div>", {"class": "networkinfo"});
	var $cloudBlock = $("<div>", {"class": "cloudBlock"});
	var $gridBlock = $("<div>", {"class": "chartBlock",id:"chartBlock"});

	$('body').append($mainDiv);
	$mainDiv.append($headerDiv);
	$mainDiv.append($mainBODY);

	$headerDiv.html('<span>'+pagetitle+'</span>');

	$mainBODY.append($rumTopologyTitle);
	$rumTopologyTitle.html('<span class="outerBg"><span class="bold">'+extMonLbl+' </span><span data-qclass="yellowTip" data-qtip='+descriptor+' >'+trimString(descriptor,10,50)+'</span><span class="bold"> '+atLbl+' </span>'+msmt_time+'<span></span>');
	if(!Ext.isEmpty(headerSubData)){
		var ct =0;
		var divider = '';
		$toggleDataBlock = $("<div>", {"class": "toggleData"});
		$list = $("<div>",{"style":"width:auto;border:0px solid red;display:block;visibility:visible"});

		var len = (Object.keys(headerSubData).length)/2;
		for (var keys in headerSubData)
		{
			if (headerSubData.hasOwnProperty(keys)){
				if(keys.indexOf("_icon") > 0)
					continue;

				if((ct+1) == len)
					divider = "border-right-width:0px !important;";

				if(keys == "Location" || keys == "External Agent Location"){
					$list.append('<span id="list'+ct+'" style="float:left;border:0px solid green" data-qtip="'+extagent+'" data-qclass="yellowTip"></span><span style="border-right-width:0px !important; text-overflow:ellipsis;text-align:left;" class="listblk brlist" data-qtip="'+extagent+':&nbsp;'+headerSubData[keys]+'" data-qclass="yellowTip"><img  style="width:11px" src="/final/images/clear.png" class="'+headerSubData[keys+"_icon"]+'"/>'+headerSubData[keys]+'</span>');
				}
				else if (keys == "Component"){
					$list.append('<span id="list'+ct+'" style="float:left;border:0px solid green" data-qtip="'+compLbl+'" data-qclass="yellowTip"></span><span style="text-overflow:ellipsis;text-align:left;" class="listblk brlist" data-qtip="'+compLbl+'" data-qclass="yellowTip"><img src="/final/images/clear.png"  style="width:11px" class="'+headerSubData[keys+"_icon"]+'"/>'+headerSubData[keys]+'</span>');
				}
				else if (keys=="URL Accessed")
				{
					$list.append('<span id="list'+ct+'" style="float:left;border:0px solid green" data-qtip="'+urlLbl+'" data-qclass="yellowTip"></span><span style="text-overflow:ellipsis;text-align:left;" class="listblk brlist" data-qtip="'+urlLbl+'" data-qclass="yellowTip"><img src="/final/images/clear.png" class="'+headerSubData[keys+"_icon"]+'"/>'+headerSubData[keys]+'</span>');
				}
				else{
					$list.append('<span id="list'+ct+'" style="float:left;border:0px solid green" data-qtip="'+keys+'" data-qclass="yellowTip"></span><span style="'+divider+' text-overflow:ellipsis;text-align:left;" class="listblk brlist" data-qtip="'+keys+'" data-qclass="yellowTip"><img src="/final/images/clear.png" class="'+headerSubData[keys+"_icon"]+'"/>'+headerSubData[keys]+'</span>');
				}
				ct = ct+1;
			}
		}
		$mainBODY.append($toggleDataBlock);
		$list.append('</div>');
		$toggleDataBlock.append('</div>');
		$toggleDataBlock.append($list);
	}
	$mainBODY.append($topologyBlock);
	$topologyBlock.append($userBlock);
	if(!Ext.isEmpty(browserData)){
		$topologyBlock.append($arrowBlock);
		$topologyBlock.append($browerBlock);
	}
	$topologyBlock.append($requestrespondblock);
	$requestrespondblock.append($networkInfo);
	$requestrespondblock.append($contentDownloadInfo);
	$topologyBlock.append($cloudBlock);
	$topologyBlock.append('<div style="clear:both"></div>');
	$topologyBlock.append($gridBlock);
	/*
	* Initialization of each block
	*/
	var initUserdata = $userBlock.loadData(),
		contentDownloadInfo = $contentDownloadInfo.loadData(),
		networkInfo = $networkInfo.loadData(),
		backendInfo = $cloudBlock.loadData(),
		gridBlock = $gridBlock.loadData();

	var initBrowserdata;
	if(!Ext.isEmpty(browserData))
		initBrowserdata = $browerBlock.loadData()
	/*
	*	Loading each data
	*/
	initUserdata.userBlock(userData);
	if(!Ext.isEmpty(browserData))
		initBrowserdata.browserBlock(browserData);
	contentDownloadInfo.contentDownload(contentData);
	networkInfo.networkInfo(networkData);
	backendInfo.backendInfo(backendData);
	gridBlock.loadGridData(gridData);

	//Events
  /*$('#toggleButton').click(function(){
		var _this = $(this);
		_this.css('z-index',999);
		//$(_this).css({bottom:$('#toogleList').height - 50+"px"});
		if ($toogleList.is(':hidden')) {
					//$('.toogleGrp').css('z-index',99);
					//$('.rumuserIcon').css('z-index',100);
					
				}
		
		$toogleList.slideToggle( "slow", function() {
			if ($toogleList.is(':hidden')) {
					//$('.toogleGrp').css('z-index',999);
					_this.removeClass('rumtogglearrowRotate');
					$(_this).css({bottom:"-4px"});
				}else{
					_this.addClass('rumtogglearrowRotate');
				}
		});
	});*/
	
})(data);