var container="";
Ext.define('ComponentMeasureTabSet.controller.CompareGraph', {
	extend: 'Ext.app.Controller',
	views:['ComponentMeasureTabSet.view.CompareGraph','ComponentMeasureTabSet.view.CompareGraphFilters'],
	stores:['ComponentMeasureTabSet.store.Measures'],
	refs:[{
		ref:'main',
		selector:'main'
	},{
		ref:'compareGraph',
		selector:'compgraph'
	},{
		ref:'compareGraphFilters',
		selector:'comparegraphfilters'
	},{
		ref:'measuresValue',
		selector:'comparegraphfilters panel combo[itemId=measurelist]'
	},{
		ref:'timelineValue',
		selector:'compgraph panel slider[action=timelinechange]'
	},{
		ref:'startHourValue',
			selector:'compgraph panel combo[itemId=starthr]'
		},{
			ref:'endHourValue',
			selector:'compgraph panel combo[itemId=endhr]'
		},{
			ref:'startTimeValue',
			selector:'compgraph panel datefield[itemId=FromDate]'
		},{
			ref:'endTimeValue',
			selector:'compgraph panel datefield[itemId=todate]'
		},{
			ref:'compareGraphButton',
			selector:'compgraph panel button[action=graphbtn]'
		}
	],
	graphMode:"3D",	
	init: function() {
		this.control({
			'comparegraphfilters':{
				render: function(){					
					this.enableHourCombos();					
				}
			},
			//'compgraph panel toolbar image[action=graphFilters]':{
			'image[action=compgraphFilters]':{
				click: function(image){
					this.compareFilter();
				},
				mouseover:this.displayToolTip
			},
			'compgraph panel slider[action=timelinechange]':{
				changecomplete: function(slider, newValue, thumb, eOpts){
					this.compareFilter();
					this.enableHourCombos();
					this.submitFilters(true);			
					var tabBar = Ext.getCmp('tabToolBar');
					if(!Ext.isEmpty(tabBar))
						tabBar.removeAll();
					var toolbar = this.getCompareGraph().tabToolBar;
					if(newValue > 16)
					{
						for(var i=0;i<toolbar.items.length-1;i++)
						{
							if(toolbar.items[i].hidden==true)
							{
								toolbar.items[i].hidden=false;
							}
							//else
								//toolbar.items[i].hidden=true;
						}
					}
					else
					{
						for(var i=0;i<toolbar.items.length-1;i++)
						{
							if(i == 2)
								toolbar.items[i].hidden=true;
						}
					}
					var tbar = this.getMain().tabBar;
					tbar.addTool([{xtype: "tbfill"},toolbar]);
				},
				afterrender: function(){
					this.enableHourCombos();		
				}
			},
			'compgraph panel button[action=graphbtn]':{
				click: function(){
					this.submitFilters(true);
				}
			},
			'comparegraphfilters toolbar button[action=closewindow]':{
				click: function(){
					//this.getCompareGraphFilters().close();
					this.getCompareGraphFilters().up('container').hide();
				}
			},
			//'compgraph panel toolbar image[action=save]':{
			'image[action=compsave]':{
				click: function(){
					var saveURL = this.getCompareGraph().saveURL;
					if(saveURL!=null)
						window.location.href=saveURL+"&from=save";
				},
				mouseover:this.displayToolTip
			},
			//'compgraph panel label[action=mode]':{
			'label[action=compmode]':{
				click: function(label) {
					this.graphMode=label.ttext;
					this.submitFilters(true);
					var tabBar = Ext.getCmp('tabToolBar');
					if(!Ext.isEmpty(tabBar))
						tabBar.removeAll();
					var toolbar = this.getCompareGraph().tabToolBar;
					if(toolbar.items[0].ttext=='2D')
						toolbar.items[0].ttext = '3D';
					else
						toolbar.items[0].ttext = '2D';
					var tbar = this.getMain().tabBar;
					tbar.addTool([{xtype: "tbfill"},toolbar]);
				},
				mouseover:this.displayToolTip
			},
			'comparegraphfilters toolbar button[action=data]':{
				click: function(){
					this.submitFilters(true);
					var measurement=this.getMeasuresValue().getValue();
					var url= this.getCompareGraph().dataURL;
					url = url.replace(/(measurement=)[^\&]+/, '$1' + measurement);
					url=url.substring(url.indexOf("?")+1);
					if(url!=-1){
							window.openWindow("aggDataComparison.jsp?" + url,"wname,width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
					}
					//this.getCompareGraphFilters().close();
					if( !Ext.isEmpty(this.getCompareGraphFilters()))
					this.getCompareGraphFilters().up('container').hide();
				}
			},
			//'compgraph panel toolbar image[action=print]':{
			'image[action=compprint]':{
				click: function(){	
					var url= requestParams.activeTabUrl;
					url=url.substring(url.indexOf("?")+1,url.indexOf("&tabSetPage=true"));				
					url=this.appendToURL(url);
					//var url = this.getCompareGraph().saveURL;
					if(url!=-1)
					{
						window.openWindow("EgPrintGraph.jsp?"+ encodeURI(url+"&graph_type=aggregategraph","PrintWindow","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable"));
					}
					if(!Ext.isEmpty(this.getCompareGraphFilters()))
					{
						//this.getCompareGraphFilters().close();
						this.getCompareGraphFilters().up('container').hide();
					}
				},
				mouseover:this.displayToolTip
			},
			'comparegraphfilters toolbar button[action=graph]':{
				click: function(){
					this.submitFilters(true);	
				}
			}
		});
	},
	compareFilter:function(){
		var VWidth = Ext.Element.getViewportWidth( );
					if(!this.getCompareGraphFilters()){
						var win=Ext.create('ComponentMeasureTabSet.view.CompareGraphFilters');
						win.createItems(this.getCompareGraph().data);
						win.show();
						container = Ext.create('Ext.container.Container',{
						padding:5,
						floating:true,
						frame:true,
						width:500,
						hidden:true,
						//height:500,
						floatable:true,
						//id:'configMod',
						cls:'configMode_popup',
						items:[
							{
								xtype:'container',
								cls:'configMode_popupArrow',
								style:{'top':'-13px','left':'468px'}
							},
							{
								xtype:'container',
								html:'<div style="float:left;margin:0px 0px 0px 4px;color: #f7f7f7;" class="settingsfont"><b>SETTINGS</b></div><div style="text-align:right;float:right;"><div class="iconClose3"></div></div>',
								style:{'top':'0px','margin':'2px'}
							},
							
								
							win
								
							
						]
						});
					
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -515,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth -515
									}
								});
						
						
						container.showAt(VWidth -515,5000);
						Ext.select('.iconClose3').on('click',function(){
							
								Ext.create('Ext.fx.Anim', {
									
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -515,
										top:50
									},
									to: {
									   top:-500,
										left: VWidth -515
									},
									callback: function(){
										container.hide();
										
									   }
								});
							
						},this);
					}
					else if(container.isHidden()){
						var win=this.getCompareGraphFilters();
						win.show();
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -515,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth -515
									}
								});
						
						
						container.showAt(VWidth -515,5000);
						//win.setPosition(this.getMain().getWidth() - win.getWidth(),image.y+40);
						//win.setPosition(image.x+20-win.getWidth(),image.y+60);
					}
					else{
						container.hide();
						//this.getCompareGraphFilters().hide();
					}
	},
	enableHourCombos: function(){
		var tLine=this.getCompareGraph().timelineData.items[this.getTimelineValue().getValue()].value;
		if(!Ext.isEmpty(this.getCompareGraphFilters())){
			if(tLine==="Any"){
				this.getStartHourValue().enable();
				this.getEndHourValue().enable();
				this.getStartTimeValue().enable();
				this.getEndTimeValue().enable();
			}else{
				this.getStartHourValue().disable();
				this.getEndHourValue().disable();
				this.getStartTimeValue().disable();
				this.getEndTimeValue().disable();
			}
		}	
	},

	submitFilters: function(graphBtnClicked){
		var url= requestParams.activeTabUrl;
		url=this.appendToURL(url);
		if(url!=-1){
			var wholeViewport = document.getElementsByTagName("body")[0];
	    	if(!Ext.isEmpty(Ext.get(wholeViewport))){
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				mask.show();
			}
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				success : function(response, opts){				
					var jsonText = response.responseText;
					var jsonData;
					if(!Ext.isEmpty(jsonText))
					 jsonData = Ext.decode(jsonText);
					this.getCompareGraph().removeAll();
					this.getCompareGraph().createTabUI(jsonData);
					if(graphBtnClicked===true){
						//this.getCompareGraphFilters().close();
						this.getCompareGraphFilters().up('container').hide();
					}									
				},
				failure : function(){alert("failure");}
			});
		}		
	},
	appendToURL: function(url){		
		var tLine=this.getCompareGraph().timelineData.items[this.getTimelineValue().getValue()].value;
		url+='&time='+tLine;
		
		if(Ext.isEmpty(this.getCompareGraphFilters())){
			var win=Ext.create('ComponentMeasureTabSet.view.CompareGraphFilters');
			win.createItems(this.getCompareGraph().data);
		}
		var measure=this.getMeasuresValue().getValue();
		if(measure==""){
			Ext.Msg.alert("Error",this.getCompareGraph().data.MeasureErrormsg);
			return -1;
		}
		url = url.replace(/(measure=)[^\&]+/, '$1' + measure);

		var starttime=Ext.Date.format(this.getStartTimeValue().getValue(),'m/d/Y');
		var endtime=Ext.Date.format(this.getEndTimeValue().getValue(),'m/d/Y');
		var currTime=Ext.Date.format(new Date(),'m/d/Y');
		var starttimeDummy=Ext.Date.parse(this.getStartTimeValue().getValue(),'m/d/Y');
		var endtimeDummy=Ext.Date.parse(this.getEndTimeValue().getValue(),'m/d/Y');
		var currTimeDummy=new Date();
		
		
		/*if(starttime > currTime || endtime > currTime){
			if(starttimeDummy > currTimeDummy || endtimeDummy > currTimeDummy){
				Ext.Msg.alert("Error",this.getCompareGraph().data.CurrentDateError);
				return -1;
			}
		}
		else if(starttime > endtime){	
			Ext.Msg.alert("Error",this.getCompareGraph().data.DateErrormsg);
			return -1;
		}
		else if(starttime === endtime){
			if(this.getStartHourValue().getValue() >= this.getEndHourValue().getValue()){
				Ext.Msg.alert("Error",this.getCompareGraph().data.DateErrormsg);
				return -1;
			}
		}*/

		var shr =parseInt(this.getStartHourValue().getValue());
		var ehr = parseInt(this.getEndHourValue().getValue());

		if(tLine == 'Any' && dateValidation(starttime,endtime,shr,ehr,0,0)==-1)
		{
			Ext.Msg.alert("Error",this.getCompareGraph().data.DateErrormsg);
			return -1;
		}

		url+='&starttime='+starttime+'&endtime='+endtime;
		url+='&starthr='+this.getStartHourValue().getValue()+'&endhr='+this.getEndHourValue().getValue();

		//if(!Ext.isEmpty(this.getDescriptionValue())){
			//url = url.replace(/(info=)[^\&]+/, '$1' + this.getDescriptionValue().getValue());
		//}			
		url = url.replace(/(gtype=)[^\&]+/, '$1' + this.getCompareGraph().data.HiddenFields.gtype);		
		url = url+"&mode="+this.graphMode;
		
		return url;
	},
	
	displayToolTip:function(image){
		if(!Ext.isEmpty(this.getCompareGraph().toolTip)){
			var tip = this.getCompareGraph().toolTip;
			tip.setTarget(image.id);
			tip.update(image.tooltip);
			tip.show();
		}
	}
});