var pageNumber = 1;
Ext.define('ComponentMeasureTabSet.controller.DetailedDiagnosisAnalysis',{
	extend : 'Ext.app.Controller',
	refs : [{
		ref : 'timelineCombo',
		selector : 'detailediagnosisanalysis combo[itemId= "timeline"]'
	},{
		ref : 'detailedDiagnosisAnalysisPanel',
		selector : 'detailediagnosisanalysis'
	},{
		ref : 'timeline',
		selector : 'detailediagnosis combo[itemId= "timeline"]'
	},{
		ref : 'testListCombo',
		selector : 'detailediagnosis combo[itemId= "testList"]'
	},{
		ref : 'componenetCombo',
		selector : 'detailediagnosis combo[itemId= "compList"]'
	},{
		ref : 'measureHostListCombo',
		selector : 'detailediagnosis combo[itemId= "measureHostList"]'
	},{
		ref : 'sortByCombo',
		selector : 'detailediagnosis combo[itemId= "sortby"]'
	},{
		ref : 'measurementCombo',
		selector : 'detailediagnosis combo[itemId= "measurelist"]'
	}],
	
	init : function(){
		this.control({
				'detailediagnosisanalysis combo[itemId= "timeline"]' : {
					select : this.showDDAnalysis
				}
		});
	},
	//mask:null,
	
	getAllFieldValues : function(){
		var jsonData = this.getDetailedDiagnosisAnalysisPanel().jsonData;
		var filtersObject = new Object();
		var infoVal = jsonData.hiddenFields.selectedInfoValue;
		if(infoVal != null && infoVal != 'undefined' )
		{
			do
			{
				infoVal=infoVal.replace('+','|plus|');
			}
			while (infoVal.indexOf("+")>-1);
			do
			{
				infoVal=infoVal.replace('&','|amp|');
			}
			while (infoVal.indexOf("&")>-1);

			do
			{
				infoVal=infoVal.replace('%','|pct|');
			}
			while (infoVal.indexOf("%")>-1);

			do
			{
				infoVal=infoVal.replace('#','|hash|');
			}
			while (infoVal.indexOf("#")>-1);

			do
			{
				infoVal=infoVal.replace('\u00AE','|rights|');
			}
			while (infoVal.indexOf("\u00AE")>-1);

			do
			{
				infoVal=infoVal.replace('$','|dollar|');
			}
			while (infoVal.indexOf("$")>-1);
		}

		filtersObject.description = infoVal;
		filtersObject.measurement = jsonData.hiddenFields.selectedMeasureValue;
		filtersObject.measurementText = jsonData.hiddenFields.selectedMeasureValue;
		filtersObject.fromDate =  jsonData.hiddenFields.s_st_time;
		filtersObject.fromHr = jsonData.hiddenFields.s_st_hr;
		filtersObject.fromMin = jsonData.hiddenFields.s_st_min;
		filtersObject.toDate = jsonData.hiddenFields.s_en_time;
		filtersObject.toHr = jsonData.hiddenFields.s_en_hr;
		filtersObject.toMin= jsonData.hiddenFields.s_end_min;
		filtersObject.timeline =this.getTimeline().getValue();
		filtersObject.selectfilter = this.getTimelineCombo().getValue();
		filtersObject.sortby = this.getSortByCombo().getValue(); 
		return filtersObject;
	},
	//KNRaju on 25.11.14
	showDDAnalysis : function(pageNo,msg,maxNo){

		if(Ext.isEmpty(msg))
			msg="newReq";

		var jsonData = this.getDetailedDiagnosisAnalysisPanel().jsonData;
		var paginationText = jsonData.sbPagination;
		
		if( ! isNaN(pageNo))
			pageNumber = pageNo;
		else if(paginationText != null && paginationText != 'undefined' && paginationText != '' ){
			pageNumber = paginationText.substring(paginationText.indexOf("value=")+7);
			pageNumber = pageNumber.substring(0,pageNumber.indexOf('"'));
		}
		
		var filtersObject = this.getAllFieldValues();

		if(!Ext.isEmpty(filtersObject)){
			var CompType="";
			var testName = this.getTestListCombo().getValue();
			var componenet =this.getComponenetCombo().getValue();
			if(componenet!=null && componenet!=undefined )
			{
				CompType=componenet.substring(0,componenet.indexOf(":"));
			}
			if(componenet!=null && componenet!=undefined )
			{
				componenet=componenet.substring(componenet.indexOf(":")+1);
			}
			var measurementHost = this.getMeasureHostListCombo().getValue();
			var info = filtersObject.description;
			var mesObj = filtersObject.measurement;
			var dignosisLink = ddLink;
		
			var jspFile = dignosisLink.substring(0,dignosisLink.indexOf("?"));

			var reqPrams = '';
			if(dignosisLink.indexOf('&timeline') != -1)
				reqPrams = dignosisLink.substring(dignosisLink.indexOf("?")+1,dignosisLink.indexOf('&timeline'));
			else
				reqPrams = dignosisLink.substring(dignosisLink.indexOf("?")+1);

			var host = '',portwithSid='';
			try
			{
				host = componenet.substring(0,componenet.indexOf(":"));
				portwithSid = componenet.substring(componenet.indexOf(":")+1);
			}
			catch (e)
			{
				host = '';
				portwithSid='';
			}
			
			var port = '';
			if(portwithSid.indexOf(":") != -1)
			{
				port = portwithSid.substring(0,portwithSid.indexOf(":"));
				var sidInfo = portwithSid.substring(portwithSid.indexOf(":")+1);
				if(info == null || info == undefined || info == 'undefined' ){
					info = sidInfo+"*";
					filtersObject.description = sidInfo+"*";
				}
			}
			else	
				port = portwithSid;
			var dignosisLinkTemp1 = '?site='+siteName+'&host='+host+'&port='+port+'&test='+testName+'&info='+encodeURIComponent(info)+'&msmt_host='+measurementHost;
			var dignosisLinkTemp2 = dignosisLink.substring(dignosisLink.indexOf("&from="),dignosisLink.indexOf("&measure"));
			var dignosisLinkTemp3 = '&measure='+mesObj;
			var dignosisLinkTemp4 = dignosisLink.substring(dignosisLink.indexOf("&flag"),dignosisLink.indexOf("&comptype=")+10);
			var reqArr = reqPrams.split('&');
			var reorderArr = new Array();
			var hostFlag = false;
			for(var a=0;a<reqArr.length;a++){
				var params = reqArr[a];
				if(params.indexOf('site=') != -1)
					reorderArr.push('site='+encodeURI(siteName));
				else if(params.indexOf('host=') != -1)
				{	
					if(!hostFlag)
					{
						reorderArr.push('host='+encodeURI(host));
						hostFlag = true;
					}else
						reorderArr.push('msmt_host='+encodeURI(measurementHost));
				}
				else if(params.indexOf('port=') != -1)
					reorderArr.push('port='+port);
				else if(params.indexOf('test=') != -1)
					reorderArr.push('test='+testName);
				else if(params.indexOf('comptype=') != -1)
				{
					//reorderArr.push('comptype=NONE');
					reorderArr.push('comptype='+CompType);
				}
				else if(params.indexOf('info=') != -1)
					reorderArr.push('info='+encodeURI(info));
				else if(params.indexOf('msmt_host=') != -1)
					reorderArr.push('msmt_host='+encodeURI(measurementHost));
				else if(params.indexOf('measure=') != -1)
					reorderArr.push('measure='+mesObj);
				else
					reorderArr.push(params);
			}
			
			var afterReqString = '';
			for(var a=0;a<reorderArr.length;a++){
				afterReqString += reorderArr[a]+'&';
			}

			//dignosisLink = jspFile+dignosisLinkTemp1+dignosisLinkTemp2+dignosisLinkTemp3+dignosisLinkTemp4+'NONE';
			dignosisLink = jspFile+'?'+afterReqString;


		//	dignosisLink = jspFile+dignosisLinkTemp1+dignosisLinkTemp2+dignosisLinkTemp3+dignosisLinkTemp4+'NONE';

			if(dignosisLink.indexOf("timeline")!=-1){
				dignosisLink = dignosisLink.substring(0,(dignosisLink.indexOf("timeline")-1));
			}
			if(dignosisLink.indexOf("$")!=-1){
			var rem = dignosisLink.substring(dignosisLink.indexOf("$")+1);
			dignosisLink=dignosisLink+rem;	
			}
			if(dignosisLink.indexOf("&comptype=") == -1)
			{
				if(CompType!=null && CompType!=undefined && CompType!="")
				{
					dignosisLink = dignosisLink+"&comptype="+CompType;
				}
				else
				{
					dignosisLink = dignosisLink+"&comptype=NONE";
				}
			}
			
			var tempAddLink = ddLink.substring(ddLink.indexOf('&host'),ddLink.indexOf('&starttime'));
			var url = "";
			//&hqstring="+jsonData.hiddenFields.hqstring+tempAddLink+"
			url = dignosisLink+"&starttime="+filtersObject.fromDate+"&endtime="+filtersObject.toDate+"&starthr="+filtersObject.fromHr+"&endhr="+
			filtersObject.toHr+"&startmin="+filtersObject.fromMin+"&endmin="+filtersObject.toMin+"&from=0&fromPage=layMod&"+
			"newWindow=true&comeFrom="+jsonData.hiddenFields.comeFrom+"&isVM="+jsonData.hiddenFields.isVM+"&source="+jsonData.hiddenFields.source+"&clicked=dd&timeline="+filtersObject.timeline+"&pageNo="+pageNumber+"&sortBy="+filtersObject.sortby;
			//url = url.replace(/(measure=)[^\&]+/, '$1' + filtersObject.measurement);
			//url = url.replace(/(info=)[^\&]+/, '$1' + filtersObject.description);
			url = url+"&selectfilter="+filtersObject.selectfilter;
			url = url+"&fromAnalysisDD=analysisDD&reqType="+encodeURI(msg)+"&totalRecords="+totalRecords;
			var urlForCountRec = url+"&isCountRecords=Yes&reqType="+encodeURI(msg);

			Ext.Ajax.request({
			url : url,
			scope : this,
			success : function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				this.getDetailedDiagnosisAnalysisPanel().removeAll();
				this.getDetailedDiagnosisAnalysisPanel().createTabUI(jsonData);
				
				var sbPagination=jsonData.sbPagination;
				if(Ext.isEmpty(sbPagination))
				{
					 Ext.ComponentQuery.query('#tableViewAnalysisFoot')[0].hide();					// Ext.getCmp('tableViewFoot').hide();
				}

				if(msg!="fromPagination")
				{
					Ext.Ajax.request({
					url : urlForCountRec,
					timeout: 180000,
					scope : this,
					success : function(response){
						 var jsonText = response.responseText;				 
						 if(jsonText.indexOf('@') != -1)
							 jsonText = jsonText.substring(0,jsonText.indexOf('@'));
						 totalRecords = parseInt(jsonText.trim());				
						 var c=document.getElementById("totalPages");
						 if(c!=null && c!="" && c!="undefined")
						 {
							 var totRec = parseInt(jsonText.trim());
							 if(totRec < 2)
							 {
							  var nxt = document.getElementById("next");
							  if(nxt!=null && nxt!="undefined")
								nxt.style.visibility="hidden";
							  var lst = document.getElementById("last");
							  if(lst!=null && lst!="undefined")	
								lst.style.visibility="hidden";
							 }
							else
							{
								var nxt = document.getElementById("next");
								if(nxt!=null && nxt!="undefined")
									nxt.style.visibility="visible";
								var lst = document.getElementById("last");
								if(lst!=null && lst!="undefined")	
									lst.style.visibility="visible";
							}
							c.innerHTML=" of "+jsonText;
						 }
							
					
					}
					});
				}
				else if(msg == "fromPagination")
				{
					if(pageNo == maxNo)
					{
						var nxt = document.getElementById("next");
						if(nxt!=null && nxt!="undefined")
							nxt.style.visibility="hidden";
						var lst = document.getElementById("last");
						if(lst!=null && lst!="undefined")	
							lst.style.visibility="hidden";
					}
				}
			}
		});
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();
		}
	 }
	}

});