Ext.define('ComponentMeasureTabSet.controller.FixHistory', {
	extend : 'Ext.app.Controller',
	views : ['ComponentMeasureTabSet.view.FixHistory'],
	refs : [{
				ref : 'fixhistory',
				selector : 'fixhistory'
			}, {
				ref : 'checks',
				selector : 'fixhistory > panel[itemId=upperheader] > checkbox'
			}, {
				ref : 'descriptor',
				selector : 'fixhistory > panel[itemId=upperheader] > panel[itemId=combopanel] > combo[itemId=description]'
			}, {
				ref : 'component',
				selector : 'fixhistory > panel[itemId=upperheader] > panel[itemId=combopanel] > combo[itemId=component]'
			}

	],
	init : function() {
		this.control({

			//'fixhistory > panel[itemId=selected] > panel > toolbar > button[action=delete]' : {
			'fixhistory button[action=delete]' : {
				click : this.deleteFromSelected
			},
			'fixhistory > panel[itemId=upperheader] > button[action=submit]' : {
				click : this.submitHistory
			},
			'fixhistory > panel[itemId=upperheader] > panel[itemId=combopanel] > combo[itemId=component]' : {
				select : this.component_onChange
			}
		});
	},
	deleteFromSelected : function(button) {
		var selectedPanelForAttributes = button.findParentByType('toolbar')
				.findParentByType('panel').findParentByType('panel');
		var str = button.deleteUrl;
		var thisForm = selectedPanelForAttributes;
		if (thisForm != null && thisForm != '' && thisForm != 'undefined') {
			var qryStr = "test=" + thisForm.test;
			qryStr += "&measure=" + thisForm.measure;
			qryStr += "&isVM=" + thisForm.isVM;
			qryStr += "&source=" + thisForm.source;
			if (thisForm.component != null)
				qryStr += "&component=" + encodeURI(thisForm.component);
			else {

				qryStr += "&component=" + encodeURI(thisForm.hid_comp_name);
			}
			qryStr += "&" + str;
			var vm = thisForm.isVM;
			var s_info = "";
			if (vm) {
				var desc = thisForm.descriptor;
				if (desc == "ALL") {
					s_info = thisForm.info;
					if (s_info.indexOf(":") > -1)
						s_info = s_info.substring(0, s_info.indexOf(":"));
				} else {
					s_info = thisForm.descriptor;
				}
			} else {
				s_info = thisForm.descriptor;
			}
			if (s_info != null && s_info != '') {
				s_info = s_info.replace('+', '|plus|');
				s_info = s_info.replace('&', '|amp|');
				s_info = s_info.replace('%', '|pct|');
				s_info = s_info.replace('#', '|hash|');
				try
				{
					s_info = window.opener.filterEncode(s_info);
				}
				catch (e)
				{
					try{
						s_info = parent.filterEncode(s_info);
					}
					catch(ee)
					{
						s_info = parent.parent.filterEncode(s_info);
					}
				}
			}
			qryStr += "&info=" + encodeURI(s_info);

			allCompschecked = this.getChecks().getValue();
			if (allCompschecked != null)
				qryStr += "&allComponents=" + allCompschecked;
				var tempFixedHistory = this.getFixhistory();
			Ext.MessageBox.confirm('Confirm', 'Do you want to delete History?',
					function(btn) {
						if(btn=='yes')
						{
							Ext.Ajax.request({
								url : "/final/monitor/Egfixdeletep.jsp?" + qryStr,
								method : 'POST',
								scope : this,
								success : function(response, opts) {
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);

									Ext.Ajax.request({
												url : jsonData.url,
												method : 'POST',
												scope : this,
												success : function(response, opts) {
													var jsonText =null;
													jsonText = response.responseText;
													var jsonData = null;
													jsonData = Ext.decode(jsonText);
													Ext.suspendLayouts();
													tempFixedHistory.createTabUI(jsonData);
													Ext.resumeLayouts(true);
													//tempFixedHistory.doLayout();
												},
												failure : function() {
													alert("failure");
												}
											});

								},
								failure : function() {
									alert("failure");
								}
							});
					}
			});

		}
	},
	submitHistory : function() {
		var selectedPanelForAttributes = this.getFixhistory()
				.down('panel[itemId=selected]');
		var thisForm = selectedPanelForAttributes;
		if (thisForm != null && thisForm != '' && thisForm != 'undefined') {
			var qryStr = "&test=" + thisForm.test;
			qryStr += "&measure=" + thisForm.measure;
			qryStr += "&isVM=" + thisForm.isVM;
			qryStr += "&source=" + thisForm.source;
			if (thisForm.component != null)
				qryStr += "&component=" + encodeURI(thisForm.component);
			else {
				//qryStr += "&site=" + encodeURI(thisForm.site);
				qryStr += "&component=" + encodeURI(thisForm.hid_comp_name);
			}
			var vm = thisForm.isVM;
			var s_info = "";
			if (vm) {
				var desc = this.getDescriptor().getValue();//thisForm.descriptor;
				if (desc == "ALL") {
					s_info = thisForm.info;
					if (s_info.indexOf(":") > -1)
						s_info = s_info.substring(0, s_info.indexOf(":"));
					qryStr += "&vmDesc=ALL";
				} else {
					s_info = this.getDescriptor().getValue();//thisForm.descriptor;
				}
			} else {
				if(!Ext.isEmpty(this.getDescriptor()))
					s_info = this.getDescriptor().getValue();//thisForm.descriptor;
			}
			if (s_info != null && s_info != '') {
				s_info = s_info.replace('+', '|plus|');
				s_info = s_info.replace('&', '|amp|');
				s_info = s_info.replace('%', '|pct|');
				s_info = s_info.replace('#', '|hash|');
			}
			qryStr += "&info=" + encodeURI(s_info);
			allCompschecked = this.getChecks().getValue();
			if (allCompschecked != null)
				qryStr += "&allComponents=" + allCompschecked;
			Ext.Ajax.request({
						url : "/final/monitor/dispComponentHistory.jsp?"
								+ qryStr,
						method : 'POST',
						scope : this,
						success : function(response, opts) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							this.getFixhistory().createTabUI(jsonData);
						},
						failure : function() {
							alert("failure");
						}
					});
		}
	},
	component_onChange : function() 
	{
		var selectedPanelForAttributes = this.getFixhistory()
				.down('panel[itemId=selected]');
		var thisForm = selectedPanelForAttributes;

		if (thisForm != null && thisForm != '' && thisForm != 'undefined')
		{
			var info = "";
			if(!Ext.isEmpty(thisForm.info))
			 info = ( thisForm.info != "+" )?"ALL":thisForm.info.trim();
			var qryStr = "&test=" + thisForm.test;
			qryStr += "&measure=" + thisForm.measure;
			if (this.getComponent().getValue() != null)
			{
				qryStr += "&component="
						+ encodeURI(this.getComponent().getValue());
			}
			else 
			{
				qryStr += "&component=" + encodeURI(thisForm.hid_comp_name);
			}
			qryStr += "&info=" + info;
			allCompschecked = this.getChecks().getValue();
			if (allCompschecked != null)
				qryStr += "&allComponents=" + allCompschecked;

			Ext.Ajax.request({
						url : "/final/monitor/dispComponentHistory.jsp?"
								+ qryStr,
						method : 'POST',
						scope : this,
						success : function(response, opts) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							this.getFixhistory().createTabUI(jsonData);
						},
						failure : function() {
							alert("failure");
						}
					});
			
		}
	}
});