Ext.define('ComponentMeasureTabSet.controller.ProcessDetails',{
	extend:'Ext.app.Controller',
	requires:['ComponentMeasureTabSet.view.ProcessDetails'],
	views:['ProcessDetails'],
	refs : [{
				ref : 'descriptionCombo',
				selector : 'detailediagnosis combo[itemId= "infolist"]'
			},{
				ref : 'measurementCombo',
				selector : 'detailediagnosis combo[itemId= "measurelist"]'
			},{
				ref : 'timelineCombo',
				selector : 'detailediagnosis combo[itemId= "timeline"]'
			},{
				ref : 'fromHrCombo',
				selector : 'detailediagnosis combo[itemId= "fromHr"]'
			},{
				ref : 'fromMinCombo',
				selector : 'detailediagnosis combo[itemId= "fromMin"]'
			},{
				ref : 'toHrCombo',
				selector : 'detailediagnosis combo[itemId= "toHr"]'
			},{
				ref : 'toMinCombo',
				selector : 'detailediagnosis combo[itemId= "toMin"]'
			},{
				ref : 'fromDate',
				selector : 'detailediagnosis datefield[itemId= "fromdate"]'
			},{
				ref : 'toDate',
				selector : 'detailediagnosis datefield[itemId= "todate"]'
			},{
				ref : 'detailedDiagnosisPanel',
				selector : 'detailediagnosis'
			},{
				ref:'threaddetails',
				selector:'threaddetails'
			},{
				ref : 'detailedDiagnosisPanel',
				selector : 'detailediagnosis'
			},{
				ref : 'threadName',
				selector : 'threaddetails multiselect'
			}
	],
	init:function()
	{
		this.control({
			'processdetails':{
				'boxready': this.loadform
			},
			'processdetails combo[id=time]':{
				'select':this.timeOnChange
			},
			'processdetails combo[id=measure]':{
				'select':this.measureOnChange
			},
			'processdetails combo[id=sortByOrder]':{
				'select':this.sortOnChange
			},
			'processdetails #processname':{
				'change':this.processOnChange
			},
		});
	},
	timeOnChange:function(obj)
	{
		this.loadform(obj);
	},
	measureOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnChange:function(obj)
	{
		this.loadform(obj);
	},
	processOnChange:function(obj)
	{
		this.loadFormForProcessName(obj);
	},
	loadFormForProcessName:function(obj)
	{
		var resultPanel = Ext.getCmp("processResulPanel");
		if(resultPanel.isotherUpdateRunning)
			return;

		var measureTime = Ext.getCmp('time').value;
		var test = Ext.getCmp("test").getValue();
		var meas = Ext.getCmp("measure").value;
		var selectedvalue = Ext.getCmp('processname').getValue();
		params="time="+encodeURIComponent(measureTime)+"&details="+encodeURIComponent(selectedvalue)+"&measure="+encodeURIComponent(meas)+"&test="+encodeURIComponent(test);

			Ext.Ajax.request({
				url : '/final/monitor/sqlProcess.jsp',
				params : params,
				method:'POST',
				async: false,
				success : function(response) {
					var resultData = Ext.decode(response.responseText);
					resultPanel.update(resultData.tableData);
				}
			});
	},
	rebuildUrl:function(URLForSql){
		var re_url="";
		var temp_Sortby="";
		try
		{
			var fsplit = URLForSql.split('?');
			re_url +=fsplit[0]+"?";
			var paramSplit = fsplit[1].split('&');
			var urlParams='';
			var sortValue='';
			for(var a in paramSplit)
			{
				var params = paramSplit[a];
				try
				{
					params = params.trim()
					if(!Ext.isEmpty(params))
					{
						var pramVal = params.split('=');
						var key = pramVal[0];
						var value = pramVal[1];
						if(key =='sortby')
							temp_Sortby=value;
						if(key !='s_measure' && key !='sortby')
						{
							urlParams+="&"+key+"="+value;
						}
						if(key=='s_measure')
						{
							value = Ext.getCmp('measure').getValue();
							//value = value.replace(" ", "_");
							value = value.replace(/ /g, '_');
							urlParams+="&"+key+"="+value;
						}				
					}
				}
				catch (e)
				{
					//console.log("e=-=-=->>",e)
					continue;
				}				
			}
			if(urlParams.indexOf('sortby') == -1)
			{
				var value = Ext.getCmp('sortByOrder').getValue();
				//if(value == 'Spid')
					//sortValue ="1";
				//else if(value == 'DB')
					//sortValue ="2";
				//else if(value == 'Host/IP ADDRESS')
					//sortValue ="3";
				//else if(value == 'Program name')
					//sortValue ="4";
				//else if(value == 'Login Time')
					//sortValue ="5";
				//else if(value == 'Last Execution Time')
					//sortValue ="6";
				//else if(value == 'Waittime(msecs)')
					//sortValue ="7";
				//else if(value == 'Waittype')
					//sortValue ="8";
				//else if(value == 'Spid(blocking)')
					//sortValue ="9";
				//else if(value == 'Trans nesting level')
					//sortValue ="10";
				//else if(value == 'Physical io')
					//sortValue ="11";
				//else if(value == 'Mem usage(pages)')
					//sortValue ="12";
				//else if(value == 'Idle time(min)')
					//sortValue ="13";
				//else
					//sortValue ="14";
				if(value== null || value==undefined)
					value=temp_Sortby;
				urlParams+="&sortby="+value;
			}
			if(urlParams.indexOf('&') == 0)
				urlParams = urlParams.substring(1);
			re_url +=urlParams;
		}
		catch (e)
		{
			console.log("e=-=-=-=->>",e)
		}
		return re_url;
	},
	loadform:function(obj)
	{
		var url;
		if(obj.xtype == 'processdetails')
			url = URLForSql;
		else
			url =this.rebuildUrl(URLForSql);
		
		var me= this;
		var details = null;
		Ext.getCmp("processResulPanel").isotherUpdateRunning=true;
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			success : function(response, opts){
				var formdata = Ext.decode(response.responseText);
				//console.log(formdata);
				var subformdata =null;
				if(!Ext.isEmpty(formdata))
				{
					var processCombo = Ext.getCmp("processname");
					if(processCombo != undefined && processCombo != 'undefined' && !Ext.isEmpty(processCombo) && !processCombo.isVisible())
					{
						processCombo.show();
					}
					if(!Ext.isEmpty(formdata.errorMsg))
					{
						
						processCombo.getStore().loadRawData([]);
						processCombo.hide();
						var resultPanel = Ext.getCmp("processResulPanel");
						resultPanel.update('<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>');
						return;
					}
					for(var i = 0;i<formdata.data.length;i++)
					{
						var namefromJson=formdata.data[i].name;
						if(!Ext.isEmpty(namefromJson))
						{
							if(namefromJson=='measurementtime')
							{
								var selectedvalue = Ext.getCmp('time').getValue();
								if(Ext.isEmpty(selectedvalue))
									selectedmeasuretime=formdata.data[i].selectedvalue;
								if(selectedmeasuretime==null)
									selectedmeasuretime ='';
								subformdata = formdata.data[0].measuremtime;
								me.setComboOptionsInList('time', subformdata,selectedmeasuretime);
							}
							else if(namefromJson=='measurement')
							{
								var selectedvalue = Ext.getCmp('measure').getValue();
								if(Ext.isEmpty(selectedvalue))
									selectedvalue = formdata.data[i].selectedvalue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[1].measurement;
								me.setComboOptionsInList('measure', subformdata,selectedvalue);
							}
							else if(namefromJson=='sortby')
							{
								var selectedvalue = Ext.getCmp('sortByOrder').getValue();
								if(Ext.isEmpty(selectedvalue))
									selectedvalue = formdata.data[i].selectedValue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[2].sortByOrder;
								me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
							}
							else if(namefromJson=='processname')  
							{
								var processCombo = Ext.getCmp("processname");
								var	selectedvalue = formdata.data[i].selectedValue;
								subformdata = formdata.data[3].processname;
								me.setComboOptionsInList('processname', subformdata,'');
								var tempSelectedValue = [];
								tempSelectedValue.push(selectedvalue);
								processCombo.setValue(tempSelectedValue);
							}
						}
					}
					var resultPanel = Ext.getCmp("processResulPanel");
					var measureTime = Ext.getCmp('time').getValue();
					var meas = Ext.getCmp("measure").getValue();
					var test;
					try
					{
						test = formdata.data[2].test;
					}
					catch (e)
					{
						test = formdata.data.test;
					}
					Ext.getCmp("test").setValue(test);

					var selectedDetailedValue = formdata.firstOptionValue;
					
					params="time="+encodeURIComponent(measureTime)+"&details="+encodeURIComponent(selectedDetailedValue)+"&measure="+encodeURIComponent(meas)+"&test="+encodeURIComponent(test);
					var url='/final/monitor/sqlProcess.jsp';
					Ext.Ajax.request({
						url : url,
						params : params,
						method:'POST',
						async: false,
						success : function(response)
						{
							var resultData = Ext.decode(response.responseText);
							resultPanel.update(resultData.tableData);
						},
						failure:function()
						{
							alert('update failure');
						}
					});
				}
				Ext.getCmp("processResulPanel").isotherUpdateRunning=false;
			},
			failure:function()
			{
				Ext.getCmp("processResulPanel").isotherUpdateRunning=false;
				alert('failure');
			}
		});
	},
	
	setComboOptionsInList : function(fieldName, list, value)
	{
		var field = Ext.getCmp(fieldName);
		field.getStore().loadRawData(list);
		field.suspendEvents(false);
		if(value=='')
		{
			value = field.getStore().getAt(0).get('value');
		}
		field.setValue(value);
		field.resumeEvents();
	},
	getAllFieldValues : function()
	{
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		var filtersObject = new Object();
		if(!Ext.isEmpty(this.getDescriptionCombo()))
		filtersObject.description = this.getDescriptionCombo().getValue();
		filtersObject.measurement = this.getMeasurementCombo().getValue();
		filtersObject.measurementText = this.getMeasurementCombo().getValue();
		filtersObject.timeline = this.getTimelineCombo().getValue(); 
		var fromDate = this.getFromDate().getValue();
		if(!Ext.isEmpty(fromDate)){
			filtersObject.fromDate=Ext.Date.format(fromDate,'m/d/Y');
		  }
		var toDate = this.getToDate().getValue();
		if(!Ext.isEmpty(toDate)){
			filtersObject.toDate=Ext.Date.format(toDate,'m/d/Y');
		  }
		
		  var currentDate = new Date();
		  var currentHrs = currentDate.getHours();
		  var currentMin = currentDate.getMinutes();
		  currentDate = Ext.Date.format(currentDate,'m/d/Y');
		 
		filtersObject.fromHr = this.getFromHrCombo().getValue();
		filtersObject.fromMin = this.getFromMinCombo().getValue();
		filtersObject.toHr = this.getToHrCombo().getValue();
		filtersObject.toMin = this.getToMinCombo().getValue();
		//if(filtersObject.timeline=="Any" && (currentDate < filtersObject.fromDate || currentDate < filtersObject.toDate)){
			//Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  //return;
		//}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				//(currentHrs < filtersObject.fromHr || currentHrs < filtersObject.toHr)){
			//Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  //return;
		//}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				//(currentHrs == filtersObject.fromHr || currentHrs == filtersObject.toHr) && (currentMin < filtersObject.fromMin || currentMin < filtersObject.toMin)){
			//Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  //return;
		//}
		//if(filtersObject.timeline=="Any" && filtersObject.fromDate > filtersObject.toDate){
			  //Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
			  //return;
		//}
		 //if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  //if(filtersObject.fromHr > filtersObject.toHr){
				  //Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  //return;
			  //}
		 //}
		 //if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  //if(filtersObject.fromHr == filtersObject.toHr){
				  //if(filtersObject.fromMin >= filtersObject.toMin){
					 //Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  //return;
				  //}
			  //}
		 //}	  
		return filtersObject;
	},
})