var container="";
Ext.define('ComponentMeasureTabSet.controller.SummaryGraph', {
	extend: 'Ext.app.Controller',
	views:['ComponentMeasureTabSet.view.SummaryGraph','ComponentMeasureTabSet.view.SummaryGraphFilters','ComponentMeasureTabSet.view.Main','ComponentMeasureTabSet.view.TrendGraphFilters','ComponentMeasureTabSet.view.MeasureGraphFilters'],
	refs:[
	{
		ref : 'descriptionCombo',
		selector : 'summarygraphfilters combo[itemId= "infolist"]'
	},{
		ref:'main',
		selector:'main'
	},{
		ref:'summaryGraph',
		selector:'summarygraph'
	},{
		ref:'summaryGraphFilters',
		selector:'summarygraphfilters'
	},{
		ref:'trendGraphFilters',
		selector:'trendgraphfilters'
	},{
		ref:'measureGraphFilters',
		selector:'measuregraphfilters'
	},
	{
		ref:'graphDuration',
		selector:'summarygraphfilters panel combo[action=period]'
	},
	{
		ref:'graphStartHour',
		selector:'summarygraph panel combo[action=starthr]'
	},
	{
		ref:'graphEndHour',
		selector:'summarygraph panel combo[action=endhr]'
	},
	{
		ref:'graphStartDate',
		selector:'summarygraph panel datefield[action=fromdate]'
	},
	{
		ref:'graphEndDate',
		selector:'summarygraph panel datefield[action=todate]'
	},
	{
		ref:'measureForGraph',
		selector:'summarygraphfilters panel combo[action=measurelist]'
	},
	{
		ref:'disForGraph',
		selector:'summarygraphfilters panel combo[action=infolist]'
	},
	{
		ref:'graphTimeline',
		selector:'summarygraph panel slider'
	},{
		ref:'summaryGraphButton',
		selector:'summarygraph panel button[action=graph]'
	},{
		ref : 'infolistCombo',
		selector : 'summarygraphfilters combo[itemId= "infolist"]'
	}
	],
	mode:'3D',
	init: function() {
		this.control({
			'summarygraphfilters':{
				render: function(){
					/*if(this.getGraphTimeline()!=undefined){
						var tLine=this.getSummaryGraph().timelineData.items[this.getGraphTimeline().getValue()].value;
						if(tLine!=null && tLine=="Any"){
							this.getGraphStartHour().enable();
							this.getGraphEndHour().enable();
							this.getGraphStartDate().enable();
							this.getGraphEndDate().enable();
						}
					}*/
				}
			},
			'summarygraphfilters toolbar button[action=closewindow]':{
				click: function(){
					this.getSummaryGraphFilters().close();
				}
			},
			'summarygraph panel slider[action=timelinechange]':{
				changecomplete: function(slider, newValue, thumb, eOpts){
					var tLine=this.getSummaryGraph().timelineData.items[this.getGraphTimeline().getValue()].value;
					//this.summaryFilter();
					if(!Ext.isEmpty(this.getSummaryGraph())){
						if(tLine=="Any"){
							this.getGraphStartHour().enable();
							this.getGraphEndHour().enable();
							this.getGraphStartDate().enable();
							this.getGraphEndDate().enable();
						}else{
							this.getGraphStartHour().disable();
							this.getGraphEndHour().disable();
							this.getGraphStartDate().disable();
							this.getGraphEndDate().disable();
						}
					}
					this.valueadd(true, 'timelinechange');
				}
			},
			//'summarygraph panel toolbar image[action=graphFilters]':{
			'image[action=graphFilters]':{
				click: function(image){
					this.summaryFilter();
				},
				mouseover:this.displayTooltip

			},
			'summarygraph panel toolbar label[action=mode]':{
				click: function(label) {
					
					this.mode=label.text;
					this.valueadd(true , 'mode');				
				},
				mouseover:this.displayTooltip
			},
			'label[action=summode]':{
				click: function(label) {
					this.mode=label.ttext;
					this.valueadd(true, 'sumode');
					var tabBar = Ext.getCmp('tabToolBar');
					if(!Ext.isEmpty(tabBar))
					{
						tabBar.removeAll();
					}
					var toolbar = this.getSummaryGraph().tabToolBar;

					if(toolbar.items[0].ttext=='2D')
						toolbar.items[0].ttext = '3D';
					else
						toolbar.items[0].ttext = '2D';

					var tbar = this.getMain().tabBar;
					tbar.addTool([{xtype: "tbfill"},toolbar]);
				}
			},
			'summarygraphfilters panel combo[action=period]':{
				select: function(){
					this.valueadd(true, 'period');
				}
			},
			'summarygraphfilters trigger[name="descriptionOpt"]':
			{
				'keyup': this.descriptorOptSelect
			},
			'summarygraphfilters toolbar button[action=graph]':{
				click: function(){
					this.valueadd(true, 'graph');
				}
			
			},
			'summarygraph panel button[action=graph]':{
				click: function(){
					this.valueadd(true, 'graph');
				}
			}
			});
		
		},
		summaryFilter:function(){
			if(!Ext.isEmpty(this.getTrendGraphFilters()))
			{
				this.getTrendGraphFilters().destroy();
				if(container != undefined)
					container.destroy();
			}
			if(!Ext.isEmpty(this.getMeasureGraphFilters()))
			{
				this.getMeasureGraphFilters().destroy();
				if(container != undefined)
					container.destroy();
			}
			if(!Ext.isEmpty(this.getSummaryGraphFilters()))
			{
				this.getSummaryGraphFilters().destroy();
				if(container != undefined)
					container.destroy();
			}
			var VWidth = Ext.Element.getViewportWidth( );
					if(!this.getSummaryGraphFilters() || container.isHidden()){

						var summarywindow = Ext.create('ComponentMeasureTabSet.view.SummaryGraphFilters');
						summarywindow.createItems(this.getSummaryGraph().data);
						summarywindow.show();
						container = Ext.create('Ext.container.Container',{
						padding:5,
						floating:true,
						frame:true,
						width:650,
						hidden:true,
						floatable:true,
						cls:'configMode_popup',
						items:[
							{
								xtype:'container',
								cls:'configMode_popupArrow',
								style:{'top':'-13px','left':'578px'}
							},
							{
								xtype:'container',
								html:'<div style="float:left;margin:0px 0px 0px 4px;color: #f7f7f7;" class="settingsfont"><b>SETTINGS</b></div><div style="text-align:right;float:right;"><div class="iconClose3"></div></div>',
								style:{'top':'0px','margin':'2px'}
							},		
								summarywindow
							]
						});
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth - 655,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth - 655
									}
								});
						
						
						container.showAt(VWidth - 655,5000);
						Ext.select('.iconClose3').on('click',function(){
							
								Ext.create('Ext.fx.Anim', {
									
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth - 655,
										top:50
									},
									to: {
									   top:-500,
										left: VWidth - 655
									},
									callback: function(){
										container.destroy();
										
									   }
								});
							
						},this);
						
					}
					/*else if(container.isHidden()){
						var summarywindow=this.getSummaryGraphFilters();
						summarywindow.show();
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -515,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth -515
									}
								});
						
						
						container.showAt(VWidth -515,5000);
						
					}*/
					else{
						//this.getSummaryGraphFilters().hide();
						container.destroy();
					}
		},
		valueadd: function(graphClicked, fromFunc){
			var url=requestParams.activeTabUrl;
			var infoValue=null;
			if(this.getInfolistCombo()!=null)
			{
				infoValue =  this.getInfolistCombo().getValue();
			}
			var valid=false;
			var defval=null;
			if(descriptorRawData!=null && descriptorRawData!=undefined && descriptorRawData.length>0)
			{
				defval=descriptorRawData[0].value;

					if(infoValue==null || infoValue=="")
					infoValue = defval;

				for(var i=0;i<descriptorRawData.length;i++)
				{
					if(infoValue!=null && infoValue!=undefined && descriptorRawData[i].name==infoValue)
					{
						valid=true;
					}
					else if(infoValue!=null && infoValue!=undefined && descriptorRawData[i].value==infoValue)
					{
						valid=true;
					}
				}
			}
			var compObj = this.getInfolistCombo();
			if(descriptorRawData!=null && descriptorRawData!=undefined && descriptorRawData.length>1)
			{
				if(infoValue==null || infoValue == '-1' || !valid)
				{
					Ext.MessageBox.show({
								title : 'Alert',
								msg : 'Please choose a valid descriptor',
								buttons : Ext.MessageBox.OK,
								icon : Ext.MessageBox.WARNING,
								fn:function(buttonId)
								{
									if(!Ext.isEmpty(Ext.getCmp("descriptionOpt")))
										Ext.getCmp("descriptionOpt").setValue("");
										var compStore = descriptorRawData;
										compStore = descriptorRawData;
										if(!Ext.isEmpty(compObj))
										{
											compObj.getStore().removeAll(); 
											compObj.getStore().loadRawData(compStore);
											var value;
										}
										if(!Ext.isEmpty(compObj))
										{
												if(Ext.isEmpty(compObj.getStore().getAt(0)))
												value =defval;
											else
												value = compObj.getStore().getAt(0).get('value');
												compObj.setValue(value);
										}
									}
							});
					return false;
				}
			}
			url=this.appendToURL(url, fromFunc);
			// --no need here, handled in appendURL method--Url Encoding for Rights Character
			//url = encodeURI(url);
			if (url!=null && url!=-1 && url.indexOf('#')>-1)		
			{
				url=url.replace('#','|hash|');
			}
				if(url!=-1){
				Ext.Ajax.request({
					url : url,
					method : 'POST',
					scope:this,
					success : function(response, opts){				
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						this.getSummaryGraph().removeAll();
						this.getSummaryGraph().createTabUI(jsonData);
						if(graphClicked==true){
							if(!Ext.isEmpty(this.getSummaryGraphFilters()))
							{
								/*if(!Ext.isEmpty(this.getSummaryGraphFilters().up('container')))
								{
									this.getSummaryGraphFilters().up('container').hide();
									this.getSummaryGraphFilters().close();
								}*/
								
								if(!Ext.isEmpty('container') && !Ext.isEmpty(container)){
									container.destroy();
								}
							}
						}
						if(!Ext.isEmpty(jsonData.Filters))
						{
							for(var i=0; i< jsonData.Filters.length; i++)
							{
								if(jsonData.Filters[i].name=="timeline")
								{
									var thisTimelineData=jsonData.Filters[i].selectvalue;
									if(!Ext.isEmpty(this.getSummaryGraph()))
									{
										if(thisTimelineData=="Any")
										{
											this.getGraphStartHour().enable();
											this.getGraphEndHour().enable();
											this.getGraphStartDate().enable();
											this.getGraphEndDate().enable();
										}else
										{
											this.getGraphStartHour().disable();
											this.getGraphEndHour().disable();
											this.getGraphStartDate().disable();
											this.getGraphEndDate().disable();
										}
									}
								}
							}
						}
					},
					failure : function(){alert("failure");}
				});
			}		
		},
		appendToURL: function(url,actionFrom ){		
			if(this.getGraphTimeline()!=undefined){
				var tLine=this.getSummaryGraph().timelineData.items[this.getGraphTimeline().getValue()].value;
				
			}	
			if(Ext.isEmpty(this.getSummaryGraphFilters())){
				var summarywindow = Ext.create('ComponentMeasureTabSet.view.SummaryGraphFilters');
				summarywindow.createItems(this.getSummaryGraph().data);
			}				
			var period;

			if(!Ext.isEmpty(this.getGraphDuration()))
			{
				period=this.getGraphDuration().value;
			}
			var starttime=Ext.Date.format(this.getGraphStartDate().getValue(),'m/d/Y');
			var endtime=Ext.Date.format(this.getGraphEndDate().getValue(),'m/d/Y');
			var currTime=Ext.Date.format(new Date(),'m/d/Y');
			var starttimeDummy=Ext.Date.parse(this.getGraphStartDate().getValue(),'m/d/Y');
			var endtimeDummy=Ext.Date.parse(this.getGraphEndDate().getValue(),'m/d/Y');
			var currTimeDummy=new Date();

			if(!Ext.isEmpty(actionFrom) && actionFrom == 'period')
				tLine = (period == 'D')?'1 week':(period == 'M' )?'6 months':'24 hours';
			url+='&timeLine='+tLine;
			var starthr = parseInt(this.getGraphStartHour().value);
			var endhr = parseInt(this.getGraphEndHour().value);
			var measure= this.getMeasureForGraph().value;
		
			if(tLine == 'Any' && dateValidation(starttime,endtime,starthr,endhr,0,0)==-1)
			{
				Ext.Msg.alert("Error",this.getSummaryGraph().data.DateErrormsg);
				return -1;
			}
/*/////////////////////////
			var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));
			var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
			var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
			var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
			var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
			var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
			var state=0;

		
			if(styear > endyear)			
				state=-1;		
			else if(styear == endyear)			
				if(stmon > endmon)				
					state=-1;				
				else if(stmon == endmon)
					if(stday > endday)						
						state=-1;
///////////////////////////////				
			

			if(state == -1 &&  tLine.toLowerCase() == 'any')
			{
				Ext.Msg.alert("Error",this.getSummaryGraph().data.DateErrormsg);
				return -1;
			}


			
	*/	

			/*if( tLine.toLowerCase() == 'any' )
			{
				if(starttime > currTime || endtime > currTime){
					//if(starttimeDummy > currTimeDummy || endtimeDummy > currTimeDummy){
			
					//}
				}
				 if(starttime > endtime){			
					Ext.Msg.alert("Error",this.getSummaryGraph().data.DateErrormsg);
					return -1;
				}
				else if(starttime === endtime){
					if(starthr >= endhr){
						Ext.Msg.alert("Error",this.getSummaryGraph().data.DateErrormsg);
						return -1;
					}
				}	
			}
			
			*/
			if(this.getDisForGraph()!=undefined)
			{
				var info = this.getDisForGraph().value;
				url = url.replace(/(info=)[^\&]+/, '$1' + encodeURIComponent(info));
			}

			url+="&starttime="+starttime+"&endtime="+endtime+"&starthr="+starthr+"&endhr="+endhr;
			url = url.replace(/(measure=)[^\&]+/, '$1' + measure);
			url = url.replace(/(period=)[^\&]+/, '$1' + period);

			url = url.replace(/(mode=)[^\&]+/, '$1' + this.mode);
			return url;
		},
		displayTooltip:function(image)
		{
			if(!Ext.isEmpty(this.getSummaryGraph().toolTip))
			{
				var tip = this.getSummaryGraph().toolTip;
				tip.setTarget(image.id);
				tip.update(image.tooltip);
				tip.show();
			}
		},
			descriptorOptSelect :function(obj, event)
	{
		var findVal = obj.getValue();
		var mainForm = this.getSummaryGraphFilters();
		var compStore = descriptorRawData;
		//var compObj = this.getDetailediagnosis().getComponent("infolist");
		var compObj = this.getInfolistCombo();
		var isRecordFound = false;
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compStore = descriptorRawData;
			compObj.getStore().removeAll(); 
			compObj.getStore().loadRawData(compStore);
			var value = compObj.getStore().getAt(0).get('value');
			compObj.setValue(value);
		}
		else
		{
			var genStore = new Ext.data.Store({
									fields : ['name', 'value'],
									data : []
								});
			if(findVal!=null)
				findVal=findVal.toLowerCase();
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['name'];
				if(getRecord!=null)
					getRecord=getRecord.toLowerCase();
				if ( getRecord.indexOf(findVal) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'name': compStore[i]['name'],
						'value': compStore[i]['value']
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll(); 
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
				console.log("genStore",genStore.getAt(0).get('value'));
				compObj.setValue(genStore.getAt(0).get('value'));
			}
			else
			{
				compObj.getStore().removeAll();
				compObj.getStore().add({
					'name': 'Not Applicable!',
					'value': '-1'
				});
				if(findVal=="")
				{
					compObj.setValue(genStore.getAt(0).get('value'));
				}
				else
				{
					compObj.setValue("-1");
				}
			}
			obj.focus();
		 }
	}
});