Ext.define('ComponentMeasureTabSet.controller.ThreadDetails', {
    extend: 'Ext.app.Controller',
    requires:['ComponentMeasureTabSet.view.ThreadDetails'],
    views:['ThreadDetails'],
    
	refs : [{
				ref : 'descriptionCombo',
				selector : 'detailediagnosis combo[itemId= "infolist"]'
			},{
				ref : 'measurementCombo',
				selector : 'detailediagnosis combo[itemId= "measurelist"]'
			},{
				ref : 'timelineCombo',
				selector : 'detailediagnosis combo[itemId= "timeline"]'
			},{
				ref : 'fromHrCombo',
				selector : 'detailediagnosis combo[itemId= "fromHr"]'
			},{
				ref : 'fromMinCombo',
				selector : 'detailediagnosis combo[itemId= "fromMin"]'
			},{
				ref : 'toHrCombo',
				selector : 'detailediagnosis combo[itemId= "toHr"]'
			},{
				ref : 'toMinCombo',
				selector : 'detailediagnosis combo[itemId= "toMin"]'
			},{
				ref : 'fromDate',
				selector : 'detailediagnosis datefield[itemId= "fromdate"]'
			},{
				ref : 'toDate',
				selector : 'detailediagnosis datefield[itemId= "todate"]'
			},{
				ref : 'detailedDiagnosisPanel',
				selector : 'detailediagnosis'
			},{
				ref:'threaddetails',
				selector:'threaddetails'
			},{
				ref : 'detailedDiagnosisPanel',
				selector : 'detailediagnosis'
			},{
				ref : 'threadName',
				selector : 'threaddetails multiselect'
			}
	],

    init: function() {
    	this.control({
					'threaddetails':{
						'boxready':this.loadform
					},
					'threaddetails combo[id="time"]':{
							'select':this.timeOnChange
					},
					'threaddetails combo[id="measure"]':{
							'select':this.measureOnChange
					},
					'threaddetails combo[id="sortByOrder"]':{
						'select':this.sortOnChange
					},
					'threaddetails #threadname':{
						'change':this.threadOnChange
					},

		});
	},
	timeOnChange:function(obj)
	{
		this.loadform(obj);
	},
	measureOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnChange:function(obj)
	{
		this.loadform(obj);
	},
	threadOnChange:function(obj)
	{
		this.loadFormForThreadName(obj);
	},
	loadFormForThreadName:function(obj)
	{
		var resultPanel = Ext.getCmp("threadResulPanel");
		var measureTime = Ext.getCmp('time').value;
		var selectedvalue = Ext.getCmp('threadname').value;
		params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
		Ext.Ajax.request({
			async: false,
			url : '/final/monitor/jvmThreads.jsp',
			params:params,
			method:'POST',
			success : function(response) {
				var resultData = Ext.decode(response.responseText);
				//resultPanel.update(resultData);
				resultPanel.update(resultData.tableData);
			}
		});
	},
	loadform:function(obj)
	{
		var url = "";
		var selectedhref = Ext.getCmp('windowValue').selectedHref;
		if(!Ext.isEmpty(selectedhref) && selectedhref != null && selectedhref != undefined)










		{
			if(selectedhref.indexOf("?") >-1)
			{
				url = selectedhref.substring(selectedhref.indexOf("?")+1);
			}
			var filtersObject = this.getAllFieldValues();
			url = url + "&s_st_time="+filtersObject.fromDate+"&s_en_time="+filtersObject.toDate+"&s_st_hr="+filtersObject.fromHr+"&s_en_hr="+
				filtersObject.toHr+"&s_st_min="+filtersObject.fromMin+"&s_end_min="+filtersObject.toMin+"&fromStackMeasure=true";
			var selectedDate = Ext.getCmp('windowValue').selectedValue;
			if(!Ext.isEmpty(selectedDate))





			{
				url = url+"&sdate="+selectedDate;
			}
			if(!Ext.isEmpty(obj))
			{
				var elementId = obj.id;
				var meas =null;
				var sortValue = null;
				if(!Ext.isEmpty(elementId))
				{
					if(elementId=="time")
					{
						if(!Ext.isEmpty(obj.value))
						{
							url = url+"&time="+obj.value;
						}
					}
					else if(elementId=="sortByOrder")



					{
						var sortValue = obj.value;
						url = url + "&sortby="+sortValue;
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;


					}
				}
			}
			Ext.getCmp('measure').hide();
			Ext.getCmp('threadname').hide();
			Ext.getCmp('west-region-container').hide();
			var me= this;
			var details = null;
			Ext.Ajax.request({
				url : '/final/monitor/ThreadDetails.jsp?'+url,
				success : function(response) {
					var formdata = Ext.decode(response.responseText);
					var subformdata =null;
					if(!Ext.isEmpty(formdata) && !Ext.isEmpty(formdata.data))
					{
						for(var i = 0;i<formdata.data.length;i++)
						{
							var name=formdata.data[i].name;
							if(!Ext.isEmpty(name))
							{
								if(name=="memtime")
								{	//var selectedvalue = Ext.getCmp("time").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].time;
									me.setComboOptionsInList('time', subformdata,selectedvalue);
								}
								else if(name=="memsortname")
								{
									//var selectedvalue = Ext.getCmp("sortByOrder").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].sortByOrder;
									me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
								}
							}
						}
						var resultPanel = Ext.getCmp("threadResulPanel");
						resultPanel.update(formdata.tableData);
					}
				}
			});
		}
		else
		{
			var filtersObject = this.getAllFieldValues();
			var dignosisLink = ddLink;
			dignosisLink = threadDetailLink;
			url = dignosisLink+="&s_st_time="+filtersObject.fromDate+"&s_en_time="+filtersObject.toDate+"&s_st_hr="+filtersObject.fromHr+"&s_en_hr="+
				filtersObject.toHr+"&s_st_min="+filtersObject.fromMin+"&s_end_min="+filtersObject.toMin+"&flag=1&firsttime=true&"+
				"newWindow=true";
				
			url = url.replace(/(measure=)[^\&]+/, '$1' + filtersObject.measurement);
			var infoValue = filtersObject.description;
			if(Ext.isEmpty(filtersObject.description))
				infoValue ="NONE";
			url = url.replace(/(info=)[^\&]+/, '$1' + infoValue);
			url = url.replace("measure", "s_measure");
			if(!Ext.isEmpty(url))
			{
				if(url.indexOf("?") >-1)
				{
					url = url.substring(url.indexOf("?")+1);
				}
			}
			if(!Ext.isEmpty(obj))
			{
				var elementId = obj.id;
				var meas =null;
				var sortValue = null;
				if(!Ext.isEmpty(elementId))
				{
					if(elementId=="time")
					{
						if(!Ext.isEmpty(obj.value))
						{
							url = url+"&time="+obj.value;
							meas = Ext.getCmp("measure").value;
							url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						}
					}
					else if(elementId=="measure")
					{
						if(!Ext.isEmpty(obj.value))
						{
							var timeTemp = Ext.getCmp("time").value;
							url = url+"&time="+timeTemp;
							meas = obj.value;
							url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						}
					}
					else if(elementId=="sortByOrder")
					{
						var sortValue = obj.value;
						url = url + "&sortby="+sortValue;
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;
						var meas = Ext.getCmp("measure").value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
					}
					else if(elementId=="threadnameSelect")
					{
						var selectedThreadName = this.getThreadName().getValue();
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;
						var meas = Ext.getCmp("measure").value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						url = url+"&selectedThreadName="+encodeURIComponent(selectedThreadName);
					}
					if(!Ext.isEmpty(meas) && !Ext.isEmpty(elementId) && elementId!="sortByOrder")
					{
						if(meas == 'Total_current_threads')
							sortValue ="1";
						else if(meas == 'Blocked_threads')
							sortValue ="8";
						else if(meas == 'Deadlock_threads')
							sortValue ="8";
						else if(meas == 'Waiting_threads')
							sortValue ="11";
						else if(meas == 'Timed_waiting_threads')
							sortValue ="11";
						else
							sortValue ="5";
						url = url+"&sortby="+sortValue;
					}
				}
			}
			var selectedDate = Ext.getCmp('windowValue').selectedValue;
			if(!Ext.isEmpty(selectedDate))
			{
				url = url+"&sdate="+selectedDate;
			}
			var me= this;
			var details = null;
			Ext.Ajax.request({
				url : '/final/monitor/ThreadDetails.jsp?'+url,
				success : function(response) {
					var formdata = response.responseText;
					if(formdata != null && formdata != 'undefined' && formdata != undefined && formdata != '')
						formdata = Ext.decode(response.responseText);
					var subformdata =null;
					if(!Ext.isEmpty(formdata) && !Ext.isEmpty(formdata.data))
					{
						var fcount=0;
						for(var i = 0;i<formdata.data.length;i++)
						{
							var name=formdata.data[i].name;
							if(!Ext.isEmpty(name))
							{
								if(name=="memtime")
								{	//var selectedvalue = Ext.getCmp("time").value;
									var selectedvalue = formdata.data[i].selectedvalue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].time;
									me.setComboOptionsInList('time', subformdata,selectedvalue);
								}
								else if(name=="Measurement")
								{
									var selectedvalue = formdata.data[i].selectedvalue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].measure;
									me.setComboOptionsInList('measure', subformdata,selectedvalue);
								}
								else if(name=="memsortname")
								{
									//var selectedvalue = Ext.getCmp("sortByOrder").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].sortByOrder;
									me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
								}
								else if(name=="threadname")
								{
									var threadCombo = Ext.getCmp("threadname");
									var	selectedvalue = formdata.data[i].selectedValue;
									subformdata = formdata.data[i].threadname;
									me.setComboOptionsInList('threadname', subformdata,'');
									var tempSelectedValue = [];
									tempSelectedValue.push(selectedvalue);
									threadCombo.setValue(tempSelectedValue);
								}
							}
							fcount++;
						}
						//this.loadData();
						if(formdata.data.length == fcount)
						{
							var resultPanel = Ext.getCmp("threadResulPanel");
							var measureTime = Ext.getCmp('time').value;
							params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
							Ext.Ajax.request({
								async: false,
								url : '/final/monitor/jvmThreads.jsp',
								params:params,
								method:'POST',
								success : function(response) {
									var resultData = Ext.decode(response.responseText);
									//resultPanel.update(resultData);
									resultPanel.update(resultData.tableData);
								}
							});
						}
					}
					else
					{
						Ext.getCmp("windowValue").close();
						Ext.Msg.alert("Message","No Data Available");
					}
				}
			});
		}
	},
	setComboOptionsInList : function(fieldName, list, value) {
		var field = Ext.getCmp(fieldName);
		field.getStore().loadRawData(list);
		field.suspendEvents(false);
		if(value=='')
		{
			value = field.getStore().getAt(0).get('value');
		}
		field.setValue(value);
		field.resumeEvents();
	},
	getAllFieldValues : function(){
		var jsonData = this.getDetailedDiagnosisPanel().jsonData;
		var filtersObject = new Object();
		if(!Ext.isEmpty(this.getDescriptionCombo()))
		filtersObject.description = this.getDescriptionCombo().getValue();
		filtersObject.measurement = this.getMeasurementCombo().getValue();
		filtersObject.measurementText = this.getMeasurementCombo().getValue();
		filtersObject.timeline = this.getTimelineCombo().getValue(); 
		var fromDate = this.getFromDate().getValue();
		if(!Ext.isEmpty(fromDate)){
			filtersObject.fromDate=Ext.Date.format(fromDate,'m/d/Y');
		  }
		var toDate = this.getToDate().getValue();
		if(!Ext.isEmpty(toDate)){
			filtersObject.toDate=Ext.Date.format(toDate,'m/d/Y');
		  }
		
		  var currentDate = new Date();
		  var currentHrs = currentDate.getHours();
		  var currentMin = currentDate.getMinutes();
		  currentDate = Ext.Date.format(currentDate,'m/d/Y');
		 
		filtersObject.fromHr = this.getFromHrCombo().getValue();
		filtersObject.fromMin = this.getFromMinCombo().getValue();
		filtersObject.toHr = this.getToHrCombo().getValue();
		filtersObject.toMin = this.getToMinCombo().getValue();
		/*if(filtersObject.timeline=="Any" && (currentDate < filtersObject.fromDate || currentDate < filtersObject.toDate)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				(currentHrs < filtersObject.fromHr || currentHrs < filtersObject.toHr)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}else if(filtersObject.timeline =="Any" && (currentDate == filtersObject.fromDate || currentDate == filtersObject.toDate)&&
				(currentHrs == filtersObject.fromHr || currentHrs == filtersObject.toHr) && (currentMin < filtersObject.fromMin || currentMin < filtersObject.toMin)){
			Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorCurrentDate);
			  return;
		}
		if(filtersObject.timeline=="Any" && filtersObject.fromDate > filtersObject.toDate){
			  Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
			  return;
		}
		 if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  if(filtersObject.fromHr > filtersObject.toHr){
				  Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  return;
			  }
		 }
		 if(filtersObject.timeline=="Any" && filtersObject.fromDate == filtersObject.toDate){
			  if(filtersObject.fromHr == filtersObject.toHr){
				  if(filtersObject.fromMin >= filtersObject.toMin){
					 Ext.Msg.alert('Error', jsonData.hiddenFields.dateErrorDate);
				  return;
				  }
			  }
		 }	 */ 
		return filtersObject;
	},
});